/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-01-09 18:44:24 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wor6069_awb_critical_css` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `css_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mobile_css` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `desktop_css` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mobile_preloads` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `desktop_preloads` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `updated_at` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_cmplz_cookiebanners` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `banner_version` int NOT NULL,
  `default` int NOT NULL,
  `position` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `checkbox_style` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_logo` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `logo_attachment_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `close_button` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `revoke` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `manage_consent_options` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `header` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dismiss` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `save_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `view_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_functional` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_all` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_stats` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_prefs` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optin` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_categories` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `disable_cookiebanner` int NOT NULL,
  `banner_width` int NOT NULL,
  `soft_cookiewall` int NOT NULL,
  `dismiss_on_scroll` int NOT NULL,
  `dismiss_on_timeout` int NOT NULL,
  `dismiss_timeout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept_informational` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_custom_cookie_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `functional_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text_anonymous` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `preferences_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `marketing_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_background` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_toggles` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `border_width` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `font_size` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_deny` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_settings` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `buttons_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `animation` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_box_shadow` int NOT NULL,
  `header_footer_shadow` int NOT NULL,
  `hide_preview` int NOT NULL,
  `disable_width_correction` int NOT NULL,
  `legal_documents` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_cmplz_cookies` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sync` int NOT NULL,
  `ignored` int NOT NULL,
  `retention` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceID` int NOT NULL,
  `cookieFunction` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `collectedPersonalData` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `purpose` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int NOT NULL,
  `isOwnDomainCookie` int NOT NULL,
  `domain` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `deleted` int NOT NULL,
  `isMembersOnly` int NOT NULL,
  `showOnPolicy` int NOT NULL,
  `lastUpdatedDate` int NOT NULL,
  `lastAddDate` int NOT NULL,
  `firstAddDate` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_cmplz_dnsmpd` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `region` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `global_optout` int NOT NULL,
  `cross_context` int NOT NULL,
  `limit_sensitive` int NOT NULL,
  `request_for_access` int NOT NULL,
  `right_to_be_forgotten` int NOT NULL,
  `right_to_data_portability` int NOT NULL,
  `request_date` int NOT NULL,
  `resolved` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_cmplz_services` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceType` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `thirdParty` int NOT NULL,
  `sharesData` int NOT NULL,
  `secondParty` int NOT NULL,
  `privacyStatementURL` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int NOT NULL,
  `sync` int NOT NULL,
  `lastUpdatedDate` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_fusion_form_entries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `submission_id` bigint NOT NULL,
  `form_id` bigint NOT NULL,
  `field_id` bigint NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_fusion_form_fields` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `field_name` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_label` varchar(256) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_fusion_form_submissions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(512) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_fusion_forms` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `views` bigint DEFAULT '0',
  `submissions_count` bigint DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_litespeed_url` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_litespeed_url_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url_id` bigint NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint NOT NULL COMMENT 'mobile=1',
  `webp` tinyint NOT NULL COMMENT 'webp=1',
  `expired` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=15763 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6239 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=4286 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_trustindex_google_reviews` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `user` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `user_photo` text,
  `text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `rating` decimal(3,1) DEFAULT NULL,
  `highlight` varchar(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `reviewId` text,
  `reply` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wor6069_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wor6069_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor6069_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wor6069_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor6069_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=395 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wor6069_cmplz_cookiebanners */
INSERT INTO `wor6069_cmplz_cookiebanners` VALUES("1", "Bannière A", "3", "1", "bottom-right", "slider", "", "0", "1", "Gérer le consentement", "hover-hide-mobile", "a:2:{s:4:\"text\";s:22:\"Gérer le consentement\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:7:\"Refuser\";s:4:\"show\";i:1;}", "Enregistrer les préférences", "Voir les préférences", "Fonctionnel", "a:2:{s:4:\"text\";s:9:\"Marketing\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:12:\"Statistiques\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:13:\"Préférences\";s:4:\"show\";i:1;}", "Accepter", "Pour offrir les meilleures expériences, nous utilisons des technologies telles que les cookies pour stocker et/ou accéder aux informations des appareils. Le fait de consentir à ces technologies nous permettra de traiter des données telles que le comportement de navigation ou les ID uniques sur ce site. Le fait de ne pas consentir ou de retirer son consentement peut avoir un effet négatif sur certaines caractéristiques et fonctions.", "view-preferences", "0", "526", "0", "0", "0", "10", "a:2:{s:4:\"text\";s:8:\"Accepter\";s:4:\"show\";i:1;}", "Pour offrir les meilleures expériences, nous utilisons des technologies telles que les cookies pour stocker et/ou accéder aux informations des appareils. Le fait de consentir à ces technologies nous permettra de traiter des données telles que le comportement de navigation ou les ID uniques sur ce site. Le fait de ne pas consentir ou de retirer son consentement peut avoir un effet négatif sur certaines caractéristiques et fonctions.", "0", "/* Container */\n.cmplz-cookiebanner{}\n\n/* Logo */\n.cmplz-cookiebanner .cmplz-logo{}\n/* Title */\n.cmplz-cookiebanner .cmplz-title{}\n/* Close icon */\n.cmplz-cookiebanner .cmplz-close{}\n\n/* Message */\n.cmplz-cookiebanner .cmplz-message{}\n\n /* All buttons */\n.cmplz-buttons .cmplz-btn{}\n/* Accept button */\n.cmplz-btn .cmplz-accept{} \n /* Deny button */\n.cmplz-btn .cmplz-deny{}\n /* Save preferences button */\n.cmplz-btn .cmplz-deny{}\n /* View preferences button */\n.cmplz-btn .cmplz-deny{}\n\n /* Document hyperlinks */\n.cmplz-links .cmplz-documents{}\n\n /* Categories */\n.cmplz-cookiebanner .cmplz-category{}\n.cmplz-cookiebanner .cmplz-category-title{} \n\n/* Manage consent tab */\n#cmplz-manage-consent .cmplz-manage-consent{} \n\n/* Soft cookie wall */\n.cmplz-soft-cookiewall{}\n\n/* Placeholder button - Per category */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice{}\n\n/* Placeholder button & message - Per service */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice,\n.cmplz-blocked-content-notice{}\nbutton.cmplz-accept-service{}\n\n/* Styles for the AMP notice */\n#cmplz-consent-ui, #cmplz-post-consent-ui {}\n/* Message */\n#cmplz-consent-ui .cmplz-consent-message {}\n/* Buttons */\n#cmplz-consent-ui button, #cmplz-post-consent-ui button {}", "a:0:{}", "a:2:{s:4:\"text\";s:341:\"L’accès ou le stockage technique est strictement nécessaire dans la finalité d’intérêt légitime de permettre l’utilisation d’un service spécifique explicitement demandé par l’abonné ou l’utilisateur, ou dans le seul but d’effectuer la transmission d’une communication sur un réseau de communications électroniques.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:92:\"Le stockage ou l’accès technique qui est utilisé exclusivement à des fins statistiques.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:448:\"Le stockage ou l’accès technique qui est utilisé exclusivement dans des finalités statistiques anonymes. En l’absence d’une assignation à comparaître, d’une conformité volontaire de la part de votre fournisseur d’accès à internet ou d’enregistrements supplémentaires provenant d’une tierce partie, les informations stockées ou extraites à cette seule fin ne peuvent généralement pas être utilisées pour vous identifier.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:184:\"L’accès ou le stockage technique est nécessaire dans la finalité d’intérêt légitime de stocker des préférences qui ne sont pas demandées par l’abonné ou l’internaute.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:242:\"L’accès ou le stockage technique est nécessaire pour créer des profils d’internautes afin d’envoyer des publicités, ou pour suivre l’utilisateur sur un site web ou sur plusieurs sites web ayant des finalités marketing similaires.\";s:4:\"show\";i:1;}", "a:2:{s:5:\"color\";s:7:\"#ffffff\";s:6:\"border\";s:7:\"#f2f2f2\";}", "a:2:{s:5:\"color\";s:7:\"#222222\";s:9:\"hyperlink\";s:7:\"#1E73BE\";}", "a:3:{s:10:\"background\";s:7:\"#1e73be\";s:6:\"bullet\";s:7:\"#ffffff\";s:8:\"inactive\";s:7:\"#F56E28\";}", "a:5:{s:3:\"top\";i:12;s:5:\"right\";i:12;s:6:\"bottom\";i:12;s:4:\"left\";i:12;s:4:\"type\";s:2:\"px\";}", "a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}", "12", "a:3:{s:10:\"background\";s:7:\"#1E73BE\";s:6:\"border\";s:7:\"#1E73BE\";s:4:\"text\";s:7:\"#ffffff\";}", "a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#222222\";}", "a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#333333\";}", "a:5:{s:3:\"top\";i:6;s:5:\"right\";i:6;s:6:\"bottom\";i:6;s:4:\"left\";i:6;s:4:\"type\";s:2:\"px\";}", "none", "1", "0", "0", "0", "1");

/* INSERT TABLE DATA: wor6069_commentmeta */
INSERT INTO `wor6069_commentmeta` VALUES("1", "2", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("2", "2", "akismet_history", "a:3:{s:4:\"time\";d:1580917903.184011;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("3", "2", "akismet_history", "a:3:{s:4:\"time\";d:1580917951.001534;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("4", "2", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("5", "3", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("6", "3", "akismet_history", "a:3:{s:4:\"time\";d:1580917933.508054;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("7", "3", "akismet_history", "a:3:{s:4:\"time\";d:1580917945.149214;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("8", "3", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("9", "4", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("10", "4", "akismet_history", "a:3:{s:4:\"time\";d:1580917895.322643;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("11", "4", "akismet_history", "a:3:{s:4:\"time\";d:1580917952.168701;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("12", "4", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("13", "5", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("14", "5", "akismet_history", "a:3:{s:4:\"time\";d:1580917930.261234;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("15", "5", "akismet_history", "a:3:{s:4:\"time\";d:1580917946.328655;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("16", "5", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("17", "6", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("18", "6", "akismet_history", "a:3:{s:4:\"time\";d:1580917891.349338;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("19", "6", "akismet_history", "a:3:{s:4:\"time\";d:1580917953.337889;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("20", "6", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("21", "7", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("22", "7", "akismet_history", "a:3:{s:4:\"time\";d:1580917926.862337;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("23", "7", "akismet_history", "a:3:{s:4:\"time\";d:1580917947.496501;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("24", "7", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("25", "8", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("26", "8", "akismet_history", "a:3:{s:4:\"time\";d:1580917886.352578;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("27", "8", "akismet_history", "a:3:{s:4:\"time\";d:1580917954.506829;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("28", "8", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("29", "9", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("30", "9", "akismet_history", "a:3:{s:4:\"time\";d:1580917923.700291;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("31", "9", "akismet_history", "a:3:{s:4:\"time\";d:1580917948.662444;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("32", "9", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("33", "10", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("34", "10", "akismet_history", "a:3:{s:4:\"time\";d:1580917880.621322;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("35", "10", "akismet_history", "a:3:{s:4:\"time\";d:1580917955.709294;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("36", "10", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("37", "11", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("38", "11", "akismet_history", "a:3:{s:4:\"time\";d:1580917919.980213;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("39", "11", "akismet_history", "a:3:{s:4:\"time\";d:1580917949.833431;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("40", "11", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("41", "12", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("42", "12", "akismet_history", "a:3:{s:4:\"time\";d:1580917305.128845;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("43", "12", "akismet_history", "a:3:{s:4:\"time\";d:1580917330.652558;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("44", "12", "_wxr_import_user", "7496");
INSERT INTO `wor6069_commentmeta` VALUES("45", "13", "akismet_result", "false");
INSERT INTO `wor6069_commentmeta` VALUES("46", "13", "akismet_history", "a:3:{s:4:\"time\";d:1580917318.668794;s:5:\"event\";s:9:\"check-ham\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("47", "13", "akismet_history", "a:3:{s:4:\"time\";d:1580917329.495903;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:12:\"danyduchaine\";}");
INSERT INTO `wor6069_commentmeta` VALUES("48", "13", "_wxr_import_user", "7496");

/* INSERT TABLE DATA: wor6069_comments */
INSERT INTO `wor6069_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2024-12-27 15:51:20", "2024-12-27 14:51:20", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("2", "876", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:51:43", "2020-02-05 15:51:43", "Vivamus suscipit tortor eget felis porttitor volutpat. Vivamus suscipit tortor eget felis porttitor volutpat. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("3", "876", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:52:13", "2020-02-05 15:52:13", "Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("4", "886", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:51:35", "2020-02-05 15:51:35", "Mauris blandit aliquet elit, eget tincidunt nibh pulvinar a. Proin eget tortor risus. Donec sollicitudin molestie malesuada. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("5", "886", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:52:10", "2020-02-05 15:52:10", "Pellentesque in ipsum id orci porta dapibus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Curabitur aliquet quam id dui posuere blandit.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("6", "890", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:51:31", "2020-02-05 15:51:31", "Donec sollicitudin molestie malesuada. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula. Pellentesque in ipsum id orci porta dapibus. Donec rutrum congue leo eget malesuada.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("7", "890", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:52:06", "2020-02-05 15:52:06", "Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Donec sollicitudin molestie malesuada. Donec rutrum congue leo eget malesuada.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("8", "1310", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:51:26", "2020-02-05 15:51:26", "Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Praesent sapien massa, convallis a pellentesque nec, egestas non nisi. Nulla porttitor accumsan tincidunt.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("9", "1310", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:52:03", "2020-02-05 15:52:03", "Pellentesque in ipsum id orci porta dapibus. Sed porttitor lectus nibh. Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Cras ultricies ligula sed magna dictum porta.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("10", "1316", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:51:20", "2020-02-05 15:51:20", "Curabitur arcu erat, accumsan id imperdiet et, porttitor at sem. Sed porttitor lectus nibh. Sed porttitor lectus nibh. Nulla quis lorem ut libero malesuada feugiat.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("11", "1316", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:51:59", "2020-02-05 15:51:59", "Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Vivamus suscipit tortor eget felis porttitor volutpat. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula. Sed porttitor lectus nibh.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("12", "1319", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:41:45", "2020-02-05 15:41:45", "Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Vivamus magna justo, lacinia eget consectetur sed, convallis at tellus. Sed porttitor lectus nibh. Quisque velit nisi, pretium ut lacinia in, elementum id enim.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wor6069_comments` VALUES("13", "1319", "admin", "admin@avadarestaurant.com", "", "2001:18c0:8a0:9c00:3824:1dd3:64a9:71b1", "2020-02-05 15:41:58", "2020-02-05 15:41:58", "Pellentesque in ipsum id orci porta dapibus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Donec velit neque, auctor sit amet aliquam vel, ullamcorper sit amet ligula. Curabitur non nulla sit amet nisl tempus convallis quis ac lectus. Nulla porttitor accumsan tincidunt.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wor6069_duplicator_packages */
INSERT INTO `wor6069_duplicator_packages` VALUES("1", "20241227_wordpressTemplate", "d77713738d8975ba6403_20241227190311", "100", "2024-12-27 19:03:27", "Miyou", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-27 19:03:11\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:26:\"20241227_wordpressTemplate\";s:4:\"Hash\";s:35:\"d77713738d8975ba6403_20241227190311\";s:8:\"NameHash\";s:62:\"20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"50.13 sec.\";s:7:\"ExeSize\";s:7:\"73.49KB\";s:7:\"ZipSize\";s:7:\"97.64MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Miyou\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/agenczx/donnadieu\";s:4:\"Size\";i:102379715;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1756;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:14293;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:16048;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/agenczx/donnadieu/wp-admin\";i:1;s:35:\"/home/agenczx/donnadieu/wp-includes\";i:2;s:44:\"/home/agenczx/donnadieu/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/agenczx/donnadieu\";i:1;s:23:\"/home/agenczx/donnadieu\";i:2;s:34:\"/home/agenczx/donnadieu/wp-content\";i:3;s:42:\"/home/agenczx/donnadieu/wp-content/uploads\";i:4;s:42:\"/home/agenczx/donnadieu/wp-content/plugins\";i:5;s:45:\"/home/agenczx/donnadieu/wp-content/mu-plugins\";i:6;s:41:\"/home/agenczx/donnadieu/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311_installer.php.bak\";s:4:\"Size\";i:75249;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:107:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp/original_files_d777137-27190311/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:87:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp/original_files_d777137-27190311\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:23:\"/home/agenczx/donnadieu\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/agenczx/donnadieu/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3253:\"<?php\ndefine( \'WP_CACHE\', true );\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the\n * installation. You don\'t have to use the web site, you can\n * copy this file to \"wp-config.php\" and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * MySQL settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://codex.wordpress.org/Editing_wp-config.php\n *\n * @package WordPress\n */\n\n// ** MySQL settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine(\'DB_NAME\', \'agenczxdonnadieu\');\n\n/** MySQL database username */\ndefine(\'DB_USER\', \'agenczxdonnadieu\');\n\n/** MySQL database password */\ndefine(\'DB_PASSWORD\', \'B20902265b\');\n\n/** MySQL hostname */\ndefine(\'DB_HOST\', \'agenczxdonnadieu.mysql.db:3306\');\n\n/** Database Charset to use in creating database tables. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** The Database Collate type. Don\'t change this if in doubt. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Authentication Unique Keys and Salts.\n *\n * Change these to different unique phrases!\n * You can generate these using the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}\n * You can change these at any point in time to invalidate all existing cookies. This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\',         \'vgA2SR0LfwnSj6znwPvlFEQGSJ8Lxl1rBZEEy/ZKitu1imiTp/3uyDi3jLPf\');\ndefine(\'SECURE_AUTH_KEY\',  \'IS95CfTS12HAJ64hZrDuqdG7ICIsTBRrskp1oCN4rcE6DLywfPcCP9Ic4SkM\');\ndefine(\'LOGGED_IN_KEY\',    \'2FD7Q5ZeTBJ0rBq7Gy1zmAEb8p5tfZdyYazOJIPYTlS7737z4tf4crwm4MPn\');\ndefine(\'NONCE_KEY\',        \'SR8hQFzdICQkPdPRIP9G4lulideElKvBbyGGlZ5fTU6IDeVD2elGhvpZkwDj\');\ndefine(\'AUTH_SALT\',        \'E8//SHFTvGjEf7ntkggzb4DCLGcwafLwCyzeO64f6xq/VLHS9YWTRBrmEobY\');\ndefine(\'SECURE_AUTH_SALT\', \'aD115N07UPq3RWmOvNiCGA1Oa3TYJIYVLUzToDLyXZAcKJJMl81Ad6nPmNOe\');\ndefine(\'LOGGED_IN_SALT\',   \'wn1/RY4B1isWIZvkMlneQi00XlStoeLhvtd3PqKbIw8X8B3Da8bzVujO6KSZ\');\ndefine(\'NONCE_SALT\',       \'Rzid/xM/napvOAZFP1cHLepgVRsTDuRacUp0Tg+0BL5xnLk8v0ELcGYVKcQX\');\n\n/**#@-*/\n\n/**\n * WordPress Database Table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n */\n$table_prefix  = \'wor6069_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the Codex.\n *\n * @link https://codex.wordpress.org/Debugging_in_WordPress\n */\ndefine(\'WP_DEBUG\', false);\n\n/* That\'s all, stop editing! Happy blogging. */\n\n/** Absolute path to the WordPress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/* Fixes \"Add media button not working\", see http://www.carnfieldwebdesign.co.uk/blog/wordpress-fix-add-media-button-not-working/ */\ndefine(\'CONCATENATE_SCRIPTS\', false );\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:18:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:38:\"define(\'DB_NAME\', \'agenczxdonnadieu\');\";s:5:\"value\";s:18:\"\'agenczxdonnadieu\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:20:\", \'agenczxdonnadieu\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:38:\"define(\'DB_USER\', \'agenczxdonnadieu\');\";s:5:\"value\";s:18:\"\'agenczxdonnadieu\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:20:\", \'agenczxdonnadieu\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'B20902265b\');\";s:5:\"value\";s:12:\"\'B20902265b\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'B20902265b\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:52:\"define(\'DB_HOST\', \'agenczxdonnadieu.mysql.db:3306\');\";s:5:\"value\";s:32:\"\'agenczxdonnadieu.mysql.db:3306\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:34:\", \'agenczxdonnadieu.mysql.db:3306\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:91:\"define(\'AUTH_KEY\',         \'vgA2SR0LfwnSj6znwPvlFEQGSJ8Lxl1rBZEEy/ZKitu1imiTp/3uyDi3jLPf\');\";s:5:\"value\";s:62:\"\'vgA2SR0LfwnSj6znwPvlFEQGSJ8Lxl1rBZEEy/ZKitu1imiTp/3uyDi3jLPf\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:72:\",         \'vgA2SR0LfwnSj6znwPvlFEQGSJ8Lxl1rBZEEy/ZKitu1imiTp/3uyDi3jLPf\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:91:\"define(\'SECURE_AUTH_KEY\',  \'IS95CfTS12HAJ64hZrDuqdG7ICIsTBRrskp1oCN4rcE6DLywfPcCP9Ic4SkM\');\";s:5:\"value\";s:62:\"\'IS95CfTS12HAJ64hZrDuqdG7ICIsTBRrskp1oCN4rcE6DLywfPcCP9Ic4SkM\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:65:\",  \'IS95CfTS12HAJ64hZrDuqdG7ICIsTBRrskp1oCN4rcE6DLywfPcCP9Ic4SkM\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:91:\"define(\'LOGGED_IN_KEY\',    \'2FD7Q5ZeTBJ0rBq7Gy1zmAEb8p5tfZdyYazOJIPYTlS7737z4tf4crwm4MPn\');\";s:5:\"value\";s:62:\"\'2FD7Q5ZeTBJ0rBq7Gy1zmAEb8p5tfZdyYazOJIPYTlS7737z4tf4crwm4MPn\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:67:\",    \'2FD7Q5ZeTBJ0rBq7Gy1zmAEb8p5tfZdyYazOJIPYTlS7737z4tf4crwm4MPn\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:91:\"define(\'NONCE_KEY\',        \'SR8hQFzdICQkPdPRIP9G4lulideElKvBbyGGlZ5fTU6IDeVD2elGhvpZkwDj\');\";s:5:\"value\";s:62:\"\'SR8hQFzdICQkPdPRIP9G4lulideElKvBbyGGlZ5fTU6IDeVD2elGhvpZkwDj\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:71:\",        \'SR8hQFzdICQkPdPRIP9G4lulideElKvBbyGGlZ5fTU6IDeVD2elGhvpZkwDj\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:91:\"define(\'AUTH_SALT\',        \'E8//SHFTvGjEf7ntkggzb4DCLGcwafLwCyzeO64f6xq/VLHS9YWTRBrmEobY\');\";s:5:\"value\";s:62:\"\'E8//SHFTvGjEf7ntkggzb4DCLGcwafLwCyzeO64f6xq/VLHS9YWTRBrmEobY\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:71:\",        \'E8//SHFTvGjEf7ntkggzb4DCLGcwafLwCyzeO64f6xq/VLHS9YWTRBrmEobY\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:91:\"define(\'SECURE_AUTH_SALT\', \'aD115N07UPq3RWmOvNiCGA1Oa3TYJIYVLUzToDLyXZAcKJJMl81Ad6nPmNOe\');\";s:5:\"value\";s:62:\"\'aD115N07UPq3RWmOvNiCGA1Oa3TYJIYVLUzToDLyXZAcKJJMl81Ad6nPmNOe\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:64:\", \'aD115N07UPq3RWmOvNiCGA1Oa3TYJIYVLUzToDLyXZAcKJJMl81Ad6nPmNOe\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:91:\"define(\'LOGGED_IN_SALT\',   \'wn1/RY4B1isWIZvkMlneQi00XlStoeLhvtd3PqKbIw8X8B3Da8bzVujO6KSZ\');\";s:5:\"value\";s:62:\"\'wn1/RY4B1isWIZvkMlneQi00XlStoeLhvtd3PqKbIw8X8B3Da8bzVujO6KSZ\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:66:\",   \'wn1/RY4B1isWIZvkMlneQi00XlStoeLhvtd3PqKbIw8X8B3Da8bzVujO6KSZ\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:91:\"define(\'NONCE_SALT\',       \'Rzid/xM/napvOAZFP1cHLepgVRsTDuRacUp0Tg+0BL5xnLk8v0ELcGYVKcQX\');\";s:5:\"value\";s:62:\"\'Rzid/xM/napvOAZFP1cHLepgVRsTDuRacUp0Tg+0BL5xnLk8v0ELcGYVKcQX\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:70:\",       \'Rzid/xM/napvOAZFP1cHLepgVRsTDuRacUp0Tg+0BL5xnLk8v0ELcGYVKcQX\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}s:19:\"CONCATENATE_SCRIPTS\";a:3:{s:3:\"src\";s:38:\"define(\'CONCATENATE_SCRIPTS\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:28:\"define(\'CONCATENATE_SCRIPTS\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:28:\"$table_prefix  = \'wor6069_\';\";s:5:\"value\";s:10:\"\'wor6069_\'\";s:5:\"parts\";a:2:{i:0;s:16:\"$table_prefix  =\";i:1;s:12:\" \'wor6069_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3137279;s:4:\"File\";s:75:\"20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'30\', Revision \'41ebc5d9\'\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:2:{i:0;s:7:\"utf8mb4\";i:1;s:7:\"utf8mb3\";}s:13:\"collationList\";a:4:{i:0;s:18:\"utf8mb3_general_ci\";i:1;s:18:\"utf8mb4_0900_ai_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"InnoDB\";i:1;s:6:\"MEMORY\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:16:\"agenczxdonnadieu\";s:15:\"tablesBaseCount\";i:53;s:16:\"tablesFinalCount\";i:53;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:786;s:16:\"tablesSizeOnDisk\";i:5783552;s:10:\"tablesList\";a:53:{s:27:\"wor6069_cmplz_cookiebanners\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:21:\"wor6069_cmplz_cookies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:20:\"wor6069_cmplz_dnsmpd\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wor6069_cmplz_services\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wor6069_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:16:\"wor6069_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:27:\"wor6069_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:27:\"wor6069_fusion_form_entries\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:26:\"wor6069_fusion_form_fields\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:31:\"wor6069_fusion_form_submissions\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:20:\"wor6069_fusion_forms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:13:\"wor6069_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:21:\"wor6069_litespeed_url\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:26:\"wor6069_litespeed_url_file\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:15:\"wor6069_options\";a:3:{s:14:\"inaccurateRows\";i:479;s:12:\"insertedRows\";i:503;s:4:\"size\";i:3702784;}s:16:\"wor6069_postmeta\";a:3:{s:14:\"inaccurateRows\";i:15;s:12:\"insertedRows\";i:137;s:4:\"size\";i:49152;}s:13:\"wor6069_posts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:28;s:4:\"size\";i:81920;}s:26:\"wor6069_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:9;s:4:\"size\";i:32768;}s:21:\"wor6069_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:16:\"wor6069_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:8;s:4:\"size\";i:49152;}s:13:\"wor6069_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:16:\"wor6069_usermeta\";a:3:{s:14:\"inaccurateRows\";i:18;s:12:\"insertedRows\";i:24;s:4:\"size\";i:49152;}s:13:\"wor6069_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:21:\"wor6069_wfauditevents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:22:\"wor6069_wfblockediplog\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wor6069_wfblocks7\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:16:\"wor6069_wfconfig\";a:3:{s:14:\"inaccurateRows\";i:218;s:12:\"insertedRows\";i:229;s:4:\"size\";i:16384;}s:18:\"wor6069_wfcrawlers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:21:\"wor6069_wffilechanges\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:18:\"wor6069_wffilemods\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:14:\"wor6069_wfhits\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:16:\"wor6069_wfhoover\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:16:\"wor6069_wfissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:23:\"wor6069_wfknownfilelist\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:26:\"wor6069_wflivetraffichuman\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:14:\"wor6069_wflocs\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wor6069_wflogins\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:24:\"wor6069_wfls_2fa_secrets\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"wor6069_wfls_role_counts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:0;}s:21:\"wor6069_wfls_settings\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:30;s:4:\"size\";i:16384;}s:23:\"wor6069_wfnotifications\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:23:\"wor6069_wfpendingissues\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:22:\"wor6069_wfreversecache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:24:\"wor6069_wfsecurityevents\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:19:\"wor6069_wfsnipcache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:16:\"wor6069_wfstatus\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:22:\"wor6069_wftrafficrates\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:21:\"wor6069_wfwaffailures\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:23:\"wor6069_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:18;s:4:\"size\";i:114688;}s:33:\"wor6069_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:11;s:4:\"size\";i:65536;}s:24:\"wor6069_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:24;s:12:\"insertedRows\";i:24;s:4:\"size\";i:32768;}s:26:\"wor6069_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:23:\"wor6069_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:7:\"Percona\";s:7:\"version\";s:6:\"8.0.39\";s:14:\"versionComment\";s:55:\"Percona Server (GPL), Release \'30\', Revision \'41ebc5d9\'\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:131:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp/20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-27 19:03:11\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20241227_wordpressTemplate\";s:4:\"Hash\";s:35:\"d77713738d8975ba6403_20241227190311\";s:8:\"NameHash\";s:62:\"20241227_wordpressTemplate_d77713738d8975ba6403_20241227190311\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:241;s:13:\"BuildProgress\";r:500;}}}");
INSERT INTO `wor6069_duplicator_packages` VALUES("2", "20241227_wordpressTemplate", "de3e0017dd27b51e7776_20250109184413", "22", "2025-01-09 18:44:24", "Miyou", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-09 18:44:13\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:26:\"20241227_wordpressTemplate\";s:4:\"Hash\";s:35:\"de3e0017dd27b51e7776_20250109184413\";s:8:\"NameHash\";s:62:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:5:\"Miyou\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:74:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/agenczx/donnadieu\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1790;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16105;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-09 18:44:13\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20241227_wordpressTemplate\";s:4:\"Hash\";s:35:\"de3e0017dd27b51e7776_20250109184413\";s:8:\"NameHash\";s:62:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:80:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/agenczx/donnadieu/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:75:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'30\', Revision \'41ebc5d9\'\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:131:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp/20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/agenczx/donnadieu/wp-admin\";i:1;s:35:\"/home/agenczx/donnadieu/wp-includes\";i:2;s:44:\"/home/agenczx/donnadieu/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/agenczx/donnadieu\";i:1;s:23:\"/home/agenczx/donnadieu\";i:2;s:34:\"/home/agenczx/donnadieu/wp-content\";i:3;s:42:\"/home/agenczx/donnadieu/wp-content/uploads\";i:4;s:42:\"/home/agenczx/donnadieu/wp-content/plugins\";i:5;s:45:\"/home/agenczx/donnadieu/wp-content/mu-plugins\";i:6;s:41:\"/home/agenczx/donnadieu/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wor6069_fusion_forms */
INSERT INTO `wor6069_fusion_forms` VALUES("1", "3348", "2", "0", NULL);
INSERT INTO `wor6069_fusion_forms` VALUES("2", "3907", "12", "0", NULL);

/* INSERT TABLE DATA: wor6069_options */
INSERT INTO `wor6069_options` VALUES("1", "siteurl", "http://donnadieu.agencemiyou.com", "yes");
INSERT INTO `wor6069_options` VALUES("2", "home", "http://donnadieu.agencemiyou.com", "yes");
INSERT INTO `wor6069_options` VALUES("3", "blogname", "Donnadieu Bois", "yes");
INSERT INTO `wor6069_options` VALUES("4", "blogdescription", "Le spécialiste du bois à Rochefort-du-Gard, Villeneuves-lès-Avignon, Les Angles(30)", "yes");
INSERT INTO `wor6069_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wor6069_options` VALUES("6", "admin_email", "miyustreet@gmail.com", "yes");
INSERT INTO `wor6069_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wor6069_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wor6069_options` VALUES("9", "use_smilies", "0", "yes");
INSERT INTO `wor6069_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wor6069_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wor6069_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wor6069_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wor6069_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wor6069_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wor6069_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wor6069_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wor6069_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wor6069_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wor6069_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wor6069_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wor6069_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wor6069_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wor6069_options` VALUES("24", "time_format", "G\\hi", "yes");
INSERT INTO `wor6069_options` VALUES("25", "links_updated_date_format", "d F Y G\\hi", "yes");
INSERT INTO `wor6069_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wor6069_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wor6069_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wor6069_options` VALUES("29", "rewrite_rules", "a:283:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:7:\"menu/?$\";s:35:\"index.php?post_type=avada_portfolio\";s:37:\"menu/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:32:\"menu/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:24:\"menu/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=avada_portfolio&paged=$matches[1]\";s:12:\"faq-items/?$\";s:29:\"index.php?post_type=avada_faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=avada_faq&paged=$matches[1]\";s:44:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"fusion_tb_layout/([^/]+)/embed/?$\";s:49:\"index.php?fusion_tb_layout=$matches[1]&embed=true\";s:37:\"fusion_tb_layout/([^/]+)/trackback/?$\";s:43:\"index.php?fusion_tb_layout=$matches[1]&tb=1\";s:45:\"fusion_tb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&paged=$matches[2]\";s:52:\"fusion_tb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&cpage=$matches[2]\";s:41:\"fusion_tb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?fusion_tb_layout=$matches[1]&page=$matches[2]\";s:33:\"fusion_tb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"fusion_tb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"fusion_tb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_tb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"fusion_tb_section/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"fusion_tb_section/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"fusion_tb_section/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"fusion_tb_section/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"fusion_tb_section/([^/]+)/embed/?$\";s:50:\"index.php?fusion_tb_section=$matches[1]&embed=true\";s:38:\"fusion_tb_section/([^/]+)/trackback/?$\";s:44:\"index.php?fusion_tb_section=$matches[1]&tb=1\";s:46:\"fusion_tb_section/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&paged=$matches[2]\";s:53:\"fusion_tb_section/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&cpage=$matches[2]\";s:42:\"fusion_tb_section/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?fusion_tb_section=$matches[1]&page=$matches[2]\";s:34:\"fusion_tb_section/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"fusion_tb_section/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"fusion_tb_section/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_tb_section/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"fusion_tb_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:54:\"fusion_tb_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:35:\"fusion_tb_category/([^/]+)/embed/?$\";s:51:\"index.php?fusion_tb_category=$matches[1]&embed=true\";s:47:\"fusion_tb_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?fusion_tb_category=$matches[1]&paged=$matches[2]\";s:29:\"fusion_tb_category/([^/]+)/?$\";s:40:\"index.php?fusion_tb_category=$matches[1]\";s:39:\"fusion_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"fusion_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"fusion_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"fusion_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"fusion_form/([^/]+)/embed/?$\";s:44:\"index.php?fusion_form=$matches[1]&embed=true\";s:32:\"fusion_form/([^/]+)/trackback/?$\";s:38:\"index.php?fusion_form=$matches[1]&tb=1\";s:40:\"fusion_form/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&paged=$matches[2]\";s:47:\"fusion_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&cpage=$matches[2]\";s:36:\"fusion_form/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?fusion_form=$matches[1]&page=$matches[2]\";s:28:\"fusion_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"fusion_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"fusion_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"fusion_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:32:\"menu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"menu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"menu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"menu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"menu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"menu/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"menu/([^/]+)/embed/?$\";s:48:\"index.php?avada_portfolio=$matches[1]&embed=true\";s:25:\"menu/([^/]+)/trackback/?$\";s:42:\"index.php?avada_portfolio=$matches[1]&tb=1\";s:45:\"menu/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:40:\"menu/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:33:\"menu/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\";s:40:\"menu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\";s:29:\"menu/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\";s:21:\"menu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"menu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"menu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"menu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"menu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"menu/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:57:\"portfolio_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:52:\"portfolio_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:33:\"portfolio_skills/([^/]+)/embed/?$\";s:49:\"index.php?portfolio_skills=$matches[1]&embed=true\";s:45:\"portfolio_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\";s:27:\"portfolio_skills/([^/]+)/?$\";s:38:\"index.php?portfolio_skills=$matches[1]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:42:\"index.php?avada_faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:36:\"index.php?avada_faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?avada_faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:43:\"fusion_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"fusion_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"fusion_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"fusion_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"fusion_template/([^/]+)/embed/?$\";s:48:\"index.php?fusion_template=$matches[1]&embed=true\";s:36:\"fusion_template/([^/]+)/trackback/?$\";s:42:\"index.php?fusion_template=$matches[1]&tb=1\";s:44:\"fusion_template/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&paged=$matches[2]\";s:51:\"fusion_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_template/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?fusion_template=$matches[1]&page=$matches[2]\";s:32:\"fusion_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"fusion_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"fusion_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"fusion_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"fusion_element/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"fusion_element/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"fusion_element/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"fusion_element/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"fusion_element/([^/]+)/embed/?$\";s:47:\"index.php?fusion_element=$matches[1]&embed=true\";s:35:\"fusion_element/([^/]+)/trackback/?$\";s:41:\"index.php?fusion_element=$matches[1]&tb=1\";s:43:\"fusion_element/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&paged=$matches[2]\";s:50:\"fusion_element/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_element/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?fusion_element=$matches[1]&page=$matches[2]\";s:31:\"fusion_element/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"fusion_element/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"fusion_element/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"fusion_element/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"element_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?element_category=$matches[1]&feed=$matches[2]\";s:52:\"element_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?element_category=$matches[1]&feed=$matches[2]\";s:33:\"element_category/([^/]+)/embed/?$\";s:49:\"index.php?element_category=$matches[1]&embed=true\";s:45:\"element_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?element_category=$matches[1]&paged=$matches[2]\";s:27:\"element_category/([^/]+)/?$\";s:38:\"index.php?element_category=$matches[1]\";s:58:\"template_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?template_category=$matches[1]&feed=$matches[2]\";s:53:\"template_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?template_category=$matches[1]&feed=$matches[2]\";s:34:\"template_category/([^/]+)/embed/?$\";s:50:\"index.php?template_category=$matches[1]&embed=true\";s:46:\"template_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?template_category=$matches[1]&paged=$matches[2]\";s:28:\"template_category/([^/]+)/?$\";s:39:\"index.php?template_category=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"slide-page/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:46:\"slide-page/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:27:\"slide-page/([^/]+)/embed/?$\";s:43:\"index.php?slide-page=$matches[1]&embed=true\";s:39:\"slide-page/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?slide-page=$matches[1]&paged=$matches[2]\";s:21:\"slide-page/([^/]+)/?$\";s:32:\"index.php?slide-page=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=3421&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wor6069_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wor6069_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wor6069_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wor6069_options` VALUES("33", "active_plugins", "a:9:{i:0;s:33:\"complianz-gdpr/complianz-gpdr.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:33:\"fusion-builder/fusion-builder.php\";i:3;s:27:\"fusion-core/fusion-core.php\";i:4;s:59:\"fusion-white-label-branding/fusion-white-label-branding.php\";i:5;s:35:\"litespeed-cache/litespeed-cache.php\";i:6;s:23:\"wordfence/wordfence.php\";i:7;s:24:\"wordpress-seo/wp-seo.php\";i:8;s:61:\"wp-reviews-plugin-for-google/wp-reviews-plugin-for-google.php\";}", "yes");
INSERT INTO `wor6069_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wor6069_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wor6069_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wor6069_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wor6069_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wor6069_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wor6069_options` VALUES("40", "template", "Avada", "yes");
INSERT INTO `wor6069_options` VALUES("41", "stylesheet", "Avada", "yes");
INSERT INTO `wor6069_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wor6069_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wor6069_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wor6069_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wor6069_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `wor6069_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wor6069_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wor6069_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wor6069_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wor6069_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wor6069_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wor6069_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wor6069_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wor6069_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wor6069_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wor6069_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wor6069_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wor6069_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wor6069_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wor6069_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wor6069_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wor6069_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wor6069_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wor6069_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wor6069_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wor6069_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wor6069_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wor6069_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wor6069_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wor6069_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wor6069_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wor6069_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wor6069_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wor6069_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wor6069_options` VALUES("76", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("77", "widget_text", "a:2:{i:2;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:113:\"Quam eu proin sit massa condimentum. Volutpat non pulvinar<br> aliquet nunc. Quam eu proin sit massa condimentum.\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wor6069_options` VALUES("79", "uninstall_plugins", "a:2:{s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "no");
INSERT INTO `wor6069_options` VALUES("80", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `wor6069_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wor6069_options` VALUES("82", "page_on_front", "3421", "yes");
INSERT INTO `wor6069_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wor6069_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wor6069_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wor6069_options` VALUES("86", "site_icon", "3849", "yes");
INSERT INTO `wor6069_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wor6069_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wor6069_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wor6069_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wor6069_options` VALUES("91", "admin_email_lifespan", "1750863080", "yes");
INSERT INTO `wor6069_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wor6069_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wor6069_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wor6069_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wor6069_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wor6069_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wor6069_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wor6069_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `wor6069_options` VALUES("100", "wor6069_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:67:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:27:\"access_white_label_branding\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:14:\"manage_privacy\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "on");
INSERT INTO `wor6069_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wor6069_options` VALUES("102", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("103", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:9:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:8:\"search-2\";i:4;s:14:\"recent-posts-2\";i:5;s:17:\"recent-comments-2\";i:6;s:10:\"archives-2\";i:7;s:12:\"categories-2\";i:8;s:6:\"meta-2\";}s:21:\"avada-footer-widget-1\";a:5:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";i:2;s:13:\"media_image-5\";i:3;s:6:\"text-2\";i:4;s:21:\"social_links-widget-2\";}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:13:\"array_version\";i:3;s:42:\"avada-custom-sidebar-horsdoeuvres-megamenu\";a:1:{i:0;s:13:\"custom_html-2\";}s:40:\"avada-custom-sidebar-maincourse-megamenu\";a:1:{i:0;s:13:\"custom_html-3\";}s:38:\"avada-custom-sidebar-desserts-megamenu\";a:1:{i:0;s:13:\"custom_html-4\";}s:39:\"avada-custom-sidebar-cocktails-megamenu\";a:1:{i:0;s:13:\"custom_html-5\";}}", "yes");
INSERT INTO `wor6069_options` VALUES("104", "cron", "a:19:{i:1736448292;a:2:{s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}s:27:\"litespeed_task_imgoptm_pull\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1736448681;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1736450103;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1736450108;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1736477481;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1736477624;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1736514908;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1736520681;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1736520824;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1736520829;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1736520853;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1736521227;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1736521742;a:3:{s:21:\"cmplz_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"cmplz_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:20:\"cmplz_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"cmplz_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"cmplz_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"cmplz_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1736607081;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1736773200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1736780400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1736912767;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1737904142;a:1:{s:22:\"cmplz_every_month_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:13:\"cmplz_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wor6069_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("107", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("109", "widget_media_image", "a:2:{i:5;a:23:{s:4:\"size\";s:6:\"medium\";s:5:\"width\";i:613;s:6:\"height\";i:118;s:7:\"caption\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:9:\"link_type\";s:6:\"custom\";s:8:\"link_url\";s:0:\"\";s:13:\"image_classes\";s:0:\"\";s:12:\"link_classes\";s:0:\"\";s:8:\"link_rel\";s:0:\"\";s:17:\"link_target_blank\";b:0;s:11:\"image_title\";s:0:\"\";s:13:\"attachment_id\";i:1879;s:3:\"url\";s:89:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2020/01/logo-restaurant@2x-300x58.png\";s:5:\"title\";s:0:\"\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("112", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("113", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("115", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("116", "widget_custom_html", "a:5:{i:2;a:11:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:3326:\"[fusion_builder_column type=\"1_1\" layout=\"1_1\" spacing=\"\" center_content=\"no\" link=\"\" target=\"_self\" min_height=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" hover_type=\"none\" border_size=\"0\" border_color=\"\" border_style=\"solid\" border_position=\"all\" box_shadow=\"no\" box_shadow_blur=\"0\" box_shadow_spread=\"0\" box_shadow_color=\"\" box_shadow_style=\"\" background_type=\"single\" gradient_start_position=\"0\" gradient_end_position=\"100\" gradient_type=\"linear\" radial_direction=\"center center\" linear_angle=\"180\" background_color=\"\" background_image=\"\" background_image_id=\"\" background_position=\"left top\" background_repeat=\"no-repeat\" background_blend_mode=\"none\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" filter_type=\"regular\" filter_hue=\"0\" filter_saturation=\"100\" filter_brightness=\"100\" filter_contrast=\"100\" filter_invert=\"0\" filter_sepia=\"0\" filter_opacity=\"100\" filter_blur=\"0\" filter_hue_hover=\"0\" filter_saturation_hover=\"100\" filter_brightness_hover=\"100\" filter_contrast_hover=\"100\" filter_invert_hover=\"0\" filter_sepia_hover=\"0\" filter_opacity_hover=\"100\" filter_blur_hover=\"0\" first=\"true\" last=\"true\"][fusion_title title_type=\"text\" rotation_effect=\"bounceIn\" display_time=\"1200\" highlight_effect=\"circle\" loop_animation=\"off\" highlight_width=\"9\" highlight_top_margin=\"0\" before_text=\"\" highlight_text=\"\" after_text=\"\" content_align=\"center\" size=\"2\" font_size=\"24px\" animated_font_size=\"\" line_height=\"\" letter_spacing=\"\" text_color=\"#ffffff\" animated_text_color=\"\" highlight_color=\"\" style_type=\"default\" sep_color=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" margin_bottom=\"20px\" margin_bottom_mobile=\"20px\" margin_top=\"10px\"]HORS D\'OEUVRES[/fusion_title][fusion_fontawesome icon=\"fusion-prefix-restaurant-sushi-1\" size=\"96\" flip=\"\" rotate=\"\" spin=\"no\" link=\"\" linktarget=\"_self\" iconcolor=\"#b7b7b7\" iconcolor_hover=\"#b7b7b7\" circle=\"no\" circlecolor=\"\" circlecolor_hover=\"\" circlebordersize=\"\" circlebordercolor=\"#383838\" circlebordercolor_hover=\"\" icon_hover_type=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" margin_bottom=\"7%\" margin_top=\"0\" /][fusion_separator style_type=\"default\" sep_color=\"\" border_size=\"\" icon=\"\" icon_circle=\"\" icon_circle_color=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" top_margin=\"30px\" /][fusion_button link=\"https://donnadieu.agencemiyou.com/our-seasonal-menu/#hors-doeuvres\" text_transform=\"\" title=\"\" target=\"_self\" link_attributes=\"\" alignment=\"center\" modal=\"\" color=\"custom\" button_gradient_top_color=\"\" button_gradient_bottom_color=\"\" button_gradient_top_color_hover=\"\" button_gradient_bottom_color_hover=\"\" accent_color=\"#ffffff\" accent_hover_color=\"\" type=\"\" bevel_color=\"\" border_width=\"\" border_radius=\"\" border_color=\"\" border_hover_color=\"\" size=\"\" stretch=\"default\" icon=\"\" icon_position=\"left\" icon_divider=\"no\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\"]VIEW MENU[/fusion_button][/fusion_builder_column]\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";}i:3;a:11:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:3332:\"[fusion_builder_column type=\"1_1\" layout=\"1_1\" spacing=\"\" center_content=\"no\" link=\"\" target=\"_self\" min_height=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" hover_type=\"none\" border_size=\"0\" border_color=\"\" border_style=\"solid\" border_position=\"all\" box_shadow=\"no\" box_shadow_blur=\"0\" box_shadow_spread=\"0\" box_shadow_color=\"\" box_shadow_style=\"\" background_type=\"single\" gradient_start_position=\"0\" gradient_end_position=\"100\" gradient_type=\"linear\" radial_direction=\"center center\" linear_angle=\"180\" background_color=\"\" background_image=\"\" background_image_id=\"\" background_position=\"left top\" background_repeat=\"no-repeat\" background_blend_mode=\"none\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" filter_type=\"regular\" filter_hue=\"0\" filter_saturation=\"100\" filter_brightness=\"100\" filter_contrast=\"100\" filter_invert=\"0\" filter_sepia=\"0\" filter_opacity=\"100\" filter_blur=\"0\" filter_hue_hover=\"0\" filter_saturation_hover=\"100\" filter_brightness_hover=\"100\" filter_contrast_hover=\"100\" filter_invert_hover=\"0\" filter_sepia_hover=\"0\" filter_opacity_hover=\"100\" filter_blur_hover=\"0\" first=\"true\" last=\"true\"][fusion_title title_type=\"text\" rotation_effect=\"bounceIn\" display_time=\"1200\" highlight_effect=\"circle\" loop_animation=\"off\" highlight_width=\"9\" highlight_top_margin=\"0\" before_text=\"\" highlight_text=\"\" after_text=\"\" content_align=\"center\" size=\"2\" font_size=\"24px\" animated_font_size=\"\" line_height=\"\" letter_spacing=\"\" text_color=\"#ffffff\" animated_text_color=\"\" highlight_color=\"\" style_type=\"default\" sep_color=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" margin_bottom=\"20px\" margin_bottom_mobile=\"20px\" margin_top=\"10px\"]\r\n<p>MAIN COURSE</p>\r\n[/fusion_title][fusion_fontawesome icon=\"fusion-prefix-restaurant-sushi-7\" size=\"96\" flip=\"\" rotate=\"\" spin=\"no\" link=\"\" linktarget=\"_self\" iconcolor=\"#b7b7b7\" iconcolor_hover=\"#b7b7b7\" circle=\"no\" circlecolor=\"\" circlecolor_hover=\"\" circlebordersize=\"\" circlebordercolor=\"#383838\" circlebordercolor_hover=\"\" icon_hover_type=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" margin_bottom=\"7%\" margin_top=\"0\" /][fusion_separator style_type=\"default\" sep_color=\"\" border_size=\"\" icon=\"\" icon_circle=\"\" icon_circle_color=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" top_margin=\"30px\" /][fusion_button link=\"https://donnadieu.agencemiyou.com/our-seasonal-menu/#main-course\" text_transform=\"\" title=\"\" target=\"_self\" link_attributes=\"\" alignment=\"center\" modal=\"\" color=\"custom\" button_gradient_top_color=\"\" button_gradient_bottom_color=\"\" button_gradient_top_color_hover=\"\" button_gradient_bottom_color_hover=\"\" accent_color=\"#ffffff\" accent_hover_color=\"\" type=\"\" bevel_color=\"\" border_width=\"\" border_radius=\"\" border_color=\"\" border_hover_color=\"\" size=\"\" stretch=\"default\" icon=\"\" icon_position=\"left\" icon_divider=\"no\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\"]VIEW MENU[/fusion_button][/fusion_builder_column]\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";}i:4;a:11:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:3342:\"[fusion_builder_column type=\"1_1\" layout=\"1_1\" spacing=\"\" center_content=\"no\" link=\"\" target=\"_self\" min_height=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" hover_type=\"none\" border_size=\"0\" border_color=\"\" border_style=\"solid\" border_position=\"all\" box_shadow=\"no\" box_shadow_blur=\"0\" box_shadow_spread=\"0\" box_shadow_color=\"\" box_shadow_style=\"\" background_type=\"single\" gradient_start_position=\"0\" gradient_end_position=\"100\" gradient_type=\"linear\" radial_direction=\"center center\" linear_angle=\"180\" background_color=\"\" background_image=\"\" background_image_id=\"\" background_position=\"left top\" background_repeat=\"no-repeat\" background_blend_mode=\"none\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" filter_type=\"regular\" filter_hue=\"0\" filter_saturation=\"100\" filter_brightness=\"100\" filter_contrast=\"100\" filter_invert=\"0\" filter_sepia=\"0\" filter_opacity=\"100\" filter_blur=\"0\" filter_hue_hover=\"0\" filter_saturation_hover=\"100\" filter_brightness_hover=\"100\" filter_contrast_hover=\"100\" filter_invert_hover=\"0\" filter_sepia_hover=\"0\" filter_opacity_hover=\"100\" filter_blur_hover=\"0\" first=\"true\" last=\"true\"][fusion_title title_type=\"text\" rotation_effect=\"bounceIn\" display_time=\"1200\" highlight_effect=\"circle\" loop_animation=\"off\" highlight_width=\"9\" highlight_top_margin=\"0\" before_text=\"\" highlight_text=\"\" after_text=\"\" content_align=\"center\" size=\"2\" font_size=\"24px\" animated_font_size=\"\" line_height=\"\" letter_spacing=\"\" text_color=\"#ffffff\" animated_text_color=\"\" highlight_color=\"\" style_type=\"default\" sep_color=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" margin_bottom=\"20px\" margin_bottom_mobile=\"20px\" margin_top=\"10px\"]\r\n\r\nDESSERT &amp; COFFEE\r\n\r\n[/fusion_title][fusion_fontawesome icon=\"fusion-prefix-restaurant-cake\" size=\"79\" flip=\"\" rotate=\"\" spin=\"no\" link=\"\" linktarget=\"_self\" iconcolor=\"#b7b7b7\" iconcolor_hover=\"#b7b7b7\" circle=\"no\" circlecolor=\"\" circlecolor_hover=\"\" circlebordersize=\"\" circlebordercolor=\"#383838\" circlebordercolor_hover=\"\" icon_hover_type=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" margin_bottom=\"10%\" margin_top=\"12px\" /][fusion_separator style_type=\"default\" sep_color=\"\" border_size=\"\" icon=\"\" icon_circle=\"\" icon_circle_color=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" top_margin=\"30px\" /][fusion_button link=\"https://donnadieu.agencemiyou.com/our-seasonal-menu/#dessert-coffee\" text_transform=\"\" title=\"\" target=\"_self\" link_attributes=\"\" alignment=\"center\" modal=\"\" color=\"custom\" button_gradient_top_color=\"\" button_gradient_bottom_color=\"\" button_gradient_top_color_hover=\"\" button_gradient_bottom_color_hover=\"\" accent_color=\"#ffffff\" accent_hover_color=\"\" type=\"\" bevel_color=\"\" border_width=\"\" border_radius=\"\" border_color=\"\" border_hover_color=\"\" size=\"\" stretch=\"default\" icon=\"\" icon_position=\"left\" icon_divider=\"no\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\"]VIEW MENU[/fusion_button][/fusion_builder_column]\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";}i:5;a:11:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:3347:\"[fusion_builder_column type=\"1_1\" layout=\"1_1\" spacing=\"\" center_content=\"no\" link=\"\" target=\"_self\" min_height=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" hover_type=\"none\" border_size=\"0\" border_color=\"\" border_style=\"solid\" border_position=\"all\" box_shadow=\"no\" box_shadow_blur=\"0\" box_shadow_spread=\"0\" box_shadow_color=\"\" box_shadow_style=\"\" background_type=\"single\" gradient_start_position=\"0\" gradient_end_position=\"100\" gradient_type=\"linear\" radial_direction=\"center center\" linear_angle=\"180\" background_color=\"\" background_image=\"\" background_image_id=\"\" background_position=\"left top\" background_repeat=\"no-repeat\" background_blend_mode=\"none\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" filter_type=\"regular\" filter_hue=\"0\" filter_saturation=\"100\" filter_brightness=\"100\" filter_contrast=\"100\" filter_invert=\"0\" filter_sepia=\"0\" filter_opacity=\"100\" filter_blur=\"0\" filter_hue_hover=\"0\" filter_saturation_hover=\"100\" filter_brightness_hover=\"100\" filter_contrast_hover=\"100\" filter_invert_hover=\"0\" filter_sepia_hover=\"0\" filter_opacity_hover=\"100\" filter_blur_hover=\"0\" first=\"true\" last=\"true\"][fusion_title title_type=\"text\" rotation_effect=\"bounceIn\" display_time=\"1200\" highlight_effect=\"circle\" loop_animation=\"off\" highlight_width=\"9\" highlight_top_margin=\"0\" before_text=\"\" highlight_text=\"\" after_text=\"\" content_align=\"center\" size=\"2\" font_size=\"24px\" animated_font_size=\"\" line_height=\"\" letter_spacing=\"\" text_color=\"#ffffff\" animated_text_color=\"\" highlight_color=\"\" style_type=\"default\" sep_color=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" margin_bottom=\"20px\" margin_bottom_mobile=\"20px\" margin_top=\"10px\"]\r\n<p>DRINKS &amp; COCKTAILS</p>\r\n[/fusion_title][fusion_fontawesome icon=\"fusion-prefix-restaurant-cocktail\" size=\"96\" flip=\"\" rotate=\"\" spin=\"no\" link=\"\" linktarget=\"_self\" iconcolor=\"#b7b7b7\" iconcolor_hover=\"#b7b7b7\" circle=\"no\" circlecolor=\"\" circlecolor_hover=\"\" circlebordersize=\"\" circlebordercolor=\"#383838\" circlebordercolor_hover=\"\" icon_hover_type=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" margin_bottom=\"7%\" margin_top=\"0\" /][fusion_separator style_type=\"default\" sep_color=\"\" border_size=\"\" icon=\"\" icon_circle=\"\" icon_circle_color=\"\" alignment=\"center\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\" top_margin=\"30px\" /][fusion_button link=\"https://donnadieu.agencemiyou.com/our-seasonal-menu/#drink-cocktail\" text_transform=\"\" title=\"\" target=\"_self\" link_attributes=\"\" alignment=\"center\" modal=\"\" color=\"custom\" button_gradient_top_color=\"\" button_gradient_bottom_color=\"\" button_gradient_top_color_hover=\"\" button_gradient_bottom_color_hover=\"\" accent_color=\"#ffffff\" accent_hover_color=\"\" type=\"\" bevel_color=\"\" border_width=\"\" border_radius=\"\" border_color=\"\" border_hover_color=\"\" size=\"\" stretch=\"default\" icon=\"\" icon_position=\"left\" icon_divider=\"no\" animation_type=\"\" animation_direction=\"left\" animation_speed=\"0.3\" animation_offset=\"\" hide_on_mobile=\"small-visibility,medium-visibility,large-visibility\" class=\"\" id=\"\"]VIEW MENU[/fusion_button][/fusion_builder_column]\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:5:\"solid\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";s:13:\"fusion_margin\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor6069_options` VALUES("120", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wor6069_options` VALUES("121", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1735311461;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wor6069_options` VALUES("124", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wor6069_options` VALUES("132", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("133", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("134", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wor6069_options` VALUES("137", "wp_attachment_pages_enabled", "1", "on");
INSERT INTO `wor6069_options` VALUES("138", "user_count", "2", "off");
INSERT INTO `wor6069_options` VALUES("139", "db_upgraded", "", "on");
INSERT INTO `wor6069_options` VALUES("146", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"miyustreet@gmail.com\";s:7:\"version\";s:5:\"6.7.1\";s:9:\"timestamp\";i:1735311184;}", "no");
INSERT INTO `wor6069_options` VALUES("147", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"4c4b1497052d14ba5d0e0ed5a97a759a\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wor6069_options` VALUES("155", "can_compress_scripts", "0", "on");
INSERT INTO `wor6069_options` VALUES("177", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wor6069_options` VALUES("182", "current_theme", "Avada", "auto");
INSERT INTO `wor6069_options` VALUES("183", "theme_mods_Avada", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:20;}s:18:\"custom_css_post_id\";i:-1;}", "on");
INSERT INTO `wor6069_options` VALUES("184", "theme_switched", "", "auto");
INSERT INTO `wor6069_options` VALUES("185", "avada_version", "7.11.13", "auto");
INSERT INTO `wor6069_options` VALUES("193", "_transient_timeout_avada_demos", "1735397862", "off");
INSERT INTO `wor6069_options` VALUES("195", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("196", "shop_single_image_size", "a:3:{s:5:\"width\";i:700;s:6:\"height\";s:0:\"\";i:0;i:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("197", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("198", "woocommerce_single_image_width", "700", "auto");
INSERT INTO `wor6069_options` VALUES("199", "woocommerce_thumbnail_image_width", "500", "auto");
INSERT INTO `wor6069_options` VALUES("200", "woocommerce_thumbnail_cropping", "uncropped", "auto");
INSERT INTO `wor6069_options` VALUES("201", "fusion_dynamic_css_posts", "a:14:{i:3421;b:1;i:3824;b:1;i:3913;b:0;i:4253;b:0;i:3809;b:1;i:4268;b:0;i:4270;b:0;i:4274;b:0;i:4275;b:0;i:3818;b:1;i:3807;b:1;i:4276;b:0;i:4284;b:0;i:4285;b:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("202", "fusion_dynamic_css_ids", "a:14:{i:3421;s:32:\"0051487b54f870bac4e4235c84add33a\";i:3824;s:32:\"0051487b54f870bac4e4235c84add33a\";i:3913;b:0;i:4253;b:0;i:3809;s:32:\"0051487b54f870bac4e4235c84add33a\";i:4268;b:0;i:4270;b:0;i:4274;b:0;i:4275;b:0;i:3818;s:32:\"0051487b54f870bac4e4235c84add33a\";i:3807;s:32:\"0051487b54f870bac4e4235c84add33a\";i:4276;b:0;i:4284;b:0;i:4285;b:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("203", "avada_disable_builder", "1", "auto");
INSERT INTO `wor6069_options` VALUES("204", "avada_disable_encoding", "1", "auto");
INSERT INTO `wor6069_options` VALUES("209", "revslider-valid-notice", "false", "auto");
INSERT INTO `wor6069_options` VALUES("223", "_site_transient_fusion_wordpress_org_plugins", "a:6:{s:3:\"pwa\";a:30:{s:4:\"name\";s:3:\"PWA\";s:4:\"slug\";s:3:\"pwa\";s:7:\"version\";s:5:\"0.8.2\";s:6:\"author\";s:100:\"<a href=\"https://github.com/GoogleChromeLabs/pwa-wp/graphs/contributors\">PWA Plugin Contributors</a>\";s:14:\"author_profile\";s:43:\"https://profiles.wordpress.org/westonruter/\";s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:84;s:7:\"ratings\";a:5:{i:5;i:21;i:4;i:0;i:3;i:0;i:2;i:0;i:1;i:5;}s:11:\"num_ratings\";i:26;s:11:\"support_url\";s:41:\"https://wordpress.org/support/plugin/pwa/\";s:15:\"support_threads\";i:1;s:24:\"support_threads_resolved\";i:1;s:15:\"active_installs\";i:30000;s:12:\"last_updated\";s:22:\"2024-11-11 10:23pm GMT\";s:5:\"added\";s:10:\"2018-07-12\";s:8:\"homepage\";s:42:\"https://github.com/GoogleChromeLabs/pwa-wp\";s:13:\"download_link\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.8.2.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:0:{}s:4:\"tags\";a:4:{s:20:\"progressive-web-apps\";s:20:\"progressive web apps\";s:3:\"pwa\";s:3:\"pwa\";s:15:\"service-workers\";s:16:\"service-workers.\";s:16:\"web-app-manifest\";s:16:\"web app manifest\";}s:8:\"versions\";a:12:{s:5:\"0.1.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.1.0.zip\";s:5:\"0.2.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.2.0.zip\";s:5:\"0.3.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.3.0.zip\";s:5:\"0.4.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.4.0.zip\";s:5:\"0.5.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.5.0.zip\";s:5:\"0.6.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.6.0.zip\";s:5:\"0.7.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.7.0.zip\";s:5:\"0.7.1\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.7.1.zip\";s:5:\"0.8.0\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.8.0.zip\";s:5:\"0.8.1\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.8.1.zip\";s:5:\"0.8.2\";s:52:\"https://downloads.wordpress.org/plugin/pwa.0.8.2.zip\";s:5:\"trunk\";s:46:\"https://downloads.wordpress.org/plugin/pwa.zip\";}s:14:\"business_model\";b:0;s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:58:\"https://ps.w.org/pwa/assets/banner-772x250.png?rev=2272148\";s:4:\"high\";s:59:\"https://ps.w.org/pwa/assets/banner-1544x500.png?rev=2272148\";}s:12:\"preview_link\";s:0:\"\";}s:11:\"woocommerce\";a:30:{s:4:\"name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:7:\"version\";s:5:\"9.5.1\";s:6:\"author\";s:48:\"<a href=\"https://woocommerce.com\">Automattic</a>\";s:14:\"author_profile\";s:41:\"https://profiles.wordpress.org/woothemes/\";s:8:\"requires\";s:3:\"6.6\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:90;s:7:\"ratings\";a:5:{i:5;i:3653;i:4;i:181;i:3;i:98;i:2;i:105;i:1;i:395;}s:11:\"num_ratings\";i:4432;s:11:\"support_url\";s:49:\"https://wordpress.org/support/plugin/woocommerce/\";s:15:\"support_threads\";i:1265;s:24:\"support_threads_resolved\";i:707;s:15:\"active_installs\";i:8000000;s:12:\"last_updated\";s:22:\"2024-12-17 11:36am GMT\";s:5:\"added\";s:10:\"2011-09-27\";s:8:\"homepage\";s:24:\"https://woocommerce.com/\";s:13:\"download_link\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:6:{i:1;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-1.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:2;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-2.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:3;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-3.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:4;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-4.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:5;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-5.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}i:6;a:2:{s:3:\"src\";s:64:\"https://ps.w.org/woocommerce/assets/screenshot-6.jpg?rev=2366418\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:9:\"ecommerce\";s:9:\"ecommerce\";s:12:\"online-store\";s:12:\"online store\";s:11:\"sell-online\";s:11:\"sell online\";s:4:\"shop\";s:4:\"shop\";s:13:\"shopping-cart\";s:13:\"shopping cart\";}s:8:\"versions\";a:466:{s:5:\"3.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.0.zip\";s:5:\"3.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.1.zip\";s:5:\"3.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.2.zip\";s:5:\"3.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.3.zip\";s:5:\"3.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.4.zip\";s:5:\"3.0.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.5.zip\";s:5:\"3.0.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.6.zip\";s:5:\"3.0.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.7.zip\";s:5:\"3.0.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.8.zip\";s:5:\"3.0.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.0.9.zip\";s:5:\"3.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.0.zip\";s:5:\"3.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.1.zip\";s:5:\"3.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.1.2.zip\";s:5:\"3.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.0.zip\";s:5:\"3.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.1.zip\";s:5:\"3.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.2.zip\";s:5:\"3.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.3.zip\";s:5:\"3.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.4.zip\";s:5:\"3.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.5.zip\";s:5:\"3.2.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.2.6.zip\";s:5:\"3.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.0.zip\";s:5:\"3.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.1.zip\";s:5:\"3.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2.zip\";s:10:\"3.3.2-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.2-rc.1.zip\";s:5:\"3.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.3.zip\";s:5:\"3.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.4.zip\";s:5:\"3.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.5.zip\";s:5:\"3.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.3.6.zip\";s:5:\"3.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0.zip\";s:12:\"3.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-beta.1.zip\";s:10:\"3.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.0-rc.2.zip\";s:5:\"3.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.1.zip\";s:5:\"3.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.2.zip\";s:5:\"3.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.3.zip\";s:5:\"3.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.4.zip\";s:5:\"3.4.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.5.zip\";s:5:\"3.4.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.6.zip\";s:5:\"3.4.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.7.zip\";s:5:\"3.4.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.4.8.zip\";s:5:\"3.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0.zip\";s:12:\"3.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-beta.1.zip\";s:10:\"3.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.1.zip\";s:10:\"3.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.0-rc.2.zip\";s:5:\"3.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.1.zip\";s:6:\"3.5.10\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.10.zip\";s:5:\"3.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.2.zip\";s:5:\"3.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.3.zip\";s:5:\"3.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.4.zip\";s:5:\"3.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.5.zip\";s:5:\"3.5.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.6.zip\";s:5:\"3.5.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.7.zip\";s:5:\"3.5.8\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.8.zip\";s:5:\"3.5.9\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.5.9.zip\";s:5:\"3.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0.zip\";s:12:\"3.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-beta.1.zip\";s:10:\"3.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.1.zip\";s:10:\"3.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.2.zip\";s:10:\"3.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.0-rc.3.zip\";s:5:\"3.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.1.zip\";s:5:\"3.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.2.zip\";s:5:\"3.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.3.zip\";s:5:\"3.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.4.zip\";s:5:\"3.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.5.zip\";s:5:\"3.6.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.6.zip\";s:5:\"3.6.7\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.6.7.zip\";s:5:\"3.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0.zip\";s:12:\"3.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-beta.1.zip\";s:10:\"3.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.1.zip\";s:10:\"3.7.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.0-rc.2.zip\";s:5:\"3.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.1.zip\";s:5:\"3.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.2.zip\";s:5:\"3.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.7.3.zip\";s:5:\"3.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0.zip\";s:12:\"3.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-beta.1.zip\";s:10:\"3.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.1.zip\";s:10:\"3.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.0-rc.2.zip\";s:5:\"3.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.1.zip\";s:5:\"3.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.2.zip\";s:5:\"3.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.8.3.zip\";s:5:\"3.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0.zip\";s:12:\"3.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.1.zip\";s:12:\"3.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-beta.2.zip\";s:10:\"3.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.1.zip\";s:10:\"3.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.2.zip\";s:10:\"3.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.3.zip\";s:10:\"3.9.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.0-rc.4.zip\";s:5:\"3.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.1.zip\";s:5:\"3.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.2.zip\";s:5:\"3.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.3.zip\";s:5:\"3.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.4.zip\";s:5:\"3.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.3.9.5.zip\";s:5:\"4.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0.zip\";s:12:\"4.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-beta.1.zip\";s:10:\"4.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.1.zip\";s:10:\"4.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.0-rc.2.zip\";s:5:\"4.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.1.zip\";s:5:\"4.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.2.zip\";s:5:\"4.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.3.zip\";s:5:\"4.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.0.4.zip\";s:5:\"4.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0.zip\";s:12:\"4.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.1.zip\";s:12:\"4.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-beta.2.zip\";s:10:\"4.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.1.zip\";s:10:\"4.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.0-rc.2.zip\";s:5:\"4.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.1.zip\";s:5:\"4.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.2.zip\";s:5:\"4.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.3.zip\";s:5:\"4.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.1.4.zip\";s:5:\"4.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0.zip\";s:10:\"4.2.0-RC.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.1.zip\";s:10:\"4.2.0-RC.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-RC.2.zip\";s:12:\"4.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.0-beta.1.zip\";s:5:\"4.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.1.zip\";s:5:\"4.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.2.zip\";s:5:\"4.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.3.zip\";s:5:\"4.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.4.zip\";s:5:\"4.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.2.5.zip\";s:5:\"4.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0.zip\";s:12:\"4.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-beta.1.zip\";s:10:\"4.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.1.zip\";s:10:\"4.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.2.zip\";s:10:\"4.3.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.0-rc.3.zip\";s:5:\"4.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.1.zip\";s:5:\"4.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.2.zip\";s:5:\"4.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.3.zip\";s:5:\"4.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.4.zip\";s:5:\"4.3.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.5.zip\";s:5:\"4.3.6\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.3.6.zip\";s:5:\"4.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0.zip\";s:12:\"4.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-beta.1.zip\";s:10:\"4.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.0-rc.1.zip\";s:5:\"4.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.1.zip\";s:5:\"4.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.2.zip\";s:5:\"4.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.3.zip\";s:5:\"4.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.4.4.zip\";s:5:\"4.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0.zip\";s:12:\"4.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-beta.1.zip\";s:10:\"4.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.1.zip\";s:10:\"4.5.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.0-rc.3.zip\";s:5:\"4.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.1.zip\";s:5:\"4.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.2.zip\";s:5:\"4.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.3.zip\";s:5:\"4.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.4.zip\";s:5:\"4.5.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.5.5.zip\";s:5:\"4.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0.zip\";s:12:\"4.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-beta.1.zip\";s:10:\"4.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.0-rc.1.zip\";s:5:\"4.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.1.zip\";s:5:\"4.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.2.zip\";s:5:\"4.6.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.3.zip\";s:5:\"4.6.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.4.zip\";s:5:\"4.6.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.6.5.zip\";s:5:\"4.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0.zip\";s:12:\"4.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.1.zip\";s:12:\"4.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-beta.2.zip\";s:10:\"4.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.0-rc.1.zip\";s:5:\"4.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1.zip\";s:12:\"4.7.1-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.1-beta.1.zip\";s:5:\"4.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.2.zip\";s:5:\"4.7.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.3.zip\";s:5:\"4.7.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.7.4.zip\";s:5:\"4.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0.zip\";s:12:\"4.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-beta.1.zip\";s:10:\"4.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.1.zip\";s:10:\"4.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.0-rc.2.zip\";s:5:\"4.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.1.zip\";s:5:\"4.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.2.zip\";s:5:\"4.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.8.3.zip\";s:5:\"4.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0.zip\";s:12:\"4.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-beta.1.zip\";s:10:\"4.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.1.zip\";s:10:\"4.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.0-rc.2.zip\";s:5:\"4.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.1.zip\";s:5:\"4.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.2.zip\";s:5:\"4.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.3.zip\";s:5:\"4.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.4.zip\";s:5:\"4.9.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.4.9.5.zip\";s:5:\"5.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0.zip\";s:12:\"5.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.1.zip\";s:12:\"5.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-beta.2.zip\";s:10:\"5.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.1.zip\";s:10:\"5.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.2.zip\";s:10:\"5.0.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.0-rc.3.zip\";s:5:\"5.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.1.zip\";s:5:\"5.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.2.zip\";s:5:\"5.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.0.3.zip\";s:5:\"5.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0.zip\";s:12:\"5.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-beta.1.zip\";s:10:\"5.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.0-rc.1.zip\";s:5:\"5.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.1.zip\";s:5:\"5.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.2.zip\";s:5:\"5.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.1.3.zip\";s:5:\"5.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0.zip\";s:12:\"5.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-beta.1.zip\";s:10:\"5.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.1.zip\";s:10:\"5.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.0-rc.2.zip\";s:5:\"5.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.1.zip\";s:5:\"5.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.2.zip\";s:5:\"5.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.3.zip\";s:5:\"5.2.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.4.zip\";s:5:\"5.2.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.2.5.zip\";s:5:\"5.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0.zip\";s:12:\"5.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-beta.1.zip\";s:10:\"5.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.1.zip\";s:10:\"5.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.0-rc.2.zip\";s:5:\"5.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.1.zip\";s:5:\"5.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.2.zip\";s:5:\"5.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.3.3.zip\";s:5:\"5.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0.zip\";s:12:\"5.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-beta.1.zip\";s:10:\"5.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.0-rc.1.zip\";s:5:\"5.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.1.zip\";s:5:\"5.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.2.zip\";s:5:\"5.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.3.zip\";s:5:\"5.4.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.4.4.zip\";s:5:\"5.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0.zip\";s:12:\"5.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-beta.1.zip\";s:10:\"5.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.1.zip\";s:10:\"5.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.0-rc.2.zip\";s:5:\"5.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.1.zip\";s:5:\"5.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.2.zip\";s:5:\"5.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.3.zip\";s:5:\"5.5.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.5.4.zip\";s:5:\"5.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0.zip\";s:12:\"5.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-beta.1.zip\";s:10:\"5.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.1.zip\";s:10:\"5.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.0-rc.2.zip\";s:5:\"5.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.1.zip\";s:5:\"5.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.6.2.zip\";s:5:\"5.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0.zip\";s:12:\"5.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-beta.1.zip\";s:10:\"5.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.0-rc.1.zip\";s:5:\"5.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.1.zip\";s:5:\"5.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.7.2.zip\";s:5:\"5.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0.zip\";s:12:\"5.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.1.zip\";s:12:\"5.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-beta.2.zip\";s:10:\"5.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.0-rc.1.zip\";s:5:\"5.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.8.1.zip\";s:5:\"5.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0.zip\";s:12:\"5.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-beta.1.zip\";s:10:\"5.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.1.zip\";s:10:\"5.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.0-rc.2.zip\";s:5:\"5.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.5.9.1.zip\";s:5:\"6.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0.zip\";s:12:\"6.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-beta.1.zip\";s:10:\"6.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.0-rc.1.zip\";s:5:\"6.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.0.1.zip\";s:5:\"6.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0.zip\";s:12:\"6.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-beta.1.zip\";s:10:\"6.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.1.zip\";s:10:\"6.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.0-rc.2.zip\";s:5:\"6.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.1.zip\";s:5:\"6.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.1.2.zip\";s:5:\"6.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0.zip\";s:12:\"6.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-beta.1.zip\";s:10:\"6.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.1.zip\";s:10:\"6.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.0-rc.2.zip\";s:5:\"6.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.1.zip\";s:5:\"6.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.2.2.zip\";s:5:\"6.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0.zip\";s:12:\"6.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-beta.1.zip\";s:10:\"6.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.1.zip\";s:10:\"6.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.0-rc.2.zip\";s:5:\"6.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.3.1.zip\";s:5:\"6.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0.zip\";s:12:\"6.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-beta.1.zip\";s:10:\"6.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.0-rc.1.zip\";s:5:\"6.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.4.1.zip\";s:5:\"6.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0.zip\";s:12:\"6.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-beta.1.zip\";s:10:\"6.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.1.zip\";s:10:\"6.5.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.0-rc.2.zip\";s:5:\"6.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.5.1.zip\";s:5:\"6.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0.zip\";s:12:\"6.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-beta.1.zip\";s:10:\"6.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.1.zip\";s:10:\"6.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.0-rc.2.zip\";s:5:\"6.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.6.1.zip\";s:5:\"6.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0.zip\";s:12:\"6.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.1.zip\";s:12:\"6.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-beta.2.zip\";s:10:\"6.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.7.0-rc.1.zip\";s:5:\"6.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0.zip\";s:12:\"6.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.1.zip\";s:12:\"6.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-beta.2.zip\";s:10:\"6.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.0-rc.1.zip\";s:5:\"6.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.1.zip\";s:5:\"6.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.8.2.zip\";s:5:\"6.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0.zip\";s:12:\"6.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.1.zip\";s:12:\"6.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-beta.2.zip\";s:10:\"6.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.0-rc.1.zip\";s:5:\"6.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.1.zip\";s:5:\"6.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.2.zip\";s:5:\"6.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.3.zip\";s:5:\"6.9.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.6.9.4.zip\";s:5:\"7.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0.zip\";s:12:\"7.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.1.zip\";s:12:\"7.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.2.zip\";s:12:\"7.0.0-beta.3\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-beta.3.zip\";s:10:\"7.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.1.zip\";s:10:\"7.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.0-rc.2.zip\";s:5:\"7.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.0.1.zip\";s:5:\"7.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0.zip\";s:12:\"7.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.1.zip\";s:12:\"7.1.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-beta.2.zip\";s:10:\"7.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.1.zip\";s:10:\"7.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.0-rc.2.zip\";s:5:\"7.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.1.1.zip\";s:5:\"7.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0.zip\";s:12:\"7.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.1.zip\";s:12:\"7.2.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-beta.2.zip\";s:10:\"7.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.1.zip\";s:10:\"7.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.0-rc.2.zip\";s:5:\"7.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.1.zip\";s:5:\"7.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.2.zip\";s:5:\"7.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.2.3.zip\";s:5:\"7.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0.zip\";s:12:\"7.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.1.zip\";s:12:\"7.3.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-beta.2.zip\";s:10:\"7.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.1.zip\";s:10:\"7.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.3.0-rc.2.zip\";s:5:\"7.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0.zip\";s:12:\"7.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.1.zip\";s:12:\"7.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-beta.2.zip\";s:10:\"7.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.1.zip\";s:10:\"7.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.0-rc.2.zip\";s:5:\"7.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.4.1.zip\";s:5:\"7.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0.zip\";s:12:\"7.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.1.zip\";s:12:\"7.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-beta.2.zip\";s:10:\"7.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.0-rc.1.zip\";s:5:\"7.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.5.1.zip\";s:5:\"7.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0.zip\";s:12:\"7.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.1.zip\";s:12:\"7.6.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-beta.2.zip\";s:10:\"7.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.1.zip\";s:10:\"7.6.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.2.zip\";s:10:\"7.6.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.0-rc.3.zip\";s:5:\"7.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.6.1.zip\";s:5:\"7.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0.zip\";s:12:\"7.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.1.zip\";s:12:\"7.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-beta.2.zip\";s:10:\"7.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.0-rc.1.zip\";s:5:\"7.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.1.zip\";s:5:\"7.7.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.7.2.zip\";s:5:\"7.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0.zip\";s:12:\"7.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.1.zip\";s:12:\"7.8.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-beta.2.zip\";s:10:\"7.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.1.zip\";s:10:\"7.8.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.0-rc.2.zip\";s:5:\"7.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.1.zip\";s:5:\"7.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.2.zip\";s:5:\"7.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.8.3.zip\";s:5:\"7.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0.zip\";s:12:\"7.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.1.zip\";s:12:\"7.9.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-beta.2.zip\";s:10:\"7.9.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.2.zip\";s:10:\"7.9.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.0-rc.3.zip\";s:5:\"7.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.7.9.1.zip\";s:5:\"8.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0.zip\";s:12:\"8.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.1.zip\";s:12:\"8.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-beta.2.zip\";s:10:\"8.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.1.zip\";s:10:\"8.0.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.0-rc.2.zip\";s:5:\"8.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.1.zip\";s:5:\"8.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.2.zip\";s:5:\"8.0.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.3.zip\";s:5:\"8.0.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.0.4.zip\";s:5:\"8.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0.zip\";s:12:\"8.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-beta.1.zip\";s:10:\"8.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.1.zip\";s:10:\"8.1.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.0-rc.2.zip\";s:5:\"8.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.1.zip\";s:5:\"8.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.1.2.zip\";s:5:\"8.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0.zip\";s:12:\"8.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-beta.1.zip\";s:10:\"8.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.1.zip\";s:10:\"8.2.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.0-rc.2.zip\";s:5:\"8.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.1.zip\";s:5:\"8.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.2.zip\";s:5:\"8.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.2.3.zip\";s:5:\"8.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0.zip\";s:12:\"8.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-beta.1.zip\";s:10:\"8.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.1.zip\";s:10:\"8.3.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.0-rc.2.zip\";s:5:\"8.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.1.zip\";s:5:\"8.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.3.2.zip\";s:5:\"8.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0.zip\";s:12:\"8.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-beta.1.zip\";s:10:\"8.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.0-rc.1.zip\";s:5:\"8.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.4.1.zip\";s:5:\"8.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0.zip\";s:12:\"8.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-beta.1.zip\";s:10:\"8.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.0-rc.1.zip\";s:5:\"8.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.1.zip\";s:5:\"8.5.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.2.zip\";s:5:\"8.5.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.5.3.zip\";s:5:\"8.6.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0.zip\";s:12:\"8.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-beta.1.zip\";s:10:\"8.6.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.0-rc.1.zip\";s:5:\"8.6.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.1.zip\";s:5:\"8.6.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.6.2.zip\";s:5:\"8.7.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0.zip\";s:12:\"8.7.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.1.zip\";s:12:\"8.7.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-beta.2.zip\";s:10:\"8.7.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.0-rc.1.zip\";s:5:\"8.7.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.7.1.zip\";s:5:\"8.8.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0.zip\";s:12:\"8.8.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-beta.1.zip\";s:10:\"8.8.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.0-rc.1.zip\";s:5:\"8.8.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.1.zip\";s:5:\"8.8.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.2.zip\";s:5:\"8.8.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.3.zip\";s:5:\"8.8.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.4.zip\";s:5:\"8.8.5\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.8.5.zip\";s:5:\"8.9.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0.zip\";s:12:\"8.9.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-beta.1.zip\";s:10:\"8.9.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.0-rc.1.zip\";s:5:\"8.9.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.1.zip\";s:5:\"8.9.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.2.zip\";s:5:\"8.9.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.8.9.3.zip\";s:5:\"9.0.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0.zip\";s:12:\"9.0.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.1.zip\";s:12:\"9.0.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-beta.2.zip\";s:10:\"9.0.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.0-rc.1.zip\";s:5:\"9.0.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.1.zip\";s:5:\"9.0.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.0.2.zip\";s:5:\"9.1.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0.zip\";s:12:\"9.1.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-beta.1.zip\";s:10:\"9.1.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.0-rc.1.zip\";s:5:\"9.1.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.1.zip\";s:5:\"9.1.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.2.zip\";s:5:\"9.1.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.3.zip\";s:5:\"9.1.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.1.4.zip\";s:5:\"9.2.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0.zip\";s:12:\"9.2.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-beta.1.zip\";s:10:\"9.2.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.0-rc.1.zip\";s:5:\"9.2.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.1.zip\";s:5:\"9.2.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.2.zip\";s:5:\"9.2.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.2.3.zip\";s:5:\"9.3.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0.zip\";s:12:\"9.3.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-beta.1.zip\";s:10:\"9.3.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.0-rc.1.zip\";s:5:\"9.3.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.1.zip\";s:5:\"9.3.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.2.zip\";s:5:\"9.3.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.3.zip\";s:5:\"9.3.4\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.3.4.zip\";s:5:\"9.4.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0.zip\";s:12:\"9.4.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.1.zip\";s:12:\"9.4.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-beta.2.zip\";s:10:\"9.4.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.1.zip\";s:10:\"9.4.0-rc.2\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.2.zip\";s:10:\"9.4.0-rc.3\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.3.zip\";s:10:\"9.4.0-rc.4\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.0-rc.4.zip\";s:5:\"9.4.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.1.zip\";s:5:\"9.4.2\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.2.zip\";s:5:\"9.4.3\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.4.3.zip\";s:5:\"9.5.0\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0.zip\";s:12:\"9.5.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.1.zip\";s:12:\"9.5.0-beta.2\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-beta.2.zip\";s:10:\"9.5.0-rc.1\";s:65:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.0-rc.1.zip\";s:5:\"9.5.1\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.5.1.zip\";s:12:\"9.6.0-beta.1\";s:67:\"https://downloads.wordpress.org/plugin/woocommerce.9.6.0-beta.1.zip\";s:5:\"trunk\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3000842\";s:4:\"high\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3000842\";}s:12:\"preview_link\";s:0:\"\";}s:19:\"the-events-calendar\";a:30:{s:4:\"name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:7:\"version\";s:5:\"6.9.0\";s:6:\"author\";s:52:\"<a href=\"https://evnt.is/1x\">The Events Calendar</a>\";s:14:\"author_profile\";s:49:\"https://profiles.wordpress.org/theeventscalendar/\";s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:86;s:7:\"ratings\";a:5:{i:5;i:1728;i:4;i:131;i:3;i:87;i:2;i:70;i:1;i:298;}s:11:\"num_ratings\";i:2314;s:11:\"support_url\";s:57:\"https://wordpress.org/support/plugin/the-events-calendar/\";s:15:\"support_threads\";i:140;s:24:\"support_threads_resolved\";i:128;s:15:\"active_installs\";i:700000;s:12:\"last_updated\";s:21:\"2024-12-17 7:24pm GMT\";s:5:\"added\";s:10:\"2010-01-19\";s:8:\"homepage\";s:0:\"\";s:13:\"download_link\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.9.0.zip\";s:14:\"upgrade_notice\";a:1:{s:5:\"[6.0]\";s:242:\"<p>Please see the changelog for the complete list of changes in this release.\nPrevious versions of The Events Calendar are not cross-compatible with 6.X add-ons.\nRemember to always make a backup of your database and files before updating!</p>\";}s:11:\"screenshots\";a:9:{i:1;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-1.png?rev=2755131\";s:7:\"caption\";s:27:\"Affichage du mois au survol\";}i:2;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-2.png?rev=2755131\";s:7:\"caption\";s:10:\"Vue mobile\";}i:3;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-3.png?rev=2755131\";s:7:\"caption\";s:16:\"Évènement seul\";}i:4;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-4.png?rev=2755131\";s:7:\"caption\";s:17:\"Afficher en liste\";}i:5;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-5.png?rev=2755131\";s:7:\"caption\";s:25:\"Éditeur d’évènements\";}i:6;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-6.png?rev=2755131\";s:7:\"caption\";s:35:\"Liste des évènements coté Admin \";}i:7;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-7.png?rev=2755131\";s:7:\"caption\";s:20:\"Réglages généraux\";}i:8;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-8.png?rev=2755131\";s:7:\"caption\";s:30:\"Réglages de l&rsquo;affichage\";}i:9;a:2:{s:3:\"src\";s:72:\"https://ps.w.org/the-events-calendar/assets/screenshot-9.png?rev=2755131\";s:7:\"caption\";s:15:\"Importateur CSV\";}}s:4:\"tags\";a:5:{s:8:\"calendar\";s:8:\"calendar\";s:5:\"event\";s:5:\"Event\";s:6:\"events\";s:6:\"events\";s:9:\"organizer\";s:9:\"organizer\";s:8:\"schedule\";s:8:\"schedule\";}s:8:\"versions\";a:353:{s:3:\"1.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.zip\";s:5:\"1.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.1.zip\";s:5:\"1.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.2.zip\";s:5:\"1.5.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.3.zip\";s:5:\"1.5.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.4.zip\";s:5:\"1.5.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.5.zip\";s:5:\"1.5.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.5.6.zip\";s:3:\"1.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.zip\";s:5:\"1.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.1.zip\";s:5:\"1.6.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.2.zip\";s:5:\"1.6.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.3.zip\";s:5:\"1.6.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.4.zip\";s:5:\"1.6.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.1.6.5.zip\";s:3:\"2.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.zip\";s:5:\"2.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.1.zip\";s:6:\"2.0.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.10.zip\";s:6:\"2.0.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.11.zip\";s:5:\"2.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.2.zip\";s:5:\"2.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.3.zip\";s:5:\"2.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.4.zip\";s:5:\"2.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.5.zip\";s:5:\"2.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.6.zip\";s:5:\"2.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.7.zip\";s:5:\"2.0.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.8.zip\";s:5:\"2.0.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.2.0.9.zip\";s:3:\"3.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.zip\";s:5:\"3.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.1.zip\";s:5:\"3.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.2.zip\";s:5:\"3.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.0.3.zip\";s:3:\"3.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.1.zip\";s:4:\"3.10\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.zip\";s:6:\"3.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.10.1.zip\";s:4:\"3.11\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.zip\";s:6:\"3.11.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.1.zip\";s:6:\"3.11.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.11.2.zip\";s:4:\"3.12\";s:67:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.zip\";s:6:\"3.12.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.1.zip\";s:6:\"3.12.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.2.zip\";s:6:\"3.12.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.3.zip\";s:6:\"3.12.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.4.zip\";s:6:\"3.12.5\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.5.zip\";s:6:\"3.12.6\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.12.6.zip\";s:3:\"3.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.2.zip\";s:3:\"3.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.zip\";s:5:\"3.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.3.1.zip\";s:3:\"3.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.zip\";s:5:\"3.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.4.1.zip\";s:3:\"3.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.zip\";s:5:\"3.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.5.1.zip\";s:3:\"3.6\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.zip\";s:5:\"3.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.6.1.zip\";s:3:\"3.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.7.zip\";s:3:\"3.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.zip\";s:5:\"3.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.8.1.zip\";s:3:\"3.9\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.zip\";s:5:\"3.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.1.zip\";s:5:\"3.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.2.zip\";s:5:\"3.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.3.9.3.zip\";s:3:\"4.0\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.zip\";s:5:\"4.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.1.zip\";s:5:\"4.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.2.zip\";s:5:\"4.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.3.zip\";s:5:\"4.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.4.zip\";s:5:\"4.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.5.zip\";s:5:\"4.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.6.zip\";s:5:\"4.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.7.zip\";s:3:\"4.1\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.zip\";s:7:\"4.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.0.1.zip\";s:5:\"4.1.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.zip\";s:7:\"4.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.1.1.zip\";s:5:\"4.1.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.2.zip\";s:5:\"4.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.3.zip\";s:5:\"4.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.1.4.zip\";s:3:\"4.2\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.zip\";s:5:\"4.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.zip\";s:7:\"4.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.1.1.zip\";s:5:\"4.2.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.2.zip\";s:5:\"4.2.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.3.zip\";s:5:\"4.2.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.4.zip\";s:5:\"4.2.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.5.zip\";s:5:\"4.2.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.6.zip\";s:5:\"4.2.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.2.7.zip\";s:3:\"4.3\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.zip\";s:7:\"4.3.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.0.2.zip\";s:5:\"4.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.zip\";s:7:\"4.3.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.1.2.zip\";s:7:\"4.3.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.2.1.zip\";s:7:\"4.3.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.3.1.zip\";s:7:\"4.3.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.1.zip\";s:7:\"4.3.4.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.4.3.zip\";s:7:\"4.3.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.3.5.1.zip\";s:3:\"4.4\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.zip\";s:7:\"4.4.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.0.2.zip\";s:5:\"4.4.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.zip\";s:7:\"4.4.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.1.2.zip\";s:7:\"4.4.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.2.1.zip\";s:7:\"4.4.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.3.1.zip\";s:7:\"4.4.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.4.1.zip\";s:7:\"4.4.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.4.5.1.zip\";s:3:\"4.5\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.zip\";s:7:\"4.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.1.zip\";s:7:\"4.5.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.0.3.zip\";s:7:\"4.5.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.1.1.zip\";s:6:\"4.5.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.zip\";s:8:\"4.5.10.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.10.2.zip\";s:8:\"4.5.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.11.1.zip\";s:6:\"4.5.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.zip\";s:8:\"4.5.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.1.zip\";s:8:\"4.5.12.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.2.zip\";s:8:\"4.5.12.4\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.12.4.zip\";s:8:\"4.5.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.13.1.zip\";s:5:\"4.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.zip\";s:7:\"4.5.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.2.2.zip\";s:7:\"4.5.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.3.1.zip\";s:7:\"4.5.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.4.1.zip\";s:7:\"4.5.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.5.1.zip\";s:7:\"4.5.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.6.1.zip\";s:7:\"4.5.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.7.1.zip\";s:5:\"4.5.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.zip\";s:7:\"4.5.8.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.8.2.zip\";s:7:\"4.5.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.5.9.1.zip\";s:7:\"4.6.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.0.1.zip\";s:7:\"4.6.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.1.1.zip\";s:6:\"4.6.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.zip\";s:8:\"4.6.10.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.10.2.zip\";s:6:\"4.6.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.zip\";s:8:\"4.6.11.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.11.2.zip\";s:8:\"4.6.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.12.1.zip\";s:8:\"4.6.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.13.1.zip\";s:6:\"4.6.14\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.zip\";s:8:\"4.6.14.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.14.2.zip\";s:8:\"4.6.15.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.15.1.zip\";s:8:\"4.6.16.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.16.1.zip\";s:8:\"4.6.17.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.17.1.zip\";s:8:\"4.6.18.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.18.1.zip\";s:8:\"4.6.19.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.19.1.zip\";s:7:\"4.6.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.2.1.zip\";s:6:\"4.6.20\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.zip\";s:8:\"4.6.20.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.20.2.zip\";s:8:\"4.6.21.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.21.1.zip\";s:6:\"4.6.22\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.zip\";s:8:\"4.6.22.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.22.2.zip\";s:8:\"4.6.23.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.23.1.zip\";s:6:\"4.6.24\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.zip\";s:8:\"4.6.24.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.24.2.zip\";s:8:\"4.6.25.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.25.1.zip\";s:6:\"4.6.26\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.zip\";s:8:\"4.6.26.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.26.2.zip\";s:7:\"4.6.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.3.1.zip\";s:7:\"4.6.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.4.1.zip\";s:7:\"4.6.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.5.1.zip\";s:7:\"4.6.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.6.1.zip\";s:7:\"4.6.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.7.1.zip\";s:7:\"4.6.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.8.1.zip\";s:7:\"4.6.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.9.1.zip\";s:3:\"4.7\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.zip\";s:7:\"4.7.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.0.2.zip\";s:7:\"4.7.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.1.1.zip\";s:7:\"4.7.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.2.1.zip\";s:7:\"4.7.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.3.1.zip\";s:7:\"4.7.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.7.4.1.zip\";s:3:\"4.8\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.zip\";s:7:\"4.8.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.0.2.zip\";s:7:\"4.8.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.1.1.zip\";s:7:\"4.8.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.8.2.1.zip\";s:7:\"4.9.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.1.zip\";s:7:\"4.9.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.2.zip\";s:7:\"4.9.0.4\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.0.4.zip\";s:5:\"4.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.1.zip\";s:7:\"4.9.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.1.2.zip\";s:8:\"4.9.10.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.10.1.zip\";s:8:\"4.9.11.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.11.1.zip\";s:8:\"4.9.12.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.12.1.zip\";s:8:\"4.9.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.13.1.zip\";s:8:\"4.9.14.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.14.1.zip\";s:7:\"4.9.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.2.1.zip\";s:5:\"4.9.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.zip\";s:7:\"4.9.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.1.zip\";s:7:\"4.9.3.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.3.3.zip\";s:7:\"4.9.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.4.1.zip\";s:7:\"4.9.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.5.1.zip\";s:7:\"4.9.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.6.1.zip\";s:7:\"4.9.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.7.1.zip\";s:7:\"4.9.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.8.1.zip\";s:7:\"4.9.9.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.9.9.1.zip\";s:5:\"5.0.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.zip\";s:7:\"5.0.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.1.zip\";s:7:\"5.0.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.0.3.zip\";s:7:\"5.0.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.1.1.zip\";s:7:\"5.0.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.1.2.zip\";s:5:\"5.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.zip\";s:7:\"5.0.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.2.zip\";s:7:\"5.0.2.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.2.3.zip\";s:5:\"5.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.zip\";s:7:\"5.0.3.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.2.zip\";s:7:\"5.0.3.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.0.3.3.zip\";s:7:\"5.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.0.1.zip\";s:7:\"5.1.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.0.2.zip\";s:7:\"5.1.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.1.1.zip\";s:7:\"5.1.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.1.2.zip\";s:7:\"5.1.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.2.1.zip\";s:7:\"5.1.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.2.2.zip\";s:5:\"5.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.3.zip\";s:7:\"5.1.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.3.1.zip\";s:5:\"5.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.4.zip\";s:7:\"5.1.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.4.1.zip\";s:5:\"5.1.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.5.zip\";s:7:\"5.1.5.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.5.1.zip\";s:5:\"5.1.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.6.zip\";s:7:\"5.1.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.1.6.1.zip\";s:6:\"5.10.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.0.zip\";s:6:\"5.10.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.10.1.zip\";s:6:\"5.11.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.11.0.zip\";s:6:\"5.12.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.0.zip\";s:6:\"5.12.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.1.zip\";s:6:\"5.12.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.2.zip\";s:6:\"5.12.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.3.zip\";s:6:\"5.12.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.12.4.zip\";s:6:\"5.13.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.13.0.zip\";s:6:\"5.14.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.zip\";s:8:\"5.14.0.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.1.zip\";s:8:\"5.14.0.2\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.2.zip\";s:8:\"5.14.0.3\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.3.zip\";s:8:\"5.14.0.4\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.0.4.zip\";s:6:\"5.14.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.1.zip\";s:6:\"5.14.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.2.zip\";s:8:\"5.14.2.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.14.2.1.zip\";s:6:\"5.15.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.15.0.zip\";s:8:\"5.15.0.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.15.0.1.zip\";s:6:\"5.16.0\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.0.zip\";s:6:\"5.16.1\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.1.zip\";s:8:\"5.16.1.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.1.1.zip\";s:6:\"5.16.2\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.2.zip\";s:8:\"5.16.2.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.2.1.zip\";s:6:\"5.16.3\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.3.zip\";s:8:\"5.16.3.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.3.1.zip\";s:6:\"5.16.4\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.4.zip\";s:8:\"5.16.4.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.16.4.1.zip\";s:5:\"5.2.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.0.zip\";s:7:\"5.2.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.0.1.zip\";s:5:\"5.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.zip\";s:7:\"5.2.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.1.zip\";s:7:\"5.2.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.2.1.2.zip\";s:5:\"5.3.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.0.zip\";s:7:\"5.3.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.0.1.zip\";s:5:\"5.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.zip\";s:7:\"5.3.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.1.zip\";s:7:\"5.3.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.1.2.zip\";s:5:\"5.3.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.zip\";s:7:\"5.3.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.1.zip\";s:7:\"5.3.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.3.2.2.zip\";s:5:\"5.4.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.zip\";s:7:\"5.4.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.1.zip\";s:7:\"5.4.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.2.zip\";s:7:\"5.4.0.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.4.0.3.zip\";s:5:\"5.5.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.zip\";s:7:\"5.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.1.zip\";s:7:\"5.5.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.5.0.2.zip\";s:5:\"5.6.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.6.0.zip\";s:5:\"5.7.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.7.0.zip\";s:5:\"5.7.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.7.1.zip\";s:5:\"5.8.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.0.zip\";s:5:\"5.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.1.zip\";s:5:\"5.8.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.8.2.zip\";s:5:\"5.9.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.0.zip\";s:5:\"5.9.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.1.zip\";s:5:\"5.9.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.5.9.2.zip\";s:5:\"6.0.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.0.zip\";s:7:\"6.0.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.0.1.zip\";s:5:\"6.0.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.1.zip\";s:7:\"6.0.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.1.1.zip\";s:6:\"6.0.10\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.10.zip\";s:6:\"6.0.11\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.11.zip\";s:6:\"6.0.12\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.12.zip\";s:6:\"6.0.13\";s:69:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.13.zip\";s:8:\"6.0.13.1\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.13.1.zip\";s:5:\"6.0.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.2.zip\";s:5:\"6.0.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.3.zip\";s:7:\"6.0.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.3.1.zip\";s:5:\"6.0.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.4.zip\";s:5:\"6.0.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.5.zip\";s:5:\"6.0.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.6.zip\";s:7:\"6.0.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.6.1.zip\";s:7:\"6.0.6.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.6.2.zip\";s:5:\"6.0.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.7.zip\";s:7:\"6.0.7.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.7.1.zip\";s:5:\"6.0.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.8.zip\";s:5:\"6.0.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.0.9.zip\";s:5:\"6.1.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.0.zip\";s:7:\"6.1.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.0.1.zip\";s:7:\"6.1.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.0.2.zip\";s:5:\"6.1.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.1.zip\";s:5:\"6.1.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.2.zip\";s:7:\"6.1.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.2.1.zip\";s:7:\"6.1.2.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.2.2.zip\";s:5:\"6.1.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.3.zip\";s:5:\"6.1.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.1.4.zip\";s:5:\"6.2.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.0.zip\";s:7:\"6.2.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.0.1.zip\";s:5:\"6.2.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.1.zip\";s:5:\"6.2.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.2.zip\";s:7:\"6.2.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.2.1.zip\";s:5:\"6.2.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.3.zip\";s:7:\"6.2.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.3.1.zip\";s:7:\"6.2.3.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.3.2.zip\";s:5:\"6.2.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.4.zip\";s:5:\"6.2.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.5.zip\";s:5:\"6.2.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.6.zip\";s:7:\"6.2.6.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.6.1.zip\";s:5:\"6.2.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.7.zip\";s:5:\"6.2.8\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.8.zip\";s:7:\"6.2.8.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.8.1.zip\";s:7:\"6.2.8.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.8.2.zip\";s:5:\"6.2.9\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.2.9.zip\";s:5:\"6.3.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.0.zip\";s:5:\"6.3.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.1.zip\";s:5:\"6.3.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.2.zip\";s:5:\"6.3.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.3.zip\";s:7:\"6.3.3.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.3.1.zip\";s:5:\"6.3.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.4.zip\";s:5:\"6.3.5\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.5.zip\";s:5:\"6.3.6\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.6.zip\";s:5:\"6.3.7\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.3.7.zip\";s:5:\"6.4.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.4.0.zip\";s:7:\"6.4.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.4.0.1.zip\";s:5:\"6.5.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.0.zip\";s:7:\"6.5.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.0.1.zip\";s:5:\"6.5.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.zip\";s:7:\"6.5.1.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.1.zip\";s:7:\"6.5.1.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.2.zip\";s:7:\"6.5.1.3\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.3.zip\";s:7:\"6.5.1.4\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.4.zip\";s:7:\"6.5.1.5\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.5.zip\";s:7:\"6.5.1.6\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.1.6.zip\";s:5:\"6.5.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.5.2.zip\";s:5:\"6.6.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.0.zip\";s:7:\"6.6.0.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.0.1.zip\";s:7:\"6.6.0.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.0.2.zip\";s:5:\"6.6.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.1.zip\";s:5:\"6.6.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.2.zip\";s:5:\"6.6.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.3.zip\";s:5:\"6.6.4\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.4.zip\";s:7:\"6.6.4.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.4.1.zip\";s:7:\"6.6.4.2\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.6.4.2.zip\";s:5:\"6.7.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.7.0.zip\";s:5:\"6.7.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.7.1.zip\";s:5:\"6.8.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.8.0.zip\";s:5:\"6.8.1\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.8.1.zip\";s:5:\"6.8.2\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.8.2.zip\";s:7:\"6.8.2.1\";s:70:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.8.2.1.zip\";s:5:\"6.8.3\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.8.3.zip\";s:5:\"6.9.0\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.9.0.zip\";s:5:\"trunk\";s:62:\"https://downloads.wordpress.org/plugin/the-events-calendar.zip\";}s:14:\"business_model\";b:0;s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:18:\"https://evnt.is/29\";s:7:\"banners\";a:2:{s:3:\"low\";s:74:\"https://ps.w.org/the-events-calendar/assets/banner-772x250.png?rev=2257622\";s:4:\"high\";s:75:\"https://ps.w.org/the-events-calendar/assets/banner-1544x500.png?rev=2257622\";}s:12:\"preview_link\";s:0:\"\";}s:13:\"wordpress-seo\";a:30:{s:4:\"name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:7:\"version\";s:4:\"24.1\";s:6:\"author\";s:43:\"<a href=\"https://yoa.st/1uk\">Team Yoast</a>\";s:14:\"author_profile\";s:37:\"https://profiles.wordpress.org/yoast/\";s:8:\"requires\";s:3:\"6.5\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:5:\"7.2.5\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:96;s:7:\"ratings\";a:5:{i:5;i:25952;i:4;i:631;i:3;i:197;i:2;i:139;i:1;i:827;}s:11:\"num_ratings\";i:27746;s:11:\"support_url\";s:51:\"https://wordpress.org/support/plugin/wordpress-seo/\";s:15:\"support_threads\";i:213;s:24:\"support_threads_resolved\";i:203;s:15:\"active_installs\";i:10000000;s:12:\"last_updated\";s:21:\"2024-12-18 8:53am GMT\";s:5:\"added\";s:10:\"2010-10-11\";s:8:\"homepage\";s:18:\"https://yoa.st/1uj\";s:13:\"download_link\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.24.1.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:9:{i:1;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-1.png?rev=2853382\";s:7:\"caption\";s:56:\"Son interface moderne rend Yoast SEO facile à utiliser.\";}i:2;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-2.png?rev=2853382\";s:7:\"caption\";s:86:\"Gérez facilement la façon dont vos articles et vos pages apparaissent dans les SERP.\";}i:3;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-3.png?rev=2853382\";s:7:\"caption\";s:91:\"Yoast SEO Premium dispose d‘options supplémentaires d‘optimisation de l‘exploration.\";}i:4;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-4.png?rev=2853382\";s:7:\"caption\";s:65:\"Yoast SEO s‘intègre à des outils tels que Semrush et Wincher.\";}i:5;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-5.png?rev=2853382\";s:7:\"caption\";s:74:\"Les fameuses analyses de référencement et de lisibilité dans Yoast SEO.\";}i:6;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-6.png?rev=2853382\";s:7:\"caption\";s:54:\"Voyez à quoi ressemble votre publication dans Google.\";}i:7;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-7.png?rev=2853382\";s:7:\"caption\";s:68:\"La configuration des premiers pas vous aide à démarrer rapidement.\";}i:8;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-8.png?rev=2853382\";s:7:\"caption\";s:50:\"L‘analyse linguistique inclusive dans Yoast SEO.\";}i:9;a:2:{s:3:\"src\";s:66:\"https://ps.w.org/wordpress-seo/assets/screenshot-9.png?rev=2956588\";s:7:\"caption\";s:0:\"\";}}s:4:\"tags\";a:5:{s:16:\"content-analysis\";s:16:\"Content analysis\";s:11:\"readability\";s:11:\"Readability\";s:6:\"schema\";s:6:\"schema\";s:3:\"seo\";s:3:\"seo\";s:11:\"xml-sitemap\";s:11:\"xml sitemap\";}s:8:\"versions\";a:81:{s:4:\"18.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.0.zip\";s:4:\"18.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.1.zip\";s:4:\"18.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.2.zip\";s:4:\"18.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.3.zip\";s:4:\"18.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.4.zip\";s:6:\"18.4.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.4.1.zip\";s:4:\"18.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.5.zip\";s:6:\"18.5.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.5.1.zip\";s:4:\"18.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.6.zip\";s:4:\"18.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.7.zip\";s:4:\"18.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.8.zip\";s:4:\"18.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.18.9.zip\";s:4:\"19.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.0.zip\";s:4:\"19.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.1.zip\";s:5:\"19.10\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.10.zip\";s:5:\"19.11\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.11.zip\";s:5:\"19.12\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.12.zip\";s:5:\"19.13\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.13.zip\";s:5:\"19.14\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.14.zip\";s:4:\"19.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.2.zip\";s:4:\"19.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.3.zip\";s:4:\"19.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.4.zip\";s:4:\"19.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.5.zip\";s:6:\"19.5.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.5.1.zip\";s:4:\"19.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.6.zip\";s:6:\"19.6.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.6.1.zip\";s:4:\"19.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.7.zip\";s:6:\"19.7.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.7.1.zip\";s:6:\"19.7.2\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.7.2.zip\";s:4:\"19.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.8.zip\";s:4:\"19.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.19.9.zip\";s:4:\"20.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.0.zip\";s:4:\"20.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.1.zip\";s:5:\"20.10\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.10.zip\";s:5:\"20.11\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.11.zip\";s:5:\"20.12\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.12.zip\";s:5:\"20.13\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.13.zip\";s:4:\"20.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.2.zip\";s:6:\"20.2.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.2.1.zip\";s:4:\"20.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.3.zip\";s:4:\"20.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.4.zip\";s:4:\"20.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.5.zip\";s:4:\"20.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.6.zip\";s:4:\"20.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.7.zip\";s:4:\"20.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.8.zip\";s:4:\"20.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.20.9.zip\";s:4:\"21.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.0.zip\";s:4:\"21.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.1.zip\";s:4:\"21.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.2.zip\";s:4:\"21.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.3.zip\";s:4:\"21.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.4.zip\";s:4:\"21.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.5.zip\";s:4:\"21.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.6.zip\";s:4:\"21.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.7.zip\";s:4:\"21.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.8.zip\";s:6:\"21.8.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.8.1.zip\";s:4:\"21.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.9.zip\";s:6:\"21.9.1\";s:63:\"https://downloads.wordpress.org/plugin/wordpress-seo.21.9.1.zip\";s:4:\"22.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.0.zip\";s:4:\"22.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.1.zip\";s:4:\"22.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.2.zip\";s:4:\"22.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.3.zip\";s:4:\"22.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.4.zip\";s:4:\"22.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.5.zip\";s:4:\"22.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.6.zip\";s:4:\"22.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.7.zip\";s:4:\"22.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.8.zip\";s:4:\"22.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.22.9.zip\";s:4:\"23.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.0.zip\";s:4:\"23.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.1.zip\";s:4:\"23.2\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.2.zip\";s:4:\"23.3\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.3.zip\";s:4:\"23.4\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.4.zip\";s:4:\"23.5\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.5.zip\";s:4:\"23.6\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.6.zip\";s:4:\"23.7\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.7.zip\";s:4:\"23.8\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.8.zip\";s:4:\"23.9\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.23.9.zip\";s:4:\"24.0\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.24.0.zip\";s:4:\"24.1\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.24.1.zip\";s:5:\"trunk\";s:56:\"https://downloads.wordpress.org/plugin/wordpress-seo.zip\";}s:14:\"business_model\";s:10:\"commercial\";s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:39:\"https://yoast.com/help/support/#premium\";s:11:\"donate_link\";s:18:\"https://yoa.st/1up\";s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";s:4:\"high\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";}s:12:\"preview_link\";s:0:\"\";}s:6:\"leadin\";a:30:{s:4:\"name\";s:79:\"HubSpot &#8211; CRM, e-mail marketing, chat en direct, formulaires et analytics\";s:4:\"slug\";s:6:\"leadin\";s:7:\"version\";s:7:\"11.1.75\";s:6:\"author\";s:59:\"<a href=\"http://hubspot.com/products/wordpress\">HubSpot</a>\";s:14:\"author_profile\";s:42:\"https://profiles.wordpress.org/hubspotdev/\";s:8:\"requires\";s:3:\"5.8\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.2\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:88;s:7:\"ratings\";a:5:{i:5;i:159;i:4;i:13;i:3;i:5;i:2;i:10;i:1;i:20;}s:11:\"num_ratings\";i:207;s:11:\"support_url\";s:44:\"https://wordpress.org/support/plugin/leadin/\";s:15:\"support_threads\";i:3;s:24:\"support_threads_resolved\";i:1;s:15:\"active_installs\";i:300000;s:12:\"last_updated\";s:22:\"2024-12-02 10:51am GMT\";s:5:\"added\";s:10:\"2014-03-12\";s:8:\"homepage\";s:45:\"http://www.hubspot.com/integrations/wordpress\";s:13:\"download_link\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.75.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:8:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-1.png?rev=3041936\";s:7:\"caption\";s:64:\"Utilisez des rapports pour mesurer l‘impact de vos activités.\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-2.png?rev=3041936\";s:7:\"caption\";s:100:\"Organisez et suivez vos leads, et faites-les parvenir à maturation, avec le CRM gratuit de HubSpot.\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-3.png?rev=3041936\";s:7:\"caption\";s:89:\"Les formulaires de votre site web se synchroniseront automatiquement avec le CRM HubSpot.\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-4.png?rev=3041936\";s:7:\"caption\";s:94:\"Convertissez vos leads et faites-les parvenir à maturation au moyen de listes et d‘e-mails.\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-5.png?rev=3041936\";s:7:\"caption\";s:76:\"Envoyez à vos contacts un e-mail professionnel, pertinent et personnalisé.\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-6.png?rev=3041936\";s:7:\"caption\";s:120:\"Ajoutez un chat en direct à votre site web afin d‘aider vos visiteurs et d‘interagir avec eux en toute simplicité.\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-7.png?rev=3041936\";s:7:\"caption\";s:114:\"Ajoutez des chatbots disponibles en continu à votre site web pour automatiser la capture des leads et le support.\";}i:8;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/leadin/assets/screenshot-8.png?rev=3041936\";s:7:\"caption\";s:170:\"Créez des formulaires et des formulaires contextuels esthétiques en quelques minutes pour votre site web grâce à l‘éditeur en glisser-déposer intuitif de HubSpot.\";}}s:4:\"tags\";a:5:{s:9:\"analytics\";s:9:\"analytics\";s:3:\"crm\";s:3:\"crm\";s:5:\"forms\";s:5:\"forms\";s:9:\"live-chat\";s:9:\"live chat\";s:9:\"marketing\";s:9:\"marketing\";}s:8:\"versions\";a:48:{s:7:\"10.0.18\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.0.18.zip\";s:7:\"10.0.21\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.0.21.zip\";s:7:\"10.0.24\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.0.24.zip\";s:6:\"10.0.7\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.0.7.zip\";s:7:\"10.1.13\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.13.zip\";s:7:\"10.1.16\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.16.zip\";s:7:\"10.1.23\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.23.zip\";s:7:\"10.1.27\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.27.zip\";s:7:\"10.1.29\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.1.29.zip\";s:6:\"10.1.6\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.1.6.zip\";s:6:\"10.2.0\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.2.0.zip\";s:7:\"10.2.12\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.2.12.zip\";s:7:\"10.2.15\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.2.15.zip\";s:7:\"10.2.16\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.2.16.zip\";s:6:\"10.2.2\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.2.2.zip\";s:7:\"10.2.22\";s:57:\"https://downloads.wordpress.org/plugin/leadin.10.2.22.zip\";s:6:\"10.2.4\";s:56:\"https://downloads.wordpress.org/plugin/leadin.10.2.4.zip\";s:7:\"11.0.16\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.16.zip\";s:6:\"11.0.2\";s:56:\"https://downloads.wordpress.org/plugin/leadin.11.0.2.zip\";s:7:\"11.0.22\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.22.zip\";s:7:\"11.0.27\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.27.zip\";s:6:\"11.0.3\";s:56:\"https://downloads.wordpress.org/plugin/leadin.11.0.3.zip\";s:7:\"11.0.31\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.31.zip\";s:7:\"11.0.52\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.52.zip\";s:7:\"11.0.54\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.54.zip\";s:7:\"11.0.56\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.56.zip\";s:7:\"11.0.58\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.0.58.zip\";s:6:\"11.0.7\";s:56:\"https://downloads.wordpress.org/plugin/leadin.11.0.7.zip\";s:7:\"11.1.10\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.10.zip\";s:7:\"11.1.11\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.11.zip\";s:7:\"11.1.13\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.13.zip\";s:7:\"11.1.14\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.14.zip\";s:7:\"11.1.15\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.15.zip\";s:6:\"11.1.2\";s:56:\"https://downloads.wordpress.org/plugin/leadin.11.1.2.zip\";s:7:\"11.1.20\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.20.zip\";s:7:\"11.1.21\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.21.zip\";s:7:\"11.1.22\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.22.zip\";s:7:\"11.1.34\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.34.zip\";s:7:\"11.1.40\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.40.zip\";s:6:\"11.1.6\";s:56:\"https://downloads.wordpress.org/plugin/leadin.11.1.6.zip\";s:7:\"11.1.60\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.60.zip\";s:7:\"11.1.65\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.65.zip\";s:7:\"11.1.66\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.66.zip\";s:7:\"11.1.73\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.73.zip\";s:7:\"11.1.75\";s:57:\"https://downloads.wordpress.org/plugin/leadin.11.1.75.zip\";s:5:\"9.2.0\";s:55:\"https://downloads.wordpress.org/plugin/leadin.9.2.0.zip\";s:6:\"9.2.26\";s:56:\"https://downloads.wordpress.org/plugin/leadin.9.2.26.zip\";s:5:\"trunk\";s:49:\"https://downloads.wordpress.org/plugin/leadin.zip\";}s:14:\"business_model\";b:0;s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://ps.w.org/leadin/assets/banner-772x250.png?rev=3041936\";s:4:\"high\";s:62:\"https://ps.w.org/leadin/assets/banner-1544x500.png?rev=3041936\";}s:12:\"preview_link\";s:0:\"\";}s:7:\"bbpress\";a:30:{s:4:\"name\";s:7:\"bbPress\";s:4:\"slug\";s:7:\"bbpress\";s:7:\"version\";s:6:\"2.6.11\";s:6:\"author\";s:58:\"<a href=\"https://bbpress.org\">The bbPress Contributors</a>\";s:14:\"author_profile\";s:47:\"https://profiles.wordpress.org/johnjamesjacoby/\";s:8:\"requires\";s:3:\"6.0\";s:6:\"tested\";s:5:\"6.5.5\";s:12:\"requires_php\";s:6:\"5.6.20\";s:16:\"requires_plugins\";a:0:{}s:6:\"rating\";i:78;s:7:\"ratings\";a:5:{i:5;i:197;i:4;i:40;i:3;i:25;i:2;i:21;i:1;i:58;}s:11:\"num_ratings\";i:341;s:11:\"support_url\";s:45:\"https://wordpress.org/support/plugin/bbpress/\";s:15:\"support_threads\";i:0;s:24:\"support_threads_resolved\";i:0;s:15:\"active_installs\";i:100000;s:12:\"last_updated\";s:21:\"2024-06-29 5:02pm GMT\";s:5:\"added\";s:10:\"2010-01-13\";s:8:\"homepage\";s:19:\"https://bbpress.org\";s:13:\"download_link\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.6.11.zip\";s:14:\"upgrade_notice\";a:0:{}s:11:\"screenshots\";a:7:{i:1;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-1.png?rev=872931\";s:7:\"caption\";s:37:\"Forums - Interface d’administration\";}i:2;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-2.png?rev=872931\";s:7:\"caption\";s:37:\"Sujets - Interface d’administration\";}i:3;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-3.png?rev=872931\";s:7:\"caption\";s:40:\"Réponses - Interface d’administration\";}i:4;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-4.png?rev=872931\";s:7:\"caption\";s:42:\"Paramètres - Interface d’administration\";}i:5;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-5.png?rev=872931\";s:7:\"caption\";s:44:\"Paramètres 2 - Interface d’administration\";}i:6;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-6.png?rev=872931\";s:7:\"caption\";s:38:\"Thèmes - Interface d’administration\";}i:7;a:2:{s:3:\"src\";s:59:\"https://ps.w.org/bbpress/assets/screenshot-7.png?rev=872931\";s:7:\"caption\";s:37:\"Forum individuel - Thème par défaut\";}}s:4:\"tags\";a:4:{s:10:\"discussion\";s:10:\"discussion\";s:5:\"forum\";s:5:\"forum\";s:6:\"forums\";s:6:\"forums\";s:7:\"support\";s:7:\"support\";}s:8:\"versions\";a:67:{s:3:\"2.0\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.0.zip\";s:10:\"2.0-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-1.zip\";s:11:\"2.0-beta-2b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-2b.zip\";s:10:\"2.0-beta-3\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3.zip\";s:11:\"2.0-beta-3b\";s:62:\"https://downloads.wordpress.org/plugin/bbpress.2.0-beta-3b.zip\";s:8:\"2.0-rc-2\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-2.zip\";s:8:\"2.0-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-3.zip\";s:8:\"2.0-rc-4\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-4.zip\";s:8:\"2.0-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.0-rc-5.zip\";s:5:\"2.0.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.1.zip\";s:5:\"2.0.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.2.zip\";s:5:\"2.0.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.0.3.zip\";s:3:\"2.1\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.1.zip\";s:10:\"2.1-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.1-beta-1.zip\";s:7:\"2.1-rc1\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc1.zip\";s:7:\"2.1-rc2\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc2.zip\";s:7:\"2.1-rc3\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc3.zip\";s:7:\"2.1-rc4\";s:58:\"https://downloads.wordpress.org/plugin/bbpress.2.1-rc4.zip\";s:5:\"2.1.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.1.zip\";s:5:\"2.1.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.2.zip\";s:5:\"2.1.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.1.3.zip\";s:3:\"2.2\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.2.zip\";s:5:\"2.2.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.1.zip\";s:5:\"2.2.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.2.zip\";s:5:\"2.2.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.3.zip\";s:5:\"2.2.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.2.4.zip\";s:3:\"2.3\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.3.zip\";s:9:\"2.3-beta1\";s:60:\"https://downloads.wordpress.org/plugin/bbpress.2.3-beta1.zip\";s:5:\"2.3.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.1.zip\";s:5:\"2.3.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.3.2.zip\";s:3:\"2.4\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.4.zip\";s:5:\"2.4.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.4.1.zip\";s:3:\"2.5\";s:54:\"https://downloads.wordpress.org/plugin/bbpress.2.5.zip\";s:5:\"2.5.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.1.zip\";s:6:\"2.5.10\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.10.zip\";s:6:\"2.5.11\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.11.zip\";s:6:\"2.5.12\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.12.zip\";s:6:\"2.5.13\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.13.zip\";s:6:\"2.5.14\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:5:\"2.5.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.2.zip\";s:5:\"2.5.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.3.zip\";s:5:\"2.5.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.4.zip\";s:5:\"2.5.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.5.zip\";s:5:\"2.5.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.6.zip\";s:5:\"2.5.7\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.7.zip\";s:5:\"2.5.8\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.8.zip\";s:5:\"2.5.9\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.5.9.zip\";s:10:\"2.6-beta-1\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-1.zip\";s:10:\"2.6-beta-2\";s:61:\"https://downloads.wordpress.org/plugin/bbpress.2.6-beta-2.zip\";s:8:\"2.6-rc-1\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-1.zip\";s:8:\"2.6-rc-3\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-3.zip\";s:8:\"2.6-rc-5\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-5.zip\";s:8:\"2.6-rc-6\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-6.zip\";s:8:\"2.6-rc-7\";s:59:\"https://downloads.wordpress.org/plugin/bbpress.2.6-rc-7.zip\";s:5:\"2.6.0\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.0.zip\";s:5:\"2.6.1\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.1.zip\";s:6:\"2.6.10\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.6.10.zip\";s:6:\"2.6.11\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.6.11.zip\";s:5:\"2.6.2\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.2.zip\";s:5:\"2.6.3\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.3.zip\";s:5:\"2.6.4\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.4.zip\";s:5:\"2.6.5\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.5.zip\";s:5:\"2.6.6\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.6.zip\";s:5:\"2.6.7\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.7.zip\";s:5:\"2.6.8\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.8.zip\";s:5:\"2.6.9\";s:56:\"https://downloads.wordpress.org/plugin/bbpress.2.6.9.zip\";s:5:\"trunk\";s:50:\"https://downloads.wordpress.org/plugin/bbpress.zip\";}s:14:\"business_model\";b:0;s:14:\"repository_url\";s:0:\"\";s:22:\"commercial_support_url\";s:0:\"\";s:11:\"donate_link\";s:0:\"\";s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://ps.w.org/bbpress/assets/banner-772x250.png?rev=478663\";s:4:\"high\";s:62:\"https://ps.w.org/bbpress/assets/banner-1544x500.png?rev=567403\";}s:12:\"preview_link\";s:0:\"\";}}", "off");
INSERT INTO `wor6069_options` VALUES("224", "fusion_registration_data", "a:1:{s:5:\"avada\";a:5:{s:5:\"token\";s:0:\"\";s:13:\"purchase_code\";s:36:\"4ab13107-2854-409f-bc33-206ef359619a\";s:8:\"is_valid\";b:1;s:6:\"scopes\";a:0:{}s:6:\"errors\";s:0:\"\";}}", "auto");
INSERT INTO `wor6069_options` VALUES("230", "fusion_core_version", "5.11.13", "auto");
INSERT INTO `wor6069_options` VALUES("231", "widget_ad_125_125-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("232", "widget_fusion_author-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("233", "widget_contact_info-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("234", "widget_pyre_tabs-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("235", "widget_recent_works-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("236", "widget_tweets-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("237", "widget_flickr-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("238", "widget_social_links-widget", "a:2:{i:2;a:48:{s:5:\"title\";s:0:\"\";s:10:\"linktarget\";s:0:\"\";s:15:\"icons_font_size\";s:4:\"16px\";s:10:\"icon_color\";s:7:\"#030303\";s:10:\"boxed_icon\";s:3:\"Yes\";s:11:\"boxed_color\";s:7:\"#ffffff\";s:10:\"color_type\";s:6:\"custom\";s:17:\"boxed_icon_radius\";s:4:\"50px\";s:18:\"boxed_icon_padding\";s:4:\"16px\";s:11:\"tooltip_pos\";s:3:\"Top\";s:11:\"show_custom\";s:2:\"No\";s:7:\"fb_link\";s:53:\"https://www.facebook.com/ThemeFusion-101565403356430/\";s:11:\"flickr_link\";s:0:\"\";s:8:\"rss_link\";s:0:\"\";s:12:\"twitter_link\";s:32:\"https://twitter.com/Theme_Fusion\";s:10:\"vimeo_link\";s:0:\"\";s:12:\"youtube_link\";s:47:\"https://www.youtube.com/user/ThemeFusionVideos/\";s:14:\"instagram_link\";s:44:\"https://www.instagram.com/themefusion/?hl=en\";s:14:\"pinterest_link\";s:0:\"\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:9:\"digg_link\";s:0:\"\";s:13:\"linkedin_link\";s:44:\"https://www.linkedin.com/company/themefusion\";s:12:\"blogger_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:11:\"forrst_link\";s:0:\"\";s:12:\"myspace_link\";s:0:\"\";s:15:\"deviantart_link\";s:0:\"\";s:10:\"yahoo_link\";s:0:\"\";s:11:\"reddit_link\";s:0:\"\";s:11:\"paypal_link\";s:0:\"\";s:12:\"dropbox_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:9:\"xing_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:10:\"email_link\";s:0:\"\";s:6:\"use_to\";s:2:\"No\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("239", "widget_facebook-like-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("240", "widget_menu-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("241", "widget_avada-vertical-menu-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("242", "widget_form-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor6069_options` VALUES("256", "fusion_builder_version", "3.11.13", "auto");
INSERT INTO `wor6069_options` VALUES("265", "fusion_form_cleanup_datetime", "1736521424", "auto");
INSERT INTO `wor6069_options` VALUES("269", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"24.2\";}", "auto");
INSERT INTO `wor6069_options` VALUES("270", "wpseo", "a:105:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"24.2\";s:16:\"previous_version\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1735311627;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:33:\"https://donnadieu.agencemiyou.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:8:{s:18:\"fusion_tb_category\";s:18:\"fusion_tb_category\";s:18:\"portfolio_category\";s:18:\"portfolio_category\";s:16:\"portfolio_skills\";s:16:\"portfolio_skills\";s:14:\"portfolio_tags\";s:14:\"portfolio_tags\";s:12:\"faq_category\";s:12:\"faq_category\";s:16:\"element_category\";s:16:\"element_category\";s:17:\"template_category\";s:17:\"template_category\";s:10:\"slide-page\";s:10:\"slide-page\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:1;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:5:{s:30:\"aioseo_custom_archive_settings\";b:1;s:31:\"aioseo_default_archive_settings\";b:1;s:23:\"aioseo_general_settings\";b:1;s:32:\"aioseo_posttype_default_settings\";b:1;s:24:\"aioseo_taxonomy_settings\";b:1;}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:1;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1735311632;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";i:4;s:5:\"slide\";}s:28:\"last_known_public_taxonomies\";a:11:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:18:\"fusion_tb_category\";i:4;s:18:\"portfolio_category\";i:5;s:16:\"portfolio_skills\";i:6;s:14:\"portfolio_tags\";i:7;s:12:\"faq_category\";i:8;s:16:\"element_category\";i:9;s:17:\"template_category\";i:10;s:10:\"slide-page\";}s:23:\"last_known_no_unindexed\";a:6:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1736436093;s:31:\"wpseo_unindexed_post_link_count\";i:1736436093;s:31:\"wpseo_unindexed_term_link_count\";i:1736436093;s:35:\"wpseo_total_unindexed_general_items\";i:1736436093;s:27:\"wpseo_total_unindexed_posts\";i:1736265744;s:27:\"wpseo_total_unindexed_terms\";i:1736265744;}s:14:\"new_post_types\";a:3:{i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";i:5;s:5:\"slide\";}s:14:\"new_taxonomies\";a:3:{i:3;s:18:\"fusion_tb_category\";i:9;s:16:\"element_category\";i:10;s:17:\"template_category\";}s:34:\"show_new_content_type_notification\";b:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("271", "wpseo_titles", "a:270:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:50:\"%%name%%, auteur/autrice sur %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Page non trouvée %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:30:\"Erreur 404 : Page introuvable\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:21:\"title-avada_portfolio\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-avada_portfolio\";s:0:\"\";s:23:\"noindex-avada_portfolio\";b:0;s:34:\"display-metabox-pt-avada_portfolio\";b:1;s:34:\"post_types-avada_portfolio-maintax\";i:0;s:32:\"schema-page-type-avada_portfolio\";s:7:\"WebPage\";s:35:\"schema-article-type-avada_portfolio\";s:4:\"None\";s:28:\"social-title-avada_portfolio\";s:9:\"%%title%%\";s:34:\"social-description-avada_portfolio\";s:0:\"\";s:32:\"social-image-url-avada_portfolio\";s:0:\"\";s:31:\"social-image-id-avada_portfolio\";i:0;s:31:\"title-ptarchive-avada_portfolio\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-ptarchive-avada_portfolio\";s:0:\"\";s:33:\"bctitle-ptarchive-avada_portfolio\";s:0:\"\";s:33:\"noindex-ptarchive-avada_portfolio\";b:0;s:38:\"social-title-ptarchive-avada_portfolio\";s:21:\"%%pt_plural%% Archive\";s:44:\"social-description-ptarchive-avada_portfolio\";s:0:\"\";s:42:\"social-image-url-ptarchive-avada_portfolio\";s:0:\"\";s:41:\"social-image-id-ptarchive-avada_portfolio\";i:0;s:15:\"title-avada_faq\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-avada_faq\";s:0:\"\";s:17:\"noindex-avada_faq\";b:0;s:28:\"display-metabox-pt-avada_faq\";b:1;s:28:\"post_types-avada_faq-maintax\";i:0;s:26:\"schema-page-type-avada_faq\";s:7:\"WebPage\";s:29:\"schema-article-type-avada_faq\";s:4:\"None\";s:22:\"social-title-avada_faq\";s:9:\"%%title%%\";s:28:\"social-description-avada_faq\";s:0:\"\";s:26:\"social-image-url-avada_faq\";s:0:\"\";s:25:\"social-image-id-avada_faq\";i:0;s:25:\"title-ptarchive-avada_faq\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-ptarchive-avada_faq\";s:0:\"\";s:27:\"bctitle-ptarchive-avada_faq\";s:0:\"\";s:27:\"noindex-ptarchive-avada_faq\";b:0;s:32:\"social-title-ptarchive-avada_faq\";s:21:\"%%pt_plural%% Archive\";s:38:\"social-description-ptarchive-avada_faq\";s:0:\"\";s:36:\"social-image-url-ptarchive-avada_faq\";s:0:\"\";s:35:\"social-image-id-ptarchive-avada_faq\";i:0;s:25:\"title-themefusion_elastic\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-themefusion_elastic\";s:0:\"\";s:27:\"noindex-themefusion_elastic\";b:0;s:38:\"display-metabox-pt-themefusion_elastic\";b:1;s:38:\"post_types-themefusion_elastic-maintax\";i:0;s:36:\"schema-page-type-themefusion_elastic\";s:7:\"WebPage\";s:39:\"schema-article-type-themefusion_elastic\";s:4:\"None\";s:32:\"social-title-themefusion_elastic\";s:9:\"%%title%%\";s:38:\"social-description-themefusion_elastic\";s:0:\"\";s:36:\"social-image-url-themefusion_elastic\";s:0:\"\";s:35:\"social-image-id-themefusion_elastic\";i:0;s:11:\"title-slide\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:14:\"metadesc-slide\";s:0:\"\";s:13:\"noindex-slide\";b:0;s:24:\"display-metabox-pt-slide\";b:1;s:24:\"post_types-slide-maintax\";i:0;s:22:\"schema-page-type-slide\";s:7:\"WebPage\";s:25:\"schema-article-type-slide\";s:4:\"None\";s:18:\"social-title-slide\";s:9:\"%%title%%\";s:24:\"social-description-slide\";s:0:\"\";s:22:\"social-image-url-slide\";s:0:\"\";s:21:\"social-image-id-slide\";i:0;s:18:\"title-tax-category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:28:\"title-tax-fusion_tb_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-fusion_tb_category\";s:0:\"\";s:38:\"display-metabox-tax-fusion_tb_category\";b:1;s:30:\"noindex-tax-fusion_tb_category\";b:0;s:35:\"social-title-tax-fusion_tb_category\";s:27:\"Archives des %%term_title%%\";s:41:\"social-description-tax-fusion_tb_category\";s:0:\"\";s:39:\"social-image-url-tax-fusion_tb_category\";s:0:\"\";s:38:\"social-image-id-tax-fusion_tb_category\";i:0;s:36:\"taxonomy-fusion_tb_category-ptparent\";i:0;s:28:\"title-tax-portfolio_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:38:\"display-metabox-tax-portfolio_category\";b:1;s:30:\"noindex-tax-portfolio_category\";b:0;s:35:\"social-title-tax-portfolio_category\";s:27:\"Archives des %%term_title%%\";s:41:\"social-description-tax-portfolio_category\";s:0:\"\";s:39:\"social-image-url-tax-portfolio_category\";s:0:\"\";s:38:\"social-image-id-tax-portfolio_category\";i:0;s:36:\"taxonomy-portfolio_category-ptparent\";i:0;s:26:\"title-tax-portfolio_skills\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-portfolio_skills\";s:0:\"\";s:36:\"display-metabox-tax-portfolio_skills\";b:1;s:28:\"noindex-tax-portfolio_skills\";b:0;s:33:\"social-title-tax-portfolio_skills\";s:27:\"Archives des %%term_title%%\";s:39:\"social-description-tax-portfolio_skills\";s:0:\"\";s:37:\"social-image-url-tax-portfolio_skills\";s:0:\"\";s:36:\"social-image-id-tax-portfolio_skills\";i:0;s:34:\"taxonomy-portfolio_skills-ptparent\";i:0;s:24:\"title-tax-portfolio_tags\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-tax-portfolio_tags\";s:0:\"\";s:34:\"display-metabox-tax-portfolio_tags\";b:1;s:26:\"noindex-tax-portfolio_tags\";b:0;s:31:\"social-title-tax-portfolio_tags\";s:27:\"Archives des %%term_title%%\";s:37:\"social-description-tax-portfolio_tags\";s:0:\"\";s:35:\"social-image-url-tax-portfolio_tags\";s:0:\"\";s:34:\"social-image-id-tax-portfolio_tags\";i:0;s:32:\"taxonomy-portfolio_tags-ptparent\";i:0;s:22:\"title-tax-faq_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-faq_category\";s:0:\"\";s:32:\"display-metabox-tax-faq_category\";b:1;s:24:\"noindex-tax-faq_category\";b:0;s:29:\"social-title-tax-faq_category\";s:27:\"Archives des %%term_title%%\";s:35:\"social-description-tax-faq_category\";s:0:\"\";s:33:\"social-image-url-tax-faq_category\";s:0:\"\";s:32:\"social-image-id-tax-faq_category\";i:0;s:30:\"taxonomy-faq_category-ptparent\";i:0;s:31:\"title-tax-themefusion_es_groups\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-tax-themefusion_es_groups\";s:0:\"\";s:41:\"display-metabox-tax-themefusion_es_groups\";b:1;s:33:\"noindex-tax-themefusion_es_groups\";b:0;s:38:\"social-title-tax-themefusion_es_groups\";s:27:\"Archives des %%term_title%%\";s:44:\"social-description-tax-themefusion_es_groups\";s:0:\"\";s:42:\"social-image-url-tax-themefusion_es_groups\";s:0:\"\";s:41:\"social-image-id-tax-themefusion_es_groups\";i:0;s:39:\"taxonomy-themefusion_es_groups-ptparent\";i:0;s:26:\"title-tax-element_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-element_category\";s:0:\"\";s:36:\"display-metabox-tax-element_category\";b:1;s:28:\"noindex-tax-element_category\";b:0;s:33:\"social-title-tax-element_category\";s:27:\"Archives des %%term_title%%\";s:39:\"social-description-tax-element_category\";s:0:\"\";s:37:\"social-image-url-tax-element_category\";s:0:\"\";s:36:\"social-image-id-tax-element_category\";i:0;s:34:\"taxonomy-element_category-ptparent\";i:0;s:27:\"title-tax-template_category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-tax-template_category\";s:0:\"\";s:37:\"display-metabox-tax-template_category\";b:1;s:29:\"noindex-tax-template_category\";b:0;s:34:\"social-title-tax-template_category\";s:27:\"Archives des %%term_title%%\";s:40:\"social-description-tax-template_category\";s:0:\"\";s:38:\"social-image-url-tax-template_category\";s:0:\"\";s:37:\"social-image-id-tax-template_category\";i:0;s:35:\"taxonomy-template_category-ptparent\";i:0;s:20:\"title-tax-slide-page\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-slide-page\";s:0:\"\";s:30:\"display-metabox-tax-slide-page\";b:1;s:22:\"noindex-tax-slide-page\";b:0;s:27:\"social-title-tax-slide-page\";s:27:\"Archives des %%term_title%%\";s:33:\"social-description-tax-slide-page\";s:0:\"\";s:31:\"social-image-url-tax-slide-page\";s:0:\"\";s:30:\"social-image-id-tax-slide-page\";i:0;s:28:\"taxonomy-slide-page-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `wor6069_options` VALUES("272", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `wor6069_options` VALUES("293", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wor6069_options` VALUES("294", "recently_activated", "a:0:{}", "off");
INSERT INTO `wor6069_options` VALUES("331", "duplicator_version_plugin", "1.5.11.2", "auto");
INSERT INTO `wor6069_options` VALUES("333", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1735312089;s:10:\"updateTime\";i:1735312089;}", "off");
INSERT INTO `wor6069_options` VALUES("334", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wor6069_options` VALUES("335", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wor6069_options` VALUES("336", "duplicator_settings", "a:22:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;s:14:\"usage_tracking\";b:0;i:0;b:0;s:12:\"last_updated\";s:19:\"2024-12-27-19-02-39\";s:18:\"package_ui_created\";s:1:\"1\";}", "auto");
INSERT INTO `wor6069_options` VALUES("337", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"g,VrUF=oBoUftq&3-XJoFbIP,+GfVmVw_x2qr5;jmnLC\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1735326258,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 388.7,\n    \"siteNumFiles\": 17895,\n    \"siteDbSizeMB\": 28.81,\n    \"siteDbNumTables\": 55\n}", "auto");
INSERT INTO `wor6069_options` VALUES("338", "duplicator_notifications", "a:4:{s:6:\"update\";i:1736411913;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wor6069_options` VALUES("339", "wordfence_ls_version", "1.1.14", "auto");
INSERT INTO `wor6069_options` VALUES("340", "wfls_last_role_change", "1736255693", "off");
INSERT INTO `wor6069_options` VALUES("341", "wordfence_version", "8.0.2", "auto");
INSERT INTO `wor6069_options` VALUES("342", "wordfence_case", "1", "auto");
INSERT INTO `wor6069_options` VALUES("343", "wordfence_installed", "1", "auto");
INSERT INTO `wor6069_options` VALUES("344", "wordfenceActivated", "1", "auto");
INSERT INTO `wor6069_options` VALUES("345", "wf_plugin_act_error", "", "auto");
INSERT INTO `wor6069_options` VALUES("352", "litespeed.conf.__activation", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("353", "litespeed.purge.queue", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("354", "litespeed.purge.queue2", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("355", "litespeed.cloud._summary", "{\"curr_request.ver_check\":0,\"last_request.ver_check\":1735312130,\"news.utime\":1736265717,\"curr_request.news\":0,\"last_request.news\":1736265717,\"ips_ts\":1735324891,\"ips_ts_runner\":1735324891,\"ips\":[\"102.221.36.98\",\"103.106.229.82\",\"103.106.229.94\",\"103.146.63.42\",\"103.152.118.219\",\"103.152.118.72\",\"103.164.203.163\",\"103.188.22.12\",\"103.28.90.190\",\"103.75.117.169\",\"104.225.142.116\",\"104.244.77.37\",\"108.61.158.223\",\"109.248.43.195\",\"135.148.120.32\",\"136.243.106.228\",\"139.84.230.39\",\"141.164.38.65\",\"145.239.252.65\",\"146.88.239.197\",\"147.78.0.165\",\"147.78.3.13\",\"147.78.3.161\",\"149.248.44.108\",\"149.28.136.245\",\"149.28.47.113\",\"149.28.85.239\",\"152.228.171.66\",\"152.53.36.14\",\"152.53.38.14\",\"155.138.221.81\",\"156.67.218.140\",\"157.90.154.114\",\"158.51.123.249\",\"162.254.117.80\",\"162.254.118.29\",\"163.182.174.161\",\"163.47.21.168\",\"164.52.202.100\",\"167.71.185.204\",\"167.88.61.211\",\"170.249.218.98\",\"178.17.171.177\",\"178.22.124.247\",\"178.22.124.251\",\"178.255.220.12\",\"18.192.146.200\",\"185.116.60.231\",\"185.116.60.232\",\"185.126.237.51\",\"185.212.169.91\",\"185.228.26.40\",\"185.53.57.40\",\"185.53.57.89\",\"188.172.228.182\",\"188.172.229.113\",\"188.64.184.71\",\"190.92.176.5\",\"191.96.101.140\",\"192.248.156.201\",\"192.99.38.117\",\"193.203.191.189\",\"194.163.134.104\",\"194.36.144.221\",\"195.231.17.141\",\"198.38.89.73\",\"199.59.247.242\",\"201.182.97.70\",\"202.182.123.93\",\"202.61.226.253\",\"204.10.163.237\",\"209.124.84.191\",\"209.208.26.218\",\"211.23.143.87\",\"213.159.1.75\",\"213.183.48.170\",\"213.184.85.245\",\"216.238.106.164\",\"216.238.71.13\",\"23.95.73.167\",\"27.131.75.41\",\"31.131.4.244\",\"31.22.115.186\",\"31.40.212.152\",\"34.247.229.180\",\"34.249.110.197\",\"38.101.149.196\",\"38.114.121.40\",\"38.54.30.228\",\"38.54.42.235\",\"38.54.79.187\",\"38.60.253.237\",\"41.185.29.210\",\"41.223.52.170\",\"45.124.65.86\",\"45.132.244.92\",\"45.248.77.61\",\"45.32.123.201\",\"45.32.169.55\",\"45.32.183.112\",\"45.32.210.159\",\"45.32.67.144\",\"45.32.77.223\",\"45.63.67.181\",\"45.76.252.131\",\"45.77.148.74\",\"45.77.233.177\",\"46.250.220.133\",\"49.12.102.29\",\"5.134.119.103\",\"5.134.119.194\",\"5.188.183.13\",\"5.189.146.228\",\"51.81.186.219\",\"51.81.33.156\",\"54.246.224.74\",\"54.36.103.97\",\"61.219.247.87\",\"61.219.247.90\",\"64.176.4.251\",\"64.227.16.93\",\"64.31.63.160\",\"65.108.104.232\",\"65.20.75.178\",\"65.21.81.50\",\"65.21.81.51\",\"66.42.124.101\",\"67.219.99.102\",\"69.50.95.216\",\"70.34.205.229\",\"79.172.239.249\",\"81.31.156.245\",\"81.31.156.246\",\"83.229.71.151\",\"86.105.14.231\",\"86.105.14.232\",\"89.58.38.4\",\"91.148.135.53\",\"91.201.67.57\",\"91.228.7.67\",\"92.118.205.75\",\"93.95.227.66\",\"94.75.232.90\",\"95.179.133.28\",\"95.216.116.209\"]}", "auto");
INSERT INTO `wor6069_options` VALUES("356", "litespeed.conf._version", "6.5.4", "auto");
INSERT INTO `wor6069_options` VALUES("357", "litespeed.conf.hash", "FQssF5Td8BPpqyMVO3v5diKjEJpX0Atg", "auto");
INSERT INTO `wor6069_options` VALUES("358", "litespeed.conf.auto_upgrade", "", "auto");
INSERT INTO `wor6069_options` VALUES("359", "litespeed.conf.api_key", "", "auto");
INSERT INTO `wor6069_options` VALUES("360", "litespeed.conf.server_ip", "", "auto");
INSERT INTO `wor6069_options` VALUES("361", "litespeed.conf.guest", "", "auto");
INSERT INTO `wor6069_options` VALUES("362", "litespeed.conf.guest_optm", "", "auto");
INSERT INTO `wor6069_options` VALUES("363", "litespeed.conf.news", "1", "auto");
INSERT INTO `wor6069_options` VALUES("364", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"spider\",\"PTST\",\"HeadlessChrome\"]", "auto");
INSERT INTO `wor6069_options` VALUES("365", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "auto");
INSERT INTO `wor6069_options` VALUES("366", "litespeed.conf.cache", "1", "auto");
INSERT INTO `wor6069_options` VALUES("367", "litespeed.conf.cache-priv", "1", "auto");
INSERT INTO `wor6069_options` VALUES("368", "litespeed.conf.cache-commenter", "1", "auto");
INSERT INTO `wor6069_options` VALUES("369", "litespeed.conf.cache-rest", "1", "auto");
INSERT INTO `wor6069_options` VALUES("370", "litespeed.conf.cache-page_login", "1", "auto");
INSERT INTO `wor6069_options` VALUES("371", "litespeed.conf.cache-resources", "1", "auto");
INSERT INTO `wor6069_options` VALUES("372", "litespeed.conf.cache-mobile", "", "auto");
INSERT INTO `wor6069_options` VALUES("373", "litespeed.conf.cache-mobile_rules", "[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]", "auto");
INSERT INTO `wor6069_options` VALUES("374", "litespeed.conf.cache-browser", "", "auto");
INSERT INTO `wor6069_options` VALUES("375", "litespeed.conf.cache-exc_useragents", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("376", "litespeed.conf.cache-exc_cookies", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("377", "litespeed.conf.cache-exc_qs", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("378", "litespeed.conf.cache-exc_cat", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("379", "litespeed.conf.cache-exc_tag", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("380", "litespeed.conf.cache-force_uri", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("381", "litespeed.conf.cache-force_pub_uri", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("382", "litespeed.conf.cache-priv_uri", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("383", "litespeed.conf.cache-exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("384", "litespeed.conf.cache-exc_roles", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("385", "litespeed.conf.cache-drop_qs", "[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]", "auto");
INSERT INTO `wor6069_options` VALUES("386", "litespeed.conf.cache-ttl_pub", "604800", "auto");
INSERT INTO `wor6069_options` VALUES("387", "litespeed.conf.cache-ttl_priv", "1800", "auto");
INSERT INTO `wor6069_options` VALUES("388", "litespeed.conf.cache-ttl_frontpage", "604800", "auto");
INSERT INTO `wor6069_options` VALUES("389", "litespeed.conf.cache-ttl_feed", "604800", "auto");
INSERT INTO `wor6069_options` VALUES("390", "litespeed.conf.cache-ttl_rest", "604800", "auto");
INSERT INTO `wor6069_options` VALUES("391", "litespeed.conf.cache-ttl_browser", "31557600", "auto");
INSERT INTO `wor6069_options` VALUES("392", "litespeed.conf.cache-ttl_status", "[\"404 3600\",\"500 600\"]", "auto");
INSERT INTO `wor6069_options` VALUES("393", "litespeed.conf.cache-login_cookie", "", "auto");
INSERT INTO `wor6069_options` VALUES("394", "litespeed.conf.cache-ajax_ttl", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("395", "litespeed.conf.cache-vary_cookies", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("396", "litespeed.conf.cache-vary_group", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("397", "litespeed.conf.purge-upgrade", "1", "auto");
INSERT INTO `wor6069_options` VALUES("398", "litespeed.conf.purge-stale", "", "auto");
INSERT INTO `wor6069_options` VALUES("399", "litespeed.conf.purge-post_all", "", "auto");
INSERT INTO `wor6069_options` VALUES("400", "litespeed.conf.purge-post_f", "1", "auto");
INSERT INTO `wor6069_options` VALUES("401", "litespeed.conf.purge-post_h", "1", "auto");
INSERT INTO `wor6069_options` VALUES("402", "litespeed.conf.purge-post_p", "1", "auto");
INSERT INTO `wor6069_options` VALUES("403", "litespeed.conf.purge-post_pwrp", "1", "auto");
INSERT INTO `wor6069_options` VALUES("404", "litespeed.conf.purge-post_a", "1", "auto");
INSERT INTO `wor6069_options` VALUES("405", "litespeed.conf.purge-post_y", "", "auto");
INSERT INTO `wor6069_options` VALUES("406", "litespeed.conf.purge-post_m", "1", "auto");
INSERT INTO `wor6069_options` VALUES("407", "litespeed.conf.purge-post_d", "", "auto");
INSERT INTO `wor6069_options` VALUES("408", "litespeed.conf.purge-post_t", "1", "auto");
INSERT INTO `wor6069_options` VALUES("409", "litespeed.conf.purge-post_pt", "1", "auto");
INSERT INTO `wor6069_options` VALUES("410", "litespeed.conf.purge-timed_urls", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("411", "litespeed.conf.purge-timed_urls_time", "", "auto");
INSERT INTO `wor6069_options` VALUES("412", "litespeed.conf.purge-hook_all", "[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]", "auto");
INSERT INTO `wor6069_options` VALUES("413", "litespeed.conf.esi", "", "auto");
INSERT INTO `wor6069_options` VALUES("414", "litespeed.conf.esi-cache_admbar", "1", "auto");
INSERT INTO `wor6069_options` VALUES("415", "litespeed.conf.esi-cache_commform", "1", "auto");
INSERT INTO `wor6069_options` VALUES("416", "litespeed.conf.esi-nonce", "[\"stats_nonce\",\"subscribe_nonce\"]", "auto");
INSERT INTO `wor6069_options` VALUES("417", "litespeed.conf.util-instant_click", "", "auto");
INSERT INTO `wor6069_options` VALUES("418", "litespeed.conf.util-no_https_vary", "", "auto");
INSERT INTO `wor6069_options` VALUES("419", "litespeed.conf.debug-disable_all", "", "auto");
INSERT INTO `wor6069_options` VALUES("420", "litespeed.conf.debug", "", "auto");
INSERT INTO `wor6069_options` VALUES("421", "litespeed.conf.debug-ips", "[\"127.0.0.1\"]", "auto");
INSERT INTO `wor6069_options` VALUES("422", "litespeed.conf.debug-level", "", "auto");
INSERT INTO `wor6069_options` VALUES("423", "litespeed.conf.debug-filesize", "3", "auto");
INSERT INTO `wor6069_options` VALUES("424", "litespeed.conf.debug-collapse_qs", "", "auto");
INSERT INTO `wor6069_options` VALUES("425", "litespeed.conf.debug-inc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("426", "litespeed.conf.debug-exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("427", "litespeed.conf.debug-exc_strings", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("428", "litespeed.conf.db_optm-revisions_max", "0", "auto");
INSERT INTO `wor6069_options` VALUES("429", "litespeed.conf.db_optm-revisions_age", "0", "auto");
INSERT INTO `wor6069_options` VALUES("430", "litespeed.conf.optm-css_min", "", "auto");
INSERT INTO `wor6069_options` VALUES("431", "litespeed.conf.optm-css_comb", "", "auto");
INSERT INTO `wor6069_options` VALUES("432", "litespeed.conf.optm-css_comb_ext_inl", "1", "auto");
INSERT INTO `wor6069_options` VALUES("433", "litespeed.conf.optm-ucss", "", "auto");
INSERT INTO `wor6069_options` VALUES("434", "litespeed.conf.optm-ucss_inline", "", "auto");
INSERT INTO `wor6069_options` VALUES("435", "litespeed.conf.optm-ucss_whitelist", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("436", "litespeed.conf.optm-ucss_file_exc_inline", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("437", "litespeed.conf.optm-ucss_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("438", "litespeed.conf.optm-css_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("439", "litespeed.conf.optm-js_min", "", "auto");
INSERT INTO `wor6069_options` VALUES("440", "litespeed.conf.optm-js_comb", "", "auto");
INSERT INTO `wor6069_options` VALUES("441", "litespeed.conf.optm-js_comb_ext_inl", "1", "auto");
INSERT INTO `wor6069_options` VALUES("442", "litespeed.conf.optm-js_delay_inc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("443", "litespeed.conf.optm-js_exc", "[\"jquery.js\",\"jquery.min.js\"]", "auto");
INSERT INTO `wor6069_options` VALUES("444", "litespeed.conf.optm-html_min", "", "auto");
INSERT INTO `wor6069_options` VALUES("445", "litespeed.conf.optm-html_lazy", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("446", "litespeed.conf.optm-html_skip_comment", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("447", "litespeed.conf.optm-qs_rm", "", "auto");
INSERT INTO `wor6069_options` VALUES("448", "litespeed.conf.optm-ggfonts_rm", "", "auto");
INSERT INTO `wor6069_options` VALUES("449", "litespeed.conf.optm-css_async", "", "auto");
INSERT INTO `wor6069_options` VALUES("450", "litespeed.conf.optm-ccss_per_url", "", "auto");
INSERT INTO `wor6069_options` VALUES("451", "litespeed.conf.optm-ccss_sep_posttype", "[\"page\"]", "auto");
INSERT INTO `wor6069_options` VALUES("452", "litespeed.conf.optm-ccss_sep_uri", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("453", "litespeed.conf.optm-css_async_inline", "1", "auto");
INSERT INTO `wor6069_options` VALUES("454", "litespeed.conf.optm-css_font_display", "", "auto");
INSERT INTO `wor6069_options` VALUES("455", "litespeed.conf.optm-js_defer", "", "auto");
INSERT INTO `wor6069_options` VALUES("456", "litespeed.conf.optm-emoji_rm", "", "auto");
INSERT INTO `wor6069_options` VALUES("457", "litespeed.conf.optm-noscript_rm", "", "auto");
INSERT INTO `wor6069_options` VALUES("458", "litespeed.conf.optm-ggfonts_async", "", "auto");
INSERT INTO `wor6069_options` VALUES("459", "litespeed.conf.optm-exc_roles", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("460", "litespeed.conf.optm-ccss_con", "", "auto");
INSERT INTO `wor6069_options` VALUES("461", "litespeed.conf.optm-js_defer_exc", "[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]", "auto");
INSERT INTO `wor6069_options` VALUES("462", "litespeed.conf.optm-gm_js_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("463", "litespeed.conf.optm-dns_prefetch", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("464", "litespeed.conf.optm-dns_prefetch_ctrl", "", "auto");
INSERT INTO `wor6069_options` VALUES("465", "litespeed.conf.optm-dns_preconnect", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("466", "litespeed.conf.optm-exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("467", "litespeed.conf.optm-guest_only", "1", "auto");
INSERT INTO `wor6069_options` VALUES("468", "litespeed.conf.object", "", "auto");
INSERT INTO `wor6069_options` VALUES("469", "litespeed.conf.object-kind", "", "auto");
INSERT INTO `wor6069_options` VALUES("470", "litespeed.conf.object-host", "localhost", "auto");
INSERT INTO `wor6069_options` VALUES("471", "litespeed.conf.object-port", "11211", "auto");
INSERT INTO `wor6069_options` VALUES("472", "litespeed.conf.object-life", "360", "auto");
INSERT INTO `wor6069_options` VALUES("473", "litespeed.conf.object-persistent", "1", "auto");
INSERT INTO `wor6069_options` VALUES("474", "litespeed.conf.object-admin", "1", "auto");
INSERT INTO `wor6069_options` VALUES("475", "litespeed.conf.object-transients", "1", "auto");
INSERT INTO `wor6069_options` VALUES("476", "litespeed.conf.object-db_id", "0", "auto");
INSERT INTO `wor6069_options` VALUES("477", "litespeed.conf.object-user", "", "auto");
INSERT INTO `wor6069_options` VALUES("478", "litespeed.conf.object-pswd", "", "auto");
INSERT INTO `wor6069_options` VALUES("479", "litespeed.conf.object-global_groups", "[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]", "auto");
INSERT INTO `wor6069_options` VALUES("480", "litespeed.conf.object-non_persistent_groups", "[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]", "auto");
INSERT INTO `wor6069_options` VALUES("481", "litespeed.conf.discuss-avatar_cache", "", "auto");
INSERT INTO `wor6069_options` VALUES("482", "litespeed.conf.discuss-avatar_cron", "", "auto");
INSERT INTO `wor6069_options` VALUES("483", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "auto");
INSERT INTO `wor6069_options` VALUES("484", "litespeed.conf.optm-localize", "", "auto");
INSERT INTO `wor6069_options` VALUES("485", "litespeed.conf.optm-localize_domains", "[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]", "auto");
INSERT INTO `wor6069_options` VALUES("486", "litespeed.conf.media-lazy", "", "auto");
INSERT INTO `wor6069_options` VALUES("487", "litespeed.conf.media-lazy_placeholder", "", "auto");
INSERT INTO `wor6069_options` VALUES("488", "litespeed.conf.media-placeholder_resp", "", "auto");
INSERT INTO `wor6069_options` VALUES("489", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "auto");
INSERT INTO `wor6069_options` VALUES("490", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>", "auto");
INSERT INTO `wor6069_options` VALUES("491", "litespeed.conf.media-lqip", "", "auto");
INSERT INTO `wor6069_options` VALUES("492", "litespeed.conf.media-lqip_qual", "4", "auto");
INSERT INTO `wor6069_options` VALUES("493", "litespeed.conf.media-lqip_min_w", "150", "auto");
INSERT INTO `wor6069_options` VALUES("494", "litespeed.conf.media-lqip_min_h", "150", "auto");
INSERT INTO `wor6069_options` VALUES("495", "litespeed.conf.media-placeholder_resp_async", "1", "auto");
INSERT INTO `wor6069_options` VALUES("496", "litespeed.conf.media-iframe_lazy", "", "auto");
INSERT INTO `wor6069_options` VALUES("497", "litespeed.conf.media-add_missing_sizes", "", "auto");
INSERT INTO `wor6069_options` VALUES("498", "litespeed.conf.media-lazy_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("499", "litespeed.conf.media-lazy_cls_exc", "[\"wmu-preview-img\"]", "auto");
INSERT INTO `wor6069_options` VALUES("500", "litespeed.conf.media-lazy_parent_cls_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("501", "litespeed.conf.media-iframe_lazy_cls_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("502", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("503", "litespeed.conf.media-lazy_uri_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("504", "litespeed.conf.media-lqip_exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("505", "litespeed.conf.media-vpi", "", "auto");
INSERT INTO `wor6069_options` VALUES("506", "litespeed.conf.media-vpi_cron", "", "auto");
INSERT INTO `wor6069_options` VALUES("507", "litespeed.conf.img_optm-auto", "", "auto");
INSERT INTO `wor6069_options` VALUES("508", "litespeed.conf.img_optm-cron", "1", "auto");
INSERT INTO `wor6069_options` VALUES("509", "litespeed.conf.img_optm-ori", "1", "auto");
INSERT INTO `wor6069_options` VALUES("510", "litespeed.conf.img_optm-rm_bkup", "", "auto");
INSERT INTO `wor6069_options` VALUES("511", "litespeed.conf.img_optm-webp", "", "auto");
INSERT INTO `wor6069_options` VALUES("512", "litespeed.conf.img_optm-lossless", "", "auto");
INSERT INTO `wor6069_options` VALUES("513", "litespeed.conf.img_optm-exif", "1", "auto");
INSERT INTO `wor6069_options` VALUES("514", "litespeed.conf.img_optm-webp_attr", "[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"img.data-lazyload\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"div.data-vc-parallax-image\",\"video.poster\"]", "auto");
INSERT INTO `wor6069_options` VALUES("515", "litespeed.conf.img_optm-webp_replace_srcset", "", "auto");
INSERT INTO `wor6069_options` VALUES("516", "litespeed.conf.img_optm-jpg_quality", "82", "auto");
INSERT INTO `wor6069_options` VALUES("517", "litespeed.conf.crawler", "", "auto");
INSERT INTO `wor6069_options` VALUES("518", "litespeed.conf.crawler-usleep", "500", "auto");
INSERT INTO `wor6069_options` VALUES("519", "litespeed.conf.crawler-run_duration", "400", "auto");
INSERT INTO `wor6069_options` VALUES("520", "litespeed.conf.crawler-run_interval", "600", "auto");
INSERT INTO `wor6069_options` VALUES("521", "litespeed.conf.crawler-crawl_interval", "302400", "auto");
INSERT INTO `wor6069_options` VALUES("522", "litespeed.conf.crawler-threads", "3", "auto");
INSERT INTO `wor6069_options` VALUES("523", "litespeed.conf.crawler-timeout", "30", "auto");
INSERT INTO `wor6069_options` VALUES("524", "litespeed.conf.crawler-load_limit", "1", "auto");
INSERT INTO `wor6069_options` VALUES("525", "litespeed.conf.crawler-sitemap", "", "auto");
INSERT INTO `wor6069_options` VALUES("526", "litespeed.conf.crawler-drop_domain", "1", "auto");
INSERT INTO `wor6069_options` VALUES("527", "litespeed.conf.crawler-map_timeout", "120", "auto");
INSERT INTO `wor6069_options` VALUES("528", "litespeed.conf.crawler-roles", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("529", "litespeed.conf.crawler-cookies", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("530", "litespeed.conf.misc-heartbeat_front", "", "auto");
INSERT INTO `wor6069_options` VALUES("531", "litespeed.conf.misc-heartbeat_front_ttl", "60", "auto");
INSERT INTO `wor6069_options` VALUES("532", "litespeed.conf.misc-heartbeat_back", "", "auto");
INSERT INTO `wor6069_options` VALUES("533", "litespeed.conf.misc-heartbeat_back_ttl", "60", "auto");
INSERT INTO `wor6069_options` VALUES("534", "litespeed.conf.misc-heartbeat_editor", "", "auto");
INSERT INTO `wor6069_options` VALUES("535", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "auto");
INSERT INTO `wor6069_options` VALUES("536", "litespeed.conf.cdn", "", "auto");
INSERT INTO `wor6069_options` VALUES("537", "litespeed.conf.cdn-ori", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("538", "litespeed.conf.cdn-ori_dir", "[\"wp-content\",\"wp-includes\"]", "auto");
INSERT INTO `wor6069_options` VALUES("539", "litespeed.conf.cdn-exc", "[]", "auto");
INSERT INTO `wor6069_options` VALUES("540", "litespeed.conf.cdn-quic", "", "auto");
INSERT INTO `wor6069_options` VALUES("541", "litespeed.conf.cdn-cloudflare", "", "auto");
INSERT INTO `wor6069_options` VALUES("542", "litespeed.conf.cdn-cloudflare_email", "", "auto");
INSERT INTO `wor6069_options` VALUES("543", "litespeed.conf.cdn-cloudflare_key", "", "auto");
INSERT INTO `wor6069_options` VALUES("544", "litespeed.conf.cdn-cloudflare_name", "", "auto");
INSERT INTO `wor6069_options` VALUES("545", "litespeed.conf.cdn-cloudflare_zone", "", "auto");
INSERT INTO `wor6069_options` VALUES("546", "litespeed.conf.cdn-mapping", "[{\"url\":\"\",\"inc_img\":\"1\",\"inc_css\":\"1\",\"inc_js\":\"1\",\"filetype\":[\".aac\",\".css\",\".eot\",\".gif\",\".jpeg\",\".jpg\",\".js\",\".less\",\".mp3\",\".mp4\",\".ogg\",\".otf\",\".pdf\",\".png\",\".svg\",\".ttf\",\".webp\",\".woff\",\".woff2\"]}]", "auto");
INSERT INTO `wor6069_options` VALUES("547", "litespeed.conf.cdn-attr", "[\".src\",\".data-src\",\".href\",\".poster\",\"source.srcset\"]", "auto");
INSERT INTO `wor6069_options` VALUES("548", "litespeed.conf.qc-token", "", "auto");
INSERT INTO `wor6069_options` VALUES("549", "litespeed.conf.qc-nameservers", "", "auto");
INSERT INTO `wor6069_options` VALUES("550", "litespeed.gui.lscwp_whm_install", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("551", "litespeed.gui.dismiss", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("552", "litespeed.gui._summary", "{\"new_version\":1735916933,\"score\":1736521733}", "auto");
INSERT INTO `wor6069_options` VALUES("553", "litespeed.data.upgrading", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("554", "litespeed.admin_display.messages", "-1", "auto");
INSERT INTO `wor6069_options` VALUES("556", "cmplz_activation_time", "1735312140", "off");
INSERT INTO `wor6069_options` VALUES("560", "cmplz_active_integrations", "1", "auto");
INSERT INTO `wor6069_options` VALUES("561", "cmplz_integrations_changed", "", "auto");
INSERT INTO `wor6069_options` VALUES("562", "cmplz_cookietable_version", "7.2.0", "auto");
INSERT INTO `wor6069_options` VALUES("563", "cmplz_cbdb_version", "7.2.0", "auto");
INSERT INTO `wor6069_options` VALUES("564", "cmplz_dnsmpd_db_version", "7.2.0", "off");
INSERT INTO `wor6069_options` VALUES("565", "cmplz_preloaded_privacy_info", "a:3:{i:0;a:3:{s:11:\"plugin_name\";s:9:\"WordPress\";s:11:\"policy_text\";s:5367:\"<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : https://donnadieu.agencemiyou.com.</p><h2 class=\"wp-block-heading\">Commentaires</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><h2 class=\"wp-block-heading\">Médias</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p><h2 class=\"wp-block-heading\">Cookies</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p><h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\";s:7:\"removed\";i:1736448240;}i:1;a:3:{s:11:\"plugin_name\";s:43:\"Complianz | The Privacy Suite for WordPress\";s:11:\"policy_text\";s:559:\"<p>Ce site web utilise la Privacy Suite for WordPress de Complianz pour collecter et enregistrer le consentement basé sur le navigateur et l’appareil. Pour cette fonctionnalité, votre adresse IP est anonymisée et stockée dans notre base de données.&nbsp;Ce service ne traite aucune information permettant d’identifier une personne et ne partage aucune donnée avec le prestataire de services.&nbsp;Pour plus d’informations, consultez la <a href=\"https://complianz.io/legal/privacy-statement/\">Déclaration de confidentialité</a> de Complianz.</p>\n\";s:7:\"removed\";i:1736448240;}i:2;a:3:{s:11:\"plugin_name\";s:15:\"LiteSpeed Cache\";s:11:\"policy_text\";s:746:\"Ce site utilise la mise en cache afin de faciliter un temps de réponse plus rapide et une meilleure expérience utilisateur. La mise en cache stocke potentiellement une copie de chaque page web affichée sur ce site. Tous les fichiers de cache sont temporaires et ne sont jamais accessibles à un tiers, sauf si cela est nécessaire pour obtenir le support technique du fournisseur de l’extension de cache. Les fichiers cache expirent selon une planification fixée par l’administrateur du site, mais peuvent facilement être purgés par l’administrateur avant leur expiration naturelle, si nécessaire.Veuillez voir <a href=\"https://quic.cloud/privacy-policy/\" target=\"_blank\">https://quic.cloud/privacy-policy/</a> pour plus de détails.\";s:7:\"removed\";i:1736448240;}}", "off");
INSERT INTO `wor6069_options` VALUES("566", "cmplz_first_version", "7.1.5", "off");
INSERT INTO `wor6069_options` VALUES("567", "cmplz_generate_new_cookiepolicy_snapshot", "1", "off");
INSERT INTO `wor6069_options` VALUES("568", "cmplz-current-version", "7.2.0", "auto");
INSERT INTO `wor6069_options` VALUES("571", "cmplz_transients", "a:17:{s:35:\"cmplz_shortcode_cookie-statement-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:35:\"cmplz_shortcode_cookie-statement-us\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-us\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:35:\"cmplz_shortcode_cookie-statement-uk\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-uk\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:35:\"cmplz_shortcode_cookie-statement-ca\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-ca\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:35:\"cmplz_shortcode_cookie-statement-au\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-au\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:35:\"cmplz_shortcode_cookie-statement-za\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-za\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:35:\"cmplz_shortcode_cookie-statement-br\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:36:\"cmplz_shortcode_privacy-statement-br\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:29:\"cmplz_shortcode_impressum-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1735315744;}s:23:\"cmplz_default_banner_id\";a:2:{s:5:\"value\";s:1:\"1\";s:7:\"expires\";i:1736451815;}s:19:\"cmplz_min_banner_id\";a:2:{s:5:\"value\";s:1:\"1\";s:7:\"expires\";i:1736451815;}}", "auto");
INSERT INTO `wor6069_options` VALUES("574", "cmplz_options", "a:1:{s:11:\"use_cdb_api\";s:3:\"yes\";}", "auto");
INSERT INTO `wor6069_options` VALUES("575", "_wp_suggested_policy_text_has_changed", "changed", "off");
INSERT INTO `wor6069_options` VALUES("576", "cmplz_onboarding_dismissed", "1", "off");
INSERT INTO `wor6069_options` VALUES("580", "_transient_media_months", "a:0:{}", "on");
INSERT INTO `wor6069_options` VALUES("586", "cmplz_cookie_data_verified_date", "1735312145", "auto");
INSERT INTO `wor6069_options` VALUES("587", "cmplz_first_sync_started", "1", "off");
INSERT INTO `wor6069_options` VALUES("588", "cmplz_last_cookie_scan", "1735315749", "auto");
INSERT INTO `wor6069_options` VALUES("589", "cmplz_purposes_stored", "1", "off");
INSERT INTO `wor6069_options` VALUES("590", "cmplz_purposes_fr", "a:5:{i:0;a:2:{s:5:\"value\";s:3:\"987\";s:5:\"label\";s:11:\"Fonctionnel\";}i:1;a:2:{s:5:\"value\";s:3:\"988\";s:5:\"label\";s:9:\"Marketing\";}i:2;a:2:{s:5:\"value\";s:4:\"1262\";s:5:\"label\";s:13:\"Préférences\";}i:3;a:2:{s:5:\"value\";s:3:\"989\";s:5:\"label\";s:12:\"Statistiques\";}i:4;a:2:{s:5:\"value\";s:3:\"990\";s:5:\"label\";s:23:\"Statistiques (anonymes)\";}}", "off");
INSERT INTO `wor6069_options` VALUES("591", "_transient_timeout_cmplz_pages_list", "1737904145", "off");
INSERT INTO `wor6069_options` VALUES("592", "_transient_cmplz_pages_list", "a:3:{i:0;s:4:\"home\";i:1;s:6:\"remote\";i:2;i:1;}", "off");
INSERT INTO `wor6069_options` VALUES("593", "_transient_timeout_cmplz_processed_pages_list", "1737904149", "off");
INSERT INTO `wor6069_options` VALUES("594", "_transient_cmplz_processed_pages_list", "a:3:{i:0;s:4:\"home\";i:1;s:6:\"remote\";i:2;i:1;}", "off");
INSERT INTO `wor6069_options` VALUES("595", "cmplz_purposes_en", "a:5:{i:0;a:2:{s:5:\"value\";s:2:\"61\";s:5:\"label\";s:10:\"Functional\";}i:1;a:2:{s:5:\"value\";s:2:\"64\";s:5:\"label\";s:9:\"Marketing\";}i:2;a:2:{s:5:\"value\";s:4:\"1257\";s:5:\"label\";s:11:\"Preferences\";}i:3;a:2:{s:5:\"value\";s:2:\"63\";s:5:\"label\";s:10:\"Statistics\";}i:4;a:2:{s:5:\"value\";s:2:\"62\";s:5:\"label\";s:22:\"Statistics (anonymous)\";}}", "off");
INSERT INTO `wor6069_options` VALUES("596", "cmplz_serviceTypes_stored", "1", "off");
INSERT INTO `wor6069_options` VALUES("597", "cmplz_serviceTypes_fr", "a:53:{i:0;a:2:{s:5:\"value\";s:4:\"3106\";s:5:\"label\";s:22:\"formulaires de contact\";}i:1;a:2:{s:5:\"value\";s:4:\"1712\";s:5:\"label\";s:27:\"gérer les relations client\";}i:2;a:2:{s:5:\"value\";s:4:\"5202\";s:5:\"label\";s:53:\"gestion de l’apprentissage et constructeur de cours\";}i:3;a:2:{s:5:\"value\";s:4:\"1012\";s:5:\"label\";s:23:\"l’affichage de cartes\";}i:4;a:2:{s:5:\"value\";s:4:\"1007\";s:5:\"label\";s:97:\"l’affichage de publications sociales récentes et/ou des boutons de partage de réseaux sociaux\";}i:5;a:2:{s:5:\"value\";s:4:\"1019\";s:5:\"label\";s:28:\"l’affichage de publicités\";}i:6;a:2:{s:5:\"value\";s:4:\"1026\";s:5:\"label\";s:24:\"l’affichage de vidéos\";}i:7;a:2:{s:5:\"value\";s:4:\"1006\";s:5:\"label\";s:33:\"l’affichage des achats récents\";}i:8;a:2:{s:5:\"value\";s:4:\"1008\";s:5:\"label\";s:29:\"l’affichage des polices web\";}i:9;a:2:{s:5:\"value\";s:3:\"996\";s:5:\"label\";s:42:\"l’assistance par discussion instantanée\";}i:10;a:2:{s:5:\"value\";s:4:\"1027\";s:5:\"label\";s:68:\"l’automatisation du marketing (marketing par courriel automatisé)\";}i:11;a:2:{s:5:\"value\";s:4:\"1109\";s:5:\"label\";s:28:\"l’hébergement du site web\";}i:12;a:2:{s:5:\"value\";s:4:\"1111\";s:5:\"label\";s:46:\"l’optimisation de la performance du site web\";}i:13;a:2:{s:5:\"value\";s:4:\"1105\";s:5:\"label\";s:62:\"l’optimisation et les statistiques pour la boutique en ligne\";}i:14;a:2:{s:5:\"value\";s:4:\"1024\";s:5:\"label\";s:58:\"l&#039;amélioration de la vitesse de chargement des pages\";}i:15;a:2:{s:5:\"value\";s:3:\"994\";s:5:\"label\";s:23:\"la création de boutons\";}i:16;a:2:{s:5:\"value\";s:3:\"998\";s:5:\"label\";s:23:\"la création de contenu\";}i:17;a:2:{s:5:\"value\";s:4:\"1014\";s:5:\"label\";s:45:\"la création de fenêtre contextuelle (popup)\";}i:18;a:2:{s:5:\"value\";s:4:\"1713\";s:5:\"label\";s:31:\"la création de forums en ligne\";}i:19;a:2:{s:5:\"value\";s:4:\"1002\";s:5:\"label\";s:24:\"la création de sondages\";}i:20;a:2:{s:5:\"value\";s:4:\"1104\";s:5:\"label\";s:31:\"la gestion de boutique en ligne\";}i:21;a:2:{s:5:\"value\";s:4:\"1000\";s:5:\"label\";s:21:\"la gestion de contenu\";}i:22;a:2:{s:5:\"value\";s:4:\"1005\";s:5:\"label\";s:40:\"la gestion de l’assistance aux clients\";}i:23;a:2:{s:5:\"value\";s:4:\"1004\";s:5:\"label\";s:39:\"la gestion de l’identité des clients\";}i:24;a:2:{s:5:\"value\";s:3:\"997\";s:5:\"label\";s:27:\"la gestion des commentaires\";}i:25;a:2:{s:5:\"value\";s:4:\"1010\";s:5:\"label\";s:37:\"la gestion des paramètres régionaux\";}i:26;a:2:{s:5:\"value\";s:4:\"1001\";s:5:\"label\";s:38:\"la gestion du consentement aux cookies\";}i:27;a:2:{s:5:\"value\";s:4:\"1015\";s:5:\"label\";s:64:\"la mise à disposition de boutons de partage de réseaux sociaux\";}i:28;a:2:{s:5:\"value\";s:4:\"1023\";s:5:\"label\";s:26:\"la mise en cache des pages\";}i:29;a:2:{s:5:\"value\";s:3:\"991\";s:5:\"label\";s:13:\"la publicité\";}i:30;a:2:{s:5:\"value\";s:4:\"1003\";s:5:\"label\";s:25:\"la publicité cross-canal\";}i:31;a:2:{s:5:\"value\";s:4:\"1100\";s:5:\"label\";s:25:\"la sécurité du site web\";}i:32;a:2:{s:5:\"value\";s:4:\"1013\";s:5:\"label\";s:28:\"le blocage des indésirables\";}i:33;a:2:{s:5:\"value\";s:4:\"1107\";s:5:\"label\";s:21:\"le design du site web\";}i:34;a:2:{s:5:\"value\";s:4:\"1108\";s:5:\"label\";s:29:\"le développement du site web\";}i:35;a:2:{s:5:\"value\";s:3:\"992\";s:5:\"label\";s:31:\"le marketing d&#039;affiliation\";}i:36;a:2:{s:5:\"value\";s:4:\"1016\";s:5:\"label\";s:14:\"le remarketing\";}i:37;a:2:{s:5:\"value\";s:3:\"999\";s:5:\"label\";s:51:\"le service de réseau de diffusion de contenu (CDN)\";}i:38;a:2:{s:5:\"value\";s:3:\"993\";s:5:\"label\";s:18:\"le streaming audio\";}i:39;a:2:{s:5:\"value\";s:3:\"995\";s:5:\"label\";s:19:\"le suivi des appels\";}i:40;a:2:{s:5:\"value\";s:4:\"1102\";s:5:\"label\";s:22:\"le suivi des visiteurs\";}i:41;a:2:{s:5:\"value\";s:4:\"1025\";s:5:\"label\";s:25:\"le traitement de paiement\";}i:42;a:2:{s:5:\"value\";s:4:\"1011\";s:5:\"label\";s:39:\"les abonnements aux listes de diffusion\";}i:43;a:2:{s:5:\"value\";s:4:\"1009\";s:5:\"label\";s:70:\"les cartes de fréquentation (heat maps) et enregistrements d’écran\";}i:44;a:2:{s:5:\"value\";s:4:\"1106\";s:5:\"label\";s:47:\"les fonctions d&#039;administration du site web\";}i:45;a:2:{s:5:\"value\";s:4:\"1018\";s:5:\"label\";s:26:\"les fonctions de recherche\";}i:46;a:2:{s:5:\"value\";s:4:\"1103\";s:5:\"label\";s:19:\"les formulaires web\";}i:47;a:2:{s:5:\"value\";s:4:\"1110\";s:5:\"label\";s:21:\"les menus du site web\";}i:48;a:2:{s:5:\"value\";s:4:\"1716\";s:5:\"label\";s:23:\"les prévisions météo\";}i:49;a:2:{s:5:\"value\";s:4:\"1715\";s:5:\"label\";s:24:\"les rendez-vous en ligne\";}i:50;a:2:{s:5:\"value\";s:4:\"1101\";s:5:\"label\";s:28:\"les statistiques du site web\";}i:51;a:2:{s:5:\"value\";s:4:\"3107\";s:5:\"label\";s:27:\"notifications instantanées\";}i:52;a:2:{s:5:\"value\";s:4:\"1017\";s:5:\"label\";s:32:\"optimiser le moteur de recherche\";}}", "off");
INSERT INTO `wor6069_options` VALUES("598", "cmplz_serviceTypes_en", "a:53:{i:0;a:2:{s:5:\"value\";s:3:\"422\";s:5:\"label\";s:11:\"advertising\";}i:1;a:2:{s:5:\"value\";s:3:\"402\";s:5:\"label\";s:19:\"affiliate marketing\";}i:2;a:2:{s:5:\"value\";s:3:\"429\";s:5:\"label\";s:15:\"audio streaming\";}i:3;a:2:{s:5:\"value\";s:3:\"418\";s:5:\"label\";s:16:\"buttons creation\";}i:4;a:2:{s:5:\"value\";s:3:\"396\";s:5:\"label\";s:13:\"call tracking\";}i:5;a:2:{s:5:\"value\";s:3:\"180\";s:5:\"label\";s:12:\"chat support\";}i:6;a:2:{s:5:\"value\";s:3:\"425\";s:5:\"label\";s:19:\"comments management\";}i:7;a:2:{s:5:\"value\";s:4:\"2443\";s:5:\"label\";s:13:\"Contact Forms\";}i:8;a:2:{s:5:\"value\";s:3:\"400\";s:5:\"label\";s:16:\"content creation\";}i:9;a:2:{s:5:\"value\";s:3:\"409\";s:5:\"label\";s:43:\"content distribution network (CDN) services\";}i:10;a:2:{s:5:\"value\";s:3:\"408\";s:5:\"label\";s:18:\"content management\";}i:11;a:2:{s:5:\"value\";s:2:\"67\";s:5:\"label\";s:25:\"cookie consent management\";}i:12;a:2:{s:5:\"value\";s:4:\"1336\";s:5:\"label\";s:22:\"creating online forums\";}i:13;a:2:{s:5:\"value\";s:3:\"412\";s:5:\"label\";s:14:\"creating polls\";}i:14;a:2:{s:5:\"value\";s:3:\"399\";s:5:\"label\";s:25:\"cross-channel advertising\";}i:15;a:2:{s:5:\"value\";s:3:\"413\";s:5:\"label\";s:28:\"customer identity management\";}i:16;a:2:{s:5:\"value\";s:4:\"1157\";s:5:\"label\";s:29:\"Customer Relations Management\";}i:17;a:2:{s:5:\"value\";s:3:\"405\";s:5:\"label\";s:27:\"customer support management\";}i:18;a:2:{s:5:\"value\";s:3:\"426\";s:5:\"label\";s:27:\"display of recent purchases\";}i:19;a:2:{s:5:\"value\";s:3:\"384\";s:5:\"label\";s:58:\"display of recent social posts and/or social share buttons\";}i:20;a:2:{s:5:\"value\";s:3:\"415\";s:5:\"label\";s:19:\"display of webfonts\";}i:21;a:2:{s:5:\"value\";s:3:\"410\";s:5:\"label\";s:31:\"heat maps and screen recordings\";}i:22;a:2:{s:5:\"value\";s:4:\"3410\";s:5:\"label\";s:38:\"learning management and course builder\";}i:23;a:2:{s:5:\"value\";s:3:\"401\";s:5:\"label\";s:17:\"locale management\";}i:24;a:2:{s:5:\"value\";s:3:\"387\";s:5:\"label\";s:26:\"mailing list subscriptions\";}i:25;a:2:{s:5:\"value\";s:3:\"385\";s:5:\"label\";s:12:\"maps display\";}i:26;a:2:{s:5:\"value\";s:3:\"395\";s:5:\"label\";s:48:\"marketing automation (automated email marketing)\";}i:27;a:2:{s:5:\"value\";s:4:\"1335\";s:5:\"label\";s:19:\"online appointments\";}i:28;a:2:{s:5:\"value\";s:3:\"407\";s:5:\"label\";s:12:\"page caching\";}i:29;a:2:{s:5:\"value\";s:3:\"163\";s:5:\"label\";s:30:\"page loading speed improvement\";}i:30;a:2:{s:5:\"value\";s:3:\"161\";s:5:\"label\";s:18:\"payment processing\";}i:31;a:2:{s:5:\"value\";s:3:\"419\";s:5:\"label\";s:14:\"popup creation\";}i:32;a:2:{s:5:\"value\";s:3:\"397\";s:5:\"label\";s:30:\"providing social share buttons\";}i:33;a:2:{s:5:\"value\";s:4:\"2016\";s:5:\"label\";s:18:\"push notifications\";}i:34;a:2:{s:5:\"value\";s:3:\"411\";s:5:\"label\";s:11:\"remarketing\";}i:35;a:2:{s:5:\"value\";s:3:\"423\";s:5:\"label\";s:26:\"Search Engine Optimization\";}i:36;a:2:{s:5:\"value\";s:3:\"404\";s:5:\"label\";s:16:\"search functions\";}i:37;a:2:{s:5:\"value\";s:3:\"416\";s:5:\"label\";s:29:\"security and fraud prevention\";}i:38;a:2:{s:5:\"value\";s:3:\"398\";s:5:\"label\";s:22:\"showing advertisements\";}i:39;a:2:{s:5:\"value\";s:3:\"386\";s:5:\"label\";s:15:\"spam prevention\";}i:40;a:2:{s:5:\"value\";s:3:\"388\";s:5:\"label\";s:27:\"Statistics and optimization\";}i:41;a:2:{s:5:\"value\";s:3:\"178\";s:5:\"label\";s:13:\"video display\";}i:42;a:2:{s:5:\"value\";s:3:\"406\";s:5:\"label\";s:16:\"visitor tracking\";}i:43;a:2:{s:5:\"value\";s:4:\"1131\";s:5:\"label\";s:16:\"weather forecast\";}i:44;a:2:{s:5:\"value\";s:3:\"427\";s:5:\"label\";s:8:\"webforms\";}i:45;a:2:{s:5:\"value\";s:3:\"420\";s:5:\"label\";s:18:\"webshop management\";}i:46;a:2:{s:5:\"value\";s:3:\"421\";s:5:\"label\";s:23:\"website admin functions\";}i:47;a:2:{s:5:\"value\";s:3:\"403\";s:5:\"label\";s:14:\"website design\";}i:48;a:2:{s:5:\"value\";s:3:\"424\";s:5:\"label\";s:19:\"website development\";}i:49;a:2:{s:5:\"value\";s:3:\"414\";s:5:\"label\";s:15:\"website hosting\";}i:50;a:2:{s:5:\"value\";s:3:\"417\";s:5:\"label\";s:13:\"website menus\";}i:51;a:2:{s:5:\"value\";s:3:\"164\";s:5:\"label\";s:32:\"website performance optimization\";}i:52;a:2:{s:5:\"value\";s:3:\"162\";s:5:\"label\";s:18:\"website statistics\";}}", "off");
INSERT INTO `wor6069_options` VALUES("605", "cmplz_detected_social_media", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("606", "cmplz_detected_thirdparty_services", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("607", "cmplz_detected_stats", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("627", "cmplz_excluded_posts_array", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("632", "fusion_applied_patches", "a:4:{i:0;i:422271;i:1;i:422323;i:2;i:422480;i:3;i:422597;}", "off");
INSERT INTO `wor6069_options` VALUES("633", "litespeed.optimize.timestamp_purge_css", "1736427040", "auto");
INSERT INTO `wor6069_options` VALUES("681", "avada_previous_version", "a:1:{i:0;s:6:\"7.11.9\";}", "auto");
INSERT INTO `wor6069_options` VALUES("874", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wor6069_options` VALUES("936", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-09 18:44:13\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20241227_wordpressTemplate\";s:4:\"Hash\";s:35:\"de3e0017dd27b51e7776_20250109184413\";s:8:\"NameHash\";s:62:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:72:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/agenczx/donnadieu\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1790;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16105;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-09 18:44:13\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.39\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:26:\"20241227_wordpressTemplate\";s:4:\"Hash\";s:35:\"de3e0017dd27b51e7776_20250109184413\";s:8:\"NameHash\";s:62:\"20241227_wordpressTemplate_de3e0017dd27b51e7776_20250109184413\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/agenczx/donnadieu/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'30\', Revision \'41ebc5d9\'\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/agenczx/donnadieu/wp-admin\";i:1;s:35:\"/home/agenczx/donnadieu/wp-includes\";i:2;s:44:\"/home/agenczx/donnadieu/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/agenczx/donnadieu\";i:1;s:23:\"/home/agenczx/donnadieu\";i:2;s:34:\"/home/agenczx/donnadieu/wp-content\";i:3;s:42:\"/home/agenczx/donnadieu/wp-content/uploads\";i:4;s:42:\"/home/agenczx/donnadieu/wp-content/plugins\";i:5;s:45:\"/home/agenczx/donnadieu/wp-content/mu-plugins\";i:6;s:41:\"/home/agenczx/donnadieu/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/agenczx/donnadieu/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wor6069_options` VALUES("941", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wor6069_options` VALUES("959", "fusion_core_flush_permalinks", "1", "auto");
INSERT INTO `wor6069_options` VALUES("1031", "fusion_demo_history", "a:1:{s:10:\"restaurant\";a:11:{s:24:\"fusion_tb_layout_default\";b:0;s:5:\"terms\";a:17:{i:0;a:2:{s:7:\"term_id\";i:4;s:8:\"taxonomy\";s:8:\"category\";}i:1;a:2:{s:7:\"term_id\";i:5;s:8:\"taxonomy\";s:8:\"category\";}i:2;a:2:{s:7:\"term_id\";i:6;s:8:\"taxonomy\";s:16:\"element_category\";}i:3;a:2:{s:7:\"term_id\";i:7;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:4;a:2:{s:7:\"term_id\";i:8;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:5;a:2:{s:7:\"term_id\";i:9;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:6;a:2:{s:7:\"term_id\";i:10;s:8:\"taxonomy\";s:16:\"element_category\";}i:7;a:2:{s:7:\"term_id\";i:11;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:8;a:2:{s:7:\"term_id\";i:12;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:9;a:2:{s:7:\"term_id\";i:13;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:10;a:2:{s:7:\"term_id\";i:14;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:11;a:2:{s:7:\"term_id\";i:15;s:8:\"taxonomy\";s:16:\"element_category\";}i:12;a:2:{s:7:\"term_id\";i:16;s:8:\"taxonomy\";s:18:\"fusion_tb_category\";}i:13;a:2:{s:7:\"term_id\";i:17;s:8:\"taxonomy\";s:16:\"element_category\";}i:14;a:2:{s:7:\"term_id\";i:18;s:8:\"taxonomy\";s:16:\"element_category\";}i:15;a:2:{s:7:\"term_id\";i:19;s:8:\"taxonomy\";s:8:\"nav_menu\";}i:16;a:2:{s:7:\"term_id\";i:20;s:8:\"taxonomy\";s:8:\"nav_menu\";}}s:13:\"theme_options\";b:0;s:7:\"widgets\";a:30:{i:0;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"231\";s:11:\"option_name\";s:24:\"widget_ad_125_125-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:1;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"107\";s:11:\"option_name\";s:15:\"widget_archives\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:2;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"241\";s:11:\"option_name\";s:33:\"widget_avada-vertical-menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:3;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"102\";s:11:\"option_name\";s:12:\"widget_block\";s:12:\"option_value\";s:902:\"a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:4;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"106\";s:11:\"option_name\";s:15:\"widget_calendar\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:5;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"76\";s:11:\"option_name\";s:17:\"widget_categories\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:6;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"233\";s:11:\"option_name\";s:26:\"widget_contact_info-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:7;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"116\";s:11:\"option_name\";s:18:\"widget_custom_html\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:8;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"239\";s:11:\"option_name\";s:27:\"widget_facebook-like-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:9;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"237\";s:11:\"option_name\";s:20:\"widget_flickr-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:10;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"242\";s:11:\"option_name\";s:18:\"widget_form-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:11;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"232\";s:11:\"option_name\";s:27:\"widget_fusion_author-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:12;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"108\";s:11:\"option_name\";s:18:\"widget_media_audio\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:13;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"110\";s:11:\"option_name\";s:20:\"widget_media_gallery\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:14;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"109\";s:11:\"option_name\";s:18:\"widget_media_image\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:15;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"111\";s:11:\"option_name\";s:18:\"widget_media_video\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:16;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"240\";s:11:\"option_name\";s:18:\"widget_menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:17;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"112\";s:11:\"option_name\";s:11:\"widget_meta\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:18;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"115\";s:11:\"option_name\";s:15:\"widget_nav_menu\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:19;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"105\";s:11:\"option_name\";s:12:\"widget_pages\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:20;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"234\";s:11:\"option_name\";s:23:\"widget_pyre_tabs-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:21;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"235\";s:11:\"option_name\";s:26:\"widget_recent_works-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:22;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"133\";s:11:\"option_name\";s:22:\"widget_recent-comments\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:23;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"132\";s:11:\"option_name\";s:19:\"widget_recent-posts\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:24;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"78\";s:11:\"option_name\";s:10:\"widget_rss\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:25;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"113\";s:11:\"option_name\";s:13:\"widget_search\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:26;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"238\";s:11:\"option_name\";s:26:\"widget_social_links-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}i:27;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"114\";s:11:\"option_name\";s:16:\"widget_tag_cloud\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:28;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"77\";s:11:\"option_name\";s:11:\"widget_text\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:29;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"236\";s:11:\"option_name\";s:20:\"widget_tweets-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:4:\"auto\";}}s:16:\"sidebars_widgets\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:21:\"avada-footer-widget-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:13:\"array_version\";i:3;}s:12:\"sbg_sidebars\";b:0;s:8:\"blogname\";s:9:\"WordPress\";s:13:\"page_on_front\";s:1:\"0\";s:13:\"show_on_front\";s:5:\"posts\";s:18:\"nav_menu_locations\";a:0:{}s:12:\"general_data\";s:8:\"imported\";}}", "off");
INSERT INTO `wor6069_options` VALUES("1033", "fusion_import_data", "a:18:{s:4:\"post\";a:1:{i:0;s:10:\"restaurant\";}s:4:\"page\";a:1:{i:0;s:10:\"restaurant\";}s:15:\"avada_portfolio\";a:1:{i:0;s:10:\"restaurant\";}s:9:\"avada_faq\";a:0:{}s:12:\"avada_layout\";a:1:{i:0;s:10:\"restaurant\";}s:12:\"fusion_icons\";a:1:{i:0;s:10:\"restaurant\";}s:10:\"attachment\";a:1:{i:0;s:10:\"restaurant\";}s:7:\"product\";a:1:{i:0;s:10:\"restaurant\";}s:5:\"event\";a:0:{}s:5:\"forum\";a:0:{}s:7:\"sliders\";a:1:{i:0;s:10:\"restaurant\";}s:7:\"widgets\";a:1:{i:0;s:10:\"restaurant\";}s:13:\"theme_options\";a:1:{i:0;s:10:\"restaurant\";}s:11:\"convertplug\";a:0:{}s:8:\"acf_data\";a:0:{}s:12:\"general_data\";a:1:{i:0;s:10:\"restaurant\";}s:3:\"all\";a:1:{i:0;s:10:\"restaurant\";}s:11:\"fusion_form\";a:1:{i:0;s:10:\"restaurant\";}}", "off");
INSERT INTO `wor6069_options` VALUES("1043", "fusion_tb_layout_default", "{\\\"conditions\\\":[],\\\"template_terms\\\":{\\\"header\\\":\\\"3468\\\",\\\"footer\\\":\\\"3520\\\"}}", "auto");
INSERT INTO `wor6069_options` VALUES("1045", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wor6069_options` VALUES("1046", "category_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1047", "fusion_tb_category_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1048", "portfolio_category_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1049", "portfolio_skills_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1050", "faq_category_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1051", "element_category_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1052", "template_category_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1053", "slide-page_children", "a:0:{}", "auto");
INSERT INTO `wor6069_options` VALUES("1056", "fusion_options", "a:1043:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"wide\";s:10:\"site_width\";s:6:\"1375px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:0:\"\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:1:\"0\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"page_template\";s:10:\"site_width\";s:16:\"hundredp_padding\";s:4:\"30px\";s:13:\"sidebar_width\";s:3:\"23%\";s:14:\"sidebar_gutter\";s:2:\"6%\";s:17:\"sidebar_2_1_width\";s:3:\"21%\";s:17:\"sidebar_2_2_width\";s:3:\"21%\";s:19:\"dual_sidebar_gutter\";s:2:\"3%\";s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1000\";s:23:\"side_header_break_point\";s:4:\"1425\";s:19:\"content_break_point\";s:4:\"1000\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:16:\"visibility_small\";s:3:\"640\";s:17:\"visibility_medium\";s:4:\"1024\";s:22:\"typography_sensitivity\";s:4:\"0.27\";s:17:\"typography_factor\";s:4:\"1.50\";s:13:\"color_palette\";a:9:{s:6:\"color1\";a:2:{s:5:\"label\";s:7:\"Color 1\";s:5:\"color\";s:7:\"#ffffff\";}s:6:\"color2\";a:2:{s:5:\"label\";s:7:\"Color 2\";s:5:\"color\";s:7:\"#f5f5f5\";}s:6:\"color3\";a:2:{s:5:\"label\";s:7:\"Color 3\";s:5:\"color\";s:7:\"#ba9779\";}s:6:\"color4\";a:2:{s:5:\"label\";s:7:\"Color 4\";s:5:\"color\";s:7:\"#938f2e\";}s:6:\"color5\";a:2:{s:5:\"label\";s:7:\"Color 5\";s:5:\"color\";s:7:\"#828282\";}s:6:\"color6\";a:2:{s:5:\"label\";s:7:\"Color 6\";s:5:\"color\";s:7:\"#02270a\";}s:6:\"color7\";a:2:{s:5:\"label\";s:7:\"Color 7\";s:5:\"color\";s:7:\"#333333\";}s:6:\"color8\";a:2:{s:5:\"label\";s:7:\"Color 8\";s:5:\"color\";s:7:\"#000000\";}s:8:\"custom10\";a:2:{s:5:\"label\";s:9:\"Custom 10\";s:5:\"color\";s:21:\"rgba(255,255,255,0.8)\";}}s:13:\"primary_color\";s:17:\"var(--awb-color4)\";s:15:\"slider_position\";s:5:\"below\";s:15:\"header_position\";s:3:\"top\";s:13:\"header_layout\";s:2:\"v1\";s:19:\"header_left_content\";s:12:\"contact_info\";s:20:\"header_right_content\";s:10:\"navigation\";s:17:\"header_v4_content\";s:18:\"tagline_and_search\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"0\";s:16:\"header_bg_repeat\";s:9:\"no-repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:4:\"40px\";s:5:\"right\";s:2:\"5%\";s:6:\"bottom\";s:4:\"40px\";s:4:\"left\";s:2:\"5%\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"1\";s:15:\"header_bg_color\";s:13:\"rgba(0,0,0,0)\";s:23:\"archive_header_bg_color\";s:13:\"rgba(3,3,3,0)\";s:19:\"header_border_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 90% ),var(--awb-color8-a))\";s:19:\"header_top_bg_color\";s:17:\"var(--awb-color8)\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 45% ),var(--awb-color8-a))\";s:13:\"header_sticky\";s:1:\"0\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"1\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:20:\"header_sticky_shadow\";s:1:\"1\";s:22:\"header_sticky_bg_color\";s:17:\"var(--awb-color8)\";s:24:\"header_sticky_menu_color\";s:17:\"var(--awb-color8)\";s:25:\"header_sticky_nav_padding\";s:2:\"43\";s:27:\"header_sticky_nav_font_size\";s:4:\"14px\";s:10:\"nav_height\";s:2:\"65\";s:20:\"menu_highlight_style\";s:9:\"textcolor\";s:25:\"menu_highlight_background\";s:17:\"var(--awb-color4)\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"3\";s:11:\"nav_padding\";s:2:\"45\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:15:\"megamenu_shadow\";s:1:\"0\";s:28:\"main_menu_sub_menu_animation\";s:4:\"fade\";s:29:\"dropdown_menu_top_border_size\";s:1:\"3\";s:19:\"dropdown_menu_width\";s:3:\"210\";s:34:\"mainmenu_dropdown_vertical_padding\";s:2:\"12\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"1\";s:31:\"menu_display_dropdown_indicator\";s:4:\"none\";s:20:\"main_nav_search_icon\";s:1:\"0\";s:22:\"main_nav_search_layout\";s:7:\"overlay\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"0px\";s:17:\"menu_sub_bg_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 23% ),var(--awb-color8-a))\";s:19:\"menu_bg_hover_color\";s:17:\"var(--awb-color4)\";s:18:\"menu_sub_sep_color\";s:13:\"rgba(0,0,0,0)\";s:17:\"menu_h45_bg_color\";s:17:\"var(--awb-color1)\";s:14:\"nav_typography\";a:8:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"16px\";s:14:\"letter-spacing\";s:7:\"-0.02em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 63% ),var(--awb-color8-a))\";}s:15:\"menu_text_align\";s:6:\"center\";s:22:\"menu_hover_first_color\";s:17:\"var(--awb-color1)\";s:14:\"menu_sub_color\";s:17:\"var(--awb-color1)\";s:22:\"nav_dropdown_font_size\";s:4:\"14px\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"21\";s:22:\"flyout_menu_icon_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 53% ),var(--awb-color8-a))\";s:28:\"flyout_menu_icon_hover_color\";s:17:\"var(--awb-color1)\";s:28:\"flyout_menu_background_color\";s:112:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 1% ),calc( var(--awb-color8-a) - 20% ))\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:24:\"flyout_menu_item_padding\";s:2:\"47\";s:23:\"topmenu_dropwdown_width\";s:3:\"180\";s:29:\"header_top_first_border_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 90% ),var(--awb-color8-a))\";s:23:\"header_top_sub_bg_color\";s:17:\"var(--awb-color1)\";s:30:\"header_top_menu_bg_hover_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 98% ),var(--awb-color8-a))\";s:29:\"header_top_menu_sub_sep_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 90% ),var(--awb-color8-a))\";s:14:\"snav_font_size\";s:4:\"12px\";s:11:\"sec_menu_lh\";s:4:\"44px\";s:10:\"snav_color\";s:17:\"var(--awb-color1)\";s:25:\"header_top_menu_sub_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 45% ),var(--awb-color8-a))\";s:31:\"header_top_menu_sub_hover_color\";s:17:\"var(--awb-color7)\";s:18:\"mobile_menu_design\";s:6:\"flyout\";s:28:\"mobile_menu_icons_top_margin\";s:1:\"0\";s:22:\"mobile_menu_nav_height\";s:2:\"35\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:18:\"mobile_menu_search\";s:1:\"0\";s:29:\"mobile_menu_submenu_indicator\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:17:\"var(--awb-color8)\";s:30:\"mobile_archive_header_bg_color\";s:17:\"var(--awb-color8)\";s:28:\"mobile_menu_background_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 23% ),var(--awb-color8-a))\";s:23:\"mobile_menu_hover_color\";s:17:\"var(--awb-color4)\";s:24:\"mobile_menu_border_color\";s:19:\"rgba(255,255,255,0)\";s:24:\"mobile_menu_toggle_color\";s:17:\"var(--awb-color1)\";s:22:\"mobile_menu_typography\";a:9:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"40px\";s:11:\"line-height\";s:4:\"35px\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color1)\";}s:28:\"mobile_menu_font_hover_color\";s:17:\"var(--awb-color1)\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:14:\"megamenu_width\";s:12:\"custom_width\";s:18:\"megamenu_max_width\";s:4:\"1500\";s:31:\"megamenu_interior_content_width\";s:14:\"viewport_width\";s:19:\"megamenu_title_size\";s:4:\"21px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"0\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"14\";s:15:\"menu_icon_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 63% ),var(--awb-color8-a))\";s:21:\"menu_icon_hover_color\";s:17:\"var(--awb-color1)\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"14px\";}s:14:\"logo_alignment\";s:4:\"left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:17:\"var(--awb-color4)\";s:16:\"logo_custom_link\";s:0:\"\";s:4:\"logo\";a:5:{s:3:\"url\";s:90:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original.png\";s:2:\"id\";s:4:\"3848\";s:6:\"height\";s:4:\"1310\";s:5:\"width\";s:4:\"2461\";s:9:\"thumbnail\";s:98:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original-150x150.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:90:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original.png\";s:2:\"id\";s:4:\"3848\";s:6:\"height\";s:4:\"1310\";s:5:\"width\";s:4:\"2461\";s:9:\"thumbnail\";s:98:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original-150x150.png\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:90:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original.png\";s:2:\"id\";s:4:\"3848\";s:6:\"height\";s:4:\"1310\";s:5:\"width\";s:4:\"2461\";s:9:\"thumbnail\";s:98:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original-150x150.png\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:90:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original.png\";s:2:\"id\";s:4:\"3848\";s:6:\"height\";s:4:\"1310\";s:5:\"width\";s:4:\"2461\";s:9:\"thumbnail\";s:98:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original-150x150.png\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:90:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original.png\";s:2:\"id\";s:4:\"3848\";s:6:\"height\";s:4:\"1310\";s:5:\"width\";s:4:\"2461\";s:9:\"thumbnail\";s:98:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original-150x150.png\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:90:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original.png\";s:2:\"id\";s:4:\"3848\";s:6:\"height\";s:4:\"1310\";s:5:\"width\";s:4:\"2461\";s:9:\"thumbnail\";s:98:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2024/12/Donnadieu-Logo-VF-Original-150x150.png\";}s:8:\"fav_icon\";a:5:{s:3:\"url\";s:86:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2025/01/Donnadieu-Bois-Favicon.png\";s:2:\"id\";s:4:\"4223\";s:6:\"height\";s:3:\"284\";s:5:\"width\";s:3:\"306\";s:9:\"thumbnail\";s:94:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2025/01/Donnadieu-Bois-Favicon-150x150.png\";}s:20:\"fav_icon_apple_touch\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"fav_icon_android\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:13:\"fav_icon_edge\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:4:\"hide\";s:17:\"page_title_bar_bs\";s:11:\"breadcrumbs\";s:19:\"page_title_bar_text\";s:1:\"0\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:4:\"87px\";s:24:\"page_title_mobile_height\";s:4:\"70px\";s:19:\"page_title_bg_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 96% ),var(--awb-color8-a))\";s:23:\"page_title_border_color\";s:17:\"var(--awb-color2)\";s:20:\"page_title_font_size\";s:4:\"18px\";s:22:\"page_title_line_height\";s:3:\"1.4\";s:16:\"page_title_color\";s:17:\"var(--awb-color7)\";s:30:\"page_title_subheader_font_size\";s:4:\"14px\";s:26:\"page_title_subheader_color\";s:17:\"var(--awb-color7)\";s:20:\"page_title_alignment\";s:4:\"left\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:88:\"https://avada.website/restaurant/wp-content/themes/Avada/assets/images/page_title_bg.png\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"10px\";s:22:\"breadcrumbs_text_color\";s:17:\"var(--awb-color7)\";s:28:\"breadcrumbs_text_hover_color\";s:17:\"var(--awb-color7)\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:20:\"breadcrumb_show_leaf\";s:1:\"1\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:19:\"slidingbar_position\";s:3:\"top\";s:16:\"slidingbar_width\";s:5:\"300px\";s:17:\"slidingbar_sticky\";s:1:\"1\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:27:\"slidingbar_column_alignment\";s:7:\"stacked\";s:26:\"slidingbar_content_padding\";a:4:{s:3:\"top\";s:4:\"60px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"60px\";s:4:\"left\";s:4:\"30px\";}s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:8:\"triangle\";s:19:\"slidingbar_bg_color\";s:17:\"var(--awb-color6)\";s:24:\"slidingbar_divider_color\";s:17:\"var(--awb-color7)\";s:28:\"slidingbar_toggle_icon_color\";s:17:\"var(--awb-color1)\";s:20:\"slidingbar_font_size\";s:4:\"13px\";s:25:\"slidingbar_headings_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 87% ),var(--awb-color8-a))\";s:21:\"slidingbar_text_color\";s:17:\"var(--awb-color3)\";s:21:\"slidingbar_link_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 75% ),var(--awb-color8-a))\";s:27:\"slidingbar_link_color_hover\";s:17:\"var(--awb-color4)\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"1\";s:29:\"footer_widgets_center_content\";s:1:\"1\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"1\";s:11:\"footer_text\";s:160:\"Copyright 2012 - 2019 Avada | All Rights Reserved | Powered by <a href=\"http://wordpress.org\">WordPress</a> | <a href=\"https://theme-fusion.com\">ThemeFusion</a>\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:82:\"https://avada.website/restaurant/wp-content/uploads/sites/112/2019/12/footer2x.jpg\";s:2:\"id\";s:3:\"572\";s:6:\"height\";s:4:\"1524\";s:5:\"width\";s:4:\"3800\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"1\";s:17:\"footerw_bg_repeat\";s:9:\"no-repeat\";s:14:\"footerw_bg_pos\";s:10:\"top center\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:5:\"180px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:5:\"170px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:17:\"var(--awb-color8)\";s:18:\"footer_border_size\";s:1:\"0\";s:19:\"footer_border_color\";s:17:\"var(--awb-color2)\";s:19:\"footer_divider_line\";s:1:\"0\";s:24:\"footer_divider_line_size\";s:1:\"0\";s:25:\"footer_divider_line_style\";s:5:\"solid\";s:20:\"footer_divider_color\";s:17:\"var(--awb-color6)\";s:22:\"footer_widgets_padding\";s:4:\"15px\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"30px\";s:6:\"bottom\";s:4:\"30px\";}s:18:\"copyright_bg_color\";s:17:\"var(--awb-color8)\";s:21:\"copyright_border_size\";s:1:\"0\";s:22:\"copyright_border_color\";s:17:\"var(--awb-color6)\";s:26:\"footer_headings_typography\";a:9:{s:11:\"font-family\";s:0:\"\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 87% ),var(--awb-color8-a))\";}s:17:\"footer_text_color\";s:17:\"var(--awb-color2)\";s:17:\"footer_link_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 75% ),var(--awb-color8-a))\";s:23:\"footer_link_color_hover\";s:17:\"var(--awb-color1)\";s:20:\"copyright_text_color\";s:17:\"var(--awb-color2)\";s:20:\"copyright_link_color\";s:17:\"var(--awb-color1)\";s:26:\"copyright_link_color_hover\";s:17:\"var(--awb-color1)\";s:19:\"copyright_font_size\";s:4:\"12px\";s:24:\"responsive_sidebar_order\";s:25:\"content,sidebar,sidebar-2\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:3:\"0px\";s:16:\"sidebar_bg_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"13px\";s:21:\"sidebar_heading_color\";s:17:\"var(--awb-color7)\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:13:\"posts_sidebar\";s:4:\"None\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"0\";s:21:\"blog_sidebar_position\";s:5:\"Right\";s:20:\"blog_archive_sidebar\";s:4:\"None\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:9:\"no-repeat\";s:8:\"bg_color\";s:97:\"hsla(var(--awb-color1-h),var(--awb-color1-s),calc(var(--awb-color1-l) + 10%),var(--awb-color1-a))\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:16:\"content_bg_color\";s:17:\"var(--awb-color1)\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:9:\"no-repeat\";s:15:\"typography_sets\";a:6:{s:11:\"typography1\";a:8:{s:5:\"label\";s:8:\"Headings\";s:11:\"font-family\";s:7:\"Arsenal\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"70px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography2\";a:8:{s:5:\"label\";s:11:\"Subheadings\";s:11:\"font-family\";s:7:\"Arsenal\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:6:\"0.09em\";s:14:\"text-transform\";s:9:\"uppercase\";}s:11:\"typography3\";a:8:{s:5:\"label\";s:4:\"Lead\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:3:\"1px\";s:14:\"text-transform\";s:9:\"uppercase\";}s:11:\"typography4\";a:8:{s:5:\"label\";s:4:\"Body\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"19px\";s:11:\"line-height\";s:4:\"1.75\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography5\";a:8:{s:5:\"label\";s:5:\"Small\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"1.72\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:19:\"custom_typography_1\";a:8:{s:5:\"label\";s:17:\"Alternate Heading\";s:11:\"font-family\";s:7:\"Arsenal\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"46px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"body_typography\";a:8:{s:11:\"font-family\";s:34:\"var(--awb-typography4-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography4)\";s:9:\"font-size\";s:32:\"var(--awb-typography4-font-size)\";s:11:\"line-height\";s:34:\"var(--awb-typography4-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography4-letter-spacing)\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:10:\"link_color\";s:17:\"var(--awb-color6)\";s:16:\"link_hover_color\";s:17:\"var(--awb-color4)\";s:15:\"link_decoration\";s:1:\"0\";s:25:\"link_decoration_exclusion\";a:4:{i:0;s:7:\"buttons\";i:1;s:5:\"menus\";i:2;s:4:\"tocs\";i:3;s:11:\"tabstoggles\";}s:20:\"link_decoration_line\";s:4:\"none\";s:21:\"link_decoration_style\";s:5:\"solid\";s:25:\"link_decoration_thickness\";s:3:\"1px\";s:32:\"link_decoration_underline_offset\";s:4:\"auto\";s:26:\"link_decoration_line_hover\";s:4:\"none\";s:27:\"link_decoration_style_hover\";s:5:\"solid\";s:31:\"link_decoration_thickness_hover\";s:3:\"1px\";s:38:\"link_decoration_underline_offset_hover\";s:4:\"auto\";s:13:\"h1_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:32:\"var(--awb-typography1-font-size)\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"0.67em\";s:13:\"margin-bottom\";s:6:\"0.67em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#000000\";}s:13:\"h2_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"31px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"1.1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:13:\"h3_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"30px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"1em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:13:\"h4_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"31px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"1.33em\";s:13:\"margin-bottom\";s:6:\"1.33em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:13:\"h5_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:10:\"margin-top\";s:6:\"1.67em\";s:13:\"margin-bottom\";s:6:\"1.67em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:13:\"h6_typography\";a:11:{s:11:\"font-family\";s:34:\"var(--awb-typography2-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography2)\";s:9:\"font-size\";s:32:\"var(--awb-typography2-font-size)\";s:11:\"line-height\";s:34:\"var(--awb-typography2-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography2-letter-spacing)\";s:10:\"margin-top\";s:6:\"2.33em\";s:13:\"margin-bottom\";s:6:\"2.33em\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:21:\"post_title_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"31px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:29:\"post_titles_extras_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:1:{i:0;s:0:\"\";}s:5:\"woff2\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:4:\"woff\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"ttf\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"eot\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"svg\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:14:\"adobe_fonts_id\";s:0:\"\";s:19:\"blog_page_title_bar\";s:4:\"hide\";s:24:\"blog_show_page_title_bar\";s:15:\"bar_and_content\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:5:\"large\";s:19:\"blog_archive_layout\";s:4:\"grid\";s:20:\"blog_pagination_type\";s:10:\"pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:17:\"var(--awb-color2)\";s:38:\"blog_load_more_posts_button_text_color\";s:20:\"var(--awb-color7)333\";s:42:\"blog_load_more_posts_hover_button_bg_color\";s:99:\"hsla(var(--awb-color2-h),var(--awb-color2-s),var(--awb-color2-l),calc( var(--awb-color2-a) - 20% ))\";s:44:\"blog_load_more_posts_hover_button_text_color\";s:20:\"var(--awb-color7)333\";s:25:\"blog_archive_grid_columns\";s:1:\"3\";s:32:\"blog_archive_grid_column_spacing\";s:2:\"40\";s:18:\"blog_equal_heights\";s:1:\"0\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:21:\"blog_layout_alignment\";s:0:\"\";s:14:\"content_length\";s:7:\"excerpt\";s:19:\"excerpt_length_blog\";s:2:\"10\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:15:\"dates_box_color\";s:17:\"var(--awb-color2)\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"1\";s:22:\"featured_images_single\";s:1:\"0\";s:11:\"blog_pn_nav\";s:1:\"0\";s:15:\"blog_post_title\";s:8:\"disabled\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:18:\"social_sharing_box\";s:1:\"0\";s:11:\"author_info\";s:1:\"0\";s:13:\"related_posts\";s:1:\"0\";s:13:\"blog_comments\";s:1:\"0\";s:9:\"post_meta\";s:1:\"0\";s:16:\"post_meta_author\";s:1:\"1\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"1\";s:14:\"post_meta_read\";s:1:\"1\";s:14:\"post_meta_tags\";s:1:\"0\";s:14:\"meta_font_size\";s:4:\"12px\";s:11:\"date_format\";s:7:\"F jS, Y\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"2\";s:32:\"portfolio_archive_column_spacing\";s:2:\"70\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:2:\"10\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:2:\"10\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:10:\"pagination\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:17:\"var(--awb-color2)\";s:51:\"portfolio_archive_load_more_posts_button_text_color\";s:20:\"var(--awb-color7)333\";s:55:\"portfolio_archive_load_more_posts_hover_button_bg_color\";s:99:\"hsla(var(--awb-color2-h),var(--awb-color2-s),var(--awb-color2-l),calc( var(--awb-color2-a) - 20% ))\";s:57:\"portfolio_archive_load_more_posts_hover_button_text_color\";s:20:\"var(--awb-color7)333\";s:14:\"portfolio_slug\";s:4:\"menu\";s:24:\"portfolio_meta_font_size\";s:4:\"13px\";s:16:\"portfolio_pn_nav\";s:1:\"0\";s:19:\"portfolio_width_100\";s:1:\"1\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:25:\"portfolio_featured_images\";s:1:\"0\";s:25:\"show_first_featured_image\";s:1:\"1\";s:28:\"portfolio_project_desc_title\";s:1:\"0\";s:25:\"portfolio_project_details\";s:1:\"0\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"0\";s:23:\"portfolio_related_posts\";s:1:\"0\";s:18:\"portfolio_comments\";s:1:\"0\";s:18:\"social_media_icons\";a:6:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:1:{i:0;s:0:\"\";}s:9:\"icon_mark\";a:1:{i:0;s:0:\"\";}s:3:\"url\";a:1:{i:0;s:0:\"\";}s:12:\"custom_title\";a:1:{i:0;s:0:\"\";}s:13:\"custom_source\";a:1:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:17:\"var(--awb-color3)\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 91% ),var(--awb-color8-a))\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"1\";s:29:\"footer_social_links_font_size\";s:4:\"16px\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:17:\"var(--awb-color6)\";s:25:\"footer_social_links_boxed\";s:1:\"0\";s:29:\"footer_social_links_box_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 13% ),var(--awb-color8-a))\";s:32:\"footer_social_links_boxed_radius\";s:3:\"4px\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:39:\"Share This Story, Choose Your Platform!\";s:30:\"sharing_box_tagline_text_color\";s:17:\"var(--awb-color7)\";s:15:\"social_bg_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 96% ),var(--awb-color8-a))\";s:22:\"social_sharing_padding\";a:4:{s:3:\"top\";s:6:\"1.25em\";s:5:\"right\";s:6:\"1.25em\";s:6:\"bottom\";s:6:\"1.25em\";s:4:\"left\";s:6:\"1.25em\";}s:14:\"social_sharing\";a:9:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:6:\"reddit\";i:3;s:8:\"linkedin\";i:4;s:8:\"whatsapp\";i:5;s:6:\"tumblr\";i:6;s:9:\"pinterest\";i:7;s:2:\"vk\";i:8;s:5:\"email\";}s:30:\"sharing_social_links_font_size\";s:4:\"16px\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:17:\"var(--awb-color3)\";s:26:\"sharing_social_links_boxed\";s:1:\"0\";s:30:\"sharing_social_links_box_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 91% ),var(--awb-color8-a))\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"4px\";s:34:\"sharing_social_links_boxed_padding\";s:3:\"8px\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"0\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"30px\";s:6:\"height\";s:4:\"30px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"400px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:17:\"var(--awb-color7)\";s:16:\"es_caption_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 45% ),var(--awb-color8-a))\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-white\";s:13:\"lightbox_path\";s:8:\"vertical\";s:24:\"lightbox_animation_speed\";s:6:\"normal\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:13:\"lightbox_loop\";s:1:\"0\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:3:\"0.9\";s:14:\"lightbox_title\";s:1:\"0\";s:13:\"lightbox_desc\";s:1:\"0\";s:15:\"lightbox_social\";s:1:\"1\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:17:\"form_input_height\";s:4:\"50px\";s:14:\"form_text_size\";s:4:\"17px\";s:13:\"form_bg_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 95% ),var(--awb-color8-a))\";s:15:\"form_text_color\";s:17:\"var(--awb-color8)\";s:17:\"form_border_width\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:17:\"form_border_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 82% ),var(--awb-color8-a))\";s:23:\"form_focus_border_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 82% ),var(--awb-color8-a))\";s:18:\"form_border_radius\";s:1:\"0\";s:19:\"form_views_counting\";s:3:\"all\";s:11:\"hubspot_api\";s:3:\"off\";s:11:\"hubspot_key\";s:0:\"\";s:13:\"mailchimp_api\";s:3:\"off\";s:13:\"mailchimp_key\";s:0:\"\";s:17:\"recaptcha_version\";s:2:\"v3\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:15:\"recaptcha_score\";s:3:\"0.5\";s:24:\"recaptcha_badge_position\";s:6:\"inline\";s:20:\"recaptcha_login_form\";s:1:\"0\";s:22:\"recaptcha_comment_form\";s:1:\"0\";s:13:\"email_address\";s:0:\"\";s:24:\"contact_comment_position\";s:5:\"below\";s:29:\"contact_form_privacy_checkbox\";s:1:\"0\";s:26:\"contact_form_privacy_label\";s:152:\"By checking this box, you confirm that you have read and are agreeing to our terms of use regarding the storage of the data submitted through this form.\";s:8:\"gmap_api\";s:0:\"\";s:13:\"gmap_api_type\";s:2:\"js\";s:18:\"gmap_embed_address\";s:0:\"\";s:19:\"gmap_embed_map_type\";s:7:\"roadmap\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:17:\"var(--awb-color4)\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"map_infobox_text_color\";s:17:\"var(--awb-color1)\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:21:\"search_filter_results\";s:1:\"0\";s:14:\"search_content\";a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";}s:27:\"search_limit_to_post_titles\";s:1:\"0\";s:18:\"search_form_design\";s:7:\"classic\";s:11:\"live_search\";s:1:\"0\";s:26:\"live_search_min_char_count\";s:1:\"4\";s:28:\"live_search_results_per_page\";s:3:\"100\";s:26:\"live_search_results_height\";s:3:\"250\";s:34:\"live_search_display_featured_image\";s:1:\"1\";s:29:\"live_search_display_post_type\";s:1:\"1\";s:13:\"search_layout\";s:4:\"grid\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_pagination_type\";s:10:\"pagination\";s:19:\"search_grid_columns\";s:1:\"3\";s:26:\"search_grid_column_spacing\";s:2:\"40\";s:21:\"search_content_length\";s:7:\"excerpt\";s:21:\"search_excerpt_length\";s:2:\"10\";s:25:\"search_strip_html_excerpt\";s:1:\"1\";s:22:\"search_featured_images\";s:1:\"1\";s:11:\"search_meta\";a:5:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:9:\"read_more\";}s:26:\"search_new_search_position\";s:3:\"top\";s:18:\"gfonts_load_method\";s:3:\"cdn\";s:14:\"privacy_embeds\";s:1:\"0\";s:14:\"privacy_expiry\";s:2:\"30\";s:19:\"privacy_embed_types\";a:8:{i:0;s:7:\"youtube\";i:1;s:5:\"vimeo\";i:2;s:10:\"soundcloud\";i:3;s:8:\"facebook\";i:4;s:6:\"flickr\";i:5;s:7:\"twitter\";i:6;s:5:\"gmaps\";i:7;s:8:\"tracking\";}s:22:\"privacy_embed_defaults\";a:0:{}s:16:\"privacy_bg_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc( var(--awb-color8-a) - 90% ))\";s:13:\"privacy_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc( var(--awb-color8-a) - 70% ))\";s:11:\"privacy_bar\";s:1:\"0\";s:19:\"privacy_bar_padding\";a:4:{s:3:\"top\";s:4:\"15px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"15px\";s:4:\"left\";s:4:\"30px\";}s:20:\"privacy_bar_bg_color\";s:17:\"var(--awb-color6)\";s:21:\"privacy_bar_font_size\";s:4:\"13px\";s:17:\"privacy_bar_color\";s:17:\"var(--awb-color3)\";s:22:\"privacy_bar_link_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 75% ),var(--awb-color8-a))\";s:28:\"privacy_bar_link_hover_color\";s:17:\"var(--awb-color4)\";s:16:\"privacy_bar_text\";s:51:\"This website uses cookies and third party services.\";s:23:\"privacy_bar_button_text\";s:2:\"Ok\";s:23:\"privacy_bar_button_save\";s:1:\"0\";s:16:\"privacy_bar_more\";s:1:\"0\";s:21:\"privacy_bar_more_text\";s:8:\"Settings\";s:23:\"privacy_bar_update_text\";s:15:\"Update Settings\";s:30:\"privacy_bar_headings_font_size\";s:4:\"13px\";s:26:\"privacy_bar_headings_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 87% ),var(--awb-color8-a))\";s:19:\"privacy_bar_content\";a:4:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"type\";a:1:{i:0;s:0:\"\";}s:5:\"title\";a:1:{i:0;s:0:\"\";}s:11:\"description\";a:1:{i:0;s:0:\"\";}}s:18:\"privacy_bar_reject\";s:1:\"0\";s:23:\"privacy_bar_reject_text\";s:6:\"Reject\";s:16:\"sidenav_behavior\";s:5:\"hover\";s:18:\"side_nav_font_size\";s:4:\"14px\";s:10:\"post_views\";s:9:\"page_load\";s:19:\"post_views_counting\";s:3:\"all\";s:26:\"featured_image_placeholder\";s:1:\"1\";s:12:\"excerpt_base\";s:5:\"words\";s:16:\"disable_excerpts\";s:1:\"1\";s:24:\"excerpt_read_more_symbol\";s:6:\" [...]\";s:14:\"link_read_more\";s:1:\"0\";s:12:\"avatar_shape\";s:6:\"square\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"0\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:16:\"custom_scrollbar\";s:1:\"0\";s:20:\"scrollbar_background\";s:17:\"var(--awb-color2)\";s:16:\"scrollbar_handle\";s:17:\"var(--awb-color4)\";s:8:\"faq_slug\";s:9:\"faq-items\";s:13:\"cloning_posts\";s:1:\"1\";s:20:\"related_posts_layout\";s:17:\"title_on_rollover\";s:20:\"number_related_posts\";s:1:\"5\";s:21:\"related_posts_columns\";s:1:\"5\";s:28:\"related_posts_column_spacing\";s:2:\"44\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"0\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"1\";s:19:\"related_posts_swipe\";s:1:\"0\";s:25:\"related_posts_swipe_items\";s:1:\"0\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:4:\"fade\";s:24:\"image_rollover_icon_size\";s:4:\"15px\";s:20:\"image_rollover_icons\";s:4:\"link\";s:20:\"title_image_rollover\";s:1:\"0\";s:19:\"cats_image_rollover\";s:1:\"0\";s:26:\"icon_circle_image_rollover\";s:1:\"0\";s:24:\"image_gradient_top_color\";s:112:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 1% ),calc( var(--awb-color8-a) - 15% ))\";s:27:\"image_gradient_bottom_color\";s:13:\"rgba(3,3,3,0)\";s:25:\"image_rollover_text_color\";s:17:\"var(--awb-color1)\";s:25:\"image_rollover_icon_color\";s:17:\"var(--awb-color1)\";s:17:\"pagination_sizing\";s:12:\"width_height\";s:23:\"pagination_width_height\";s:2:\"30\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:23:\"pagination_border_width\";s:1:\"1\";s:24:\"pagination_border_radius\";s:1:\"0\";s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"12px\";s:16:\"pagination_range\";s:1:\"1\";s:26:\"pagination_start_end_range\";s:1:\"0\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:17:\"var(--awb-color2)\";s:25:\"grid_separator_style_type\";s:12:\"single|solid\";s:20:\"grid_separator_color\";s:17:\"var(--awb-color4)\";s:18:\"masonry_grid_ratio\";s:3:\"1.5\";s:20:\"masonry_width_double\";s:4:\"2000\";s:12:\"status_totop\";s:7:\"desktop\";s:14:\"totop_position\";s:5:\"right\";s:19:\"totop_border_radius\";s:1:\"0\";s:16:\"totop_background\";s:17:\"var(--awb-color4)\";s:22:\"totop_background_hover\";s:17:\"var(--awb-color6)\";s:16:\"totop_icon_color\";s:7:\"#ffffff\";s:16:\"totop_icon_hover\";s:7:\"#ffffff\";s:21:\"totop_scroll_progress\";s:1:\"0\";s:22:\"totop_scroll_down_only\";s:1:\"0\";s:23:\"enable_language_updates\";s:1:\"1\";s:19:\"dependencies_status\";s:1:\"1\";s:27:\"disable_code_block_encoding\";s:1:\"1\";s:16:\"disable_megamenu\";s:1:\"0\";s:19:\"status_widget_areas\";s:1:\"1\";s:19:\"status_avada_studio\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"0\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"1\";s:12:\"status_vimeo\";s:1:\"1\";s:11:\"status_gmap\";s:1:\"1\";s:18:\"status_fontawesome\";a:3:{i:0;s:3:\"fab\";i:1;s:3:\"far\";i:2;s:3:\"fas\";}s:28:\"fontawesome_v4_compatibility\";s:1:\"0\";s:22:\"status_fontawesome_pro\";s:1:\"0\";s:14:\"status_outline\";s:1:\"0\";s:19:\"meta_tags_separator\";s:1:\"-\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:24:\"disable_rich_snippet_faq\";s:1:\"1\";s:34:\"enable_block_editor_backend_styles\";s:1:\"0\";s:17:\"load_block_styles\";s:3:\"off\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:15:\"space_body_open\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"0\";s:19:\"status_fusion_forms\";s:1:\"1\";s:21:\"status_awb_Off_Canvas\";s:1:\"1\";s:23:\"status_fusion_portfolio\";s:1:\"1\";s:18:\"status_fusion_faqs\";s:1:\"1\";s:16:\"maintenance_mode\";s:0:\"\";s:24:\"maintenance_redirect_url\";s:0:\"\";s:20:\"maintenance_template\";s:1:\"0\";s:22:\"maintenance_user_roles\";a:0:{}s:19:\"maintenance_exclude\";s:0:\"\";s:22:\"maintenance_page_title\";s:0:\"\";s:23:\"maintenance_robots_meta\";s:7:\"noindex\";s:10:\"svg_upload\";s:8:\"disabled\";s:15:\"pw_jpeg_quality\";s:2:\"82\";s:15:\"awb_image_sizes\";a:14:{i:0;s:10:\"fusion-200\";i:1;s:10:\"fusion-400\";i:2;s:10:\"fusion-600\";i:3;s:10:\"fusion-800\";i:4;s:11:\"fusion-1200\";i:5;s:10:\"blog-large\";i:6;s:11:\"blog-medium\";i:7;s:12:\"recent-posts\";i:8;s:22:\"recent-works-thumbnail\";i:9;s:14:\"portfolio-full\";i:10;s:13:\"portfolio-one\";i:11;s:13:\"portfolio-two\";i:12;s:15:\"portfolio-three\";i:13;s:14:\"portfolio-five\";}s:27:\"wp_big_image_size_threshold\";s:4:\"2560\";s:9:\"lazy_load\";s:5:\"avada\";s:17:\"lazy_load_iframes\";s:5:\"avada\";s:17:\"font_face_display\";s:8:\"swap-all\";s:13:\"preload_fonts\";s:4:\"none\";s:22:\"preload_fonts_variants\";a:1:{i:0;s:3:\"400\";}s:21:\"preload_fonts_subsets\";a:1:{i:0;s:5:\"latin\";}s:15:\"emojis_disabled\";s:8:\"disabled\";s:23:\"jquery_migrate_disabled\";s:8:\"disabled\";s:12:\"defer_jquery\";s:1:\"1\";s:12:\"defer_styles\";s:1:\"0\";s:11:\"gzip_status\";s:1:\"0\";s:12:\"video_facade\";s:2:\"on\";s:18:\"clear_object_cache\";s:1:\"0\";s:16:\"css_cache_method\";s:4:\"file\";s:30:\"css_combine_third_party_assets\";s:1:\"1\";s:19:\"media_queries_async\";s:1:\"0\";s:12:\"critical_css\";s:1:\"1\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:13:\"info_bg_color\";s:17:\"var(--awb-color1)\";s:17:\"info_accent_color\";s:17:\"var(--awb-color5)\";s:15:\"danger_bg_color\";s:17:\"var(--awb-color1)\";s:19:\"danger_accent_color\";s:97:\"hsla(calc(var(--awb-color4-h) + 311),var(--awb-color4-s),var(--awb-color4-l),var(--awb-color4-a))\";s:16:\"success_bg_color\";s:17:\"var(--awb-color1)\";s:20:\"success_accent_color\";s:96:\"hsla(calc(var(--awb-color4-h) + 55),var(--awb-color4-s),var(--awb-color4-l),var(--awb-color4-a))\";s:16:\"warning_bg_color\";s:18:\"var(--awb-color1)f\";s:20:\"warning_accent_color\";s:97:\"hsla(calc(var(--awb-color4-h) + 156),var(--awb-color4-s),var(--awb-color4-l),var(--awb-color4-a))\";s:20:\"alert_box_text_align\";s:6:\"center\";s:24:\"alert_box_text_transform\";s:10:\"capitalize\";s:32:\"alert_box_link_color_inheritance\";s:2:\"no\";s:21:\"alert_box_dismissable\";s:5:\"boxed\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:1:\"1\";s:19:\"alert_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:16:\"animation_offset\";s:13:\"top-into-view\";s:21:\"status_css_animations\";s:7:\"desktop\";s:15:\"audio_max_width\";s:4:\"100%\";s:22:\"audio_background_color\";s:17:\"var(--awb-color8)\";s:23:\"audio_progressbar_color\";s:17:\"var(--awb-color1)\";s:27:\"audio_controls_color_scheme\";s:5:\"light\";s:17:\"audio_border_size\";s:1:\"0\";s:18:\"audio_border_color\";s:17:\"var(--awb-color1)\";s:19:\"audio_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:17:\"blog_grid_columns\";s:1:\"3\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:44:\"blog_element_load_more_posts_button_bg_color\";s:17:\"var(--awb-color2)\";s:46:\"blog_element_load_more_posts_button_text_color\";s:17:\"var(--awb-color7)\";s:50:\"blog_element_load_more_posts_hover_button_bg_color\";s:99:\"hsla(var(--awb-color2-h),var(--awb-color2-s),var(--awb-color2-l),calc( var(--awb-color2-a) - 20% ))\";s:52:\"blog_element_load_more_posts_hover_button_text_color\";s:17:\"var(--awb-color7)\";s:14:\"button_padding\";a:4:{s:3:\"top\";s:4:\"13px\";s:5:\"right\";s:4:\"29px\";s:6:\"bottom\";s:4:\"13px\";s:4:\"left\";s:4:\"29px\";}s:11:\"button_span\";s:2:\"no\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:34:\"var(--awb-typography3-font-family)\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography3)\";s:9:\"font-size\";s:32:\"var(--awb-typography3-font-size)\";s:11:\"line-height\";s:34:\"var(--awb-typography3-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography3-letter-spacing)\";s:14:\"text-transform\";s:9:\"uppercase\";}s:25:\"button_gradient_top_color\";s:98:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 100%))\";s:28:\"button_gradient_bottom_color\";s:98:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 100%))\";s:31:\"button_gradient_top_color_hover\";s:17:\"var(--awb-color1)\";s:34:\"button_gradient_bottom_color_hover\";s:17:\"var(--awb-color1)\";s:21:\"button_gradient_start\";s:1:\"0\";s:19:\"button_gradient_end\";s:3:\"100\";s:20:\"button_gradient_type\";s:6:\"linear\";s:21:\"button_gradient_angle\";s:3:\"180\";s:23:\"button_radial_direction\";s:13:\"center center\";s:19:\"button_accent_color\";s:17:\"var(--awb-color8)\";s:25:\"button_accent_hover_color\";s:17:\"var(--awb-color8)\";s:18:\"button_bevel_color\";s:17:\"var(--awb-color4)\";s:24:\"button_bevel_color_hover\";s:17:\"var(--awb-color4)\";s:19:\"button_border_width\";a:4:{s:3:\"top\";s:3:\"1px\";s:5:\"right\";s:3:\"1px\";s:6:\"bottom\";s:3:\"1px\";s:4:\"left\";s:3:\"1px\";}s:20:\"button_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:19:\"button_border_color\";s:17:\"var(--awb-color3)\";s:25:\"button_border_hover_color\";s:17:\"var(--awb-color8)\";s:14:\"button_presets\";s:1:\"0\";s:18:\"carousel_nav_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc( var(--awb-color8-a) - 40% ))\";s:20:\"carousel_hover_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc( var(--awb-color8-a) - 30% ))\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"chart_legend_position\";s:3:\"top\";s:19:\"chart_show_tooltips\";s:3:\"yes\";s:14:\"chart_bg_color\";s:19:\"rgba(255,255,255,0)\";s:21:\"chart_axis_text_color\";s:17:\"var(--awb-color8)\";s:20:\"chart_gridline_color\";s:97:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc(var(--awb-color8-a) - 90%))\";s:21:\"checklist_icons_color\";s:17:\"var(--awb-color8)\";s:16:\"checklist_circle\";s:1:\"0\";s:22:\"checklist_circle_color\";s:0:\"\";s:20:\"checklist_text_color\";s:17:\"var(--awb-color8)\";s:19:\"checklist_item_size\";s:4:\"21px\";s:22:\"checklist_item_padding\";a:4:{s:3:\"top\";s:6:\"0.35em\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:6:\"0.35em\";s:4:\"left\";s:1:\"0\";}s:17:\"checklist_divider\";s:2:\"no\";s:23:\"checklist_divider_color\";s:17:\"var(--awb-color2)\";s:25:\"checklist_odd_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:26:\"checklist_even_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:2:\"8%\";}s:11:\"col_spacing\";s:2:\"4%\";s:16:\"col_width_medium\";s:3:\"1_1\";s:15:\"col_width_small\";s:3:\"1_1\";s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:2:\"7%\";s:5:\"right\";s:3:\"10%\";s:6:\"bottom\";s:2:\"7%\";s:4:\"left\";s:3:\"10%\";}s:19:\"full_width_bg_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"full_width_gradient_start_color\";s:19:\"rgba(255,255,255,0)\";s:29:\"full_width_gradient_end_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"full_width_border_sizes\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"full_width_border_color\";s:17:\"var(--awb-color2)\";s:29:\"container_scroll_nav_bg_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc( var(--awb-color8-a) - 80% ))\";s:33:\"container_scroll_nav_bullet_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 93% ),var(--awb-color8-a))\";s:35:\"container_hundred_percent_animation\";s:4:\"fade\";s:44:\"container_hundred_percent_scroll_sensitivity\";s:3:\"200\";s:41:\"container_hundred_percent_animation_speed\";s:3:\"800\";s:41:\"container_hundred_percent_dots_navigation\";s:1:\"1\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:24:\"container_legacy_support\";s:1:\"0\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:2:\"24\";s:23:\"content_box_title_color\";s:17:\"var(--awb-color8)\";s:22:\"content_box_body_color\";s:17:\"var(--awb-color8)\";s:21:\"content_box_icon_size\";s:2:\"20\";s:22:\"content_box_icon_color\";s:17:\"var(--awb-color1)\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50%\";s:25:\"content_box_icon_bg_color\";s:17:\"var(--awb-color7)\";s:38:\"content_box_icon_bg_inner_border_color\";s:17:\"var(--awb-color8)\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"1\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:17:\"var(--awb-color4)\";s:21:\"content_box_link_type\";s:4:\"text\";s:23:\"content_box_button_span\";s:2:\"no\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:0:\"\";s:6:\"bottom\";s:0:\"\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:16:\"countdown_layout\";s:7:\"floated\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:24:\"countdown_label_position\";s:9:\"text_flow\";s:26:\"countdown_background_color\";s:17:\"var(--awb-color5)\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:29:\"countdown_counter_box_spacing\";s:4:\"10px\";s:27:\"countdown_counter_box_color\";s:17:\"var(--awb-color7)\";s:25:\"countdown_counter_padding\";a:4:{s:3:\"top\";s:5:\"0.6em\";s:5:\"right\";s:5:\"1.1em\";s:6:\"bottom\";s:5:\"0.6em\";s:4:\"left\";s:5:\"1.1em\";}s:29:\"countdown_counter_border_size\";s:1:\"0\";s:30:\"countdown_counter_border_color\";s:17:\"var(--awb-color7)\";s:31:\"countdown_counter_border_radius\";s:3:\"4px\";s:27:\"countdown_counter_font_size\";s:4:\"18px\";s:28:\"countdown_counter_text_color\";s:17:\"var(--awb-color1)\";s:25:\"countdown_label_font_size\";s:4:\"18px\";s:21:\"countdown_label_color\";s:17:\"var(--awb-color1)\";s:27:\"countdown_heading_font_size\";s:4:\"18px\";s:28:\"countdown_heading_text_color\";s:17:\"var(--awb-color1)\";s:30:\"countdown_subheading_font_size\";s:4:\"14px\";s:31:\"countdown_subheading_text_color\";s:17:\"var(--awb-color1)\";s:25:\"countdown_link_text_color\";s:17:\"var(--awb-color1)\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:17:\"var(--awb-color5)\";s:22:\"counter_box_title_size\";s:2:\"50\";s:21:\"counter_box_icon_size\";s:2:\"50\";s:22:\"counter_box_body_color\";s:17:\"var(--awb-color8)\";s:21:\"counter_box_body_size\";s:2:\"14\";s:24:\"counter_box_border_color\";s:17:\"var(--awb-color3)\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:17:\"var(--awb-color5)\";s:22:\"counter_unfilled_color\";s:17:\"var(--awb-color2)\";s:13:\"dropcap_color\";s:17:\"var(--awb-color5)\";s:18:\"dropcap_text_color\";s:17:\"var(--awb-color1)\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:17:\"var(--awb-color3)\";s:30:\"faq_accordian_background_color\";s:17:\"var(--awb-color1)\";s:25:\"faq_accordian_hover_color\";s:17:\"var(--awb-color2)\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:27:\"faq_accordion_divider_color\";s:17:\"var(--awb-color3)\";s:33:\"faq_accordion_divider_hover_color\";s:17:\"var(--awb-color3)\";s:30:\"faq_accordion_title_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:1:\"1\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:14:\"text-transform\";s:4:\"none\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:23:\"faq_accordion_icon_size\";s:2:\"16\";s:24:\"faq_accordian_icon_color\";s:17:\"var(--awb-color1)\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:17:\"var(--awb-color7)\";s:32:\"faq_accordion_content_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography4-font-family)\";s:11:\"font-backup\";s:1:\"1\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography4)\";s:9:\"font-size\";s:32:\"var(--awb-typography4-font-size)\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:26:\"faq_accordian_active_color\";s:17:\"var(--awb-color4)\";s:33:\"faq_accordian_active_accent_color\";s:0:\"\";s:22:\"flip_boxes_flip_effect\";s:7:\"classic\";s:25:\"flip_boxes_flip_direction\";s:5:\"right\";s:24:\"flip_boxes_flip_duration\";s:3:\"0.8\";s:24:\"flip_boxes_equal_heights\";s:2:\"no\";s:19:\"flip_boxes_front_bg\";s:17:\"var(--awb-color7)\";s:24:\"flip_boxes_front_heading\";s:17:\"var(--awb-color2)\";s:21:\"flip_boxes_front_text\";s:17:\"var(--awb-color3)\";s:18:\"flip_boxes_back_bg\";s:17:\"var(--awb-color5)\";s:23:\"flip_boxes_back_heading\";s:17:\"var(--awb-color1)\";s:20:\"flip_boxes_back_text\";s:97:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 20%))\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:13:\"rgba(0,0,0,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"6px\";s:13:\"gallery_limit\";s:1:\"0\";s:23:\"gallery_pagination_type\";s:6:\"button\";s:29:\"gallery_load_more_button_text\";s:9:\"Load More\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:19:\"gallery_border_size\";s:1:\"0\";s:20:\"gallery_border_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 96% ),var(--awb-color8-a))\";s:21:\"gallery_border_radius\";s:3:\"0px\";s:19:\"google_map_api_type\";s:2:\"js\";s:9:\"icon_size\";s:2:\"32\";s:10:\"icon_color\";s:17:\"var(--awb-color8)\";s:16:\"icon_color_hover\";s:17:\"var(--awb-color1)\";s:11:\"icon_circle\";s:3:\"yes\";s:17:\"icon_circle_color\";s:16:\"rgba(74,78,87,0)\";s:23:\"icon_circle_color_hover\";s:16:\"rgba(51,51,51,0)\";s:16:\"icon_border_size\";s:1:\"1\";s:17:\"icon_border_color\";s:16:\"rgba(51,51,51,0)\";s:23:\"icon_border_color_hover\";s:16:\"rgba(51,51,51,0)\";s:18:\"icon_border_radius\";a:4:{s:8:\"top_left\";s:3:\"50%\";s:9:\"top_right\";s:3:\"50%\";s:12:\"bottom_right\";s:3:\"50%\";s:11:\"bottom_left\";s:3:\"50%\";}s:15:\"icon_hover_type\";s:4:\"fade\";s:17:\"before_after_type\";s:12:\"before_after\";s:22:\"before_after_font_size\";s:2:\"14\";s:25:\"before_after_accent_color\";s:17:\"var(--awb-color1)\";s:28:\"before_after_label_placement\";s:14:\"image-centered\";s:29:\"before_after_label_hover_type\";s:8:\"together\";s:24:\"before_after_handle_type\";s:7:\"default\";s:25:\"before_after_handle_color\";s:17:\"var(--awb-color1)\";s:22:\"before_after_handle_bg\";s:19:\"rgba(255,255,255,0)\";s:19:\"before_after_offset\";s:2:\"50\";s:24:\"before_after_orientation\";s:10:\"horizontal\";s:28:\"before_after_handle_movement\";s:10:\"drag_click\";s:28:\"before_after_transition_time\";s:3:\"0.5\";s:24:\"before_after_border_size\";s:1:\"0\";s:25:\"before_after_border_color\";s:17:\"var(--awb-color3)\";s:26:\"before_after_border_radius\";s:3:\"0px\";s:21:\"imageframe_style_type\";s:4:\"none\";s:15:\"imageframe_blur\";s:1:\"3\";s:20:\"imgframe_style_color\";s:17:\"var(--awb-color8)\";s:22:\"imageframe_border_size\";s:1:\"0\";s:21:\"imgframe_border_color\";s:99:\"hsla(var(--awb-color8-h),var(--awb-color8-s),calc( var(--awb-color8-l) + 96% ),var(--awb-color8-a))\";s:24:\"imageframe_border_radius\";s:3:\"0px\";s:23:\"instagram_cache_timeout\";s:4:\"hour\";s:14:\"modal_bg_color\";s:17:\"var(--awb-color1)\";s:18:\"modal_border_color\";s:17:\"var(--awb-color3)\";s:23:\"openstreetmap_map_style\";s:9:\"osm-carto\";s:33:\"openstreetmap_mapbox_access_token\";s:0:\"\";s:13:\"person_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"person_background_color\";s:17:\"var(--awb-color8)\";s:16:\"person_pic_style\";s:4:\"none\";s:21:\"person_pic_style_blur\";s:1:\"3\";s:18:\"person_style_color\";s:17:\"var(--awb-color8)\";s:19:\"person_border_color\";s:17:\"var(--awb-color3)\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:3:\"0px\";s:16:\"person_alignment\";s:4:\"Left\";s:20:\"person_icon_position\";s:3:\"Top\";s:24:\"popover_heading_bg_color\";s:17:\"var(--awb-color2)\";s:24:\"popover_content_bg_color\";s:17:\"var(--awb-color1)\";s:20:\"popover_border_color\";s:17:\"var(--awb-color3)\";s:18:\"popover_text_color\";s:17:\"var(--awb-color8)\";s:17:\"popover_placement\";s:3:\"Top\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:17:\"portfolio_columns\";s:1:\"3\";s:24:\"portfolio_column_spacing\";s:2:\"30\";s:15:\"portfolio_items\";s:2:\"10\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:24:\"portfolio_content_length\";s:7:\"excerpt\";s:24:\"portfolio_excerpt_length\";s:2:\"10\";s:28:\"portfolio_strip_html_excerpt\";s:1:\"1\";s:23:\"portfolio_title_display\";s:3:\"all\";s:24:\"portfolio_text_alignment\";s:4:\"left\";s:24:\"portfolio_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:25:\"portfolio_pagination_type\";s:10:\"pagination\";s:49:\"portfolio_element_load_more_posts_button_bg_color\";s:99:\"hsla(var(--awb-color2-h),var(--awb-color2-s),var(--awb-color2-l),calc( var(--awb-color2-a) - 30% ))\";s:51:\"portfolio_element_load_more_posts_button_text_color\";s:17:\"var(--awb-color7)\";s:55:\"portfolio_element_load_more_posts_hover_button_bg_color\";s:17:\"var(--awb-color2)\";s:57:\"portfolio_element_load_more_posts_hover_button_text_color\";s:17:\"var(--awb-color7)\";s:36:\"full_boxed_pricing_box_heading_color\";s:17:\"var(--awb-color8)\";s:29:\"sep_pricing_box_heading_color\";s:17:\"var(--awb-color8)\";s:17:\"pricing_box_color\";s:17:\"var(--awb-color4)\";s:16:\"pricing_bg_color\";s:17:\"var(--awb-color1)\";s:30:\"pricing_background_color_hover\";s:17:\"var(--awb-color2)\";s:20:\"pricing_border_color\";s:17:\"var(--awb-color2)\";s:21:\"pricing_divider_color\";s:17:\"var(--awb-color3)\";s:25:\"progressbar_text_position\";s:6:\"on_bar\";s:22:\"progressbar_text_color\";s:17:\"var(--awb-color1)\";s:18:\"progressbar_height\";s:4:\"48px\";s:24:\"progressbar_filled_color\";s:17:\"var(--awb-color5)\";s:26:\"progressbar_unfilled_color\";s:17:\"var(--awb-color2)\";s:30:\"progressbar_filled_border_size\";s:1:\"0\";s:31:\"progressbar_filled_border_color\";s:17:\"var(--awb-color1)\";s:24:\"scroll_progress_position\";s:4:\"flow\";s:22:\"scroll_progress_height\";s:4:\"10px\";s:32:\"scroll_progress_background_color\";s:17:\"var(--awb-color2)\";s:30:\"scroll_progress_progress_color\";s:17:\"var(--awb-color4)\";s:27:\"scroll_progress_border_size\";s:1:\"0\";s:28:\"scroll_progress_border_color\";s:17:\"var(--awb-color1)\";s:29:\"scroll_progress_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:23:\"section_sep_border_size\";s:1:\"1\";s:14:\"section_sep_bg\";s:17:\"var(--awb-color2)\";s:24:\"section_sep_border_color\";s:17:\"var(--awb-color3)\";s:20:\"separator_style_type\";s:4:\"none\";s:9:\"sep_color\";s:17:\"var(--awb-color2)\";s:21:\"separator_border_size\";s:1:\"1\";s:19:\"separator_icon_size\";s:2:\"19\";s:20:\"separator_icon_color\";s:0:\"\";s:16:\"separator_circle\";s:1:\"1\";s:25:\"separator_circle_bg_color\";s:19:\"rgba(255,255,255,0)\";s:19:\"social_links_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:22:\"social_links_font_size\";s:4:\"15px\";s:23:\"social_links_color_type\";s:6:\"custom\";s:23:\"social_links_icon_color\";s:17:\"var(--awb-color1)\";s:29:\"social_links_icon_color_hover\";s:21:\"rgba(255,255,255,0.8)\";s:18:\"social_links_boxed\";s:1:\"1\";s:26:\"social_links_boxed_padding\";s:4:\"15px\";s:22:\"social_links_box_color\";s:17:\"var(--awb-color8)\";s:28:\"social_links_box_color_hover\";s:15:\"rgba(0,0,0,0.8)\";s:19:\"social_links_border\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:25:\"social_links_boxed_radius\";s:4:\"30px\";s:25:\"social_links_border_color\";s:17:\"var(--awb-color3)\";s:31:\"social_links_border_color_hover\";s:17:\"var(--awb-color4)\";s:22:\"stripe_button_api_mode\";s:4:\"test\";s:29:\"stripe_button_test_secret_key\";s:0:\"\";s:29:\"stripe_button_live_secret_key\";s:0:\"\";s:24:\"syntax_highlighter_theme\";s:7:\"default\";s:31:\"syntax_highlighter_line_numbers\";s:3:\"yes\";s:47:\"syntax_highlighter_line_number_background_color\";s:17:\"var(--awb-color2)\";s:41:\"syntax_highlighter_line_number_text_color\";s:17:\"var(--awb-color8)\";s:32:\"syntax_highlighter_line_wrapping\";s:6:\"scroll\";s:36:\"syntax_highlighter_copy_to_clipboard\";s:3:\"yes\";s:41:\"syntax_highlighter_copy_to_clipboard_text\";s:17:\"Copy to Clipboard\";s:28:\"syntax_highlighter_font_size\";s:2:\"14\";s:35:\"syntax_highlighter_background_color\";s:17:\"var(--awb-color1)\";s:30:\"syntax_highlighter_border_size\";s:1:\"1\";s:31:\"syntax_highlighter_border_color\";s:17:\"var(--awb-color3)\";s:31:\"syntax_highlighter_border_style\";s:5:\"solid\";s:25:\"syntax_highlighter_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"tabs_bg_color\";s:17:\"var(--awb-color1)\";s:19:\"tabs_inactive_color\";s:17:\"var(--awb-color2)\";s:24:\"tabs_title_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:17:\"tabs_border_color\";s:17:\"var(--awb-color3)\";s:18:\"tabs_title_padding\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:20:\"tabs_content_padding\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:18:\"tabs_icon_position\";s:4:\"left\";s:14:\"tabs_icon_size\";s:2:\"16\";s:15:\"tabs_icon_color\";s:0:\"\";s:22:\"tabs_icon_active_color\";s:0:\"\";s:16:\"tabs_title_color\";s:0:\"\";s:23:\"tabs_active_title_color\";s:0:\"\";s:22:\"tabs_mobile_breakpoint\";s:6:\"medium\";s:16:\"tabs_mobile_mode\";s:9:\"accordion\";s:23:\"tabs_mobile_sticky_tabs\";s:2:\"no\";s:11:\"tagcloud_bg\";s:22:\"rgba(255, 255, 255, 0)\";s:17:\"tagcloud_bg_hover\";s:17:\"var(--awb-color4)\";s:14:\"tagcloud_color\";s:97:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 20%))\";s:20:\"tagcloud_color_hover\";s:17:\"var(--awb-color1)\";s:21:\"tagcloud_border_color\";s:17:\"var(--awb-color8)\";s:27:\"tagcloud_border_color_hover\";s:17:\"var(--awb-color4)\";s:10:\"tagline_bg\";s:17:\"var(--awb-color2)\";s:20:\"tagline_border_color\";s:19:\"rgba(226,226,226,0)\";s:14:\"tagline_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:20:\"testimonial_bg_color\";s:17:\"var(--awb-color2)\";s:24:\"testimonial_border_width\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:24:\"testimonial_border_style\";s:5:\"solid\";s:24:\"testimonial_border_color\";s:17:\"var(--awb-color3)\";s:25:\"testimonial_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:22:\"testimonial_text_color\";s:17:\"var(--awb-color8)\";s:18:\"testimonials_speed\";s:4:\"4000\";s:19:\"testimonials_random\";s:1:\"0\";s:12:\"text_columns\";s:1:\"1\";s:21:\"text_column_min_width\";s:5:\"100px\";s:19:\"text_column_spacing\";s:3:\"2em\";s:15:\"text_rule_style\";s:4:\"none\";s:14:\"text_rule_size\";s:1:\"1\";s:15:\"text_rule_color\";s:17:\"var(--awb-color2)\";s:16:\"text_user_select\";s:4:\"auto\";s:20:\"title_text_transform\";s:0:\"\";s:16:\"title_style_type\";s:4:\"none\";s:18:\"title_border_color\";s:17:\"var(--awb-color2)\";s:12:\"title_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"31px\";s:4:\"left\";s:3:\"0px\";}s:19:\"title_margin_mobile\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:3:\"0px\";}s:14:\"accordion_type\";s:10:\"accordions\";s:20:\"accordion_boxed_mode\";s:1:\"0\";s:21:\"accordion_border_size\";s:1:\"1\";s:22:\"accordian_border_color\";s:17:\"var(--awb-color3)\";s:26:\"accordian_background_color\";s:17:\"var(--awb-color1)\";s:21:\"accordian_hover_color\";s:17:\"var(--awb-color2)\";s:22:\"accordion_divider_line\";s:1:\"1\";s:23:\"accordion_divider_color\";s:17:\"var(--awb-color3)\";s:29:\"accordion_divider_hover_color\";s:17:\"var(--awb-color3)\";s:26:\"accordion_title_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography1-font-family)\";s:11:\"font-backup\";s:1:\"1\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography1)\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:34:\"var(--awb-typography1-line-height)\";s:14:\"letter-spacing\";s:37:\"var(--awb-typography1-letter-spacing)\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:19:\"accordion_icon_size\";s:2:\"16\";s:20:\"accordian_icon_color\";s:17:\"var(--awb-color1)\";s:20:\"accordion_icon_boxed\";s:1:\"1\";s:24:\"accordian_inactive_color\";s:17:\"var(--awb-color8)\";s:28:\"accordion_content_typography\";a:9:{s:11:\"font-family\";s:34:\"var(--awb-typography4-font-family)\";s:11:\"font-backup\";s:1:\"1\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:22:\"var(--awb-typography4)\";s:9:\"font-size\";s:32:\"var(--awb-typography4-font-size)\";s:11:\"line-height\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:17:\"var(--awb-color8)\";}s:22:\"accordian_active_color\";s:17:\"var(--awb-color5)\";s:29:\"accordian_active_accent_color\";s:0:\"\";s:20:\"accordion_icon_align\";s:4:\"left\";s:21:\"user_login_text_align\";s:6:\"center\";s:28:\"user_login_form_field_layout\";s:7:\"stacked\";s:27:\"user_login_form_show_labels\";s:2:\"no\";s:33:\"user_login_form_show_placeholders\";s:3:\"yes\";s:32:\"user_login_form_show_remember_me\";s:2:\"no\";s:32:\"user_login_form_background_color\";s:17:\"var(--awb-color2)\";s:15:\"video_max_width\";s:4:\"100%\";s:14:\"video_controls\";s:3:\"yes\";s:13:\"video_preload\";s:4:\"auto\";s:22:\"widget_area_title_size\";s:4:\"31px\";s:23:\"widget_area_title_color\";s:17:\"var(--awb-color8)\";}", "auto");
INSERT INTO `wor6069_options` VALUES("1057", "awb_critical_table", "3.4", "off");
INSERT INTO `wor6069_options` VALUES("1058", "sbg_sidebars", "a:4:{s:26:\"Hors D\'oeuvres - Mega Menu\";s:26:\"Hors D\'oeuvres - Mega Menu\";s:23:\"Main Course - Mega Menu\";s:23:\"Main Course - Mega Menu\";s:20:\"Desserts - Mega Menu\";s:20:\"Desserts - Mega Menu\";s:21:\"Cocktails - Mega Menu\";s:21:\"Cocktails - Mega Menu\";}", "auto");
INSERT INTO `wor6069_options` VALUES("1196", "_transient_health-check-site-status-result", "{\"good\":17,\"recommended\":5,\"critical\":1}", "on");
INSERT INTO `wor6069_options` VALUES("1211", "cmplz_sync_cookies_complete", "1", "off");
INSERT INTO `wor6069_options` VALUES("1314", "cmplz_sync_services_complete", "1", "off");
INSERT INTO `wor6069_options` VALUES("1454", "fusion_options-transients", "a:2:{s:14:\"changed_values\";a:1:{s:8:\"fav_icon\";a:5:{s:3:\"url\";s:67:\"http://donnadieu.agencemiyou.com/wp-content/uploads/2021/04/fav.svg\";s:2:\"id\";s:4:\"3526\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:9:\"last_save\";i:1736324023;}", "auto");
INSERT INTO `wor6069_options` VALUES("1963", "fusionredux_hide_ajax_notification", "1", "auto");
INSERT INTO `wor6069_options` VALUES("2093", "WPLANG", "fr_FR", "auto");
INSERT INTO `wor6069_options` VALUES("2094", "new_admin_email", "miyustreet@gmail.com", "auto");
INSERT INTO `wor6069_options` VALUES("2104", "avada_permalinks", "a:4:{s:23:\"portfolio_category_base\";s:0:\"\";s:21:\"portfolio_skills_base\";s:0:\"\";s:19:\"portfolio_tags_base\";s:0:\"\";s:17:\"faq_category_base\";s:0:\"\";}", "auto");
INSERT INTO `wor6069_options` VALUES("2457", "cmplz_sync_cookies_after_services_complete", "1", "off");
INSERT INTO `wor6069_options` VALUES("2893", "fusion_builder_frontend_preferences", "a:4:{s:13:\"overWriteType\";s:7:\"inherit\";s:12:\"shouldInvert\";s:11:\"dont-invert\";s:16:\"contentPlacement\";s:17:\"load-type-replace\";s:12:\"imagesImport\";s:16:\"do-import-images\";}", "auto");
INSERT INTO `wor6069_options` VALUES("4235", "trustindex-google-active", "1", "auto");
INSERT INTO `wor6069_options` VALUES("4236", "trustindex-google-notifications", "a:3:{s:23:\"not-using-no-connection\";a:3:{s:9:\"timestamp\";i:1735911826;s:6:\"active\";b:0;s:8:\"do-check\";b:0;}s:7:\"rate-us\";a:3:{s:6:\"active\";b:1;s:9:\"timestamp\";i:1735911826;s:6:\"hidden\";b:1;}s:19:\"not-using-no-widget\";a:2:{s:6:\"active\";b:0;s:9:\"timestamp\";i:1735832654;}}", "off");
INSERT INTO `wor6069_options` VALUES("4238", "trustindex-google-version-control", "a:1:{s:20:\"update-version-check\";s:6:\"12.4.7\";}", "off");
INSERT INTO `wor6069_options` VALUES("4239", "trustindex-core-shortcode-inited", "12.4.7", "off");
INSERT INTO `wor6069_options` VALUES("4242", "trustindex-google-review-download-request-id", "912aa8755031g534", "off");
INSERT INTO `wor6069_options` VALUES("4243", "trustindex-google-download-timestamp", "1736689454", "off");
INSERT INTO `wor6069_options` VALUES("4244", "trustindex-google-review-download-modal", "0", "off");
INSERT INTO `wor6069_options` VALUES("4245", "trustindex-google-page-details", "a:8:{s:2:\"id\";s:27:\"ChIJi5OvZyHBtRIR2drel5fcwTw\";s:4:\"name\";s:16:\"\"Donnadieu Bois\"\";s:10:\"avatar_url\";s:97:\"https://lh5.googleusercontent.com/p/AF1QipOoYEWWUgKvOINwLETVef03Oy2JamIyDSLEsY3G=w900-h900-p-k-no\";s:16:\"write_review_url\";s:93:\"https://www.google.com/maps/place//data=!4m3!3m2!1s0x12b5c12167af938b:0x3cc1dc9797dedad9!12e1\";s:7:\"address\";s:60:\"1041 route Escale, Chem. du Mas Blanc, 30390 Domazan, France\";s:13:\"rating_number\";s:2:\"52\";s:12:\"rating_score\";s:3:\"4.4\";s:9:\"timestamp\";i:0;}", "off");
INSERT INTO `wor6069_options` VALUES("4246", "trustindex-google-lang", "fr", "off");
INSERT INTO `wor6069_options` VALUES("4248", "trustindex-google-style-id", "36", "off");
INSERT INTO `wor6069_options` VALUES("4249", "trustindex-google-scss-set", "light-background", "off");
INSERT INTO `wor6069_options` VALUES("4250", "trustindex-google-css-content", "@charset \"UTF-8\";\n@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/cyrillic-ext.woff2\") format(\"woff2\");unicode-range:U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/cyrillic.woff2\") format(\"woff2\");unicode-range:U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/greek-ext.woff2\") format(\"woff2\");unicode-range:U+1F00-1FFF}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/greek.woff2\") format(\"woff2\");unicode-range:U+0370-03FF}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/vietnamese.woff2\") format(\"woff2\");unicode-range:U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/latin-ext.woff2\") format(\"woff2\");unicode-range:U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:400;font-display:swap;src:local(\"Open Sans Regular\"), local(\"OpenSans-Regular\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/latin.woff2\") format(\"woff2\");unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/cyrillic-ext2.woff2\") format(\"woff2\");unicode-range:U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/cyrillic2.woff2\") format(\"woff2\");unicode-range:U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/greek-ext2.woff2\") format(\"woff2\");unicode-range:U+1F00-1FFF}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/greek2.woff2\") format(\"woff2\");unicode-range:U+0370-03FF}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/vietnamese2.woff2\") format(\"woff2\");unicode-range:U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+1EA0-1EF9, U+20AB}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/latin-ext2.woff2\") format(\"woff2\");unicode-range:U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB, U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF}@font-face{font-family:\"Trustindex Open Sans\";font-style:normal;font-weight:700;font-display:swap;src:local(\"Open Sans Bold\"), local(\"OpenSans-Bold\"), url(\"https://cdn.trustindex.io/assets/fonts/opensans/latin2.woff2\") format(\"woff2\");unicode-range:U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD}.ti-amp-iframe-body{background:#ffffff}.ti-widget.ti-goog{width:100%;display:block;overflow:hidden;text-align:left;direction:ltr;box-sizing:border-box}.ti-widget.ti-goog font{pointer-events:none}.ti-widget.ti-goog script{display:none !important}.ti-widget.ti-goog img{box-shadow:unset !important}.ti-widget.ti-goog *,.ti-widget.ti-goog *:after{box-sizing:border-box}.ti-widget.ti-goog *:before,.ti-widget.ti-goog *:after{-webkit-box-ordinal-group:1 !important;content:unset}.ti-widget.ti-goog:before{display:none !important}.ti-widget.ti-goog img{padding:0 !important;margin:0 !important;min-width:initial !important;max-width:initial !important}.ti-widget.ti-goog a{text-decoration:underline !important;color:inherit}.ti-widget.ti-goog a.ti-header{text-decoration:none !important}.ti-widget.ti-goog a[href=\"#\"]:not(.ti-show-original-text),.ti-widget.ti-goog a:not([href]){text-decoration:none !important;pointer-events:none}.ti-widget.ti-goog .ti-widget-container,.ti-widget.ti-goog .ti-widget-container *{font-family:\"Trustindex Open Sans\";font-size:14px;line-height:1.4em;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box}.ti-widget.ti-goog strong,.ti-widget.ti-goog strong *{font-weight:bold}.ti-widget.ti-goog .ti-widget-container{display:block;color:#000000;margin-bottom:15px}.ti-widget.ti-goog .ti-widget-container .ti-name{font-weight:bold;font-size:14px;overflow:hidden;padding-right:25px;white-space:nowrap;text-overflow:ellipsis;color:#000000;margin-bottom:2px}.ti-widget.ti-goog .ti-widget-container .ti-name a{text-decoration:none !important;font-size:inherit}.ti-widget.ti-goog .ti-widget-container .ti-name a:hover{text-decoration:underline !important}.ti-widget.ti-goog .ti-widget-container .ti-date{color:#000000;opacity:0.5;font-size:11.2px !important}.ti-widget.ti-goog .ti-profile-img{margin:0 15px 0 0 !important}.ti-widget.ti-goog .ti-profile-img img{width:40px !important;height:40px !important;display:block;border-radius:30px;object-fit:cover;object-position:top}.ti-widget.ti-goog .ti-profile-img .ti-profile-img-sprite{display:inline-block;float:left;background:white;background-repeat:no-repeat;width:40px;height:40px;border-radius:30px}.ti-widget.ti-goog .ti-profile-details{-webkit-box-flex:1;-ms-flex:1;flex:1;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;text-align:left;margin:0 !important;display:flex;flex-direction:column;justify-content:center}.ti-widget.ti-goog .ti-stars{margin-top:3px;white-space:nowrap;display:block}.ti-widget.ti-goog .ti-star{width:17px !important;height:17px !important;margin-right:1px !important;vertical-align:unset;display:inline-block !important}.ti-widget.ti-goog img.ti-star{background:none !important}.ti-widget.ti-goog .ti-footer{margin-top:15px;padding-top:0px;text-align:center;line-height:1.45em}.ti-widget.ti-goog .ti-footer .ti-name{color:#000000;font-size:15px;margin-bottom:5px;overflow:hidden;text-overflow:ellipsis}.ti-widget.ti-goog .ti-footer .ti-stars{margin-bottom:3px;margin-top:0px;line-height:0}.ti-widget.ti-goog .ti-footer .ti-profile-details{padding-top:4px}.ti-widget.ti-goog .ti-footer .ti-inner{padding-bottom:10px}.ti-widget.ti-goog .ti-footer-filter-text{font-size:15px !important;color:#000000;margin-bottom:0 !important;padding:0 15px;text-align:left;margin:15px 0}.ti-widget.ti-goog .ti-footer-filter-text:empty{margin:0 !important}.ti-widget.ti-goog .ti-disclaimer{visibility:hidden;opacity:0;padding:10px;position:absolute;bottom:100%;width:100%;min-width:220px;max-width:585px;background:white;border:1px solid #000;border-radius:4px;font-size:14px;font-weight:normal;margin-bottom:15px;text-align:left;z-index:2147483647;color:#000000 !important;transition:all 0.3s;transition-delay:0.35s;right:unset ;left:50% ;transform:translateX(-50%) }.ti-widget.ti-goog .ti-disclaimer:after{left:0 ;right:0 }.ti-widget.ti-goog .ti-disclaimer a{font-size:inherit}.ti-widget.ti-goog .ti-disclaimer:after{position:absolute;content:\"\";bottom:-10px;margin:0 auto;width:0;border:10px solid transparent;border-bottom-width:0;border-top-color:#000}.ti-widget.ti-goog .ti-disclaimer.ti-bottom{bottom:unset;margin-bottom:unset;top:100%;margin-top:15px}.ti-widget.ti-goog .ti-disclaimer.ti-bottom:after{bottom:unset;top:-10px;border:10px solid transparent;border-top-width:0;border-bottom-color:#000}.ti-widget.ti-goog .ti-disclaimer:hover{visibility:visible;opacity:1}.ti-widget.ti-goog .ti-verified-by{display:inline-block}.ti-widget.ti-goog .ti-verified-by .ti-info-icon{display:inline-block;background-size:contain;width:13px;height:13px;position:relative;top:2px;-webkit-mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-light.svg\");mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-light.svg\");-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;background-color:#000000}.ti-widget.ti-goog .ti-verified-by-row{display:block;text-align:right;margin-bottom:0 !important;font-size:13px;color:#000000;margin:12px 28px}.ti-widget.ti-goog .ti-verified-by-row>.ti-inner{display:inline-block;position:relative;padding:2px 8px;font-size:13px;font-weight:bold;padding:3px 8px}.ti-widget.ti-goog .ti-verified-by-row .ti-info-icon{-webkit-mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-regular.svg\");mask-image:url(\"https://cdn.trustindex.io/assets/icon/ti-info-regular.svg\")}.ti-widget.ti-goog .ti-verified-by-row .ti-trustindex-icon{display:inline-block;width:15px;height:15px;vertical-align:unset;position:relative;top:2px;background-image:url(\"https://cdn.trustindex.io/assets/platform/Trustindex/icon.svg\");margin-left:4px;margin-right:3px}.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer{width:350px !important;left:unset ;transform:unset ;right:0 }.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:after{left:unset ;right:15px }.ti-widget.ti-goog .ti-verified-by-row[data-style=\"1\"]>.ti-inner{background-color:#157351;color:white}.ti-widget.ti-goog .ti-verified-by-row[data-style=\"1\"] .ti-info-icon{background-color:white}.ti-widget.ti-goog .ti-verified-by-row[data-style=\"2\"]>.ti-inner{background-color:#D6F3E6;color:black}.ti-widget.ti-goog .ti-verified-by-row[data-style=\"2\"] .ti-info-icon{background-color:black}.ti-widget.ti-goog .ti-verified-by:hover+.ti-disclaimer,.ti-widget.ti-goog .ti-verified-by .ti-inner:hover .ti-disclaimer{visibility:visible;transition-delay:0.1ms;opacity:1}.ti-widget.ti-goog .ti-footer-filter-text+.ti-verified-by-row{margin-top:-20px !important}.ti-widget.ti-goog .ti-footer+.ti-verified-by-row{text-align:center}.ti-widget.ti-goog .ti-footer+.ti-verified-by-row .ti-disclaimer{right:unset ;left:50% ;transform:translateX(-50%) }.ti-widget.ti-goog .ti-footer+.ti-verified-by-row .ti-disclaimer:after{left:0 ;right:0 }@media (max-width:479px){.ti-widget.ti-goog .ti-verified-by-row{text-align:center !important}.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer{right:unset ;left:50% ;transform:translateX(-50%) }.ti-widget.ti-goog .ti-verified-by-row .ti-disclaimer:after{left:0 ;right:0 }.ti-widget.ti-goog .ti-footer-filter-text+.ti-verified-by-row{margin-top:12px !important}}@media (max-width:479px){.ti-widget.ti-goog .ti-footer-filter-text{text-align:center !important}}@media (min-width:1024px){.ti-widget.ti-goog .ti-footer-filter-text{margin:12px 28px}}.ti-widget.ti-goog .star-lg .ti-star{width:30px !important;height:30px !important}.ti-widget.ti-goog .ti-d-none{display:none !important}.ti-widget.ti-goog .ti-rating-text,.ti-widget.ti-goog .ti-rating-text strong:not(.ti-rating-large),.ti-widget.ti-goog .ti-rating-text strong a,.ti-widget.ti-goog .ti-rating-text strong span,.ti-widget.ti-goog .ti-rating-text span strong,.ti-widget.ti-goog .ti-rating-text span,.ti-widget.ti-goog .ti-footer,.ti-widget.ti-goog .ti-footer strong:not(.ti-rating-large),.ti-widget.ti-goog .ti-footer span,.ti-widget.ti-goog .ti-footer strong a{font-size:0px;color:#000000}.ti-widget.ti-goog .ti-large-logo{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;margin-bottom:0 !important}.ti-widget.ti-goog .ti-large-logo .ti-v-center{-ms-flex-item-align:center !important;align-self:center !important;text-align:center;-ms-flex-preferred-size:0;flex-basis:0;-ms-flex-positive:1;flex-grow:1;max-width:100%}.ti-widget.ti-goog .ti-large-logo img{margin:auto !important;display:block !important;position:relative;width:150px !important;height:32px !important}.ti-widget.ti-goog .nowrap{white-space:nowrap;display:inline-block;margin:0 2px}.ti-widget.ti-goog .nowrap:first-of-type{margin-left:0}.ti-widget.ti-goog .nowrap:last-of-type{margin-right:0}.ti-widget.ti-goog .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars{margin-bottom:8px;margin-top:15px;text-align:left}.ti-widget.ti-goog .ti-reviews-container-wrapper{overflow:hidden;display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;margin:0 -8px;padding-top:5px}.ti-disable-animation.ti-widget.ti-goog .ti-reviews-container-wrapper{padding-top:0 !important}@media (min-width:1024px){.ti-widget.ti-goog .ti-reviews-container-wrapper{margin:0 20px !important}}.ti-widget.ti-goog .ti-col-1 .ti-review-item{-ms-flex:0 0 100%;flex:0 0 100%;max-width:100%}.ti-widget.ti-goog .ti-col-2 .ti-review-item{-ms-flex:0 0 50%;flex:0 0 50%;max-width:50%}.ti-widget.ti-goog .ti-col-3 .ti-review-item{-ms-flex:0 0 33.333%;flex:0 0 33.333%;max-width:33.333%}.ti-widget.ti-goog .ti-col-4 .ti-review-item{-ms-flex:0 0 25%;flex:0 0 25%;max-width:25%}.ti-widget.ti-goog .ti-col-5 .ti-review-item{-ms-flex:0 0 20%;flex:0 0 20%;max-width:20%}.ti-widget.ti-goog .ti-col-6 .ti-review-item{-ms-flex:0 0 16.666%;flex:0 0 16.666%;max-width:16.666%}.ti-widget.ti-goog .ti-col-7 .ti-review-item{-ms-flex:0 0 14.286%;flex:0 0 14.286%;max-width:14.286%}.ti-widget.ti-goog .ti-col-8 .ti-review-item{-ms-flex:0 0 12.5%;flex:0 0 12.5%;max-width:12.5%}.ti-widget.ti-goog .ti-col-9 .ti-review-item{-ms-flex:0 0 11.111%;flex:0 0 11.111%;max-width:11.111%}.ti-widget.ti-goog .ti-col-10 .ti-review-item{-ms-flex:0 0 10%;flex:0 0 10%;max-width:10%}.ti-widget.ti-goog .ti-reviews-container{position:relative;display:block;touch-action:pan-y}.ti-widget.ti-goog .ti-read-more{display:block;padding:5px 0 0;text-align:left}.ti-widget.ti-goog .ti-read-more span{display:inline-block;font-weight:400;white-space:nowrap;font-size:13.5px;color:#000000;opacity:0.5;text-decoration:none !important;transition:color 300ms ease-out;cursor:pointer}.ti-widget.ti-goog .ti-read-more span:hover{opacity:1;text-decoration:underline !important}.ti-widget.ti-goog .ti-review-item{padding:0 8px;transition:transform 300ms ease-out}.ti-widget.ti-goog .ti-review-item .ti-inner{border-radius:4px}.ti-widget.ti-goog .ti-review-item>.ti-inner{border-style:solid !important;border-color:#f4f4f4 !important;background:#f4f4f4 !important;border-radius:4px !important;padding:20px !important;margin:0 !important;display:block;position:relative}.ti-widget.ti-goog .ti-review-item .ti-polarity-icon{position:relative;text-indent:3px;display:inline-block;width:15px !important;height:15px !important;vertical-align:unset}.ti-widget.ti-goog .ti-review-item .ti-recommendation .ti-recommendation-icon{position:relative;margin:0 5px !important;margin-bottom:-3px !important;text-indent:3px;display:inline-block;width:15px !important;height:15px !important;vertical-align:unset}.ti-widget.ti-goog .ti-review-item .ti-recommendation .ti-recommendation-icon:first-child{margin-left:0 !important}.ti-widget.ti-goog .ti-review-item .ti-recommendation .ti-recommendation-title{font-weight:700;font-size:13px !important;opacity:0.8;position:relative;top:-1px}.ti-widget.ti-goog .ti-review-item .ti-recommendation+.ti-dummy-stars{display:none}.ti-widget.ti-goog .ti-review-item .ti-stars{height:17px}.ti-widget.ti-goog .ti-review-item .ti-review-image{width:80px;height:80px;border-radius:4px;margin-left:12px;margin-bottom:4px;margin-top:2px;position:relative;cursor:pointer;overflow:hidden}.ti-widget.ti-goog .ti-review-item .ti-review-image img{position:absolute;object-fit:cover;width:100% !important;height:100% !important;max-width:100% !important;max-height:100% !important;border-radius:inherit;border:0;left:0;top:0;transition:all 0.3s ease-in-out;pointer-events:none}.ti-widget.ti-goog .ti-review-item .ti-review-image .ti-more-image-count{position:absolute;width:100%;height:100%;left:0;top:0;display:flex;align-items:center;justify-content:center;color:white;background-color:rgba(0, 0, 0, 0.4);font-size:18px;border-radius:inherit;opacity:0;pointer-events:none;transition:all 0.2s ease-in-out;font-weight:bold;transform:scale(0.85);z-index:2}.ti-widget.ti-goog .ti-review-item .ti-review-image:hover img{transform:scale(1.1)}.ti-widget.ti-goog .ti-review-item .ti-review-image:hover.ti-has-more-image .ti-more-image-count{opacity:1;transform:scale(1)}.ti-widget.ti-goog .ti-review-item .ti-review-image-container{display:flex;flex-wrap:nowrap;margin:0 -4px;margin-top:15px;max-height:100px;transition:all 500ms ease-in-out}.ti-widget.ti-goog .ti-review-item .ti-review-image-container .ti-review-image{float:unset !important;margin:0 !important;width:25%;height:unset;flex:0 0 auto;padding:0 4px}.ti-widget.ti-goog .ti-review-item .ti-review-image-container .ti-review-image .ti-review-image-inner{display:block;position:relative;width:100%;height:0;padding-bottom:100%;border-radius:inherit;overflow:hidden;pointer-events:none}.ti-widget.ti-goog .ti-review-item .ti-review-image-container .ti-review-image.ti-has-more-image .ti-more-image-count{opacity:1;transform:scale(1)}.ti-widget.ti-goog .ti-review-item.ti-hidden-review .ti-review-image-container{max-height:0;margin-top:0;transition-delay:500ms}.ti-widget.ti-goog .ti-review-content{display:-webkit-box;-webkit-box-orient:vertical;line-height:21.75px;height:87px;font-size:15px;text-align:left;transition:height 0.5s;font-style:normal;-webkit-line-clamp:4;overflow:hidden;padding-right:0}.ti-widget.ti-goog .ti-review-content .ti-review-image{float:right}.ti-widget.ti-goog .ti-review-content.ti-empty-text .ti-review-image{float:unset !important;margin:unset !important;display:inline-block !important}.ti-text-align-right.ti-widget.ti-goog .ti-review-content .ti-review-image{float:left;margin-left:unset;margin-right:12px}.ti-ios-fallback.ti-widget.ti-goog .ti-review-content{display:block}.ti-widget.ti-goog .ti-review-content .ti-show-original-text{font-size:inherit !important}.ti-review-text-mode-scroll.ti-widget.ti-goog .ti-review-content{-webkit-line-clamp:inherit;overflow:auto;overflow-x:hidden;padding-right:10px}.ti-text-align-right.ti-widget.ti-goog .ti-review-content{text-align:right !important}.ti-text-align-center.ti-widget.ti-goog .ti-review-content{text-align:center !important}.ti-text-align-justify.ti-widget.ti-goog .ti-review-content{text-align:justify !important}.ti-widget.ti-goog .ti-review-content .ti-stars{margin-bottom:5px}.ti-widget.ti-goog .ti-review-content strong{font-size:inherit;color:inherit;font-weight:normal !important}.ti-widget.ti-goog .ti-review-content .ti-reply-by-owner-title{font-weight:bold !important}.ti-widget.ti-goog .ti-review-content .ti-reply-by-owner-title:before{content:\"↪ \"}.ti-widget.ti-goog .ti-review-header{display:-ms-flexbox;display:flex;-ms-flex-wrap:nowrap;flex-wrap:nowrap;position:relative}.ti-widget.ti-goog .ti-highlight{padding:1px 2px;margin:0;box-decoration-break:clone;-webkit-box-decoration-break:clone;border-radius:1px;-webkit-border-radius:1px;-moz-border-radius:1px;background-color:transparent !important;background-image:linear-gradient(#fbe049, #fbe049);background-size:100% 19px;background-position:bottom;background-repeat:no-repeat;color:#000 !important;font-size:inherit !important}@media (min-width:480px){.ti-widget.ti-goog .ti-review-item:hover{-webkit-transform:translate(0, -5px);-ms-transform:translate(0, -5px);transform:translate(0, -5px)}}.ti-widget.ti-goog .ti-ai-summary-item{color:#000000}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content{-webkit-line-clamp:5;margin-top:16.25px;height:110.75px !important}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list{margin-bottom:0;padding-left:0;list-style:none;font-size:inherit}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list li{list-style:inherit;margin-bottom:0;padding-left:20px;position:relative;font-size:inherit}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list li:last-child{margin-bottom:0}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content .ti-summary-list li:before{display:block;content:\"\";width:10px;height:5px;border-left:solid 2px #000000;border-bottom:solid 2px #000000;transform:rotate(-45deg);position:absolute;left:0;top:7.5px}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img{margin-right:13px !important}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img){display:inline-block;vertical-align:middle;border:2px solid #f4f4f4}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img):not(:first-child){margin-left:-12px !important}.ti-widget.ti-goog .ti-ai-summary-item>.ti-inner{background:#f4f4f4 !important}.ti-widget.ti-goog .ti-ai-summary-item .ti-profile-img img:not(.ti-ai-profile-img){border-color:#f4f4f4}.ti-widget.ti-goog .ti-ai-summary-item .ti-name,.ti-widget.ti-goog .ti-ai-summary-item .ti-date,.ti-widget.ti-goog .ti-ai-summary-item .ti-read-more span{color:#000000}.ti-widget.ti-goog .ti-ten-rating-score{display:inline-block;font-weight:bold;font-size:15px;color:#000000;margin-left:7px;height:100%;line-height:17px;vertical-align:top}.ti-widget.ti-goog .ti-platform-icon{width:20px !important;height:20px !important;position:absolute;top:0;right:0}.ti-widget.ti-goog.ti-custom-stars [class*=\"source-\"] .ti-star.e,.ti-widget.ti-goog.ti-custom-stars [class*=\"source-\"] .ti-star.f{background-image:none}.ti-widget.ti-goog.ti-custom-stars .ti-star{-webkit-mask-size:contain;mask-size:contain;-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;mask-image:url(https://cdn.trustindex.io/assets/platform/Trustindex/star/s.svg);-webkit-mask-image:url(https://cdn.trustindex.io/assets/platform/Trustindex/star/s.svg)}.ti-widget.ti-goog.ti-custom-stars .ti-star:not(.e):not(.h){background:#f6bb06}.ti-widget.ti-goog.ti-custom-stars .ti-star.h{background:#f6bb06;background:-webkit-linear-gradient(90deg, #f6bb06 50%, #cccccc 50%) !important;background:linear-gradient(90deg, #f6bb06 50%, #cccccc 50%) !important}.ti-widget.ti-goog.ti-custom-stars .ti-star.e{background:#ccc !important}.ti-widget.ti-goog[data-language=\"ar\"] .ti-name,.ti-widget.ti-goog[data-language=\"ar\"] .ti-date,.ti-widget.ti-goog[data-language=\"ar\"] .ti-profile-details .ti-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-review-content,.ti-widget.ti-goog[data-language=\"ar\"] .ti-review-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-read-more,.ti-widget.ti-goog[data-language=\"ar\"] .ti-footer,.ti-widget.ti-goog[data-language=\"ar\"] .ti-rating-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-footer-filter-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-header-write-btn,.ti-widget.ti-goog[data-language=\"ar\"] .ti-widget-header .ti-tab-item[data-source=\"all\"] .ti-item-label,.ti-widget.ti-goog[data-language=\"ar\"] .ti-header-rating-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-rating-name,.ti-widget.ti-goog[data-language=\"ar\"] .ti-header .ti-text,.ti-widget.ti-goog[data-language=\"ar\"] .ti-load-more-reviews-button,.ti-widget.ti-goog[data-language=\"he\"] .ti-name,.ti-widget.ti-goog[data-language=\"he\"] .ti-date,.ti-widget.ti-goog[data-language=\"he\"] .ti-profile-details .ti-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-review-content,.ti-widget.ti-goog[data-language=\"he\"] .ti-review-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-read-more,.ti-widget.ti-goog[data-language=\"he\"] .ti-footer,.ti-widget.ti-goog[data-language=\"he\"] .ti-rating-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-footer-filter-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-header-write-btn,.ti-widget.ti-goog[data-language=\"he\"] .ti-widget-header .ti-tab-item[data-source=\"all\"] .ti-item-label,.ti-widget.ti-goog[data-language=\"he\"] .ti-header-rating-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-rating-name,.ti-widget.ti-goog[data-language=\"he\"] .ti-header .ti-text,.ti-widget.ti-goog[data-language=\"he\"] .ti-load-more-reviews-button,.ti-widget.ti-goog[data-language=\"fa\"] .ti-name,.ti-widget.ti-goog[data-language=\"fa\"] .ti-date,.ti-widget.ti-goog[data-language=\"fa\"] .ti-profile-details .ti-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-review-content,.ti-widget.ti-goog[data-language=\"fa\"] .ti-review-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-read-more,.ti-widget.ti-goog[data-language=\"fa\"] .ti-footer,.ti-widget.ti-goog[data-language=\"fa\"] .ti-rating-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-footer-filter-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-header-write-btn,.ti-widget.ti-goog[data-language=\"fa\"] .ti-widget-header .ti-tab-item[data-source=\"all\"] .ti-item-label,.ti-widget.ti-goog[data-language=\"fa\"] .ti-header-rating-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-rating-name,.ti-widget.ti-goog[data-language=\"fa\"] .ti-header .ti-text,.ti-widget.ti-goog[data-language=\"fa\"] .ti-load-more-reviews-button{direction:rtl}.ti-widget.ti-goog[data-language=\"ar\"] .ti-stars,.ti-widget.ti-goog[data-language=\"ar\"] .ti-footer .ti-row,.ti-widget.ti-goog[data-language=\"he\"] .ti-stars,.ti-widget.ti-goog[data-language=\"he\"] .ti-footer .ti-row,.ti-widget.ti-goog[data-language=\"fa\"] .ti-stars,.ti-widget.ti-goog[data-language=\"fa\"] .ti-footer .ti-row{direction:ltr}.ti-widget.ti-goog ::-webkit-scrollbar{width:4px;border-radius:3px}.ti-widget.ti-goog ::-webkit-scrollbar-track{background:rgba(85, 85, 85, 0.1)}.ti-widget.ti-goog ::-webkit-scrollbar-thumb{background:rgba(85, 85, 85, 0.6)}.ti-widget.ti-goog ::-webkit-scrollbar-thumb:hover{background:#555}.ti-widget.ti-goog.ti-disable-nav .ti-controls{display:none !important}.ti-widget.ti-goog.ti-disable-nav .ti-footer-filter-text{margin:15px 0}.ti-widget.ti-goog.ti-disable-nav .ti-widget-header{margin-left:8px !important;margin-right:8px !important}.ti-widget.ti-goog.ti-disable-nav .ti-reviews-container-wrapper{margin:0 !important}.ti-widget.ti-goog.ti-review-text-mode-scroll .ti-read-more,.ti-widget.ti-goog.ti-review-text-mode-truncated .ti-read-more{display:none !important}.ti-widget.ti-goog.ti-disable-font .ti-widget-container,.ti-widget.ti-goog.ti-disable-font .ti-widget-container *,.ti-widget.ti-goog.ti-disable-font .ti-enable-widget{font-family:inherit !important}.ti-widget.ti-goog.ti-disable-animation .ti-review-item:hover,.ti-widget.ti-goog.ti-disable-animation .ti-header:hover,.ti-widget.ti-goog.ti-disable-animation .ti-footer:hover{-webkit-transform:none !important;-ms-transform:none !important;transform:none !important}.ti-widget.ti-goog.ti-disable-animation .ti-widget-container{margin-top:5px}.ti-widget.ti-goog.ti-text-align-right .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-right .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-right .ti-reviews-container-wrapper .ti-read-more{text-align:right !important}.ti-widget.ti-goog.ti-text-align-center .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-center .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-center .ti-reviews-container-wrapper .ti-read-more{text-align:center !important}.ti-widget.ti-goog.ti-text-align-justify .ti-reviews-container-wrapper .ti-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-justify .ti-reviews-container-wrapper .ti-popup-inner>.ti-stars,.ti-widget.ti-goog.ti-text-align-justify .ti-reviews-container-wrapper .ti-read-more{text-align:justify !important}.ti-widget.ti-goog.ti-content-align-left .ti-review-header .ti-profile-details,.ti-widget.ti-goog.ti-content-align-left .ti-stars,.ti-widget.ti-goog.ti-content-align-left .ti-review-content,.ti-widget.ti-goog.ti-content-align-left .ti-read-more{text-align:left !important}.ti-widget.ti-goog.ti-content-align-right .ti-review-header .ti-profile-details,.ti-widget.ti-goog.ti-content-align-right .ti-stars,.ti-widget.ti-goog.ti-content-align-right .ti-review-content,.ti-widget.ti-goog.ti-content-align-right .ti-read-more{text-align:right !important}.ti-widget.ti-goog.ti-content-align-justify .ti-review-header .ti-profile-details,.ti-widget.ti-goog.ti-content-align-justify .ti-stars,.ti-widget.ti-goog.ti-content-align-justify .ti-review-content,.ti-widget.ti-goog.ti-content-align-justify .ti-read-more{text-align:justify !important}.ti-widget.ti-goog.ti-content-align-right .ti-review-header .ti-profile-img{align-self:end}.ti-widget.ti-goog.ti-content-align-right .ti-review-header:after{right:unset;left:0}.ti-widget.ti-goog.ti-content-align-right:not(.ti-no-profile-img) .ti-review-header:after{left:initial;right:0}.ti-widget.ti-goog.ti-content-align-center .ti-review-header .ti-profile-img{align-self:center}.ti-widget.ti-goog.ti-content-align-center:not(.ti-no-profile-img) .ti-review-header:after{right:inherit;left:calc(50% + 32px - 27px)}.ti-widget.ti-goog.ti-text-align-right .ti-verified-tooltip,.ti-widget.ti-goog.ti-content-align-right .ti-verified-tooltip{left:unset;right:0;margin-left:0;margin-right:25px}.ti-widget.ti-goog.ti-text-align-right .ti-verified-tooltip:before,.ti-widget.ti-goog.ti-content-align-right .ti-verified-tooltip:before{border-width:5px 0 5px 5px;border-color:transparent transparent transparent #6f6f6f;left:unset;right:-5px}.ti-widget.ti-goog.ti-text-align-right:hover .ti-verified-tooltip,.ti-widget.ti-goog.ti-content-align-right:hover .ti-verified-tooltip{margin-left:0;margin-right:20px}.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text strong:not(.ti-rating-large),.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text strong a,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text strong span,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text span strong,.ti-widget.ti-goog.ti-show-rating-text .ti-rating-text span,.ti-widget.ti-goog.ti-show-rating-text .ti-footer,.ti-widget.ti-goog.ti-show-rating-text .ti-footer strong:not(.ti-rating-large),.ti-widget.ti-goog.ti-show-rating-text .ti-footer span,.ti-widget.ti-goog.ti-show-rating-text .ti-footer strong a{font-size:14px !important}.ti-verified-review{display:inline-block;background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified.svg\");background-size:contain;width:15px;height:15px;margin:0 !important;margin-left:7px !important;position:relative;z-index:2}.ti-verified-review:only-child{margin-left:0 !important}.ti-verified-review.ti-color-green{background:url(\"https://cdn.trustindex.io/assets/icon/ti-verified-green.svg\")}.ti-verified-review .ti-verified-tooltip{color:#fff !important;background-color:#555555 !important;text-align:left;padding:0 10px;border-radius:4px;font-size:12px !important;line-height:22px !important;font-weight:500;display:inline-block;position:absolute;left:0;top:-4px;white-space:nowrap;z-index:1;opacity:0;margin-left:35px;visibility:hidden;transition:opacity 0.3s ease-in-out, margin 0.3s ease-in-out}.ti-verified-review .ti-verified-tooltip:before{width:0;height:0;border-style:solid;border-width:5px 5px 5px 0;border-color:transparent #555555 transparent transparent;content:\"\" !important;position:absolute;left:-5px;top:50%;margin-top:-5px}.ti-verified-review:hover .ti-verified-tooltip{opacity:1;margin-left:23px;visibility:visible}.ti-verified-review .ti-verified-tooltip{left:unset;right:0;margin-left:0;margin-right:25px}.ti-verified-review .ti-verified-tooltip:before{border-width:5px 0 5px 5px;border-color:transparent transparent transparent #6f6f6f;left:unset;right:-5px}.ti-verified-review:hover .ti-verified-tooltip{margin-left:0;margin-right:20px}.ti-verified-review.ti-verified-platform .ti-verified-tooltip{width:175px;max-width:250px;white-space:normal;line-height:1.4 !important;padding:4px 8px;padding-bottom:6px}.ti-verified-review.ti-verified-platform .ti-verified-tooltip:before{top:12px}.ti-recommendation+.ti-verified-review{top:2px}.ti-ten-rating-score+.ti-verified-review{top:-1px}.ti-widget .source-Trustpilot.ti-tab-item:before,.ti-widget .source-Trustpilot.ti-write-btn-dropdown-item:before,.ti-widget .source-Trustpilot .ti-review-header:after,.ti-widget .source-Trustpilot .ti-inner:after,.ti-widget .source-Trustpilot .ti-review-content:after,.ti-widget .source-Trustpilot .ti-platform-icon:after,.ti-widget .source-Trustpilot .ti-icon,.ti-widget .source-Trustpilot .ti-platform,.ti-widget .source-Trustpilot .ti-inner .col-left,.ti-widget .source-Trustpilot .ti-large-logo,.ti-widget .source-Trustpilot .ti-enable-widget:before,.ti-lightbox .source-Trustpilot.ti-tab-item:before,.ti-lightbox .source-Trustpilot.ti-write-btn-dropdown-item:before,.ti-lightbox .source-Trustpilot .ti-review-header:after,.ti-lightbox .source-Trustpilot .ti-inner:after,.ti-lightbox .source-Trustpilot .ti-review-content:after,.ti-lightbox .source-Trustpilot .ti-platform-icon:after,.ti-lightbox .source-Trustpilot .ti-icon,.ti-lightbox .source-Trustpilot .ti-platform,.ti-lightbox .source-Trustpilot .ti-inner .col-left,.ti-lightbox .source-Trustpilot .ti-large-logo,.ti-lightbox .source-Trustpilot .ti-enable-widget:before{display:none !important}.ti-widget .source-Trustpilot .ti-enable-widget,.ti-lightbox .source-Trustpilot .ti-enable-widget{padding-left:8px !important}.ti-widget .source-Trustpilot .ti-enable-widget:before,.ti-lightbox .source-Trustpilot .ti-enable-widget:before{display:none !important}.ti-widget .source-Trustpilot.disable-widget,.ti-lightbox .source-Trustpilot.disable-widget{top:4px !important;right:4px !important}.ti-widget.ti-goog{overflow:visible !important}.ti-widget.ti-goog .ti-review-item>.ti-inner,.ti-widget.ti-goog .ti-load-more-reviews-container .ti-load-more-reviews-button{border-top-width:0px !important;border-bottom-width:0px !important;border-left-width:0px !important;border-right-width:0px !important;background-color:#f4f4f4 !important;backdrop-filter:blur(0px)}.ti-image-loading,.ti-review-item .ti-review-image{background-image:url(\"https://cdn.trustindex.io/assets/img/loading_dots.gif\");background-repeat:no-repeat;background-position:50% 50%;background-size:50px}.ti-image-loading.ti-image-loading img,.ti-review-item .ti-review-image.ti-image-loading img{opacity:0 !important}.ti-widget-lightbox{text-align:left !important;z-index:9999999;height:100%;position:fixed;left:0;right:0;bottom:0;top:0;max-width:100%;width:100%;transition:all 300ms ease-out;background-color:rgba(0, 0, 0, 0.6);display:flex;color:#333;align-items:center !important;justify-content:center;flex-wrap:wrap;user-select:none;opacity:0}.ti-widget-lightbox img{padding:0 !important;margin:0 !important;min-width:initial !important;max-width:initial !important}.ti-widget-lightbox .ti-widget-lightbox-inner{max-height:calc(100vh - 160px);height:100%;max-width:1200px;width:95%}@media (max-width:1160px){.ti-widget-lightbox .ti-widget-lightbox-inner{max-height:100%;height:100%;width:100%}}.ti-widget-lightbox.ti-widget-lightbox-appeared{opacity:1}.ti-widget-lightbox .ti-widget-lightbox-close{position:absolute;top:15px;right:15px;width:40px;height:40px;z-index:1;border-radius:50px;cursor:pointer;display:flex;justify-content:center;align-items:center}@media (max-width:1160px) and (orientation:landscape){.ti-widget-lightbox .ti-widget-lightbox-close{right:315px}}@media (max-width:1160px){.ti-widget-lightbox .ti-widget-lightbox-close{background-color:rgba(0, 0, 0, 0.5)}}.ti-widget-lightbox .ti-widget-lightbox-close:active,.ti-widget-lightbox .ti-widget-lightbox-close:hover{background-color:rgba(255, 255, 255, 0.2)}.ti-widget-lightbox .ti-widget-lightbox-close:before,.ti-widget-lightbox .ti-widget-lightbox-close:after{width:60%;height:3px;background-color:#fff;position:absolute;content:\"\";transform:rotate(45deg)}.ti-widget-lightbox .ti-widget-lightbox-close:after{transform:rotate(-45deg)}.ti-widget-lightbox .ti-widget-card{overflow:hidden;border-radius:4px;height:100%;border:none;position:relative}@media (max-width:1160px){.ti-widget-lightbox .ti-widget-card{border-radius:0}}.ti-widget-lightbox .ti-card-body{background-color:#fff;position:relative;height:400px;flex-direction:row;border-radius:4px;display:flex;flex-direction:row;justify-content:flex-start;color:#000000;height:100%}@media (max-width:1160px){.ti-widget-lightbox .ti-card-body{border-radius:0}}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox .ti-card-body{flex-direction:column;width:100%;height:100%;border-radius:0}}.ti-widget-lightbox .ti-card-body .ti-card-media{flex:1 1 auto;align-items:center;display:flex;height:100%;justify-content:center;width:100%;position:relative;background-color:#000000;overflow:hidden;padding-bottom:0px}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox .ti-card-body .ti-card-media{flex:0 0 60%;width:100%}}.ti-widget-lightbox .ti-card-body .ti-card-media img{width:100% !important;height:100% !important;max-width:100% !important;max-height:100% !important;object-fit:contain;position:absolute;display:block;border-radius:inherit;opacity:1;transition:opacity 300ms ease-in-out}.ti-widget-lightbox .ti-card-body .ti-card-media .ti-nav-arrow{max-width:100%;margin-left:0px;left:inherit;top:50%;margin-top:-10px;visibility:visible;opacity:1}.ti-widget-lightbox .ti-card-body .ti-review-content{flex:0 0 auto;height:100%;width:300px;overflow:hidden;padding:0px;display:flex;flex-direction:column;font-size:15px;color:#000000}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header{position:relative;z-index:unset;padding:20px;display:flex;align-items:center;color:#000}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-platform-icon{width:20px !important;height:20px !important;position:absolute;right:16px;top:16px}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-profile-img{margin:0;margin-right:10px}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-profile-img img{width:40px !important;height:40px !important;display:block;border-radius:30px;object-fit:cover;object-position:top}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-profile-img .ti-profile-img-sprite{display:inline-block;float:left;background:white;background-repeat:no-repeat;width:40px;height:40px;border-radius:30px}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-profile-details{-webkit-box-flex:1;-ms-flex:1;flex:1;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;text-align:left;margin:0;display:flex;flex-direction:column;justify-content:center}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-profile-details .ti-name{font-weight:bold;font-size:inherit;overflow:hidden;padding-right:25px;white-space:nowrap;text-overflow:ellipsis;color:#000000;margin-bottom:2px}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-header .ti-profile-details .ti-date{color:#000000;opacity:0.5;font-size:12px}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-stars{margin:0 20px;white-space:nowrap;display:block;line-height:0}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-stars .ti-star{width:17px !important;height:17px !important;display:inline-block;margin-right:1px !important;background-size:contain;background-repeat:no-repeat;vertical-align:unset}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-stars .ti-star:before,.ti-widget-lightbox .ti-card-body .ti-review-content .ti-stars .ti-star:after{content:none !important}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-stars .ti-ten-rating-score{display:inline-block;font-weight:bold;font-size:15px;color:#000000;margin-left:7px;height:100%;line-height:17px;vertical-align:top}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-stars .ti-verified-review .ti-verified-tooltip{max-width:150px !important}.ti-widget-lightbox .ti-card-body .ti-review-content .ti-review-text{flex:0 1 100%;font-size:inherit;padding:20px;padding-top:0;margin-top:10px;display:block;overflow-x:hidden;overflow:auto;color:#000000}@media (max-width:767px) and (orientation:portrait){.ti-widget-lightbox .ti-card-body .ti-review-content{flex:0 0 40%;width:100%}}.ti-widget-lightbox .ti-nav-arrow{position:absolute;height:0px;top:50%;z-index:2;display:flex;flex-wrap:wrap;flex:0 0 100%;width:100%;transition:all 0.2s ease-in-out}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next{display:flex;align-items:center;border-radius:50%;background-color:rgba(255, 255, 255, 0.7);box-shadow:0px 0px 10px 0px rgba(0, 0, 0, 0.1);width:40px;height:40px;cursor:pointer}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:hover,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:hover{background-color:white}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:active,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:active{transform:scale(0.95);background-color:white}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:before,.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:before{width:25%;height:25%;display:block;content:\"\";transform-origin:center center;margin:auto;position:relative;border-top:solid 3px #000;border-left:solid 3px #000;box-sizing:content-box}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next{margin-left:auto;margin-right:15px}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-next:before{transform:rotate(135deg);left:-5%}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev{margin-left:15px}.ti-widget-lightbox .ti-nav-arrow .ti-arrow-prev:before{transform:rotate(-45deg);left:5%}.ti-widget.ti-goog .ti-reviews-container-wrapper{padding-top:52px;padding-bottom:8px}.ti-widget.ti-goog.ti-no-profile-img .ti-reviews-container-wrapper{padding-top:8px}.ti-widget.ti-goog .ti-review-header{flex-wrap:wrap;flex-direction:column}.ti-widget.ti-goog .ti-review-header .ti-profile-img{margin:0 !important;margin-top:-52px !important;margin-bottom:15px !important;align-self:center}.ti-widget.ti-goog .ti-review-header .ti-profile-img img{width:64px !important;height:64px !important;border-radius:32px}.ti-widget.ti-goog .ti-review-header .ti-profile-details{text-align:center;width:100%}.ti-widget.ti-goog .ti-review-header .ti-profile-details .ti-name{padding-right:0px}.ti-widget.ti-goog .ti-profile-img .ti-profile-img-sprite{width:64px !important;height:64px !important;border-radius:32px}.ti-widget.ti-goog:not(.ti-no-profile-img) .ti-review-header .ti-platform-icon{top:-15px;right:inherit;left:calc(50% + 32px - 27px);background-color:#ffffff;border-radius:50%;overflow:hidden;width:26px !important;height:26px !important;border:solid 2px #ffffff}.ti-widget.ti-goog .ti-stars{margin-bottom:10px !important;text-align:center !important}.ti-widget.ti-goog .ti-stars .ti-star{width:18px !important;height:18px !important}.ti-widget.ti-goog .ti-stars .ti-verified-review{top:-1px;position:relative}.ti-widget.ti-goog .ti-review-content,.ti-widget.ti-goog .ti-read-more{text-align:center}.ti-widget.ti-goog .ti-review-item .ti-review-image-container{justify-content:center}.ti-widget.ti-goog .ti-footer-filter-text{text-align:center}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-header:after{display:none}.ti-widget.ti-goog .ti-ai-summary-item .ti-review-content{margin-top:20.5px}.ti-widget.ti-goog .ti-controls{display:none;margin-top:-12px;width:100%;position:absolute;height:0px;z-index:1;top:50%}.ti-widget.ti-goog .ti-controls .ti-next,.ti-widget.ti-goog .ti-controls .ti-prev{position:absolute;display:inline-block;width:20px;height:30px;padding-top:20px;padding-bottom:20px;display:block;opacity:1;-webkit-transition:all 200ms ease-out;-moz-transition:all 200ms ease-out;-o-transition:all 200ms ease-out;transition:all 200ms ease-out}.ti-widget.ti-goog .ti-controls .ti-next:hover,.ti-widget.ti-goog .ti-controls .ti-prev:hover{cursor:pointer;-webkit-transform:scale(1.2);-ms-transform:scale(1.2);transform:scale(1.2)}.ti-widget.ti-goog .ti-controls .ti-next:before,.ti-widget.ti-goog .ti-controls .ti-prev:before{content:\"\";background:#cccccc;width:17px;height:3px;display:block;-webkit-transform:rotate(45deg);-ms-transform:rotate(45deg);transform:rotate(45deg);border-radius:2px;position:absolute}.ti-widget.ti-goog .ti-controls .ti-next:after,.ti-widget.ti-goog .ti-controls .ti-prev:after{content:\"\";background:#cccccc;width:17px;height:3px;display:block;-webkit-transform:rotate(-45deg);-ms-transform:rotate(-45deg);transform:rotate(-45deg);border-radius:2px;position:absolute}.ti-widget.ti-goog .ti-controls .ti-next{right:2px}.ti-widget.ti-goog .ti-controls .ti-next:after{top:18px;right:0px}.ti-widget.ti-goog .ti-controls .ti-next:before{top:8px;right:0px}.ti-widget.ti-goog .ti-controls .ti-prev{left:2px}.ti-widget.ti-goog .ti-controls .ti-prev:after{top:8px;left:0px}.ti-widget.ti-goog .ti-controls .ti-prev:before{top:18px;left:0px}@media (min-width:1024px){.ti-widget.ti-goog .ti-controls{display:block}}@media (max-width:479px){.ti-widget.ti-goog .ti-controls{top:calc(50% - 19px)}}.ti-widget.ti-goog .ti-controls-line{display:none;margin:20px auto;width:150px;height:3px;border-radius:3px;background:rgba(204, 204, 204, 0.35);position:relative;overflow:hidden}.ti-widget.ti-goog .ti-controls-line .dot{position:absolute;left:0;top:0;display:inline-block;width:25px;padding-left:4px;padding-right:4px;height:100%;border-radius:3px;background:#cccccc;transition:width 0.2s, left 0.2s}@media (max-width:479px){.ti-widget.ti-goog .ti-controls-line{display:block !important}}.ti-widget.ti-goog .ti-reviews-container .ti-controls{top:calc(50% + 16px)}@media (max-width:479px){.ti-widget.ti-goog .ti-reviews-container .ti-controls{top:calc(50% - 19px + 20px)}}", "off");
INSERT INTO `wor6069_options` VALUES("4251", "trustindex-google-review-content", "<div class=\"ti-widget\" data-layout-id=\"36\" data-layout-category=\"slider\" data-set-id=\"\" data-pid=\"\" data-language=\"fr\" data-review-target-width=\"300\" data-css-version=\"2\" data-review-text-mode=\"readmore\" data-reply-by-locale=\"Réponse du propriétaire\" data-pager-autoplay-timeout=\"6\" > <div class=\"ti-widget-container ti-col-3\"> <div class=\"ti-reviews-container\"> <div class=\"ti-controls\"> <div class=\"ti-next\" aria-label=\"Avis suivante\" role=\"button\"></div> <div class=\"ti-prev\" aria-label=\"Avis précédent\" role=\"button\"></div> </div> <div class=\"ti-reviews-container-wrapper\"> <!-- R-LIST --> <div class=\"ti-review-item source-%platform% ti-image-layout-thumbnail\" data-id=\"cfcd208495d565ef66e7dff9f98764da\" > <div class=\"ti-inner\"> <div class=\"ti-review-header\"> <img class=\"ti-platform-icon\" src=\"https://cdn.trustindex.io/assets/platform/%platform%/icon.svg\" alt=\"%platform%\" width=\"20\" height=\"20\" loading=\"lazy\" /> <div class=\"ti-profile-img\"> <img src=\"%reviewer_photo%\" srcset=\"%reviewer_photo% 2x\" alt=\"%reviewer_name%\" loading=\"lazy\" /> </div> <div class=\"ti-profile-details\"> <div class=\"ti-name\"> %reviewer_name% </div> <div class=\"ti-date\">%created_at%</div> </div> </div> <span class=\"ti-stars\"><!-- STARS-CONTENT --></span> <div class=\"ti-review-text-container ti-review-content\"><!-- R-CONTENT -->%text%<!-- R-CONTENT --></div> <span class=\"ti-read-more\" data-container=\".ti-review-content\" data-collapse-text=\"Cacher\" data-open-text=\"Lire la suite\" ></span> </div> </div> <!-- R-LIST --> </div> <div class=\"ti-controls-line\"> <div class=\"dot\"></div> </div> </div> <div class=\"ti-footer\"> <div class=\"ti-rating-text\"> <span class=\"nowrap\">Évaluation <strong>PLATFORM_NAME</strong> : </span><span class=\"nowrap\"><strong>RATING_SCORE</strong> sur RATING_SCALE, </span><span class=\"nowrap\">Basée sur <strong>RATING_NUMBER avis</strong></span><!-- FOOTER FILTER TEXT --> </div> </div> <div class=\"ti-footer-filter-text\"><!-- FOOTER FILTER TEXT --></div> <!-- VERIFIED BY TRUSTINDEX START <div class=\"ti-verified-by ti-verified-by-row\" data-style=\"1\"> <div class=\"ti-inner\"> Certifié par: Trustindex <span class=\"ti-info-icon\"></span> <div class=\"ti-disclaimer\">Le badge vérifié de Trustindex est le symbole universel de confiance. Seules les meilleures entreprises peuvent obtenir le badge vérifié, avec une note supérieure à 4.5, basée sur les avis des clients au cours des derniers 12 mois. <a href=\"https://www.trustindex.io/ti-redirect.php?a=sys&c=verified-badge&url=/the-trustindex-verified-badge\" target=\"_blank\">En savoir plus</a></div> </div> </div> VERIFIED BY TRUSTINDEX END --> </div> </div> ", "off");
INSERT INTO `wor6069_options` VALUES("4253", "trustindex-google-verified-icon", "1", "off");
INSERT INTO `wor6069_options` VALUES("4254", "trustindex-google-enable-animation", "1", "off");
INSERT INTO `wor6069_options` VALUES("4255", "trustindex-google-show-arrows", "1", "off");
INSERT INTO `wor6069_options` VALUES("4256", "trustindex-google-show-header-button", "1", "off");
INSERT INTO `wor6069_options` VALUES("4257", "trustindex-google-reviews-load-more", "1", "off");
INSERT INTO `wor6069_options` VALUES("4258", "trustindex-google-show-reviewers-photo", "1", "off");
INSERT INTO `wor6069_options` VALUES("4259", "trustindex-google-no-rating-text", "1", "off");
INSERT INTO `wor6069_options` VALUES("4260", "trustindex-google-disable-font", "0", "off");
INSERT INTO `wor6069_options` VALUES("4261", "trustindex-google-show-logos", "1", "off");
INSERT INTO `wor6069_options` VALUES("4262", "trustindex-google-show-stars", "1", "off");
INSERT INTO `wor6069_options` VALUES("4263", "trustindex-google-footer-filter-text", "0", "off");
INSERT INTO `wor6069_options` VALUES("4264", "trustindex-google-floating-desktop-open", "1", "off");
INSERT INTO `wor6069_options` VALUES("4265", "trustindex-google-floating-mobile-open", "0", "off");
INSERT INTO `wor6069_options` VALUES("4266", "trustindex-google-show-review-replies", "0", "off");
INSERT INTO `wor6069_options` VALUES("4267", "trustindex-google-filter", "a:2:{s:5:\"stars\";a:5:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;}s:12:\"only-ratings\";b:1;}", "off");
INSERT INTO `wor6069_options` VALUES("4269", "trustindex-google-widget-setted-up", "1", "off");
INSERT INTO `wor6069_options` VALUES("9231", "_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271", "1736607111", "off");
INSERT INTO `wor6069_options` VALUES("9232", "_site_transient_php_check_38979a08dcd71638878b7b4419751271", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wor6069_options` VALUES("12671", "_site_transient_timeout_browser_0845b309c7b9b957afd9ecf775a4c21f", "1736758837", "off");
INSERT INTO `wor6069_options` VALUES("12672", "_site_transient_browser_0845b309c7b9b957afd9ecf775a4c21f", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"131.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wor6069_options` VALUES("12681", "_transient_timeout_feed_mod_bc9fd7f8eaf5e82b6773ce761d04a9c6", "1736491416", "off");
INSERT INTO `wor6069_options` VALUES("12682", "_transient_feed_mod_bc9fd7f8eaf5e82b6773ce761d04a9c6", "1736448216", "off");
INSERT INTO `wor6069_options` VALUES("12693", "_transient_timeout_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1736455118", "off");
INSERT INTO `wor6069_options` VALUES("12694", "_transient_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1736411918", "off");
INSERT INTO `wor6069_options` VALUES("12826", "_transient_timeout_avada-builder-demo-theme-options", "1736777825", "off");
INSERT INTO `wor6069_options` VALUES("15057", "_transient_timeout_wpseo-statistics-totals", "1736498318", "off");
INSERT INTO `wor6069_options` VALUES("15058", "_transient_wpseo-statistics-totals", "a:2:{i:1;a:2:{s:6:\"scores\";a:1:{i:0;a:4:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"label\";s:45:\"Articles <strong>sans</strong> requête cible\";s:5:\"count\";i:7;s:4:\"link\";s:110:\"https://donnadieu.agencemiyou.com/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=na\";}}s:8:\"division\";a:5:{s:3:\"bad\";i:0;s:2:\"ok\";i:0;s:4:\"good\";i:0;s:2:\"na\";i:1;s:7:\"noindex\";i:0;}}i:2;a:2:{s:6:\"scores\";a:1:{i:0;a:4:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"label\";s:45:\"Articles <strong>sans</strong> requête cible\";s:5:\"count\";i:7;s:4:\"link\";s:110:\"https://donnadieu.agencemiyou.com/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=na\";}}s:8:\"division\";a:5:{s:3:\"bad\";i:0;s:2:\"ok\";i:0;s:4:\"good\";i:0;s:2:\"na\";i:1;s:7:\"noindex\";i:0;}}}", "off");
INSERT INTO `wor6069_options` VALUES("15185", "_transient_timeout_feed_bc9fd7f8eaf5e82b6773ce761d04a9c6", "1736491416", "off");
INSERT INTO `wor6069_options` VALUES("15186", "_transient_feed_bc9fd7f8eaf5e82b6773ce761d04a9c6", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Avada Website Builder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"https://avada.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"For WordPress & WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jan 2025 10:20:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=6.6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"How to Use the Avada Alert Element\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://avada.com/blog/how-to-use-the-avada-alert-element/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://avada.com/blog/how-to-use-the-avada-alert-element/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Jan 2025 10:03:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:15:\"Design Elements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:15:\"Tutorial Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"The Avada Alert Element is a powerful and versatile tool designed to add essential notices or alerts to your WordPress website, providing users with crucial information. Five types of Avada Alerts are available: four preset types and one custom option. Choosing a predefined style or customizing your own with unique colors and icons is easy. ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:23016:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-1 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-0 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-1\"><p>The <a href=\"https://avada.com/element/alert/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Alert Element</a> is a powerful and versatile tool designed to add essential notices or alerts to your <a href=\"https://wordpress.org/\" target=\"_blank\" rel=\"noopener noreferrer\">WordPress</a> website, providing users with crucial information. Five types of <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> Alerts are available: four preset types and one custom option. Choosing a predefined style or customizing your own with unique colors and icons is easy.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-1 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--1\" data-awb-toc-id=\"1\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-2 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">How is the Avada Alert Element Useful?</h2></div><div class=\"fusion-text fusion-text-2\"><p>The <a href=\"https://avada.com/documentation/alert-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Alert Element</a> is incredibly useful for enhancing website communication by providing a clear and prominent way to highlight important information such as general announcements, permanent or temporary announcements, updates, or warnings. By offering customizable options, such as predefined alert types and the ability to create unique styles with personalized colors and icons, the element ensures that alerts fit seamlessly into the website&#8217;s design.</p>\n</div><div class=\"fusion-alert alert general alert-info fusion-alert-left awb-alert-inherit-link-color\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"alert-icon\"><i class=\"awb-icon-info-circle\" aria-hidden=\"true\"></i></span><span class=\"fusion-alert-content\">This is a default Avada General Alert Example.</span></div></div><div class=\"fusion-alert alert error alert-danger fusion-alert-left awb-alert-inherit-link-color\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"alert-icon\"><i class=\"awb-icon-exclamation-triangle\" aria-hidden=\"true\"></i></span><span class=\"fusion-alert-content\">This is a default Avada Error Alert Example.</span></div></div><div class=\"fusion-alert alert success alert-success fusion-alert-left awb-alert-inherit-link-color\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"alert-icon\"><i class=\"awb-icon-check-circle\" aria-hidden=\"true\"></i></span><span class=\"fusion-alert-content\">This is a default Avada Success Alert Example.</span></div></div><div class=\"fusion-alert alert notice alert-warning fusion-alert-left awb-alert-inherit-link-color\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"alert-icon\"><i class=\"awb-icon-cog\" aria-hidden=\"true\"></i></span><span class=\"fusion-alert-content\">This is a default Avada Notice Alert Example.</span></div></div><div class=\"fusion-alert alert custom alert-custom fusion-alert-center awb-alert-inherit-link-color\" style=\"--awb-background-color:#bdcc9d;--awb-accent-color:#355600;--awb-border-size:1px;--awb-border-top-left-radius:5px;--awb-border-top-right-radius:5px;--awb-border-bottom-left-radius:5px;--awb-border-bottom-right-radius:5px;\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"fusion-alert-content\">This is a default Avada Custom Alert Example.</span></div></div><div class=\"fusion-text fusion-text-3\"><p>Making alerts dismissible adds interactivity. It allows users to manage the visibility of the alerts once they&#8217;ve been acknowledged, enhancing the overall user experience without overwhelming them. The site&#8217;s responsive design ensures that the alerts are appropriately displayed across different devices, making them accessible whether visitors are using a desktop, tablet, or mobile device.</p>\n</div><div class=\"fusion-alert alert custom alert-custom fusion-alert-left awb-alert-inherit-link-color alert-dismissable awb-alert-close-floated\" style=\"--awb-background-color:#ebfaff;--awb-accent-color:#005272;--awb-border-size:0px;--awb-border-top-left-radius:5px;--awb-border-top-right-radius:5px;--awb-border-bottom-left-radius:5px;--awb-border-bottom-right-radius:5px;--awb-padding-right:20px;\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"fusion-alert-content\">This is a dismissable Avada Alert Example.</span></div><button style=\"color:#005272;border-color:#005272;\" type=\"button\" class=\"close toggle-alert\" data-dismiss=\"alert\" aria-label=\"Close\">&times;</button></div><div class=\"fusion-text fusion-text-4\"><p>Additionally, the <a href=\"https://avada.com/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> Alert Element provides flexibility in positioning, styling, and animation. By using padding, margins, and alignment options, alerts can be fine-tuned to look aesthetically pleasing while maintaining high functionality. The global settings feature allows site administrators to set default options for alerts, ensuring uniformity across the site while saving time by reducing the need to configure individual alerts manually.</p>\n</div><div class=\"fusion-alert alert custom alert-custom fusion-alert-left awb-alert-inherit-link-color fusion-animated\" style=\"--awb-background-color:var(--awb-custom_color_1);--awb-accent-color:#996b00;--awb-border-size:0px;--awb-border-top-left-radius:50px;--awb-border-top-right-radius:0px;--awb-border-bottom-left-radius:0px;--awb-border-bottom-right-radius:100px;\" role=\"alert\" data-animationType=\"bounceIn\" data-animationDuration=\"0.7\" data-animationOffset=\"top-into-view\"><div class=\"fusion-alert-content-wrapper\"><span class=\"fusion-alert-content\">This is a custom-styled Alert Element with an animation effect.</span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-3 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Adding the Alert Element</h2></div><div class=\"fusion-text fusion-text-5\"><p>For our example, we use the <a href=\"https://avada.website/dispensary/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Dispensary</a> prebuilt website to demonstrate how the Alert Element works. To add an Alert to your website layout, select the Alert Element from the <a href=\"https://avada.com/feature/live-visual-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Live Builder</a>. Click the plus symbol in the column where you want to add the alert.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-1 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-1\" style=\"border:1px solid var(--awb-color2);\"><a href=\"https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[9c8f2c146f847c56237]\" data-title=\"Add Avada Alert Element\" title=\"Add Avada Alert Element\"><img fetchpriority=\"high\" decoding=\"async\" width=\"3000\" height=\"500\" alt=\"Add Avada Alert Element\" src=\"https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar.png\" class=\"img-responsive wp-image-894975\" srcset=\"https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar-200x33.png 200w, https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar-400x67.png 400w, https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar-600x100.png 600w, https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar-800x133.png 800w, https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar-1200x200.png 1200w, https://avada.com/wp-content/uploads/2024/09/avada-add-alert-element-post-le-toolbar.png 3000w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 3000px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-6\"><p>Once added, the default alert type is an error alert. You can modify its appearance by adjusting margins, like adding a 50px top margin to separate the alert from other Elements.</p>\n</div><div class=\"fusion-video fusion-youtube\" style=\"--awb-max-width:1280px;--awb-max-height:720px;--awb-align-self:center;--awb-width:100%;\"><div class=\"video-shortcode\"><priv-fac-lite-youtube class=\"fusion-hidden\" data-privacy-type=\"youtube\" videoid=\"541eofrEOZ8\" class=\"landscape\" params=\"wmode=transparent&autoplay=1&enablejsapi=1\" title=\"YouTube video player 1\" width=\"1280\" height=\"720\" data-thumbnail-size=\"auto\"></priv-fac-lite-youtube><div class=\"fusion-privacy-placeholder\" style=\"width:1280px; height:720px;\" data-privacy-type=\"youtube\"><div class=\"fusion-privacy-placeholder-content\"><div class=\"fusion-privacy-label\">For privacy reasons YouTube needs your permission to be loaded.</div><button data-privacy-type=\"youtube\" class=\"fusion-button button-default fusion-button-default-size button fusion-privacy-consent\">I Accept</button></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-7\"><p>The Alert Element provides a range of customization options. You can start by selecting one of the three other preset alert types. As you switch between them, you&#8217;ll notice changes in color and icon to match the alert&#8217;s purpose.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-4 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Standard Options for All Alert Types</h2></div><div class=\"fusion-text fusion-text-8\"><p>There are several options common to all types of Avada Alert Elements:</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-5 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight custom-textcolor highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color8);--awb-text-color:var(--awb-color1);\">General Tab</span></h3></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:5px;width:100%;\"></div><div class=\"fusion-title title fusion-title-6 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Alert Type</span></h3></div><div class=\"fusion-text fusion-text-9\"><p>Select the type of alert message. The choices are <strong>General</strong>, <strong>Error</strong>, <strong>Success</strong>, <strong>Notice</strong>, and <strong>Custom</strong>.</p>\n</div><div class=\"fusion-title title fusion-title-7 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Content Alignment</span></h3></div><div class=\"fusion-text fusion-text-10\"><p>The Alert content is centered by default, but you can align it to the left or right if needed. Regardless of the alignment, the Alert will always fill the <a href=\"https://avada.com/element/column/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> it&#8217;s placed in.</p>\n</div><div class=\"fusion-title title fusion-title-8 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Padding</span></h3></div><div class=\"fusion-text fusion-text-11\"><p>You can adjust the padding to control the alert&#8217;s internal spacing in pixels or percentages.</p>\n</div><div class=\"fusion-title title fusion-title-9 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Margins</span></h3></div><div class=\"fusion-text fusion-text-12\"><p>You can adjust the margins to control the alert&#8217;s positioning in pixels or percentages.</p>\n</div><div class=\"fusion-title title fusion-title-10 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Text Transform</span></h3></div><div class=\"fusion-text fusion-text-13\"><p>The text-transform option allows you to change the style of the text, such as setting it to standard, uppercase, or lowercase.</p>\n</div><div class=\"fusion-title title fusion-title-11 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Link Color Inheritance</span></h3></div><div class=\"fusion-text fusion-text-14\"><p>If your alert contains links, you can choose whether the links inherit the alert box&#8217;s text color or follow the default link colors set for your site.</p>\n</div><div class=\"fusion-title title fusion-title-12 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Dismiss Button</span></h3></div><div class=\"fusion-text fusion-text-15\"><p>Alerts can be made dismissible by adding a dismiss button. This button can either be boxed, floated within the text, or you can choose to have no button, making the alert permanent.</p>\n</div><div class=\"fusion-title title fusion-title-13 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Box Shadow</span></h3></div><div class=\"fusion-text fusion-text-16\"><p>The box shadow option adds a minimal shadow effect to the Alert Element. </p>\n</div><div class=\"fusion-title title fusion-title-14 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Alert Content</span></h3></div><div class=\"fusion-text fusion-text-17\"><p>The Alert content itself is easily editable, either directly on the screen or through the visual editor. You can even add other elements, such as small buttons, though standard text is typically the primary content.</p>\n</div><div class=\"fusion-title title fusion-title-15 fusion-sep-none fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Column Visibility</span></h4></div><div class=\"fusion-text fusion-text-18\"><p>Set visibility for different screen sizes and add CSS classes or IDs for further customization.</p>\n</div><div class=\"fusion-title title fusion-title-16 fusion-sep-none fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">CSS Class</span></h4></div><div class=\"fusion-text fusion-text-19\"><p>Add a class to the wrapping HTML element.</p>\n</div><div class=\"fusion-title title fusion-title-17 fusion-sep-none fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">CSS ID</span></h4></div><div class=\"fusion-text fusion-text-20\"><p>Add an ID to the wrapping HTML element.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-18 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight custom-textcolor highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color8);--awb-text-color:var(--awb-color1);\">Extras Tab</span></h3></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:5px;width:100%;\"></div><div class=\"fusion-title title fusion-title-19 fusion-sep-none fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-color4);\">Animation Type</span></h4></div><div class=\"fusion-text fusion-text-21\"><p>Select the type of animation to use on the Column Element. (None/Bounce/Fade/Flash/Rubberband/Shake/Slide/Zoom/Flip Vertically/Flip Horizontally/Light Speed/Reveal With Color)</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-20 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Summary</h2></div><div class=\"fusion-text fusion-text-22\"><p>The Avada Alert Element is an excellent tool for displaying important messages to users, mainly temporary notifications. With its wide range of customization options, you can easily match alerts to your site&#8217;s design and tailor them to your audience&#8217;s needs.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://avada.com/blog/how-to-use-the-avada-alert-element/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Avada Factory: Deconstructing a Prebuilt Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://avada.com/blog/avada-factory-deconstructing-a-prebuilt-website/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://avada.com/blog/avada-factory-deconstructing-a-prebuilt-website/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Dec 2024 17:47:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:17:\"Prebuilt Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"Branding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:318:\"Say hello to Avada Factory. This Avada prebuilt website is ideal for beginners, marketers, professionals, and anyone in between. Avada Factory can be imported at the click of a button and is highly flexible. Every aspect of the prebuilt website is easily customizable, and it can be adapted and branded to suit any ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"schanteldwl\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:139531:\"<p><div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-2 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-1 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:0px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-text fusion-text-23\"><p>Say hello to <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a>. This <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> prebuilt website is ideal for beginners, marketers, professionals, and anyone in between. Avada Factory can be imported at the click of a button and is highly flexible. Every aspect of the prebuilt website is easily customizable, and it can be adapted and branded to suit any business model or venture using the Avada Website Builder.</p>\n<p>In this article, we will explore the header, footer, and homepage layouts that make up the overall website structure to explore how the <a href=\"https://avada.com/features/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Website Builder</a> is used to create successful websites. The <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> article is a part of a deconstruction series and is the follow-on article that explores the <a href=\"https://avada.com/blog/avada-campaign-deconstructing-a-prebuilt-website/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Campaign</a> prebuilt website. It is important to highlight that <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> gives you total design freedom to create unique layouts for your website that work, with the only limit being your imagination.</p>\n</div><div class=\"fusion-builder-row fusion-builder-row-inner fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"width:104% !important;max-width:104% !important;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column_inner fusion-builder-nested-column-0 fusion_builder_column_inner_1_2 1_2 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:50%;--awb-margin-top-large:20px;--awb-spacing-right-large:3.84%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:3.84%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div style=\"text-align:center;\"><a class=\"fusion-button button-flat button-xlarge button-custom fusion-button-default button-1 fusion-button-span-yes fusion-button-default-type\" style=\"--button_accent_color:var(--awb-color1);--button_accent_hover_color:var(--awb-color1);--button_border_hover_color:var(--awb-color1);--button_gradient_top_color:var(--awb-color8);--button_gradient_bottom_color:var(--awb-color8);--button_gradient_top_color_hover:hsla(var(--awb-color8-h),var(--awb-color8-s),calc(var(--awb-color8-l) - 16%),var(--awb-color8-a));--button_gradient_bottom_color_hover:hsla(var(--awb-color8-h),var(--awb-color8-s),calc(var(--awb-color8-l) - 16%),var(--awb-color8-a));\" target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://avada.website/factory/\"><span class=\"fusion-button-text\">View Live</span><i class=\"fa-eye fas button-icon-right\" aria-hidden=\"true\"></i></a></div></div></div><div class=\"fusion-layout-column fusion_builder_column_inner fusion-builder-nested-column-1 fusion_builder_column_inner_1_2 1_2 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:50%;--awb-margin-top-large:20px;--awb-spacing-right-large:3.84%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:3.84%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div style=\"text-align:center;\"><a class=\"fusion-button button-flat button-xlarge button-custom fusion-button-default button-2 fusion-button-span-yes fusion-button-default-type\" style=\"--button_accent_color:var(--awb-color1);--button_accent_hover_color:var(--awb-color1);--button_border_hover_color:var(--awb-color1);--button_gradient_top_color:var(--awb-color8);--button_gradient_bottom_color:var(--awb-color8);--button_gradient_top_color_hover:hsla(var(--awb-color8-h),var(--awb-color8-s),calc(var(--awb-color8-l) - 16%),var(--awb-color8-a));--button_gradient_bottom_color_hover:hsla(var(--awb-color8-h),var(--awb-color8-s),calc(var(--awb-color8-l) - 16%),var(--awb-color8-a));\" target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://1.envato.market/xLEBx3\"><span class=\"fusion-button-text\">Purchase For $69</span><i class=\"fa-shopping-cart fas button-icon-right\" aria-hidden=\"true\"></i></a></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-21 fusion-sep-none fusion-title-text fusion-title-size-two awb-exclude-from-toc\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--2\" data-awb-toc-id=\"2\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-22 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"features\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Styling and Features</h2></div><div class=\"fusion-text fusion-text-24\"><p>Creating a <a href=\"https://avada.com/blog/how-to-create-a-style-guide-for-your-wordpress-website\" target=\"_blank\" rel=\"noopener noreferrer\">style guide</a> for your website will prove to be invaluable in the future. A style guide will help you to address <a href=\"https://avada.com/documentation/accessibility/\" target=\"_blank\" rel=\"noopener noreferrer\">usability</a>, the user experience, design consistency, and online trends in an organized and consistent manner.</p>\n<p>The <a href=\"https://avada.com/feature/live-visual-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Website Builder </a>has a vast array of features and styling options; however, you do not need to use all of them for your website, and this is where your style guide comes in. Decide upfront which styling options align with your brand and which design features are needed to make your website stand out.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-23 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"performance\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Performance &amp; Optimization</h2></div><div class=\"fusion-text fusion-text-25\"><p><a href=\"https://avada.com/documentation/avada-optimization-guide\" target=\"_blank\" rel=\"noopener noreferrer\">Optimizing</a> your websites for page load speed can be a seemingly complex subject because so many different facets affect how fast a page loads. It can range from the server&#8217;s speed to the options and settings selected, right through to the type and amount of content and even the size of the images added to the page or post.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-24 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">The Avada Performance Wizard</h3></div><div class=\"fusion-text fusion-text-26\"><p>The <a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard\" target=\"_blank\" rel=\"noopener noreferrer\">Performance Wizard</a> takes the guesswork out of how to best optimize your <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> website. To get you started you are presented with a step-by-step interface that will guide you through the process.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-2 hover-type-none\"><img decoding=\"async\" width=\"1900\" height=\"1345\" alt=\"Performance Wizard Start Screen\" title=\"Avada Performance Wizard Start Screen\" src=\"https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen.jpg\" class=\"img-responsive wp-image-887419\" srcset=\"https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen-200x142.jpg 200w, https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen-400x283.jpg 400w, https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen-600x425.jpg 600w, https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen-800x566.jpg 800w, https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen-1200x849.jpg 1200w, https://avada.com/wp-content/uploads/2022/10/avada-performance-wizard-start-screen.jpg 1900w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1900px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-27\"><p>What is important to note is that you should build your website first before running the Performance Wizard. Creating your website&#8217;s structure, placing design elements in situ, and formulating content ensures that the system has something to work with when searching for recommendations at each step of the process. The recommendations provided are for options that can be disabled or enabled to enhance overall performance.</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-1 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><strong>Features</strong><br />\nDisable any features not used on the website, thereby reducing the amount of code that is loaded.</p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><strong>Avada Icons</strong><br />\nScan your website for information about icons that are being used. You can also disable unused icon sets and discover how to optimize existing icons.</p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><strong>Avada Fonts/Typography</strong><br />\nCheck which fonts are being loaded on your website and then optimize how those fonts are served. Fewer variants will mean fewer requests and, therefore, faster loading times.</p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><strong>Avada Elements</strong><br />\nScan your website to discover which Design, Layout, and Form Elements are not used on the website. Disable unused Elements, thereby reducing the amount of code that is loaded.</p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><strong>Optimization</strong><br />\nOptimize how the website&#8217;s CSS and JS assets should be enqueued. These options can have a significant impact on the performance of the page load. However, some of these options can also break functionality if you use a caching plugin, so proceed with caution.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-25 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Above The Fold Optimization</h3></div><div class=\"fusion-text fusion-text-28\"><p>&#8220;Above the fold&#8221; is the part of a webpage that is immediately visible on your desktop or mobile screen without scrolling down. Traditionally, this digital real estate is where most would choose to display attention-grabbing headlines, important sales/marketing content, images, and even slider plugins as part of the page&#8217;s hero.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-3 hover-type-none\"><img decoding=\"async\" width=\"1900\" height=\"600\" alt=\"Above The Fold Optimization\" title=\"Above the Fold\" src=\"https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed.png\" class=\"img-responsive wp-image-887420\" srcset=\"https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed-200x63.png 200w, https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed-400x126.png 400w, https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed-600x189.png 600w, https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed-800x253.png 800w, https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed-1200x379.png 1200w, https://avada.com/wp-content/uploads/2022/10/above-the-fold-compressed.png 1900w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1900px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-29\"><p>The rate of content delivery for a website, and in particular the perceived speed experienced by the end-user on a mobile device, is at the heart of Google&#8217;s <a href=\"https://avada.com/documentation/what-are-google-core-web-vitals-and-why-they-matter\" target=\"_blank\" rel=\"noopener noreferrer\">Core Web Vitals</a>. Thus, passing Core Web Vitals inevitably leads to a delicate balance between good SEO, attention marketing, and page load times for a website owner.</p>\n<p>To assist you with managing your website&#8217;s <a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard\" target=\"_blank\" rel=\"noopener noreferrer\">performance</a> and <a href=\"https://avada.com/documentation/avada-optimization-guide/\" target=\"_blank\" rel=\"noopener noreferrer\">optimization</a>, our team introduced purpose-built tools and features for <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> that can make it possible for you to fine-tune your website&#8217;s performance on mobile &amp; desktop.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-26 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Generate Critical CSS</h3></div><div class=\"fusion-text fusion-text-30\"><p>Critical CSS is a convenient performance feature. You can enable Critical CSS by going to the <em><strong>Performance Wizard &gt; Optimization</strong></em> tab. Once it has been enabled, you can access the Critical CSS page from the WordPress sidebar at <em><strong>Avada &gt; Critical CSS or Maintenance &gt; Critical CSS</strong></em> from the Avada Dashboard. Both take you to the Critical CSS page to generate Critical CSS for both pages and posts.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-4 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a class=\"fusion-no-lightbox\" href=\"https://avada.com/documentation/how-to-use-critical-css\" target=\"_blank\" rel=\"noopener noreferrer\"><img decoding=\"async\" alt=\"Critical CSS\" src=\"https://avada.com/wp-content/uploads/2023/03/docs_generate_critical_css.jpg\" class=\"img-responsive wp-image-867029\"/></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-31\"><p>Critical CSS is the CSS necessary to style the above-the-fold content. When generated for a page, it will be loaded into the page head, and the rest of the CSS styles moved to the footer, resulting in less render-blocking and a faster page load time.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-27 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Resources</h3></div><div class=\"fusion-text fusion-text-32\"><p>Even with all of the performance options provided, <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> plays a lesser part than you might imagine when it comes to site optimization. Websites running <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> as the primary WordPress theme can be configured to optimize the layouts and structure that can lead to vastly improved page load scores. Still, ultimately, user content will principally dictate how fast and efficient your website will perform according to <a href=\"https://avada.com/documentation/what-are-google-core-web-vitals-and-why-they-matter\" target=\"_blank\" rel=\"noopener noreferrer\">Google Core Web Vitals</a>.</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-2 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard\" target=\"_blank\" rel=\"noopener noreferrer\">How To Use The Performance Wizard</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-youtube\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard/\" target=\"_blank\" rel=\"noopener noreferrer\">Video: How To Use The Performance Wizard</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/avada-optimization-guide\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Optimization Guide</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-youtube\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-use-critical-css\" target=\"_blank\" rel=\"noopener noreferrer\">Video: Optimize Above The Fold Content For Performance</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/avada-speed-performance\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Speed &amp; Performance</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-use-critical-css\" target=\"_blank\" rel=\"noopener noreferrer\">How To Use Critical CSS</a></div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-28 fusion-sep-none fusion-title-text fusion-title-size-three\" id=\"palette\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Color Palette</h3></div><div class=\"fusion-fss-swatches fusion-no-small-visibility fusion-no-medium-visibility fss-default-shadow\" style=\"margin-bottom:20px;\"><div class=\"fusion-fss-swatches-wrapper\" style=\"flex-direction:row;justify-content:space-between;margin:-5px;\"><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:5px;padding-top:50px;padding-right:55px;padding-bottom:50px;padding-left:55px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:100px; height:100px;background-color:#ee5519;border:10px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#ee5519\">#ee5519</div></div><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:5px;padding-top:50px;padding-right:55px;padding-bottom:50px;padding-left:55px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:100px; height:100px;background-color:#35668d;border:10px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#35668d\">#35668d</div></div><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:5px;padding-top:50px;padding-right:55px;padding-bottom:50px;padding-left:55px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:100px; height:100px;background-color:#e6f3fa;border:10px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#e6f3fa\">#e6f3fa</div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-fss-swatches fusion-no-small-visibility fusion-no-large-visibility fss-default-shadow\" style=\"margin-bottom:20px;\"><div class=\"fusion-fss-swatches-wrapper\" style=\"flex-direction:row;justify-content:flex-start;margin:-7.5px;\"><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:7.5px;padding-top:50px;padding-right:40px;padding-bottom:50px;padding-left:40px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:80px; height:80px;background-color:#ee5519;border:5px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#ee5519\">#ee5519</div></div><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:7.5px;padding-top:50px;padding-right:40px;padding-bottom:50px;padding-left:40px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:80px; height:80px;background-color:#35668d;border:5px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#35668d\">#35668d</div></div><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:7.5px;padding-top:50px;padding-right:40px;padding-bottom:50px;padding-left:40px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:80px; height:80px;background-color:#e6f3fa;border:5px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#e6f3fa\">#e6f3fa</div></div></div></div><div class=\"fusion-fss-swatches fusion-no-medium-visibility fusion-no-large-visibility fss-default-shadow\" style=\"margin-bottom:20px;\"><div class=\"fusion-fss-swatches-wrapper\" style=\"flex-direction:row;justify-content:flex-start;margin:-7.5px;\"><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:7.5px;padding-top:50px;padding-right:40px;padding-bottom:50px;padding-left:40px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:80px; height:80px;background-color:#ee5519;border:5px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#ee5519\">#ee5519</div></div><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:7.5px;padding-top:50px;padding-right:40px;padding-bottom:50px;padding-left:40px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:80px; height:80px;background-color:#35668d;border:5px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#35668d\">#35668d</div></div><div class=\"fusion-fss-swatch-wrapper\" style=\"margin:7.5px;padding-top:50px;padding-right:40px;padding-bottom:50px;padding-left:40px;background-color:#f2f2f2;border-radius:7px;\"><div class=\"fusion-fss-swatch\" style=\"width:80px; height:80px;background-color:#e6f3fa;border:5px solid var(--awb-color1);border-radius:50px;\"></div><div class=\"fusion-fss-swatch-text\" style=\"font-size:16px;color:#5e5e5e;\" data-color=\"#e6f3fa\">#e6f3fa</div></div></div></div><div class=\"fusion-text fusion-text-33\"><p>The color palette selected for the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> prebuilt website is a set of pastel colors, as seen above. If you would like to change the Avada Factory color palette, this can be done within the options panel, as explained in this <a href=\"https://avada.com/documentation/how-to-use-the-global-color-palette-in-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">help file and video</a>.</p>\n<p>Color increases brand recognition, and it can influence people in how they feel about a website. Colors produce different emotions in people, making it essential to choose the right colors for your website. The balance of white space, contrast, and well thought out color schemes are vital elements of good web design. If you have not already decided on your brand colors, choosing a color palette for your website can be confusing. However, using a handy tool like the <a href=\"https://color.adobe.com/create/color-wheel\" target=\"_blank\" rel=\"noopener noreferrer\">Adobe Color Wheel</a> or any of the myriad of app choices online, you can undoubtedly make this task effortless.</p>\n<p>We suggest checking out <a href=\"https://www.hubspot.com/\" target=\"_blank\" rel=\"noopener noreferrer\">HubSpot&#8217;s</a> article on <a href=\"https://blog.hubspot.com/marketing/color-palette-famous-websites\" target=\"_blank\" rel=\"noopener noreferrer\">color theory</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-29 fusion-sep-none fusion-title-text fusion-title-size-three\" id=\"typography\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Typography</h3></div><div class=\"fusion-text fusion-text-34\"><p>Website Typography can be more important than you realize, from your brand and user perspective to your website&#8217;s overall look and style. It is often underrated and is, in fact, an art form and technique in itself. The following <a href=\"https://blog.hubspot.com/website/website-typography\" target=\"_blank\" rel=\"noopener noreferrer\">HubSpot guide to website typography</a> will give you some great insights into the do&#8217;s and dont&#8217;s choosing which fonts work best for your <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> website.</p>\n<p>The Avada Website Builder has a vast array of Typography controls, options, and font selections to make your job easier. See this detailed <a href=\"https://avada.com/documentation/typography-options-in-avada\" target=\"_blank\" rel=\"noopener noreferrer\">help file and video</a> to get you started.</p>\n<p>Below are the fonts used for the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> prebuilt website:</p>\n</div><div class=\"fusion-builder-row fusion-builder-row-inner fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"width:104% !important;max-width:104% !important;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column_inner fusion-builder-nested-column-2 fusion_builder_column_inner_1_2 1_2 fusion-flex-column\" style=\"--awb-padding-top:20px;--awb-padding-right:20px;--awb-padding-bottom:20px;--awb-padding-left:20px;--awb-bg-color:#f2f2f2;--awb-bg-color-hover:#f2f2f2;--awb-bg-size:cover;--awb-width-large:50%;--awb-margin-top-large:20px;--awb-spacing-right-large:3.84%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:3.84%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-30 fusion-sep-none fusion-title-text fusion-title-size-three\" style=\"--awb-text-color:#5e5e5e;\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Headings</h3></div><div class=\"fusion-title title fusion-title-31 fusion-sep-none fusion-title-text fusion-title-size-div\" style=\"--awb-text-color:#5e5e5e;\"><div class=\"fusion-title-heading title-heading-left title-heading-tag\" style=\"margin:0;text-transform:capitalize;\">H1, H2, Font Family: <span style=\"font-family: Plus Jakarta Sans; font-weight: 400;\" data-fusion-font=\"true\" data-fusion-google-font=\"Plus Jakarta Sans\" data-fusion-google-variant=\"400\">Plus Jakarta Sans</span></div></div><div class=\"fusion-title title fusion-title-32 fusion-sep-none fusion-title-text fusion-title-size-div\" style=\"--awb-text-color:#5e5e5e;\"><div class=\"fusion-title-heading title-heading-left title-heading-tag\" style=\"margin:0;text-transform:capitalize;\"><p>H3, H4, Font Family: <span style=\"font-family: Plus Jakarta Sans; font-weight: 400;\" data-fusion-font=\"true\" data-fusion-google-font=\"Plus Jakarta Sans\" data-fusion-google-variant=\"400\">Plus Jakarta Sans<br />\n</span></p></div></div><div class=\"fusion-title title fusion-title-33 fusion-sep-none fusion-title-text fusion-title-size-div\" style=\"--awb-text-color:#5e5e5e;\"><div class=\"fusion-title-heading title-heading-left title-heading-tag\" style=\"margin:0;text-transform:capitalize;\">H5, H6, Font family: <span style=\"font-family: Plus Jakarta Sans; font-weight: 400;\" data-fusion-font=\"true\" data-fusion-google-font=\"Plus Jakarta Sans\" data-fusion-google-variant=\"400\">Plus Jakarta Sans</span></div></div></div></div><div class=\"fusion-layout-column fusion_builder_column_inner fusion-builder-nested-column-3 fusion_builder_column_inner_1_2 1_2 fusion-flex-column fusion-flex-align-self-stretch\" style=\"--awb-padding-top:20px;--awb-padding-right:20px;--awb-padding-bottom:20px;--awb-padding-left:20px;--awb-bg-color:#f2f2f2;--awb-bg-color-hover:#f2f2f2;--awb-bg-size:cover;--awb-width-large:50%;--awb-margin-top-large:20px;--awb-spacing-right-large:3.84%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:3.84%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-34 fusion-sep-none fusion-title-text fusion-title-size-three\" style=\"--awb-text-color:#5e5e5e;\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Body</h3></div><div class=\"fusion-title title fusion-title-35 fusion-sep-none fusion-title-text fusion-title-size-div\" style=\"--awb-text-color:#5e5e5e;\"><div class=\"fusion-title-heading title-heading-left title-heading-tag\" style=\"margin:0;text-transform:capitalize;\">Font Family: <span style=\"font-family: Plus Jakarta Sans; font-weight: 400;\" data-fusion-font=\"true\" data-fusion-google-font=\"Plus Jakarta Sans\" data-fusion-google-variant=\"400\">Plus Jakarta Sans</span></div></div></div></div></div><div class=\"fusion-text fusion-text-35\"><p>We suggest checking out HubSpot&#8217;s article on <a href=\"https://blog.hubspot.com/website/web-safe-html-css-fonts\" target=\"_blank\" rel=\"noopener noreferrer\">The Ultimate List of Web-Safe HTML and CSS Fonts</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-36 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"getstarted\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">To Get Started You Will Need The Following</h2></div><div class=\"fusion-text fusion-text-36\"><p>To get started with the <a href=\"https://avada.com/feature/live-visual-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Website Builder</a> and to create your ideal website, there are a few things that you will need;</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-3 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-network-wired fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p>A trusted <a href=\"https://avada.com/hosting/\" target=\"_blank\" rel=\"noopener noreferrer\">web hosting service</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-wordpress fab\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p>The latest version of <a href=\"https://wordpress.org/download/\" target=\"_blank\" rel=\"noopener noreferrer\">WordPress</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p>The <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Website Builder</a></p>\n</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-37 fusion-sep-none fusion-title-text fusion-title-size-three\" id=\"plugins\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Recommended Plugins</h3></div><div class=\"fusion-text fusion-text-37\"><p>What are recommended plugins, and do you need them? In short, it is not the end of the world if you choose not to install and activate the plugins used with any particular Avada <a href=\"https://avada.com/prebuilt-websites/\" target=\"_blank\" rel=\"noopener noreferrer\">prebuilt website</a>. Let&#8217;s take the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> prebuilt website as an example:</p>\n<p>It is created using <a href=\"https://avada.com/documentation/how-to-use-acf-pro-with-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">Advanced Custom Fields Pro</a>, which is a WordPress plugin that allows you to add extra content fields to your WordPress edit screens. Therefore the ACF Pro plugin should be installed and activated at the point of installing the prebuilt site.</p>\n<p>If you decide not to install the ACF Pro plugin, the full site will still be imported, but the option to add extra content fields will not be active. The following plugins have been used with the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> website:</p>\n</div><div class=\"fusion-fss-plugins-used\"><div class=\"fusion-fss-plugins-wrapper\" style=\"flex-direction:row;margin:-7.5px;\"><div class=\"fusion-fss-plugin-wrapper\" style=\"margin:7.5px;flex-basis: calc(50% - 15px);justify-content:flex-start;padding-top:1em;padding-right:1em;padding-bottom:1em;padding-left:1em;background-color:var(--awb-color2);border-radius:7px;font-size:1.2em;color:var(--awb-color8);\"><div class=\"fusion-fss-plugin\"><span class=\"fusion-fss-plugin-icon\"><svg width=\"101\" height=\"100\" viewBox=\"0 0 101 100\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"><rect x=\"0.258423\" width=\"100\" height=\"100\" rx=\"9\" fill=\"#57E9BE\"/><path d=\"M66.3427 66.6292V33H87.2584V40.7922H74.5449V46.9439H87.2584V54.3259H74.5449V66.6292H66.3427Z\" fill=\"white\"/><path d=\"M71.6742 51.8652C71.6742 56.1969 70.8623 58.7291 67.9234 61.9113C64.9845 65.0934 60.9545 67.0514 56.6365 67.3952C52.3184 67.7389 48.0294 66.4431 44.6241 63.7659C41.2188 61.0887 38.9471 57.2268 38.2619 52.9497C37.5766 48.6725 38.528 44.2942 40.9265 40.6872C43.325 37.0802 46.9945 34.5093 51.2038 33.4868C55.4131 32.4643 59.8531 33.0653 63.639 35.17C67.425 37.2747 70.854 41.7157 71.6323 46.484L63.6265 46.6562C62.9353 44.5546 61.4777 43.6108 59.5441 42.5359C57.6105 41.461 54.5227 40.3338 52.3729 40.856C50.2231 41.3782 45.8883 40.2306 44.6634 42.0728C43.4384 43.915 42.9525 49.432 43.3025 51.6164C43.6524 53.8009 46.4531 57.4137 48.1923 58.781C49.9315 60.1483 53.7624 59.1697 55.9677 58.9941C58.1731 58.8186 60.2313 57.8186 61.7323 56.1934C63.2333 54.5681 64.0668 54.0775 64.0668 51.8652H71.6742Z\" fill=\"#F2F2F2\"/><path d=\"M70.0337 51.8652C70.0337 56.1969 69.2218 58.7291 66.2829 61.9113C63.344 65.0934 59.314 67.0514 54.996 67.3952C50.6779 67.7389 46.3889 66.4431 42.9836 63.7659C39.5783 61.0887 37.3066 57.2268 36.6214 52.9497C35.9361 48.6725 36.8875 44.2942 39.286 40.6872C41.6845 37.0802 45.354 34.5093 49.5633 33.4868C53.7726 32.4643 58.2126 33.0653 61.9985 35.17C65.7845 37.2747 69.2135 41.7157 69.9918 46.484L61.986 46.6562C61.2948 44.5546 59.8372 43.6108 57.9036 42.5359C55.97 41.461 53.7024 41.154 51.5526 41.6762C49.4028 42.1984 47.5287 43.5115 46.3038 45.3537C45.0788 47.1959 44.5929 49.432 44.9428 51.6164C45.2928 53.8009 46.453 55.7733 48.1922 57.1406C49.9314 58.5079 52.1219 59.1697 54.3272 58.9941C56.5326 58.8186 58.5908 57.8186 60.0918 56.1934C61.5928 54.5681 62.4263 54.0775 62.4263 51.8652H70.0337Z\" fill=\"white\"/><path d=\"M38.4551 42.0225L37.2247 44.4832L45.427 65.3989L47.8877 66.2191L38.4551 42.0225Z\" fill=\"#F2F2F2\"/><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M14.2584 66.6293L27.382 33.4102H33.1236L46.6573 66.6293H38.0449L35.9944 62.118H24.9213L22.8708 66.6293H14.2584ZM27.7921 53.9158L30.6629 46.5338L33.1236 53.9158H27.7921Z\" fill=\"white\"/></svg></span><span class=\"fusion-fss-plugin-text\">ACF Pro</span></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-38 fusion-sep-none fusion-title-text fusion-title-size-three\" id=\"support\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">World-Class Support And Resources</h3></div><div class=\"fusion-text fusion-text-38\"><p>Many facets set the <a href=\"https://avada.com/feature/live-visual-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Website Builder</a> apart from the competition. None more important is that Avada is not reliant on 3rd party builders and tools to deliver a stable and seamless website building experience. No waiting for external developers and toolset creators to deliver the next update for your theme. We take pride in the fact that Avada is 100% maintained, evolved, and developed according to strict WordPress and PHP coding standards. Avada gives you peace of mind and guarantees that what you have to work with will always be ahead of the latest industry requirements.</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-4 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard\" target=\"_blank\" rel=\"noopener noreferrer\">How To Use The Performance Wizard</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-youtube\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard/\" target=\"_blank\" rel=\"noopener noreferrer\">Video: How To Use The Performance Wizard</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/avada-optimization-guide\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Optimization Guide</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon avada-elements-youtube\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-use-critical-css\" target=\"_blank\" rel=\"noopener noreferrer\">Video: Optimize Above The Fold Content For Performance</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/avada-speed-performance\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Speed &amp; Performance</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon icon-avada-docs\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-use-critical-css\" target=\"_blank\" rel=\"noopener noreferrer\">How To Use Critical CSS</a></div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-39 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"prebuiltwebsite\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What is a Prebuilt Website?</h2></div><div class=\"fusion-text fusion-text-39\"><p>Simply put, <a href=\"https://avada.com/prebuilt-websites/\" target=\" _self\" rel=\"noopener noreferrer\">prebuilt websites</a> are complete websites that have been designed and built to fit an industry niche. Each website comprises pages, posts, content layouts, images, or various media types representing or showcasing an online presence for a target audience or business type.</p>\n<p><a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> prebuilt websites and prebuilt content layouts (individual page or post content, layout sections, Call-to-actions, etc.) are carefully crafted by our talented team of designers to give you, the Avada user, a way to save time when prototyping a new website.</p>\n<p>Avada&#8217;s prebuilt websites are a fantastic resource for creativity and inspiration. They will make web design a more efficient and productive process for beginners, marketers, and professionals alike. Here are some essential facts:</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-5 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">They are created to save you time when building a new website.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A prebuilt website can be imported with a few clicks.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Each prebuilt website is mobile and SEO friendly.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Each prebuilt website is entirely customizable to suit your project and branding needs.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">You can white-label any prebuilt website for client work.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Prebuilt websites are included with your <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">purchase</a> of the Avada Website Builder.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Each prebuilt website is <a href=\"https://avada.com/documentation/avada-optimization-guide\" target=\" _self\" rel=\"noopener noreferrer\">optimized</a> for <a href=\"https://avada.com/documentation/how-to-use-the-performance-wizard\" target=\" _self\" rel=\"noopener noreferrer\">performance</a>.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-40 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"install\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Fast One-Click Install</h2></div><div class=\"fusion-text fusion-text-40\"><p>Importing any Avada Prebuilt Website is as simple as clicking a button, with pre-import selections making it highly flexible. You can choose to import a <a href=\"https://avada.com/prebuilt-websites/\" target=\"_blank\" rel=\"noopener noreferrer\">full </a><a href=\"https://avada.com/prebuilt-websites/\" target=\"_blank\" rel=\"noopener noreferrer\">website </a>(more than <span class=\"fusion-cs-live-demos\">109</span> to choose from) and parts of any other and anything in between. Choose pages, posts, portfolios, images, sliders, theme options, widgets, or uninstall as you prefer.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-5 hover-type-none\"><a class=\"fusion-no-lightbox\" href=\"https://avada.com/prebuilt-websites/\" target=\"_blank\" aria-label=\"Prebuilt 3-step Import\" rel=\"noopener noreferrer\"><img decoding=\"async\" width=\"1100\" height=\"420\" alt=\"Avada Prebuilt Website Import\" src=\"https://avada.com/wp-content/uploads/2022/10/prebuilt-3step-import-compressed.png\" class=\"img-responsive wp-image-887421\" srcset=\"https://avada.com/wp-content/uploads/2022/10/prebuilt-3step-import-compressed-200x76.png 200w, https://avada.com/wp-content/uploads/2022/10/prebuilt-3step-import-compressed-400x153.png 400w, https://avada.com/wp-content/uploads/2022/10/prebuilt-3step-import-compressed-600x229.png 600w, https://avada.com/wp-content/uploads/2022/10/prebuilt-3step-import-compressed-800x305.png 800w, https://avada.com/wp-content/uploads/2022/10/prebuilt-3step-import-compressed.png 1100w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1100px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div></div></div></div></div><div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-3 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-2 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:10px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-41 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"structure\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Website Structure</h2></div><div class=\"fusion-text fusion-text-41\"><p>A page or post structure is divided into four main sections: the Header, the Page Title Bar, Content, and the Footer. With the Avada Website Builder, you can independently edit each of these sections to create super flexible and stunning layout designs.</p>\n<p>Below is a list of the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> pages and posts that have been prebuilt just for you. Once installed, you can change all aspects of each Layout, and at any time, add new pages to suit your online business needs.</p>\n</div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-6 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Homepage Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/factory-home-alternate/\" target=\"_blank\" rel=\"noopener noreferrer\">Homepage Alternate Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/about/\" target=\"_blank\" rel=\"noopener noreferrer\">About Page Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/services/\" target=\"_blank\" rel=\"noopener noreferrer\">Services Page Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/faqs/\" target=\"_blank\" rel=\"noopener noreferrer\">Pages &#8211; FAQ&#8217;s Page Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/our-projects/\" target=\"_blank\" rel=\"noopener noreferrer\">Pages &#8211; Our Projects Page Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/directors/\" target=\"_blank\" rel=\"noopener noreferrer\">Pages &#8211; Board of Directors Page Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/industry-news/\" target=\"_blank\" rel=\"noopener noreferrer\">News Page Layout</a></p>\n</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-link fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">\n<p><a href=\"https://avada.website/factory/contact-us/\" target=\"_blank\" rel=\"noopener noreferrer\">Contact Page Layout</a></p>\n</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div></div></div></div></div><div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-4 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-3 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-42 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"layouts\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Explaining Layouts &amp; Layout Sections</h2></div><div class=\"fusion-text fusion-text-42\"><p>Before we look at the specific Layouts on the Avada Factory prebuilt website, the first thing to understand is the Layouts and Layout Sections&#8217; architecture. You can think of Layouts as a container for the page content. In contrast, the actual content comes from the various Layout Sections. There are four Layout Sections on a page – the Header, Page Title Bar, Content, and Footer Layout Sections.</p>\n<p>There is a default Global Layout, and any Layout Sections added to that will be shown on all pages of your website. There are Conditional Layouts with conditional logic to determine how the Layout will be used.</p>\n<p>You can make as many Layouts and Layout Sections as you like, and you can use the Layout Sections in multiple Layouts. But you can only use a specific condition on a single Layout, so the theme knows which one to use.</p>\n<p>See <a href=\"https://avada.com/documentation/understanding-layouts-and-layout-sections\" target=\"_blank\" rel=\"noopener noreferrer\">Understanding Layouts &amp; Layout Sections</a> and <a href=\"https://avada.com/documentation/understanding-conditional-layouts\" target=\"_blank\" rel=\"noopener noreferrer\">Understanding Conditional Layouts</a> for more info.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-6 hover-type-none\"><img decoding=\"async\" width=\"1050\" height=\"1050\" alt=\"Avada Layout Sections Legend\" title=\"Builder Layout Schematic\" src=\"https://avada.com/wp-content/uploads/2022/10/builder-layout-schematic-post-image.png\" class=\"img-responsive wp-image-887422\" srcset=\"https://avada.com/wp-content/uploads/2022/10/builder-layout-schematic-post-image-200x200.png 200w, https://avada.com/wp-content/uploads/2022/10/builder-layout-schematic-post-image-400x400.png 400w, https://avada.com/wp-content/uploads/2022/10/builder-layout-schematic-post-image-600x600.png 600w, https://avada.com/wp-content/uploads/2022/10/builder-layout-schematic-post-image-800x800.png 800w, https://avada.com/wp-content/uploads/2022/10/builder-layout-schematic-post-image.png 1050w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1050px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-43 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"wordpresspages\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Explaining WordPress Pages vs. Posts</h2></div><div class=\"fusion-text fusion-text-43\"><p>Website pages are allocated for static content such as your website&#8217;s homepage, about, contact page, and so on, and are timeless entities.</p>\n<p>Website posts are allocated to blog content listed in reverse (newest to the oldest) chronological order and are timely. Older posts are archived based on month and year. You can also create content for custom post types or CPT. In Avada, an example of this is the Portfolio post type. Check out this detailed <a href=\"https://wordpress.com/support/post-vs-page/\" target=\"_blank\" rel=\"noopener noreferrer\">WordPress article</a> for more information.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-44 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"change\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What Can I Change? Is the Design Flexible?</h2></div><div class=\"fusion-text fusion-text-44\"><p>The <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> prebuilt website is exactly that, prebuilt, for you. If the design and style suit your website needs, you can use it as a starting point, and you can change as much or as little as you need to.</p>\n<p>The most obvious details that you will want to change at first is the website&#8217;s wording, titles, color scheme, and images. You can choose to leave the overall layouts as is or Drag and Drop to rearrange the content&#8217;s order. Further to that, you can add or remove any of the <a href=\"https://avada.com/elements/\" target=\"_blank\" rel=\"noopener noreferrer\">Design </a><a href=\"https://avada.com/elements/\" target=\"_blank\" rel=\"noopener noreferrer\">Elements </a>to fine-tune your preferred business narrative. In short, you can change every single aspect of the prebuilt website&#8217;s Layout and content.</p>\n<p>Editing a page&#8217;s content and layouts is done using the <a href=\"https://avada.com/feature/live-visual-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Drag and Drop</a> live editor or using the traditional back-end method. The first image below shows the Live visual Drag and Drop editor is used to edit the content:</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-7 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-scaled.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[aa84d7d4106847d0ba1]\" data-title=\"Avada Factory Live Editing\" title=\"Avada Factory Live Editing\"><img decoding=\"async\" width=\"2560\" height=\"1259\" alt=\"Live Editor\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-scaled.jpg\" class=\"img-responsive wp-image-895173\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-200x98.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-400x197.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-600x295.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-800x393.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-1200x590.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Live-Editing-scaled.jpg 2560w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2560px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-45\"><p>The image below shows the traditional back-end method is used to edit the content:</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-8 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-scaled.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[8cffb42aabbe0f6e667]\" data-title=\"Avada Factory Backend Editing\" title=\"Avada Factory Backend Editing\"><img decoding=\"async\" width=\"2560\" height=\"1175\" alt=\"Back-end Editing\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-scaled.jpg\" class=\"img-responsive wp-image-895174\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-200x92.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-400x184.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-600x275.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-800x367.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-1200x551.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Backend-Editing-scaled.jpg 2560w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2560px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-45 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"comparison\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">A Side By Side Comparison (Builder vs. No Builder)</h2></div><div class=\"fusion-text fusion-text-46\"><p>We have created a side by side point of reference that illustrates the differences in building a website using the Avada Website Builder to design custom Layouts vs. not using The Avada Website Builder and only using predefined options. The latter will allow you only to build a basic site, in comparison.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-7 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-check fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.website/handmade\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Handmade</a> (Using the Website Builder)</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-times fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.website/handmade-basic/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Handmade Basic</a> (Not using the Website Builder)</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div></div></div></div></div><div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-5 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-4 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-46 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"homepage\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Exploring The Homepage Layout</h2></div><div class=\"fusion-text fusion-text-47\"><p>Website pages are allocated for static content such as your website&#8217;s homepage, about, contact page, and so on, and are timeless entities.</p>\n<p>Website posts are allocated to blog content listed in reverse (newest to the oldest) chronological order and are timely. Older posts are archived based on month and year. You can also create content for custom post types or CPT. In Avada, an example of this is the Portfolio post type. Check out this detailed <a href=\"https://wordpress.com/support/post-vs-page/\" target=\"_blank\" rel=\"noopener noreferrer\">WordPress article</a> for more information.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-47 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">The Header</h3></div><div class=\"fusion-text fusion-text-48\"><p>For the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> prebuilt website, the Header was created using the Avada <a href=\"https://avada.com/feature/header-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Header Builder</a> and is set globally across the website. This means that every page and post will use the same Header layout without any further conditions set. For example, you can change this if required by creating a unique Header layout for different pages or posts.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-9 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[6a8a417e031e3ae78c0]\" data-title=\"Avada Factory Header\" title=\"Avada Factory Header\"><img decoding=\"async\" width=\"1920\" height=\"135\" alt=\"Avada Factory Header\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header.jpg\" class=\"img-responsive wp-image-895175\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header-200x14.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header-400x28.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header-600x42.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header-800x56.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header-1200x84.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Header.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-48 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">The Page Content</h3></div><div class=\"fusion-text fusion-text-49\"><p>The content part of the homepage, the area between the Header and Footer, does not use a page title bar. You can change this page&#8217;s content in an infinite number of ways to best suit your business marketing and brand requirements.</p>\n<p>Page and Post content is structured using Container and Column Elements, and if required, Nested Columns. Check out the help file links below for detailed information and videos explaining what they are and how to use them:</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-8 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-info-circle fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">What are Containers, and how to use them? Read more <a href=\"https://avada.com/documentation/container-element\" target=\"_blank\" rel=\"noopener noreferrer\">here</a>.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-info-circle fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">What are Columns, and how to use them? Read more <a href=\"https://avada.com/documentation/column-element\" target=\"_blank\" rel=\"noopener noreferrer\">here</a>.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-info-circle fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">What are Nested Columns, and how to use them? Read more <a href=\"https://avada.com/documentation/nested-columns-element\" target=\"_blank\" rel=\"noopener noreferrer\">here</a>.</div></li></ul></div></div></div></div><div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-6 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-margin-top:0px;--awb-margin-bottom:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-5 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-49 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Hero Title</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-10 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[c8887830d745347d0e6]\" data-title=\"Avada Factory Hero Title\" title=\"Avada Factory Hero Title\"><img decoding=\"async\" width=\"1915\" height=\"494\" alt=\"Avada Factory Hero Title\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title.jpg\" class=\"img-responsive wp-image-895197\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title-200x52.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title-400x103.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title-600x155.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title-800x206.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title-1200x310.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-Title.jpg 1915w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1915px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-50\"><p>This section uses a <a href=\"https://avada.com/documentation/container-element\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> containing a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a> and three 1/2 (50% width) Columns, collectively holding Five <a href=\"https://avada.com/documentation/button-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Button Elements</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-50 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">The Hero</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-11 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[9ad9abff4731c7de7ac]\" data-title=\"Avada Factory Hero\" title=\"Avada Factory Hero\"><img decoding=\"async\" width=\"1915\" height=\"646\" alt=\"Avada Factory Hero\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero.jpg\" class=\"img-responsive wp-image-895180\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-200x67.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-400x135.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-600x202.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-800x270.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero-1200x405.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Hero.jpg 1915w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1915px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-51\"><p>Instead of using a traditional image slider, like the <a href=\"https://avada.com/features/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Slider</a> or <a href=\"https://avada.com/features/\" target=\"_blank\" rel=\"noopener noreferrer\">Slider Revolution</a>, as the above-the-fold hero section, this prebuilt site uses a single <a href=\"https://avada.com/documentation/container-element\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> with one 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> that contains a Background Slider of Images from the Library. It also holds a <a href=\"https://avada.com/documentation/nested-columns-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Nested Columns Element</a> which contains one 1/1 (100% width) Column that is empty.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-51 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Features</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-12 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[a34bfb78a81f6775390]\" data-title=\"Avada Factory Features\" title=\"Avada Factory Features\"><img decoding=\"async\" width=\"1915\" height=\"431\" alt=\"Avada Factory Features\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features.jpg\" class=\"img-responsive wp-image-895181\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features-200x45.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features-400x90.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features-600x135.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features-800x180.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features-1200x270.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Features.jpg 1915w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1915px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-52\"><p><span style=\"background-color: rgba(255, 255, 255, 0); color: var(--body_typography-color); letter-spacing: 0px; font-style: var(--body_typography-font-style,normal);\">This section was built using a <a href=\"https://avada.com/documentation/container-element\" target=\"_blank\" rel=\"noopener noreferrer\">Container </a>with four 23% width <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a>, each containing a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a> and two <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Elements</a>.<br />\n</span></p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-52 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">About Factory</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-13 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[e3af794d2b0e01eb134]\" data-title=\"Avada Factory About\" title=\"Avada Factory About\"><img decoding=\"async\" width=\"1915\" height=\"1211\" alt=\"Avada Factory About\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About.jpg\" class=\"img-responsive wp-image-895182\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About-200x126.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About-400x253.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About-600x379.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About-800x506.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About-1200x759.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-About.jpg 1915w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1915px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-53\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 2/3 (66.67% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> containing two <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Elements</a>, a <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Element</a>, and a <a href=\"https://avada.com/documentation/separator-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Separator Element</a>. This is followed by one 44% width Column and two 28% width Columns which collectively contain two Text Block Elements, a Title Element, and two <a href=\"https://avada.com/documentation/image-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Image Elements</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-53 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Marquee Title</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-14 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[232a61bcacc662d0bb1]\" data-title=\"Avada Factory Marquee Title\" title=\"Avada Factory Marquee Title\"><img decoding=\"async\" width=\"1920\" height=\"367\" alt=\"Avada Factory Marquee Title\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title.jpg\" class=\"img-responsive wp-image-895183\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title-200x38.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title-400x76.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title-600x115.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title-800x153.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title-1200x229.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Marquee-Title.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-54\"><p>To create this layout, a <a href=\"https://avada.com/documentation/container-element\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> with two 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a> each containing a Marquee type <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-54 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Services Title</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-15 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[db8ddbbec4fbe3c3475]\" data-title=\"Avada Factory Services Title\" title=\"Avada Factory Services Title\"><img decoding=\"async\" width=\"1920\" height=\"244\" alt=\"Avada Factory Services Title\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title.jpg\" class=\"img-responsive wp-image-895184\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title-200x25.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title-400x51.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title-600x76.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title-800x102.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title-1200x153.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-Title.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-55\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> with one 2/3 (66.67% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> holding two <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Elements</a> and one 1/3 (33.33% width) Column holding a <a href=\"https://avada.com/documentation/button-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Button Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-55 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Services</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-16 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[e0e2c74887293f43257]\" data-title=\"Avada Factory Services\" title=\"Avada Factory Services\"><img decoding=\"async\" width=\"1920\" height=\"740\" alt=\"Avada Factory Services\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services.jpg\" class=\"img-responsive wp-image-895185\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-200x77.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-400x154.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-600x231.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-800x308.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services-1200x463.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Services.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-56\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding four 1/4 (25% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a> each containing two <a href=\"https://avada.com/documentation/nested-columns-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Nested Columns Elements</a>.</p>\n<p>Simply put, nested columns are columns within columns. These Nested Columns are each structured holding one 1/1 (100% width) Column a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>, a <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Element</a>, and a <a href=\"https://avada.com/documentation/button-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Button Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-56 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Stats</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-17 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[18facd70c834e4f51b6]\" data-title=\"Avada Factory Stats\" title=\"Avada Factory Stats\"><img decoding=\"async\" width=\"1920\" height=\"460\" alt=\"Avada Factory Stats\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats.jpg\" class=\"img-responsive wp-image-895186\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats-200x48.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats-400x96.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats-600x144.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats-800x192.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats-1200x288.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Stats.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-57\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding four 1/4 (25% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a>, each containing a <a href=\"https://avada.com/documentation/nested-columns-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Nested Columns Element</a>, a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>, and a <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-57 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Request a Quote</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-18 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[aed8ebe76a9cc887fb2]\" data-title=\"Avada Factory Request a Quote\" title=\"Avada Factory Request a Quote\"><img decoding=\"async\" width=\"1920\" height=\"1123\" alt=\"Avada Factory Request a Quote\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote.jpg\" class=\"img-responsive wp-image-895187\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote-200x117.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote-400x234.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote-600x351.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote-800x468.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote-1200x702.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Request-a-Quote.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-58\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding two 1/2 (50% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a>. The first Column has a background Image and the second column has two <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Elements</a>, a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>, and a <a href=\"https://avada.com/documentation/button-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Button Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-58 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Projects</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-19 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[4a8cd2685a75f88b7be]\" data-title=\"Avada Factory Projects\" title=\"Avada Factory Projects\"><img decoding=\"async\" width=\"1920\" height=\"2037\" alt=\"Avada Factory Projects\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects.jpg\" class=\"img-responsive wp-image-895188\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects-200x212.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects-400x424.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects-600x637.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects-800x849.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects-1200x1273.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Projects.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-59\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding two 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a> collectively holding two <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Elements</a>, a <a href=\"https://avada.com/documentation/post-cards-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Post Cards Element</a>, and a <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-59 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Partner Logos</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-20 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[1cb3889cdabe31a9f1f]\" data-title=\"Avada Factory Partner Logos\" title=\"Avada Factory Partner Logos\"><img decoding=\"async\" width=\"1920\" height=\"434\" alt=\"Avada Factory Partner Logos\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos.jpg\" class=\"img-responsive wp-image-895189\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos-200x45.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos-400x90.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos-600x136.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos-800x181.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos-1200x271.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Partner-Logos.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-60\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding four 1/4 (25% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a> each containing an <a href=\"https://avada.com/documentation/image-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Image Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-60 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Our Team</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-21 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[19f4719a30bb094c76a]\" data-title=\"Avada Factory Our Team\" title=\"Avada Factory Our Team\"><img decoding=\"async\" width=\"1920\" height=\"1103\" alt=\"Avada Factory Our Team\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team.jpg\" class=\"img-responsive wp-image-895190\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team-200x115.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team-400x230.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team-600x345.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team-800x460.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team-1200x689.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Our-Team.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-61\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> holding two <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Elements</a> and three 1/3 (33.33% width) Columns each containing an <a href=\"https://avada.com/documentation/image-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Image Element</a> and a <a href=\"https://avada.com/documentation/nested-columns-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Nested Columns Element</a>.</p>\n<p>Each Nested Columns Element is structured using one 1/1 (100% width) Column holding a Title Element, a <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Element</a>, and a <a href=\"https://avada.com/documentation/social-links-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Social Links Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-61 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">CTA Info Section</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-22 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[200779874c1fb7a81eb]\" data-title=\"Avada Factory CTA Info Section\" title=\"Avada Factory CTA Info Section\"><img decoding=\"async\" width=\"1920\" height=\"1347\" alt=\"Avada Factory CTA Info Section\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section.jpg\" class=\"img-responsive wp-image-895191\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section-200x140.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section-400x281.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section-600x421.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section-800x561.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section-1200x842.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-CTA-Info-Section.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-62\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 3/4 (75% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> containing a Text Element, a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>, and a <a href=\"https://avada.com/documentation/button-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Button Element</a>. This is followed by one 1/1 (100% width) Column containing an <a href=\"https://avada.com/documentation/image-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Image Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-62 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Articles Resources</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-23 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[2e25685c6d29b34bbe5]\" data-title=\"Avada Factory Articles Resources\" title=\"Avada Factory Articles Resources\"><img decoding=\"async\" width=\"1920\" height=\"238\" alt=\"Avada Factory Articles Resources\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources.jpg\" class=\"img-responsive wp-image-895192\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources-200x25.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources-400x50.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources-600x74.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources-800x99.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources-1200x149.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Articles-Resources.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-63\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 2/3 (66.67% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> containing two <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Elements</a> and one 1/3 (33.33% width) Column containing a <a href=\"https://avada.com/documentation/button-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Button Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-63 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">News Posts</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-24 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[808da97d5cb4b4cd096]\" data-title=\"Avada Factory News Posts\" title=\"Avada Factory News Posts\"><img decoding=\"async\" width=\"1920\" height=\"778\" alt=\"Avada Factory News Posts\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts.jpg\" class=\"img-responsive wp-image-895193\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts-200x81.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts-400x162.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts-600x243.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts-800x324.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts-1200x486.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-News-Posts.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-64\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> containing a <a href=\"https://avada.com/documentation/post-cards-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Post Cards Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-64 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Scroll Title</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-25 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[490c1a4171c6121894b]\" data-title=\"Avada Factory Scroll Title\" title=\"Avada Factory Scroll Title\"><img decoding=\"async\" width=\"1920\" height=\"295\" alt=\"Avada Factory Scroll Title\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title.jpg\" class=\"img-responsive wp-image-895194\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title-200x31.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title-400x61.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title-600x92.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title-800x123.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title-1200x184.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Scroll-Title.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-65\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding one 1/1 (100% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a> containing a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-65 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Downloads</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-26 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[340eb8c65e59b5e1627]\" data-title=\"Avada Factory Downloads\" title=\"Avada Factory Downloads\"><img decoding=\"async\" width=\"1920\" height=\"197\" alt=\"Avada Factory Downloads\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads.jpg\" class=\"img-responsive wp-image-895195\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads-200x21.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads-400x41.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads-600x62.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads-800x82.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads-1200x123.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Downloads.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-66\"><p>This section was built using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> holding three 1/3 (33.33% width) <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a> each containing an <a href=\"https://avada.com/documentation/icon-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Icon Element</a> and a <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Element</a>.</p>\n</div></div></div></div></div><div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-7 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-margin-top:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-6 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-title title fusion-title-66 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"footer\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">The Footer</h2></div><div class=\"fusion-text fusion-text-67\"><p>A website footer aims to help visitors by providing appropriate information and navigation options at the bottom of website pages. Website footer design is underrated and more valuable to your website than you may think and is essential to the overall end-user experience. Three key points stand out, namely:</p>\n</div><ul style=\"--awb-iconcolor:#ee5519;--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-9 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-thumbs-up fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A footer should provide a website visitor with additional choices. If you want people to sign up for your mailing list, view a product demo, or contact you, inviting them at the end of a scroll is a compelling call to action.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-thumbs-up fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A footer should create a path for continued engagement by including navigation links to products, services, or other parts of your website.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-thumbs-up fas\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A footer can access essential information like ways to contact your company and customer services, privacy statements, and potential legal disclaimers.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-68\"><p>For the <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> prebuilt website, the Footer was created using the Avada <a href=\"https://avada.com/feature/footer-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Footer Builder</a> and this particular Footer content and Layout is set to display globally across the website. This means that every page and post will use the same Footer layout without any further conditions set. For example, you can change this if required by creating a unique Footer layout for different pages or posts. Let us take a closer look below:</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-67 fusion-sep-none fusion-title-center fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-center\" style=\"margin:0;text-transform:capitalize;\">Footer Content</h4></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-27 hover-type-none\" style=\"border:1px solid var(--awb-color4);\"><a href=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[ed7bc155e346e5e2d1f]\" data-title=\"Avada Factory Footer\" title=\"Avada Factory Footer\"><img decoding=\"async\" width=\"1920\" height=\"834\" alt=\"Avada Factory Footer\" src=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer.jpg\" class=\"img-responsive wp-image-895196\" srcset=\"https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer-200x87.jpg 200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer-400x174.jpg 400w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer-600x261.jpg 600w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer-800x348.jpg 800w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer-1200x521.jpg 1200w, https://avada.com/wp-content/uploads/2024/11/Avada-Factory-Footer.jpg 1920w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1920px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-text fusion-text-69\"><p>The Footer section is created using a <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> with multiple <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a> containing design elements such as <a href=\"https://avada.com/documentation/title-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Title Elements</a>, a <a href=\"https://avada.com/documentation/separator-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Separator Element</a>, the <a href=\"https://avada.com/documentation/avada-form-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Form Element</a>, an <a href=\"https://avada.com/documentation/image-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Image Element</a>, a <a href=\"https://avada.com/documentation/social-links-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Social Links Element</a>, and <a href=\"https://avada.com/documentation/text-block-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Text Block Elements</a>, with the use of <a href=\"https://avada.com/documentation/how-to-use-dynamic-content-options-in-avada\" target=\"_blank\" rel=\"noopener noreferrer\">Dynamic Data Options</a> to display the website information.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-68 fusion-sep-none fusion-title-text fusion-title-size-two\" id=\"summary\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">In Summary</h2></div><div class=\"fusion-text fusion-text-70\"><p>There are <span class=\"fusion-cs-live-demos\">109</span> <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> prebuilt websites to choose from, with more being added regularly. Our amazing design team created these prebuilt websites as a way to give you a head start when building your <a href=\"https://1.envato.market/xLEBx3\" target=\"_blank\" rel=\"noopener noreferrer\">next</a> website.</p>\n<p>You can change the styling, Layouts, content as much or as little as you need to quickly adapt any individual prebuilt site to suit your chosen niche. Get started with the Avada Website Builder today and launch your business online; Fast.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div style=\"text-align:center;\"><a class=\"fusion-button button-flat button-xlarge button-custom fusion-button-default button-3 fusion-button-span-yes fusion-button-default-type\" style=\"--button_accent_color:var(--awb-color1);--button_accent_hover_color:var(--awb-color1);--button_border_hover_color:var(--awb-color1);--button_gradient_top_color:var(--awb-color8);--button_gradient_bottom_color:var(--awb-color8);--button_gradient_top_color_hover:hsla(var(--awb-color8-h),var(--awb-color8-s),calc(var(--awb-color8-l) - 16%),var(--awb-color8-a));--button_gradient_bottom_color_hover:hsla(var(--awb-color8-h),var(--awb-color8-s),calc(var(--awb-color8-l) - 16%),var(--awb-color8-a));\" target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://1.envato.market/xLEBx3\"><span class=\"fusion-button-text\">Buy Avada Factory For Only $69</span><i class=\"fa-shopping-cart fas button-icon-right\" aria-hidden=\"true\"></i></a></div></div></div></div></div></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://avada.com/blog/avada-factory-deconstructing-a-prebuilt-website/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:88:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"How To Choose and Import an Avada Prebuilt Website\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://avada.com/blog/how-to-choose-and-import-an-avada-prebuilt-website/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://avada.com/blog/how-to-choose-and-import-an-avada-prebuilt-website/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Dec 2024 12:31:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:17:\"Prebuilt Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:14:\"Prebuilt Sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:15:\"Tutorial Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:10:\"Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:316:\"This guide is a comprehensive overview of choosing and importing an Avada prebuilt website. Let\'s get started!  Overview   What is an Avada Prebuilt Website?    Getting Started: Choosing a Prebuilt Website There are two ways to explore Avada\'s prebuilt websites. You can visit the avada.website showcase site, or ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:30238:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-8 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-7 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-71\"><p>With a growing selection of <span class=\"fusion-cs-live-demos\">109</span> professionally designed <a href=\"https://avada.com/prebuilt-websites/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada prebuilt websites</a>, the <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> ecosystem provides a starting point for creating unique and fully customized sites. These prebuilt sites offer a wide array of styles and design options tailored to different industries and niches, giving you a headstart for your website project.</p>\n</div><div class=\"fusion-text fusion-text-72\"><p>Besides the vast selection of ready-to-go websites, Avada also includes the <a href=\"https://avada.com/feature/avada-studio/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Studio</a> creative resource library, which includes a growing list of 574 <a href=\"https://avada.studio/\" target=\"_blank\" rel=\"noopener noreferrer\">professionally designed content blocks</a> that can be <a href=\"https://avada.com/blog/how-to-add-avada-studio-content-to-an-existing-website/\" target=\"_blank\" rel=\"noopener noreferrer\">imported into any Avada website</a>.</p>\n</div><div class=\"fusion-text fusion-text-73\"><p>This guide is a comprehensive overview of choosing and importing an Avada prebuilt website. Let&#8217;s get started!</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-69 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--3\" data-awb-toc-id=\"3\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-70 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What is an Avada Prebuilt Website?</h2></div><div class=\"fusion-text fusion-text-74\"><p>It is a professionally designed and complete example of what can be created with Avada\'s flexibility and creative design tools, including pages, images, settings, forms, and more. Importing an <a href=\"https://avada.website/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada prebuilt website</a> allows you to use it as a foundation for your website. There is an ever-growing list of <span class=\"fusion-cs-live-demos\">109</span> sites to choose from, each showcasing various features and styles, giving you flexibility and creative inspiration for your project.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-28 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-28\" style=\"border:1px solid var(--awb-color2);\"><a href=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[cf03a84090c27ea990d]\" data-title=\"Avada Pre-built Websites\" title=\"Avada Pre-built Websites\"><img decoding=\"async\" width=\"2500\" height=\"2132\" alt=\"Avada Pre-built Websites\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage.jpg\" class=\"img-responsive wp-image-895075\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage-200x171.jpg 200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage-400x341.jpg 400w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage-600x512.jpg 600w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage-800x682.jpg 800w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage-1200x1023.jpg 1200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-homepage.jpg 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-71 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Getting Started: Choosing a Prebuilt Website</h2></div><div class=\"fusion-text fusion-text-75\"><p>There are two ways to explore Avada&#8217;s prebuilt websites. You can visit the <a href=\"https://avada.website/\" target=\"_blank\" rel=\"noopener noreferrer\">avada.website</a> showcase site, or you can log into your <strong>Avada website Dashboard</strong> and navigate to the <strong>&#8220;Avada &gt; Websites&#8221;</strong> page. You can browse all the available prebuilt designs in either location and filter them by category or plugins. This makes it easy to find a design that fits your specific requirements. Once you&#8217;ve identified a design you like, it&#8217;s time to proceed to the actual importing step.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-29 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-29\" style=\"border:1px solid var(--awb-color2);\"><a href=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-scaled.jpg\" class=\"fusion-lightbox\" data-rel=\"iLightbox[2796f99663b0fa13fc2]\" data-title=\"Avada Dashboard Websites Page\" title=\"Avada Dashboard Websites Page\"><img decoding=\"async\" width=\"2148\" height=\"2560\" alt=\"Avada Dashboard Websites Page\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-scaled.jpg\" class=\"img-responsive wp-image-895082\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-200x238.jpg 200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-400x477.jpg 400w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-600x715.jpg 600w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-800x954.jpg 800w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-1200x1430.jpg 1200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-dashboard-alt-scaled.jpg 2148w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2148px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-72 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Importing a Prebuilt Website</h2></div><div class=\"fusion-text fusion-text-76\"><p>After you have decided on the prebuilt website you&#8217;d like to use, you can import it directly from within your Avada installation. The process starts with registering your site and launching the <a href=\"https://avada.com/blog/a-beginners-guide-to-the-avada-website-setup-wizard/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Setup Wizard</a>. You can start from scratch or import a prebuilt website through this wizard. The wizard will guide you through the importing process, making it straightforward.</p>\n</div><div class=\"fusion-video fusion-youtube\" style=\"--awb-max-width:1280px;--awb-max-height:720px;--awb-align-self:center;--awb-width:100%;\"><div class=\"video-shortcode\"><priv-fac-lite-youtube class=\"fusion-hidden\" data-privacy-type=\"youtube\" videoid=\"DzLeX8q3850\" class=\"landscape\" params=\"wmode=transparent&autoplay=1&enablejsapi=1\" title=\"YouTube video player 2\" width=\"1280\" height=\"720\" data-thumbnail-size=\"auto\"></priv-fac-lite-youtube><div class=\"fusion-privacy-placeholder\" style=\"width:1280px; height:720px;\" data-privacy-type=\"youtube\"><div class=\"fusion-privacy-placeholder-content\"><div class=\"fusion-privacy-label\">For privacy reasons YouTube needs your permission to be loaded.</div><button data-privacy-type=\"youtube\" class=\"fusion-button button-default fusion-button-default-size button fusion-privacy-consent\">I Accept</button></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-alert alert custom alert-custom fusion-alert-left awb-alert-inherit-link-color\" style=\"--awb-background-color:#ebfaff;--awb-accent-color:#005272;--awb-border-size:0px;--awb-border-top-left-radius:5px;--awb-border-top-right-radius:5px;--awb-border-bottom-left-radius:5px;--awb-border-bottom-right-radius:5px;\" role=\"alert\"><div class=\"fusion-alert-content-wrapper\"><span class=\"alert-icon\"><i class=\"avada-elements-avada-logo\" aria-hidden=\"true\"></i></span><span class=\"fusion-alert-content\">To gain access to Avada Websites and Avada Studio content, the first step is to purchase <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> and then register by following these <a href=\"https://avada.com/documentation/how-to-register-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">instructions</a>.</span></div></div><div class=\"fusion-text fusion-text-77\"><p>Alternatively, if you choose not to use the <a href=\"https://avada.com/feature/setup-wizard/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Setup Wizard</a> or need to import a different prebuilt website, later on, you can do so using the <a href=\"https://avada.com/documentation/avada-prebuilt-websites/\" target=\"_blank\" rel=\"noopener noreferrer\">Website Importer</a>. This tool is accessible from the WordPress sidebar or the Avada dashboard. The importer provides an intuitive way to manage prebuilt sites, allowing users to import or uninstall any prebuilt websites as needed quickly.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-73 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">System Requirements and Setup</h3></div><div class=\"fusion-text fusion-text-78\"><p>Before importing a prebuilt website, it&#8217;s a good idea to check your web server&#8217;s system status to ensure that things run smoothly. You can do this by logging into your Avada website, navigating to the <strong>&#8220;Avada &gt; Status&#8221;</strong> page, and then <strong>&#8220;Server Environment.&#8221;</strong> </p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-30 hover-type-none\"><a href=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[dc5d880a4fe76adacce]\" data-title=\"Avada Dashboard Server Environment\" title=\"Avada Dashboard Server Environment\"><img decoding=\"async\" width=\"2290\" height=\"1532\" alt=\"Avada Dashboard Server Environment\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment.png\" class=\"img-responsive wp-image-895079\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment-200x134.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment-400x268.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment-600x401.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment-800x535.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment-1200x803.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-server-environment.png 2290w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2290px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-79\"><p>Ensure that any server-side configuration issues marked in red are resolved to meet the recommended settings. This ensures a smooth import process without interruptions. If required, the two key operators that should be addressed are <strong>&#8220;PHP Time Limit&#8221;</strong> and <strong>&#8220;PHP Max Input Vars.&#8221;</strong> Depending on your hosting provider, you can either adjust these values yourself, or you will need to contact your hosting provider directly for assistance. </p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:5px;width:100%;\"></div><div class=\"fusion-title title fusion-title-74 fusion-sep-none fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What Is <span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">PHP Time Limit?</span></h4></div><div class=\"fusion-text fusion-text-80\"><p>A server&#8217;s PHP Time Limit is the maximum amount of time a PHP script can run before the server forcibly terminates it. This setting helps prevent poorly written or resource-intensive scripts from running indefinitely and consuming server resources.</p>\n<p>The limit is configured in the server&#8217;s PHP settings, often found in the <strong>php.ini</strong> file. The value is specified in seconds; a typical setting might be 30 seconds, which means the server will stop any PHP script that runs longer than 30 seconds. The script can adjust the time limit programmatically using the <strong><a href=\"https://www.php.net/manual/en/function.set-time-limit.php\" target=\"_blank\" rel=\"noopener noreferrer\">set_time_limit()</a></strong> function. However, some hosting providers may restrict this ability.</p>\n<p>If you encounter an error related to PHP Time Limit (such as a timeout or &#8220;Maximum execution time exceeded&#8221;), it means that the script exceeded the allowed execution time. You may need to increase the limit to accommodate longer-running processes, particularly if dealing with complex operations like importing data or generating large reports.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:5px;width:100%;\"></div><div class=\"fusion-title title fusion-title-75 fusion-sep-none fusion-title-text fusion-title-size-four\"><h4 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What Is <span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">PHP Max Input Vars?</span></h4></div><div class=\"fusion-text fusion-text-81\"><p>A server&#8217;s PHP Max Input Vars setting (max_input_vars) defines the maximum number of input variables that can be processed by a PHP script. These input variables include those received via <strong>GET</strong>, <strong>POST</strong>, and <strong>COOKIE</strong> methods, and it affects the number of variables PHP can handle when processing data, such as form submissions.</p>\n<p>The default value for <strong><a href=\"https://www.php.net/manual/en/info.configuration.php#ini.max-input-vars\" target=\"_blank\" rel=\"noopener noreferrer\">max_input_vars</a></strong> is typically <strong>1000</strong>, meaning that a maximum of 1000 individual form elements (like input fields, checkboxes, dropdowns, etc.) can be sent and processed simultaneously. If this limit is exceeded, some variables may not be processed, which can cause issues like incomplete form submissions or missing data.</p>\n<p>This setting is critical when working with large forms or multi-dimensional arrays, such as large menus in WordPress, as exceeding this limit may result in some data not saving correctly.</p>\n<p>After making changes, you&#8217;ll usually need to restart the web server for them to take effect. Alternatively, depending on your hosting environment, you can also modify <strong>&#8220;max_input_vars&#8221;</strong> in a <strong>.htaccess</strong> file or through a custom <strong>php.ini</strong> file.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-76 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Importing a Prebuilt Avada Website</h3></div><div class=\"fusion-text fusion-text-82\"><p>The ideal scenario for importing a prebuilt website is a fresh Avada and <a href=\"https://wordpress.org/\" target=\"_blank\" rel=\"noopener noreferrer\">WordPress</a> installation. Importing will not delete existing content, such as pages, posts, or portfolios. Still, it will replace the <a href=\"https://avada.com/documentation/avada-global-options/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Global Options</a> with those specific to the prebuilt website being imported. Therefore, importing a new prebuilt website over an already completed site is not advisable.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-31 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-31\"><a href=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[06e05c453d96b73238e]\" data-title=\"Uninstall Avada Prebuilt Website\" title=\"Uninstall Avada Prebuilt Website\"><img decoding=\"async\" width=\"2500\" height=\"1516\" alt=\"Uninstall Avada Prebuilt Website\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall.png\" class=\"img-responsive wp-image-895080\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall-200x121.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall-400x243.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall-600x364.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall-800x485.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall-1200x728.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-uninstall.png 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-83\"><p>To remove an existing prebuilt website, return to the Avada Websites section. You will see the imported prebuilt website listed. Click on the <strong>&#8220;Modify&#8221;</strong> button and select <strong>&#8220;Remove Content&#8221;</strong> to uninstall the site. Once removed, you are free to import a different Avada pre-built website.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-77 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">How To Preview a Prebuilt Website</h3></div><div class=\"fusion-text fusion-text-84\"><p>You can preview prebuilt websites within the Avada Websites section before importing them. Hover over the desired prebuilt and click <strong>&#8220;Preview&#8221;</strong> to explore its design and functionality. If it suits your needs, click <strong>&#8220;Import&#8221;</strong> to bring it to your WordPress website.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-32 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-32\" style=\"border:1px solid var(--awb-color2);\"><a href=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[7495d42e8df71cda2b8]\" data-title=\"Preview Avada Prebuilt Website\" title=\"Preview Avada Prebuilt Website\"><img decoding=\"async\" width=\"2500\" height=\"1943\" alt=\"Preview Avada Prebuilt Website\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview.png\" class=\"img-responsive wp-image-895081\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview-200x155.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview-400x311.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview-600x466.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview-800x622.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview-1200x933.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-import-website-post-import-preview.png 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-85\"><p>The import dialogue box will provide options to include or exclude certain parts of the prebuilt website. You may import all the content or leave out specific sections to tailor the import to your requirements. Once ready, click <strong>&#8220;Import,&#8221;</strong> and the process will begin. </p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-78 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Importing Parts of a Prebuilt Website</h2></div><div class=\"fusion-text fusion-text-86\"><p>In addition to importing an entire prebuilt website, if you prefer, you can import only specific sections of a prebuilt website. For example, suppose you only want certain forms or page elements. In that case, you can select only those options during the import process. This feature is useful when mixing and matching facets from different pre-built websites.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-79 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Customizing Your New Avada Website</h2></div><div class=\"fusion-text fusion-text-87\"><p>Once you have imported your prebuilt website, you can make it your own by customizing the pages, content, and settings. Avada offers comprehensive design tools to help you tailor everything to your brand and purpose. If you need more guidance, watch Avada&#8217;s <a href=\"https://www.youtube.com/watch?v=lLbZM3pA5_I\" target=\"_blank\" rel=\"noopener noreferrer\">two-part video series</a> on customizing a prebuilt website, where we walk through transforming the <a href=\"https://avada.website/country-butcher/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Country Butcher</a> pre-built website into an organic farm website.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-80 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Summary</h2></div><div class=\"fusion-text fusion-text-88\"><p>Importing a prebuilt website with <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> is a straightforward process that allows you to quickly create a professional-looking website tailored to your needs. Whether starting fresh or adding new elements, the prebuilt website importer makes it easy to bring your vision to life. To get started, head over to the Avada dashboard, select your prebuilt website, and start customizing it to create your perfect site.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://avada.com/blog/how-to-choose-and-import-an-avada-prebuilt-website/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"How to Use Avada Container &amp; Column Background Options\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://avada.com/blog/how-to-use-avada-container-column-background-options/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://avada.com/blog/how-to-use-avada-container-column-background-options/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Dec 2024 13:17:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:15:\"Layout Elements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:15:\"Tutorial Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"In this blog post, we\'ll explore utilizing the powerful background options available in Avada\'s Container and Column Elements. These Layout Elements offer a variety of background customization features, allowing users to create visually appealing and engaging designs beyond simple content holders. This guide covers the background settings, including colors, gradients, images, sliders, videos, ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:26895:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-9 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-8 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-89\"></div><div class=\"fusion-text fusion-text-90\"></div><div class=\"fusion-text fusion-text-91\"><p>In this blog post, we&#8217;ll explore utilizing the powerful background options available in Avada&#8217;s <a href=\"https://avada.com/element/container/\" target=\"_blank\" rel=\"noopener noreferrer\">Container</a> and <a href=\"https://avada.com/element/column/\" target=\"_blank\" rel=\"noopener noreferrer\">Column Elements</a>. These <a href=\"https://avada.com/documentation/the-avada-layout-elements/\" target=\"_blank\" rel=\"noopener noreferrer\">Layout Elements</a> offer a variety of background customization features, allowing users to create visually appealing and engaging designs beyond simple content holders. This guide covers the background settings, including colors, gradients, images, sliders, videos, patterns, and masks. Let&#8217;s get started!</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-81 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--4\" data-awb-toc-id=\"4\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-82 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Container &amp; Column Background Options</h2></div><div class=\"fusion-text fusion-text-92\"><p>Both the <a href=\"https://avada.com/documentation/container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Container</a> and <a href=\"https://avada.com/documentation/column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Column Elements</a> share four key background tabs: <strong>Color</strong>, <strong>Gradient</strong>, <strong>Image</strong>, and <strong>Slider</strong>. However, the Container Element offers additional options, including <strong>Video</strong>, <strong>Pattern</strong>, and <strong>Mask</strong>. These settings allow users to combine different background types, creating dynamic effects that can enhance the visual appeal of any page.</p>\n</div><div class=\"fusion-video fusion-youtube\" style=\"--awb-max-width:1280px;--awb-max-height:720px;--awb-align-self:center;--awb-width:100%;\"><div class=\"video-shortcode\"><priv-fac-lite-youtube class=\"fusion-hidden\" data-privacy-type=\"youtube\" videoid=\"wXMgXleYX3w\" class=\"landscape\" params=\"wmode=transparent&autoplay=1&enablejsapi=1\" title=\"YouTube video player 3\" width=\"1280\" height=\"720\" data-thumbnail-size=\"auto\"></priv-fac-lite-youtube><div class=\"fusion-privacy-placeholder\" style=\"width:1280px; height:720px;\" data-privacy-type=\"youtube\"><div class=\"fusion-privacy-placeholder-content\"><div class=\"fusion-privacy-label\">For privacy reasons YouTube needs your permission to be loaded.</div><button data-privacy-type=\"youtube\" class=\"fusion-button button-default fusion-button-default-size button fusion-privacy-consent\">I Accept</button></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-93\"><p>The tutorial video uses the <a href=\"https://avada.website/beer/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Beer</a> pre-built website to explore the background tab options in more detail. Although the focus here is on the Container Element, the same principles apply to the Column Element where relevant.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-83 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Color</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-33 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1278\" height=\"822\" alt=\"Container Background Color Options\" title=\"Container Background Color Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color.png\" class=\"img-responsive wp-image-895101\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color-200x129.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color-400x257.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color-600x386.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color-800x515.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color-1200x772.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-color.png 1278w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1278px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-94\"><p>The simplest background option is setting a solid color. Users can choose a color from the Color Picker, adjust its opacity, or select from a global color palette. Additionally, it&#8217;s possible to combine background color effects with other background types, such as images or videos. For example, applying a color with transparency over a background image allows the color to show through the image, creating layered effects.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-84 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Gradient</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-34 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1276\" height=\"2004\" alt=\"Container Background Gradient Options\" title=\"Container Background Gradient Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient.png\" class=\"img-responsive wp-image-895102\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient-200x314.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient-400x628.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient-600x942.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient-800x1256.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient-1200x1885.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-gradient.png 1276w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1276px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-95\"><p>The <strong>Gradient</strong> tab provides even more flexibility. You can define a gradient by selecting a start and end color and controlling the angle or direction. There are two types of gradients: <strong>&#8220;Linear&#8221;</strong> and &#8220;<strong>Radial&#8221;</strong>, each allowing unique combinations of colors and angles. For instance, a gradient can overlay an image, allowing you to blend colors with the image beneath. Experimenting with gradient start and end positions or introducing transparency results in varied effects.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-85 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Image</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-35 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1278\" height=\"3580\" alt=\"Container Background Image Options\" title=\"Container Background Image Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image.png\" class=\"img-responsive wp-image-895103\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image-200x560.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image-400x1121.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image-600x1681.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image-800x2241.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image-1200x3362.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-image.png 1278w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1278px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-96\"><p>The <strong>Image</strong> tab enables users to set a background image with options to control its size, position, and repetition. Users can adjust the background position (<strong>center</strong>, <strong>top</strong>, <strong>bottom</strong>, etc.) and set whether the image repeats horizontally or vertically. The background-size setting, including options like <strong>&#8220;cover&#8221;</strong> or <strong>&#8220;contain,&#8221;</strong> lets users fit the image according to container dimensions.</p>\n<p>A <strong>parallax</strong> effect can also create a scrolling movement as users navigate the page, adding an interactive layer to the design. Additionally, <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> offers a fade animation feature that can cause images to fade and blur as you scroll, adding further dynamic visual interest to your page.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-86 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Slider</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-36 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1278\" height=\"830\" alt=\"Container Background Slider Options\" title=\"Container Background Slider Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider.png\" class=\"img-responsive wp-image-895108\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider-200x130.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider-400x260.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider-600x390.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider-800x520.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider-1200x779.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-slider.png 1278w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1278px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-97\"><p>In the <strong>Slider</strong> tab, users can add multiple images to create a simple background slider that cycles through selected images. This feature is handy in full-width Containers and allows for seamless transitions between images. Several slider settings, such as <strong>slideshow speed</strong>, <strong>pause on hover</strong>, and <strong>animation effects</strong>, can be adjusted to tailor the slider to specific needs.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-87 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Video</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-37 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1278\" height=\"1588\" alt=\"Container Background Video Options\" title=\"Container Background Video Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video.png\" class=\"img-responsive wp-image-895105\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video-200x249.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video-400x497.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video-600x746.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video-800x994.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video-1200x1491.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-video.png 1278w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1278px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-98\"><p>For a more engaging experience, the <strong>Video</strong> tab allows users to set a background video, either self-hosted or sourced from <strong>YouTube</strong> or <strong>Vimeo</strong>. Background videos can create an immersive experience, though users should be mindful of container size to ensure the video fits well. Settings include <strong>looping</strong>, <strong>muting</strong>, and <strong>aspect ratio</strong> adjustments, making video backgrounds versatile for different layouts.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-88 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Pattern</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-38 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1278\" height=\"1186\" alt=\"Container Background Pattern Options\" title=\"Container Background Pattern Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern.png\" class=\"img-responsive wp-image-895106\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern-200x186.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern-400x371.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern-600x557.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern-800x742.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern-1200x1114.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-pattern.png 1278w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1278px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-99\"><p>Two advanced options, <strong>Patterns</strong> and <strong>Masks</strong>, provide further design possibilities. Patterns can be applied over any other background to add texture or decorative effects, and users can even upload custom SVG patterns.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-89 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Background Mask</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-39 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"1278\" height=\"1184\" alt=\"Container Background Mask Options\" title=\"Container Background Mask Options\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask.png\" class=\"img-responsive wp-image-895107\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask-200x185.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask-400x371.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask-600x556.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask-800x741.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask-1200x1112.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-column-container-background-post-mask.png 1278w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1278px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-100\"><p>With the <strong>Mask</strong> tab, designers can create unique cut-out effects that reveal only parts of the background beneath. Both patterns and masks have blend mode options, giving users complete control over how these elements interact with other layers.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-90 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Blend Modes for Creative Effects</h2></div><div class=\"fusion-text fusion-text-101\"><p>Across many of these background tabs, users will find options for <strong>Blend Modes</strong>. These modes determine how layers interact with one another and can be combined in creative ways to achieve various effects. For example, blending a gradient with an image or applying a mask over a video can add depth and complexity to your design.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-91 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Summary</h2></div><div class=\"fusion-text fusion-text-102\"><p>The <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> Container and Column background options offer endless possibilities for creating stunning, dynamic designs. Whether you use simple color backgrounds, complex gradient overlays, or videos and image sliders, there are numerous ways to make your website visually engaging.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://avada.com/blog/how-to-use-avada-container-column-background-options/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:79:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Version 7.11.12 Security Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://avada.com/blog/version-7-11-12-security-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://avada.com/blog/version-7-11-12-security-update/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 16:34:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:19:\"Website Maintenance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:339:\"We have released Avada 7.11.12, providing various new features, improvements, and fixing two minor security issues: Contributor+ level users can clone arbitrary posts and thus being able to view the contents of drafted or pending posts. Contributor+ level users can add JS code to a few elements for execution on the page preview of an ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6161:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-10 fusion-flex-container nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:calc( 1280px + 0px );margin-left: calc(-0px / 2 );margin-right: calc(-0px / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-9 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-blend:overlay;--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:0px;--awb-margin-bottom-large:10px;--awb-spacing-left-large:0px;--awb-width-medium:100%;--awb-spacing-right-medium:0px;--awb-spacing-left-medium:0px;--awb-width-small:100%;--awb-spacing-right-small:0px;--awb-spacing-left-small:0px;\"><div class=\"fusion-column-wrapper fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-103\" style=\"--awb-text-transform:none;\"><p>We have released <a href=\"https://avada.com/whats-new/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada 7.11.12</a>, providing various new features, improvements, and fixing two minor security issues:</p>\n</div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-10 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-shield-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Contributor+ level users can clone arbitrary posts and thus being able to view the contents of drafted or pending posts.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-shield-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Contributor+ level users can add JS code to a few elements for execution on the page preview of an admin user.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-104\" style=\"--awb-text-transform:none;\"><p>This is disclosed in our <a href=\"https://avada.com/documentation/avada-changelog\" target=\" _self\" rel=\"noopener noreferrer\">Changelog</a> and our <a href=\"https://avada.com/documentation/important-update-information\" target=\" _self\" rel=\"noopener noreferrer\">Important Update Info</a> help file.</p>\n<p>Like WordPress and any entity that develops software, we understand that security is not absolute and is a continuous process managed as such. We do our best to prevent security issues as proactively as possible, as we do not assume they’ll never come up. Our responsibility is to quickly take care of them and work to get our customers notified and prepared. This is why we recommend keeping your website and plugins up-to-date and maintained at all times.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-92 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What Should I Do Next?</h2></div><div class=\"fusion-text fusion-text-105\"><p>We cannot stress enough the importance of ensuring that your website is kept up to date and maintained at all times. Please update to ensure that your installation is issue-free and the fix detailed above is applied. These are our detailed update instructions:</p>\n</div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-11 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-external-link-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/updating-avada-older-versions/\" target=\"_blank\" rel=\"noopener noreferrer\">Updating from an old version of Avada?</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-external-link-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/important-update-information/\" target=\"_blank\" rel=\"noopener noreferrer\">Important Update Info</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-external-link-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/how-to-update-the-avada-website-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">How to Update</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-external-link-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/avada-patcher/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Patcher</a></div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-external-link-alt fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\"><a href=\"https://avada.com/documentation/avada-changelog/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Changelog</a></div></li></ul>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-text fusion-text-106\"><p>We would like to extend our gratitude and thanks to Wordfence.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://avada.com/blog/version-7-11-12-security-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"How to Use CSS Z-index With Avada in Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://avada.com/blog/how-to-use-css-z-index-with-avada-in-web-design/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://avada.com/blog/how-to-use-css-z-index-with-avada-in-web-design/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Dec 2024 09:49:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Tutorial Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:367:\"In web design, managing the visual hierarchy of elements is essential for creating clean, user-friendly interfaces, and one of the key tools for this is the CSS Z-index property. Whether layering images, building complex menus, or creating interactive hover effects, Z-index ensures your content stacks in the correct order. This CSS property defines how elements ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:18261:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-11 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-10 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-107\"><p>In web design, managing the visual hierarchy of elements is essential for creating clean, user-friendly interfaces, and one of the key tools for this is the <a href=\"https://blog.hubspot.com/website/z-index\" target=\"_blank\" rel=\"noopener noreferrer\">CSS Z-index property</a>. Whether layering images, building complex menus, or creating interactive hover effects, Z-index ensures your content stacks in the correct order. This CSS property defines how elements are layered over one another, determining which one is visible on top when elements overlap.</p>\n<p>In <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a>, a powerful and flexible <a href=\"https://avada.com/features/\" target=\"_blank\" rel=\"noopener noreferrer\">Website Builder</a> for <a href=\"https://wordpress.org/\" target=\"_blank\" rel=\"noopener noreferrer\">WordPress</a>, Z-index becomes even more important as designers often work with intricate layouts featuring overlapping <a href=\"https://avada.com/blog/how-to-use-the-avada-column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Columns</a>, <a href=\"https://avada.com/blog/how-to-use-the-avada-container-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Containers</a>, and other <a href=\"https://avada.com/elements/\" target=\"_blank\" rel=\"noopener noreferrer\">Design Elements</a>. By properly using Z-index, you can ensure that your design behaves precisely as intended, whether keeping a menu in front of other content, ensuring interactive effects appear correctly, or handling <a href=\"https://avada.com/feature/off-canvas-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Off-Canvas</a> elements like sliding bars and popups.</p>\n<p>This blog post will explore the ins and outs of using Z-index within Avada. We&#8217;ll look at how to apply it to different elements, offer practical examples, and show you how to leverage this essential tool to maintain complete control over your design. Let&#8217;s get started!</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-93 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--5\" data-awb-toc-id=\"5\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-94 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">What Is The CSS Z-Index Property?</h2></div><div class=\"fusion-text fusion-text-108\"><p>Z-index is a CSS property that dictates how elements are stacked on the webpage. Elements with a higher <a href=\"https://avada.com/documentation/how-to-use-z-index-in-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">Z-index</a> value will appear above those with lower values. In <a href=\"https://avada.com/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a>, you can find the Z-index option in various components, including containers, columns, and other specific elements such as images, pagination, scroll progress elements, and Off-Canvas sections.</p>\n</div><div class=\"fusion-video fusion-youtube\" style=\"--awb-max-width:1280px;--awb-max-height:720px;--awb-align-self:center;--awb-width:100%;\"><div class=\"video-shortcode\"><priv-fac-lite-youtube class=\"fusion-hidden\" data-privacy-type=\"youtube\" videoid=\"Vv0pXwZAD5w\" class=\"landscape\" params=\"wmode=transparent&autoplay=1&enablejsapi=1\" title=\"YouTube video player 4\" width=\"1280\" height=\"720\" data-thumbnail-size=\"auto\"></priv-fac-lite-youtube><div class=\"fusion-privacy-placeholder\" style=\"width:1280px; height:720px;\" data-privacy-type=\"youtube\"><div class=\"fusion-privacy-placeholder-content\"><div class=\"fusion-privacy-label\">For privacy reasons YouTube needs your permission to be loaded.</div><button data-privacy-type=\"youtube\" class=\"fusion-button button-default fusion-button-default-size button fusion-privacy-consent\">I Accept</button></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-95 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Practical Examples of Z-Index in Avada</h2></div><div class=\"fusion-text fusion-text-109\"><p>Avada has a range of practical options that will allow you to apply z-index in your web design. Let&#8217;s take a closer look:</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-96 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Image Overlap Example</h3></div><div class=\"fusion-text fusion-text-110\"><p>One of the most common uses of Z-index is when dealing with overlapping images. For example, consider two images within a column. By adjusting the margin values of the second image, you can create an overlap. Typically, the image that appears later in the DOM (Document Object Model) will naturally be on top. However, with the Z-index property, you can manually control which image is in the foreground.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-40 hover-type-none\"><a href=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[e4babf68ce380252625]\" data-title=\"Overlapping Images in Avada\" title=\"Overlapping Images in Avada\"><img decoding=\"async\" width=\"1500\" height=\"600\" alt=\"Overlapping Images in Avada\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example.png\" class=\"img-responsive wp-image-895062\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example-200x80.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example-400x160.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example-600x240.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example-800x320.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example-1200x480.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-example.png 1500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1500px\" /></a></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-111\"><p>In this case, by going to the design tab of the first image and setting a Z-index value of 100, that image will now be on top. Your exact Z-index value will depend on how many elements are on the page. Still, a value of 100 is generally a safe choice to ensure the image is displayed above other elements.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-97 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Columns with Hover Effects</h3></div><div class=\"fusion-text fusion-text-112\"><p>You can add multiple Containers to a page and stack them one below the other. For instance, you may choose to have all of your content inside one Container or break your page into multiple Containers, each holding a distinct section of your content.</p>\n<p>This method offers greater flexibility in managing your layout, and you can name your Containers to keep your design organized. Containers may have different background images, colors, or layout styles, allowing for varied designs across a single page.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-98 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Menus and Navigation</h3></div><div class=\"fusion-text fusion-text-113\"><p>Z-index is also invaluable when dealing with menus, such as sticky menus, mobile menus, dropdown submenus, or mega menus. In these cases, the menus must stay above other page elements. For instance, when editing the container holding a menu in Avada, designers often assign a high Z-index value to ensure that the mega menu remains above all other content on the page. The following example is the <a href=\"https://avada.website/business/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Business</a> prebuilt website <a href=\"https://avada.com/feature/mega-menu-builder/\" target=\"_blank\" rel=\"noopener noreferrer\">Mega Menu</a>:</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-41 hover-type-none\" style=\"border:1px solid var(--awb-color2);\"><img decoding=\"async\" width=\"2500\" height=\"1448\" alt=\"Avada Mega Menu Example\" title=\"Avada Mega Menu Example\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu.png\" class=\"img-responsive wp-image-895069\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu-200x116.png 200w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu-400x232.png 400w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu-600x348.png 600w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu-800x463.png 800w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu-1200x695.png 1200w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-menu.png 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-114\"><p>When setting the Z-index for menus, it&#8217;s essential to apply it to the container holding the menu, not the column. While there is no set rule for the exact Z-index value, many designers opt for large values (such as increments of 100) to ensure enough flexibility if additional <a href=\"https://avada.com/documentation/avada-builder-elements/\" target=\"_blank\" rel=\"noopener noreferrer\">Elements</a> need to be added later.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-99 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Off-Canvas Elements</h3></div><div class=\"fusion-text fusion-text-115\"><p>Off-canvas elements, such as sliding bars or popups, also benefit from Z-index manipulation. These elements should always appear above other content, which is why they typically come with a default Z-index setting.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-42 hover-type-none\"><img decoding=\"async\" width=\"2500\" height=\"1554\" alt=\"Avada Off-Canvas Example\" title=\"Avada Off-Canvas Example\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas.jpg\" class=\"img-responsive wp-image-895070\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas-200x124.jpg 200w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas-400x249.jpg 400w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas-600x373.jpg 600w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas-800x497.jpg 800w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas-1200x746.jpg 1200w, https://avada.com/wp-content/uploads/2024/10/avada-zindex-post-off-canvas.jpg 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-116\"><p>However, in cases where multiple off-canvas elements or sticky headers are present, you may need to manually adjust the Z-index to ensure everything displays as intended.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-100 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Summary</h2></div><div class=\"fusion-text fusion-text-117\"><p>Z-index is an essential tool in web design, particularly when managing overlapping content. By experimenting with Z-index values, designers can control the visual hierarchy of their elements, ensuring that content is displayed in the correct order. Mastering Z-index in <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> will help create an engaging and functional design, whether Images, Columns, Menus, or Off-Canvas Elements.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://avada.com/blog/how-to-use-css-z-index-with-avada-in-web-design/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Avada Roadmap: December Progress Update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://avada.com/blog/avada-roadmap-december-progress-update/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://avada.com/blog/avada-roadmap-december-progress-update/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Dec 2024 15:16:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Theme Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Web Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:19:\"Website Maintenance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:341:\"Happy Holidays, everyone! In this latest roadmap installment, we will share Avada 8.0 progress and the latest Avada milestones with our community.  Avada 8 December Progress Update Following on from the November Roadmap post, our team has been hard at work on the new workflow enhancements, focusing on the Global Styles system. See some ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:26433:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-12 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-11 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-118\"><p>Happy Holidays, everyone! In this latest roadmap installment, we will share Avada 8.0 progress and the latest <a href=\"https://1.envato.market/jKdLZ\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> milestones with our community.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-top:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-101 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Avada 8 December Progress Update</h2></div><div class=\"fusion-text fusion-text-119\" style=\"--awb-text-transform:none;\"><p>Following on from the <a href=\"https://avada.com/blog/avada-roadmap-november-progress-update/\" target=\"_blank\" rel=\"noopener noreferrer\">November Roadmap post</a>, our team has been hard at work on the new workflow enhancements, focusing on the Global Styles system. See some of the highlights below.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-102 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">The Global Styles System</h2></div><div class=\"fusion-text fusion-text-120\" style=\"--awb-text-transform:none;\"><p>One of the most significant changes to the Avada workflow is the introduction of the new global styles system for Elements. This new feature will make designing and maintaining your Elements easy. Read on for further details and examples.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-103 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Default</span> Global Styles</h3></div><div class=\"fusion-text fusion-text-121\" style=\"--awb-text-transform:none;\"><p>Each element starts with a default global style. This is the style that the element will use when you insert it into the page. You can think of this as a new approach to our current Global Element Options. The significant change here is that every element option will be available for every element, providing you with complete global control. You will not just be limited to style options; you will also be able to control other, more advanced options, such as the button hover transition type, globally.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-104 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Custom</span> Global Styles</h3></div><div class=\"fusion-text fusion-text-122\" style=\"--awb-text-transform:none;\"><p>In addition to the default element global styles, you can create your own custom global styles. This allows you to create various element variations, which inherit from the default global style and remain globally controllable.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-105 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Visual Global Styles Examples</h2></div><div class=\"fusion-text fusion-text-123\" style=\"--awb-text-transform:none;\"><p>In the examples that follow, we have a setup with various button elements, consisting of 4 different global styles. There is the default button global style which is displayed at the top, then three different custom global styles.</p>\n<p>The first custom global style is a small square example which is set to be smaller and without border radius. Next to that there is a an outline example, which overrides the background and border. Finally there is a red button example which overrides the background color.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-106 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Editing The <span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Default</span> Global Styles</h3></div><div class=\"fusion-text fusion-text-124\" style=\"--awb-text-transform:none;\"><p>We have made some edits to the default global style in this example. The background color has been changed to green, and the border-radius has been reduced. If you hover over the image below, you can see how these changes cascade through the various elements.</p>\n</div><div class=\"fusion-image-before-after-wrapper type-switch hover-type-together fusion-image-before-after-wrapper-1\" style=\"--awb-font-size:13px;--awb-bordersize:0px;--awb-accent-color-bg:hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 85%));--awb-transition-time:0.5s;--awb-margin-bottom:20px;\"><div class=\"fusion-image-before-after-element fusion-image-switch fusion-image-before-after-1\"><img decoding=\"async\" alt=\"Default Global Styles\" class=\"fusion-image-switch-before\" src=\"https://avada.com/wp-content/uploads/2024/12/avada8-default-style-before.png\" width=\"1000\" height=\"500\"><img decoding=\"async\" alt=\"Default Global Styles\" class=\"fusion-image-switch-after\" src=\"https://avada.com/wp-content/uploads/2024/12/avada8-default-style-after.png\" width=\"1000\" height=\"500\"></a></div></div><div class=\"fusion-text fusion-text-125\" style=\"--awb-text-transform:none;\"><p><span style=\"color: var(--awb-text-color); font-family: var(--awb-text-font-family); font-size: var(--awb-font-size); font-style: var(--awb-text-font-style); font-weight: var(--awb-text-font-weight); letter-spacing: var(--awb-letter-spacing); text-align: var(--awb-content-alignment); text-transform: var(--awb-text-transform); background-color: var(--awb-bg-color-hover);\">For the background color change we can see that that the small square custom global style is now using the new color which it is inheriting from the default global style, but the other global styles which have their own background color are not impacted.</span></p>\n<p>Then, we can see that the opposite is true for the border-radius adjustment &#8211; the outline button style and the red button have been updated, but the small square custom global style remains square. The same can be seen in the mixed examples, which are set to use custom global styles.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-107 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Editing The <span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Custom</span> Global Styles</h3></div><div class=\"fusion-text fusion-text-126\"><p>In the next example, we have decided to add an icon by default to the outline button global style and adjusted the colors of both the outline button style and the red button style.</p>\n</div><div class=\"fusion-image-before-after-wrapper type-switch hover-type-together fusion-image-before-after-wrapper-2\" style=\"--awb-font-size:13px;--awb-bordersize:0px;--awb-accent-color-bg:hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 85%));--awb-transition-time:0.5s;\"><div class=\"fusion-image-before-after-element fusion-image-switch fusion-image-before-after-2\"><img decoding=\"async\" alt=\"Default Custom Styles\" class=\"fusion-image-switch-before\" src=\"https://avada.com/wp-content/uploads/2024/12/avada8-custom-style-before.png\" width=\"1000\" height=\"500\"><img decoding=\"async\" alt=\"Default Custom Styles\" class=\"fusion-image-switch-after\" src=\"https://avada.com/wp-content/uploads/2024/12/avada8-custom-style-after.png\" width=\"1000\" height=\"500\"></a></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-127\"><p>Again, these changes cascade down. The element examples using the red button style have been updated to use the new color, but the custom sizing and typography have remained. Likewise, both the outline examples now utilize the icon defined in the custom global style.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-108 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Speed Up Your Workflow</h2></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-43 hover-type-none\"><img decoding=\"async\" width=\"1200\" height=\"627\" alt=\"Speed Up Workflow Example\" title=\"Speed Up Workflow Example\" src=\"https://avada.com/wp-content/uploads/2024/12/avada8-speed-up-workflow.png\" class=\"img-responsive wp-image-895376\" srcset=\"https://avada.com/wp-content/uploads/2024/12/avada8-speed-up-workflow-200x105.png 200w, https://avada.com/wp-content/uploads/2024/12/avada8-speed-up-workflow-400x209.png 400w, https://avada.com/wp-content/uploads/2024/12/avada8-speed-up-workflow-600x314.png 600w, https://avada.com/wp-content/uploads/2024/12/avada8-speed-up-workflow-800x418.png 800w, https://avada.com/wp-content/uploads/2024/12/avada8-speed-up-workflow.png 1200w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1200px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-128\"><p>In addition to the new level of control, the new system also helps speed up your workflow dramatically. Instead of setting the same values on each element, you can now set this once to a global style and then select that on your elements. It also allows us to offer handy shortcuts, allowing you to save existing elements as global styles and copy and paste styles via the right-click context menu.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-109 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">FAQs</h2></div><div class=\"accordian fusion-accordian\" style=\"--awb-border-size:1px;--awb-icon-size:20px;--awb-content-font-size:16px;--awb-content-text-transform:none;--awb-icon-alignment:right;--awb-hover-color:var(--awb-color2);--awb-border-color:var(--awb-color4);--awb-background-color:var(--awb-color1);--awb-divider-color:#f6f6f6;--awb-divider-hover-color:var(--awb-color4);--awb-icon-color:#143876;--awb-title-color:#143876;--awb-content-color:#575757;--awb-icon-box-color:#143876;--awb-toggle-hover-accent-color:#143876;--awb-toggle-active-accent-color:var(--awb-color7);--awb-title-font-family:&quot;Basier Square Medium&quot;;--awb-title-font-weight:400;--awb-title-font-style:normal;--awb-title-text-transform:none;--awb-content-font-family:&quot;Basier Square Regular&quot;;--awb-content-font-style:normal;--awb-content-font-weight:400;\"><div class=\"panel-group fusion-toggle-icon-right fusion-toggle-icon-unboxed\" id=\"accordion-895367-1\"><div class=\"fusion-panel panel-default panel-851eab0bf50abcb5c fusion-toggle-has-divider\"><div class=\"panel-heading\"><h4 class=\"panel-title toggle\" id=\"toggle_851eab0bf50abcb5c\"><a aria-expanded=\"false\" aria-controls=\"851eab0bf50abcb5c\" role=\"button\" data-toggle=\"collapse\" data-parent=\"#accordion-895367-1\" data-target=\"#851eab0bf50abcb5c\" href=\"#851eab0bf50abcb5c\"><span class=\"fusion-toggle-icon-wrapper\" aria-hidden=\"true\"><i class=\"fa-fusion-box active-icon fa-angle-up fal\" aria-hidden=\"true\"></i><i class=\"fa-fusion-box inactive-icon fa-angle-right fal\" aria-hidden=\"true\"></i></span><span class=\"fusion-toggle-heading\">What is the ETA for Avada 8?</span></a></h4></div><div id=\"851eab0bf50abcb5c\" class=\"panel-collapse collapse \" aria-labelledby=\"toggle_851eab0bf50abcb5c\"><div class=\"panel-body toggle-content fusion-clearfix\">It is too early in the development process to give an exact ETA for Avada 8. Before release, we will have a public Beta and full launch announcements. 8 Will be the next major update; however, in the meantime, more maintenance releases will be pushed out.</div></div></div><div class=\"fusion-panel panel-default panel-689bc7921b581afc2 fusion-toggle-has-divider\"><div class=\"panel-heading\"><h4 class=\"panel-title toggle\" id=\"toggle_689bc7921b581afc2\"><a aria-expanded=\"false\" aria-controls=\"689bc7921b581afc2\" role=\"button\" data-toggle=\"collapse\" data-parent=\"#accordion-895367-1\" data-target=\"#689bc7921b581afc2\" href=\"#689bc7921b581afc2\"><span class=\"fusion-toggle-icon-wrapper\" aria-hidden=\"true\"><i class=\"fa-fusion-box active-icon fa-angle-up fal\" aria-hidden=\"true\"></i><i class=\"fa-fusion-box inactive-icon fa-angle-right fal\" aria-hidden=\"true\"></i></span><span class=\"fusion-toggle-heading\">Can I start building a website now or should I wait until Avada 8?</span></a></h4></div><div id=\"689bc7921b581afc2\" class=\"panel-collapse collapse \" aria-labelledby=\"toggle_689bc7921b581afc2\"><div class=\"panel-body toggle-content fusion-clearfix\">Building a new website with Avada should not be contingent on an upcoming version. Get started today!</div></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-110 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">New Creative Avada Content</h2></div><div class=\"fusion-text fusion-text-129\"><p>Our talented design team is constantly working on delivering new <a href=\"https://avada.website/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada pre-built websites</a> and <a href=\"https://avada.studio/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Studio</a> content for your web design toolkit, with more to come. Be on the lookout for awesome holiday season content coming soon! Below is just some of the latest content our team released in October.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-111 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Avada Studio</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-44 hover-type-none\"><img decoding=\"async\" width=\"2000\" height=\"714\" alt=\"Avada Studio Creative Content\" title=\"Avada Studio Creative Content\" src=\"https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content.png\" class=\"img-responsive wp-image-895171\" srcset=\"https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content-200x71.png 200w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content-400x143.png 400w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content-600x214.png 600w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content-800x286.png 800w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content-1200x428.png 1200w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-studio-content.png 2000w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2000px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-130\"><p>Our design team released a new range of creative content, including <a href=\"https://avada.com/blog/8-avada-studio-content-blocks-for-web-design-collection-28/\" target=\"_blank\" rel=\"noopener noreferrer\">marketing content</a>, sales forms, <a href=\"https://avada.com/blog/8-avada-studio-content-blocks-for-web-design-collection-27/\" target=\"_blank\" rel=\"noopener noreferrer\">templates</a>, and more.   There are 574 expertly crafted, ready-to-use content blocks that will streamline the design process, enabling you to customize stunning, professional-quality websites faster than ever.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-112 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Avada Websites</h3></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-45 hover-type-none\"><img decoding=\"async\" width=\"2500\" height=\"1690\" alt=\"Avada Factory Website\" title=\"Avada Factory Website\" src=\"https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website.png\" class=\"img-responsive wp-image-895170\" srcset=\"https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website-200x135.png 200w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website-400x270.png 400w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website-600x406.png 600w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website-800x541.png 800w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website-1200x811.png 1200w, https://avada.com/wp-content/uploads/2024/11/avada-roadmap-post-factory-website.png 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-131\"><p>The most recent Avada Websites released are <a href=\"https://avada.website/factory/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Factory</a> <span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">*popular</span>, <a href=\"https://avada.website/campaign/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Campaign</a>, and <a href=\"https://avada.website/vape/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Vape</a>. With more than 100 highly customizable Avada pre-built websites that can be imported with a few clicks, Avada&#8217;s creative resources will speed up your web design workflow.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-113 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">TL; DR</h2></div><div class=\"fusion-text fusion-text-132\"><p>In summary, our team is working flat out with one goal in mind: To bring you the best website-building platform available. <a href=\"https://1.envato.market/jKdLZ\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> 8.0&#8217;s extended development cycle reflects our unwavering commitment to quality and innovation.</p>\n<p>We encourage you to subscribe to our social media platforms to stay tuned for future updates regarding Avada 8, creative Avada Studio content, and pre-built Avada websites.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-social-links fusion-social-links-1\" style=\"--awb-margin-top:0px;--awb-margin-right:0px;--awb-margin-bottom:0px;--awb-margin-left:0px;--awb-alignment:center;--awb-box-border-top:0px;--awb-box-border-right:0px;--awb-box-border-bottom:0px;--awb-box-border-left:0px;--awb-icon-colors-hover:hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc(var(--awb-color8-a) - 80%));--awb-box-colors-hover:var(--awb-color1);--awb-box-border-color:var(--awb-color3);--awb-box-border-color-hover:var(--awb-color4);\"><div class=\"fusion-social-networks boxed-icons color-type-custom\"><div class=\"fusion-social-networks-wrapper\"><a class=\"fusion-social-network-icon fusion-tooltip fusion-facebook awb-icon-facebook\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"Facebook\" data-toggle=\"tooltip\" title=\"Facebook\" aria-label=\"facebook\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://www.facebook.com/ThemeFusion-101565403356430/\"></a><a class=\"fusion-social-network-icon fusion-tooltip fusion-twitter awb-icon-twitter\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"X\" data-toggle=\"tooltip\" title=\"X\" aria-label=\"twitter\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://twitter.com/theme_fusion\"></a><a class=\"fusion-social-network-icon fusion-tooltip fusion-instagram awb-icon-instagram\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"Instagram\" data-toggle=\"tooltip\" title=\"Instagram\" aria-label=\"instagram\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://www.instagram.com/themefusion/\"></a><a class=\"fusion-social-network-icon fusion-tooltip fusion-youtube awb-icon-youtube\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"YouTube\" data-toggle=\"tooltip\" title=\"YouTube\" aria-label=\"youtube\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://www.youtube.com/@avadavideos\"></a></div></div></div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://avada.com/blog/avada-roadmap-december-progress-update/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Important Changes to the Avada Instagram Element\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://avada.com/blog/important-changes-to-the-avada-instagram-element/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://avada.com/blog/important-changes-to-the-avada-instagram-element/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Dec 2024 16:16:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:13:\"Theme Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:15:\"Web Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"Instagram recently informed users that it will phase out its Basic Display API. Until now, Avada (as well as most of the Instagram plugins for WordPress) has relied on that API to connect Instagram accounts to a user’s website and display the feed. The Basic Display API will be deprecated as of December 4, 2024, ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10516:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-13 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-12 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-133\"><p>Instagram recently informed users that it will <a href=\"https://developers.facebook.com/blog/post/2024/09/04/update-on-instagram-basic-display-api/\" target=\"_blank\" rel=\"noopener noreferrer\">phase out its Basic Display API</a>. Until now, <a href=\"https://1.envato.market/jKdLZ\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> (as well as most of the Instagram plugins for WordPress) has relied on that API to connect Instagram accounts to a user’s website and display the feed.</p>\n<p>The Basic Display API will be deprecated as of <strong>December 4, 2024,</strong> affecting anyone using the <a href=\"https://avada.com/element/instagram/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Instagram Element</a> on their site. But don’t worry; we have you covered. This post will provide some background information and the next steps. Let us first examine the background of this change.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-top:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-114 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">The Background</h2></div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-46 hover-type-none\"><img decoding=\"async\" width=\"1500\" height=\"400\" alt=\"Instagram and Avada\" title=\"Avada Instagram Element\" src=\"https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt.png\" class=\"img-responsive wp-image-895358\" srcset=\"https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt-200x53.png 200w, https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt-400x107.png 400w, https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt-600x160.png 600w, https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt-800x213.png 800w, https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt-1200x320.png 1200w, https://avada.com/wp-content/uploads/2024/12/instagram-api-post-internal-alt.png 1500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1500px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-134\" style=\"--awb-text-transform:none;\"><p>To handle authentication requests to any of the Meta APIs, any 3rd party business that wants to provide a service to their customers (like the <a href=\"https://avada.com/documentation/instagram-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Instagram Element</a>) must register their own App with Meta. Meta investigates such an app heavily to ensure its data usage complies with all its regulations. While we had a working App registered with Meta until now, due to their changes, it will become obsolete. We have had to register a new App with them and go through all of the approval procedures, which turned out to be running the gauntlet.</p>\n<p>While waiting for approval for quite some time, we could get our app registered and work with Meta earlier this week to deliver the updates to our customers on time.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-115 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">How to Adapt</h2></div><div class=\"fusion-text fusion-text-135\"><p>The new authentication process will be part of the upcoming Avada 7.11.12 update. In the interim, until this update is sent out, we will release an <a href=\"https://avada.com/documentation/avada-patcher/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Patch</a> for this functionality so that everyone can update their Avada installations. If you have an Instagram business or creator account, all you have to do is reconnect your account to your site, as described in this <a href=\"https://avada.com/documentation/instagram-element/#toc_Connect_Your_Instagram_Account\" target=\"_blank\" rel=\"noopener noreferrer\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Avada help file</span></a></p>\n<p>If you use a personal account, you must perform a few additional steps. Unfortunately, Meta has decided that moving forward, they won’t allow access to personal accounts via their APIs any longer, meaning that starting <strong>December 4, 2024</strong>, only creator and business account feeds can be displayed outside of <a href=\"https://www.instagram.com/\" target=\"_blank\" rel=\"noopener noreferrer\">Instagram</a>.</p>\n<p><strong>There is good news!</strong> A personal account can be changed to either a creator or a business account quickly and for free (and you can revert at any time). Please find the necessary steps in this <a href=\"https://help.instagram.com/502981923235522?cms_id=502981923235522\" target=\"_blank\" rel=\"noopener noreferrer\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Instagram help file</span></a></p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-116 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">TL; DR</h2></div><div class=\"fusion-text fusion-text-136\"><p>Starting <strong>December 4, 2024</strong>, Meta is phasing out its Instagram <strong>Basic Display API</strong>, meaning that personal Instagram account feeds won’t automatically update on your website. To get your Instagram feed back on track, install the <strong>Avada Patch</strong> and switch to an Instagram creator or business account.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-social-links fusion-social-links-2\" style=\"--awb-margin-top:0px;--awb-margin-right:0px;--awb-margin-bottom:0px;--awb-margin-left:0px;--awb-alignment:center;--awb-box-border-top:0px;--awb-box-border-right:0px;--awb-box-border-bottom:0px;--awb-box-border-left:0px;--awb-icon-colors-hover:hsla(var(--awb-color8-h),var(--awb-color8-s),var(--awb-color8-l),calc(var(--awb-color8-a) - 80%));--awb-box-colors-hover:var(--awb-color1);--awb-box-border-color:var(--awb-color3);--awb-box-border-color-hover:var(--awb-color4);\"><div class=\"fusion-social-networks boxed-icons color-type-custom\"><div class=\"fusion-social-networks-wrapper\"><a class=\"fusion-social-network-icon fusion-tooltip fusion-facebook awb-icon-facebook\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"Facebook\" data-toggle=\"tooltip\" title=\"Facebook\" aria-label=\"facebook\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://www.facebook.com/ThemeFusion-101565403356430/\"></a><a class=\"fusion-social-network-icon fusion-tooltip fusion-twitter awb-icon-twitter\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"X\" data-toggle=\"tooltip\" title=\"X\" aria-label=\"twitter\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://twitter.com/theme_fusion\"></a><a class=\"fusion-social-network-icon fusion-tooltip fusion-instagram awb-icon-instagram\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"Instagram\" data-toggle=\"tooltip\" title=\"Instagram\" aria-label=\"instagram\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://www.instagram.com/themefusion/\"></a><a class=\"fusion-social-network-icon fusion-tooltip fusion-youtube awb-icon-youtube\" style=\"color:var(--awb-color8);font-size:24px;width:24px;background-color:var(--awb-color3);border-color:var(--awb-color3);border-radius:4px;\" data-placement=\"top\" data-title=\"YouTube\" data-toggle=\"tooltip\" title=\"YouTube\" aria-label=\"youtube\" target=\"_blank\" rel=\"noopener noreferrer nofollow\" href=\"https://www.youtube.com/@avadavideos\"></a></div></div></div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://avada.com/blog/important-changes-to-the-avada-instagram-element/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:82:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"How to Manage Your Avada Licenses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://avada.com/blog/how-to-manage-your-avada-licenses/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://avada.com/blog/how-to-manage-your-avada-licenses/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Dec 2024 10:51:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"My Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:15:\"Tutorial Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"Managing your Avada licenses has never been more accessible, thanks to the comprehensive features on the My Avada support and license management portal. For those new to the platform or looking for guidance, here\'s a detailed walkthrough of how to efficiently handle your Avada licenses and ensure the smooth operation of your web products.  ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:18540:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-14 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-13 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-137\"><p>Managing your <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> licenses has never been more accessible, thanks to the comprehensive features on the <a href=\"https://avada.com/blog/my-avada-dot-com/\" target=\"_blank\" rel=\"noopener noreferrer\">My Avada support and license management portal</a>. For those new to the platform or looking for guidance, here&#8217;s a detailed walkthrough of how to efficiently handle your <a href=\"https://avada.com/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> licenses and ensure the smooth operation of your web products.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-117 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--6\" data-awb-toc-id=\"6\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-118 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Accessing The My Avada Portal</h2></div><div class=\"fusion-text fusion-text-138\"><p>To begin managing your licenses, navigate to the <a href=\"https://my.avada.com/\" target=\"_blank\" rel=\"noopener noreferrer\">My Avada portal</a>, which is accessible here. If you haven&#8217;t registered for an Avada Support account yet, watch the <a href=\"https://avada.com/documentation/how-to-register-for-my-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">How to Register for My Avada</a> video for a step-by-step guide. Once registered, log in to access your account dashboard.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-47 hover-type-none\"><img decoding=\"async\" width=\"1600\" height=\"1000\" alt=\"My Avada Login Screen\" title=\"My Avada Login Screen\" src=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login.png\" class=\"img-responsive wp-image-895033\" srcset=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login-200x125.png 200w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login-400x250.png 400w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login-600x375.png 600w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login-800x500.png 800w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login-1200x750.png 1200w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-login.png 1600w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 1600px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-139\"><p>The dashboard provides a snapshot of all your licenses and various options for managing them. The <a href=\"https://avada.com/documentation/how-to-use-my-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">How to Use My Avada</a> video offers a complete overview of the portal&#8217;s features; however, in this article, we&#8217;ll focus on managing your licenses specifically.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-119 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">How To Manage Licenses</h2></div><div class=\"fusion-video fusion-youtube\" style=\"--awb-max-width:1280px;--awb-max-height:720px;--awb-align-self:center;--awb-width:100%;\"><div class=\"video-shortcode\"><priv-fac-lite-youtube class=\"fusion-hidden\" data-privacy-type=\"youtube\" videoid=\"lk_AlGCHJNs\" class=\"landscape\" params=\"wmode=transparent&autoplay=1&enablejsapi=1\" title=\"YouTube video player 5\" width=\"1280\" height=\"720\" data-thumbnail-size=\"auto\"></priv-fac-lite-youtube><div class=\"fusion-privacy-placeholder\" style=\"width:1280px; height:720px;\" data-privacy-type=\"youtube\"><div class=\"fusion-privacy-placeholder-content\"><div class=\"fusion-privacy-label\">For privacy reasons YouTube needs your permission to be loaded.</div><button data-privacy-type=\"youtube\" class=\"fusion-button button-default fusion-button-default-size button fusion-privacy-consent\">I Accept</button></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-140\"><p>Once inside the My Avada Dashboard, you can see a summary of all your licenses at the top. You&#8217;ll also notice a section providing a quick overview of the most recent licenses. To manage all your licenses, click the <strong>&#8220;Manage Licenses&#8221;</strong> link or select <strong>&#8220;Licenses&#8221;</strong> from the top menu.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-48 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-48\" style=\"border:1px solid var(--awb-color2);\"><a href=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[5c06cd08307185ddb0b]\" data-title=\"Avada Dashboard\" title=\"Avada Dashboard\"><img decoding=\"async\" width=\"2780\" height=\"2886\" alt=\"Avada Dashboard\" src=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard.png\" class=\"img-responsive wp-image-895035\" srcset=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard-200x208.png 200w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard-400x415.png 400w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard-600x623.png 600w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard-800x831.png 800w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard-1200x1246.png 1200w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-dashboard.png 2780w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2780px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-141\"><p>The licenses management page contains helpful search and filtering options. You can search for a license by domain name or purchase code and use filters to sort licenses by their status: <strong>&#8220;Active,&#8221;</strong> <strong>&#8220;Locked,&#8221;</strong> or <strong>&#8220;All.&#8221;</strong> For example, if you search by the term <strong>&#8220;Avada,&#8221;</strong> you will quickly see all relevant licenses connected to that domain. Additionally, if any licenses are locked, you can contact support directly from this page to resolve the issue.</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-liftup-border-radius:0px;--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><div class=\"awb-image-frame awb-image-frame-49 imageframe-liftup\"><span class=\" fusion-imageframe imageframe-none imageframe-49\" style=\"border:1px solid var(--awb-color2);\"><a href=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses.png\" class=\"fusion-lightbox\" data-rel=\"iLightbox[509747b76b31fdccd6e]\" data-title=\"Manage Avada Licenses\" title=\"Manage Avada Licenses\"><img decoding=\"async\" width=\"2860\" height=\"2368\" alt=\"Manage Avada Licenses\" src=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses.png\" class=\"img-responsive wp-image-895036\" srcset=\"https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses-200x166.png 200w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses-400x331.png 400w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses-600x497.png 600w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses-800x662.png 800w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses-1200x994.png 1200w, https://avada.com/wp-content/uploads/2024/10/my-avada-portal-post-manage-licenses.png 2860w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2860px\" /></a></span></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-142\"><p>To check your current license data information, a <strong>&#8220;Refresh All&#8221;</strong> button checks for any changes in license status, such as recently registered or unregistered licenses.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-120 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Individual Licenses</h3></div><div class=\"fusion-text fusion-text-143\"><p>When viewing an individual license, you&#8217;ll see detailed information, including the purchase code, license status, and purchase date. You can also view the licenses&#8217; associated domains—both the live domain and the staging domain (if applicable). Each license allows one live domain and one staging domain, making managing your projects&#8217; development and production environment easy.</p>\n<p>One important feature is the ability to unregister a license from a domain. Under the terms of the Avada license, each license is valid for a single website project according to <a href=\"https://themeforest.net/licenses/terms/regular\" target=\"_blank\" rel=\"noopener noreferrer\">Envato&#8217;s licensing terms and conditions</a>. However, you can reuse the license on a new project if the old site is completely removed (no longer online). If you forgot to unregister the license before deleting the site, you can do so directly from the My Avada portal. Click the <strong>&#8220;Unlink&#8221;</strong> icon to unregister the license and make it available for a new domain.</p>\n<p>Suppose you&#8217;ve updated the website to which a license is linked. In that case, clicking the <strong>&#8220;Refresh All&#8221;</strong> button will update the domain information in the portal, reflecting the current license connection.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-121 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">License Deletion and Transfer</h3></div><div class=\"fusion-text fusion-text-144\"><p>The My Avada portal also allows you to delete a license from your account if needed. However, remember that deleting a license only removes it from your My Avada account. This feature is helpful if, for example, you need to transfer a license to a different account, such as when an agency passes the purchase code to an end user.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-122 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Adding New Licenses</h3></div><div class=\"fusion-text fusion-text-145\"><p>If you have new licenses to add to your account, the &#8220;Add New License&#8221; button provides a simple process. You can manually enter a single purchase code or use the <strong>&#8220;Import from Envato&#8221;</strong> bulk import option. This allows you to import all licenses associated with <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">your ThemeForest account</a>.</p>\n<p>After signing in to the Envato API with your ThemeForest credentials and authorizing the connection, any new licenses will be automatically added to your My Avada account.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-123 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Resources</h2></div><div class=\"fusion-text fusion-text-146\"><p>For any additional questions, Avada provides a comprehensive <a href=\"https://avada.com/documentation/avada-registration-and-licensing-faq/\" target=\"_blank\" rel=\"noopener noreferrer\">Licensing and Registration FAQ</a> document that addresses many common inquiries.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-124 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Summary</h2></div><div class=\"fusion-text fusion-text-147\"><p>Managing your Avada licenses has never been simpler! With the My Avada support and license management portal, you can easily view, organize, and control all your licenses in one place. Whether you&#8217;re managing a single project or multiple domains, the portal offers powerful tools like search, filtering, and quick license refreshes to keep everything up to date.</p>\n<p>Effortlessly unregister licenses, transfer them between accounts, and add new ones from your ThemeForest profile with just a few clicks. Plus, with detailed video guides and a comprehensive FAQ, you&#8217;ll have all the support you need at your fingertips.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://avada.com/blog/how-to-manage-your-avada-licenses/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"How to Create Overlapping Images Using Avada And WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://avada.com/blog/how-to-create-overlapping-images-using-avada-and-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://avada.com/blog/how-to-create-overlapping-images-using-avada-and-wordpress/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Nov 2024 10:34:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:5:\"Avada\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:15:\"Beginners Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Tutorial Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"Web Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://avada.com/blog//\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"Overlapping images is a dynamic way to add a visual accent to your website, allowing for a memorable design. It involves placing text or another image on top of a base image. This technique is commonly used in posters, advertisements, and even memes, but the creative potential goes far beyond these examples. While traditional tools ...\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"michaelb\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:25249:\"<div class=\"fusion-fullwidth fullwidth-box fusion-builder-row-15 fusion-flex-container has-pattern-background has-mask-background nonhundred-percent-fullwidth non-hundred-percent-height-scrolling\" style=\"--awb-border-radius-top-left:0px;--awb-border-radius-top-right:0px;--awb-border-radius-bottom-right:0px;--awb-border-radius-bottom-left:0px;--awb-flex-wrap:wrap;\" ><div class=\"fusion-builder-row fusion-row fusion-flex-align-items-flex-start fusion-flex-content-wrap\" style=\"max-width:1331.2px;margin-left: calc(-4% / 2 );margin-right: calc(-4% / 2 );\"><div class=\"fusion-layout-column fusion_builder_column fusion-builder-column-14 fusion_builder_column_1_1 1_1 fusion-flex-column\" style=\"--awb-bg-size:cover;--awb-width-large:100%;--awb-margin-top-large:20px;--awb-spacing-right-large:1.92%;--awb-margin-bottom-large:20px;--awb-spacing-left-large:1.92%;--awb-width-medium:100%;--awb-order-medium:0;--awb-spacing-right-medium:1.92%;--awb-spacing-left-medium:1.92%;--awb-width-small:100%;--awb-order-small:0;--awb-spacing-right-small:1.92%;--awb-spacing-left-small:1.92%;\"><div class=\"fusion-column-wrapper fusion-column-has-shadow fusion-flex-justify-content-flex-start fusion-content-layout-column\"><div class=\"fusion-text fusion-text-148\"><p>Overlapping images is a dynamic way to add a visual accent to your website, allowing for a <a href=\"https://avada.com/blog/a-beginners-guide-to-web-aesthetics-and-memorable-design/\" target=\"_blank\" rel=\"noopener noreferrer\">memorable design</a>. It involves placing text or another image on top of a base image. This technique is commonly used in posters, advertisements, and even memes, but the creative potential goes far beyond these examples.</p>\n<p>While traditional tools like <a href=\"https://www.adobe.com/creativecloud/photography/discover/overlay-images.html\" target=\"_blank\" rel=\"noopener noreferrer\">Adobe Photoshop</a> are still practical for creating static image overlays, modern Website Builders like <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> offers an alternate solution. This blog post will explore two easy methods for creating overlapping images using <a href=\"https://avada.com/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a> image transform and margin settings. These methods allow you to create visually engaging designs without relying on external image editing tools.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-125 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overview</h2></div><div class=\"awb-toc-el awb-toc-el--7\" data-awb-toc-id=\"7\" data-awb-toc-options=\"{&quot;allowed_heading_tags&quot;:{&quot;h2&quot;:0,&quot;h3&quot;:1},&quot;ignore_headings&quot;:&quot;.awb-toc-el__list.awb-toc-el__list--0 li:first-child&quot;,&quot;ignore_headings_words&quot;:&quot;&quot;,&quot;enable_cache&quot;:&quot;yes&quot;,&quot;highlight_current_heading&quot;:&quot;no&quot;,&quot;hide_hidden_titles&quot;:&quot;yes&quot;,&quot;limit_container&quot;:&quot;post_content&quot;,&quot;select_custom_headings&quot;:&quot;&quot;,&quot;icon&quot;:&quot;fa-angle-right far&quot;,&quot;counter_type&quot;:&quot;custom_icon&quot;}\" style=\"--awb-item-font-size:var(--awb-typography4-font-size);--awb-item-line-height:var(--awb-typography4-line-height);--awb-item-letter-spacing:var(--awb-typography4-letter-spacing);--awb-item-text-transform:var(--awb-typography4-text-transform);--awb-item-color:var(--awb-color8);--awb-item-color-hover:var(--awb-color5);--awb-item-bg-color-hover:rgba(101,189,125,0);--awb-counter-color:var(--awb-color6);--awb-hover-counter-color:var(--awb-color5);--awb-list-indent:15px;--awb-item-padding-top:3px;--awb-item-padding-right:0;--awb-item-padding-bottom:5px;--awb-item-padding-left:0;--awb-item-font-family:var(--awb-typography4-font-family);--awb-item-font-weight:var(--awb-typography4-font-weight);--awb-item-font-style:var(--awb-typography4-font-style);\"><div class=\"awb-toc-el__content\"></div></div>\n<div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-126 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Why Overlapping Images?</h2></div><div class=\"fusion-text fusion-text-149\"><p>Overlapping images can add depth and interest to your layout in various situations. Whether you&#8217;re working on a creative portfolio or a marketing page, they can create a layered, three-dimensional effect. In this tutorial, we&#8217;ll explore how to achieve this using Avada&#8217;s built-in features, focusing on two primary methods: transforming columns and manipulating image margins.</p>\n</div><div class=\"fusion-video fusion-youtube\" style=\"--awb-max-width:1280px;--awb-max-height:720px;--awb-align-self:center;--awb-width:100%;\"><div class=\"video-shortcode\"><priv-fac-lite-youtube class=\"fusion-hidden\" data-privacy-type=\"youtube\" videoid=\"fgvpe-kz26c\" class=\"landscape\" params=\"wmode=transparent&autoplay=1&enablejsapi=1\" title=\"YouTube video player 6\" width=\"1280\" height=\"720\" data-thumbnail-size=\"auto\"></priv-fac-lite-youtube><div class=\"fusion-privacy-placeholder\" style=\"width:1280px; height:720px;\" data-privacy-type=\"youtube\"><div class=\"fusion-privacy-placeholder-content\"><div class=\"fusion-privacy-label\">For privacy reasons YouTube needs your permission to be loaded.</div><button data-privacy-type=\"youtube\" class=\"fusion-button button-default fusion-button-default-size button fusion-privacy-consent\">I Accept</button></div></div></div></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:50px;width:100%;\"></div><div class=\"fusion-title title fusion-title-127 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Method 1:</span> Using Column Transform Options</h2></div><div class=\"fusion-text fusion-text-150\"><p>The first method involves using the transform settings on the columns that contain your images. Here&#8217;s how you can do it:</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-50 hover-type-none\"><img decoding=\"async\" width=\"2500\" height=\"1675\" alt=\"Avada Overlapping Images\" title=\"Avada Overlapping Images\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1.jpg\" class=\"img-responsive wp-image-895064\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1-200x134.jpg 200w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1-400x268.jpg 400w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1-600x402.jpg 600w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1-800x536.jpg 800w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1-1200x804.jpg 1200w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-1.jpg 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-128 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Set Up Columns</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-12 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Start with two Columns containing an <a href=\"https://avada.com/element/image/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Image Element</a>.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-title title fusion-title-129 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Adjust the Transform Values</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-13 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Edit the column containing the image you want to overlap.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Go to the <strong>&#8220;Extras&#8221;</strong> tab to find the transform options.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Set a <strong>TranslateX</strong> value to move the image horizontally and a <strong>TranslateY</strong> value to adjust the vertical position.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">For example, a <strong>TranslateX</strong> value of <strong>-127px</strong> and a <strong>TranslateY</strong> value of <strong>58px</strong> will shift the column, causing the image on the right to overlap with the image on the left.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-title title fusion-title-130 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Control the Z-index</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-14 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">By default, images later in the <a href=\"https://developer.mozilla.org/en-US/docs/Web/API/Document_Object_Model/Introduction\" target=\"_blank\" rel=\"noopener noreferrer\">DOM hierarchy</a> (or lower down the page) will appear above others. However, suppose you want to adjust the layering. In that case, you can assign a <strong>z-index</strong> value to control which image appears on top. For instance, setting the <strong>z-index</strong> of the left column to 100 will bring that image above the one on the right.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-title title fusion-title-131 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Ensure Consistency on Hover</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-15 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">If you&#8217;re applying hover effects, remember to duplicate the translate values in the hover state settings to keep the images overlapping while hovering. You can also add creative effects like rotating images when hovered by adjusting the rotate value.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-132 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\"><span class=\"fusion-highlight light highlight1 awb-highlight-background rounded\" style=\"--awb-color:var(--awb-custom_color_1);\">Method 2:</span> Using Image Margins</h2></div><div class=\"fusion-text fusion-text-151\"><p>The second method is similar but involves manipulating the margins of the images directly rather than the columns:</p>\n</div><div class=\"fusion-image-element \" style=\"--awb-caption-title-font-family:var(--h2_typography-font-family);--awb-caption-title-font-weight:var(--h2_typography-font-weight);--awb-caption-title-font-style:var(--h2_typography-font-style);--awb-caption-title-size:var(--h2_typography-font-size);--awb-caption-title-transform:var(--h2_typography-text-transform);--awb-caption-title-line-height:var(--h2_typography-line-height);--awb-caption-title-letter-spacing:var(--h2_typography-letter-spacing);\"><span class=\" fusion-imageframe imageframe-none imageframe-51 hover-type-none\"><img decoding=\"async\" width=\"2500\" height=\"1538\" alt=\"Avada Overlapping Images\" title=\"Avada Overlapping Images\" src=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2.jpg\" class=\"img-responsive wp-image-895065\" srcset=\"https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2-200x123.jpg 200w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2-400x246.jpg 400w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2-600x369.jpg 600w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2-800x492.jpg 800w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2-1200x738.jpg 1200w, https://avada.com/wp-content/uploads/2024/10/avada-overlapping-images-post-method-2.jpg 2500w\" sizes=\"(max-width: 1024px) 100vw, (max-width: 640px) 100vw, 2500px\" /></span></div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-133 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Adjust the Image Margins</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-16 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Select the image you want to overlap and head to the <strong>&#8220;Design&#8221;</strong> tab.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Apply negative margin values. For example, setting a top margin of <strong>-58px</strong> and a left margin of <strong>-127px</strong> will move the image up and to the left, causing it to overlap with the adjacent image.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-title title fusion-title-134 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Breaking Out of the Column</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-17 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Unlike the transform method, negative margins allow the image to break out of the boundaries of the Column, providing more flexibility. This can make the image appear more prominent than its counterpart in the first method, where the <a href=\"https://avada.com/blog/how-to-use-the-avada-column-element/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Column</a> contains the image.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-135 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Overlapping Images in a Single Column</h2></div><div class=\"fusion-text fusion-text-152\"><p>If you&#8217;re working with a single column and want to stack and overlap images vertically, you can still achieve this with margin settings:</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:10px;width:100%;\"></div><div class=\"fusion-title title fusion-title-136 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Stack Images</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-18 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Insert two images in a single <a href=\"https://avada.com/element/column/\" target=\"_blank\" rel=\"noopener noreferrer\">Column</a>.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-title title fusion-title-137 fusion-sep-none fusion-title-text fusion-title-size-three\"><h3 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Apply Negative Margins</h3></div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-19 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">Adjust the top margin of the second image. For example, setting a top margin of <strong>-550px</strong> will move it upwards, covering the first image.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">You can also shift the second image horizontally by adjusting the left margin (e.g., <strong>650px</strong>), creating a side-by-side overlap.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-153\"><p>If you apply a rotation effect, this method allows both images to rotate in unison, as they share the same column.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-138 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Combining Methods for Advanced Layouts</h2></div><div class=\"fusion-text fusion-text-154\"><p>Avada&#8217;s flexibility allows you to combine different techniques to create more complex designs. For example, you can create a layout with:</p>\n</div><ul style=\"--awb-line-height:27.2px;--awb-icon-width:27.2px;--awb-icon-height:27.2px;--awb-icon-margin:11.2px;--awb-content-margin:38.4px;\" class=\"fusion-checklist fusion-checklist-20 fusion-checklist-default type-icons\"><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A Container that includes a background image.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A 60% Column containing an Image and an <a href=\"https://avada.com/element/title/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Title Element</a>.</div></li><li class=\"fusion-li-item\" style=\"\"><span class=\"icon-wrapper circle-no\"><i class=\"fusion-li-icon fa-angle-double-right fal\" aria-hidden=\"true\"></i></span><div class=\"fusion-li-item-content\">A 40% Column with two overlapping images manipulated by margin settings.</div></li></ul><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:20px;width:100%;\"></div><div class=\"fusion-text fusion-text-155\"><p>In cases where you need to control which image appears on top, adjusting the <strong>z-index</strong> values will help you achieve the desired layering effect.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-139 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Considerations for Responsive Design</h2></div><div class=\"fusion-text fusion-text-156\"><p>While these overlapping effects look great on desktops, they may not work well on smaller screens. In the example, the images become too large to display on medium and mobile screens. A good solution is to use <a href=\"https://avada.com/documentation/how-to-use-rendering-logic-in-avada/\" target=\"_blank\" rel=\"noopener noreferrer\">Avada Rendering Logic</a> to hide these overlapping containers on smaller screens and create separate containers optimized for mobile views.</p>\n</div><div class=\"fusion-separator fusion-full-width-sep\" style=\"align-self: center;margin-left: auto;margin-right: auto;margin-bottom:30px;width:100%;\"></div><div class=\"fusion-title title fusion-title-140 fusion-sep-none fusion-title-text fusion-title-size-two\"><h2 class=\"fusion-title-heading title-heading-left\" style=\"margin:0;text-transform:capitalize;\">Summary</h2></div><div class=\"fusion-text fusion-text-157\"><p>With <a href=\"https://1.envato.market/e4rPJ1\" target=\"_blank\" rel=\"noopener noreferrer\">Avada</a>, overlapping images can be easily achieved by manipulating transform options on Columns or adjusting image margins. Both methods provide unique flexibility and design possibilities for your website. Experimenting with these settings can help you create visually dynamic layouts that capture your visitors&#8217; attention.</p>\n</div></div></div></div></div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://avada.com/blog/how-to-create-overlapping-images-using-avada-and-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:23:\"https://avada.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:17:{s:4:\"date\";s:29:\"Thu, 09 Jan 2025 15:21:33 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:49:\"Accept-Encoding, Accept-Encoding, Accept-Encoding\";s:12:\"x-powered-by\";s:9:\"WP Engine\";s:13:\"last-modified\";s:29:\"Thu, 09 Jan 2025 15:07:13 GMT\";s:4:\"etag\";s:36:\"W/\"050664bad387a74e617b45cbeea7b81d\"\";s:4:\"link\";s:54:\"<https://avada.com/wp-json/>; rel=\"https://api.w.org/\"\";s:11:\"x-cacheable\";s:17:\"CacheAlways: feed\";s:13:\"cache-control\";s:28:\"max-age=600, must-revalidate\";s:7:\"x-cache\";s:8:\"HIT: 537\";s:20:\"x-orig-cache-control\";s:28:\"max-age=600, must-revalidate\";s:16:\"content-encoding\";s:4:\"gzip\";s:15:\"cf-cache-status\";s:7:\"DYNAMIC\";s:10:\"set-cookie\";s:254:\"__cf_bm=..VzAJxPRPAre.q16nJGjxsi09sECT5hXDdqSB4Cors-1736436093-1.0.1.1-wtUUPOHz.OTWrj_1LRn.ZD81bEc6x1_gegtvYjUWa897vCbi.aAiUvvEQIC5GOOwrbWx8vjE5.odVFNhffaZ1A; path=/; expires=Thu, 09-Jan-25 15:51:33 GMT; domain=.avada.com; HttpOnly; Secure; SameSite=None\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"8ff56aefeb622a26-CDG\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:5:\"build\";i:1735311133;s:21:\"cache_expiration_time\";i:1736479293;s:23:\"__cache_expiration_time\";i:1736491416;}", "off");
INSERT INTO `wor6069_options` VALUES("15187", "_site_transient_timeout_community-events-4994e370a4d24a22cc76255ede6d00fa", "1736455118", "off");
INSERT INTO `wor6069_options` VALUES("15188", "_site_transient_community-events-4994e370a4d24a22cc76255ede6d00fa", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:20:\"2001:861:3bc2:9b20::\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:19:\"Afterwork WordPress\";s:3:\"url\";s:68:\"https://www.meetup.com/wordpress-meetup-montpellier/events/304559450\";s:6:\"meetup\";s:28:\"WordPress Meetup Montpellier\";s:10:\"meetup_url\";s:52:\"https://www.meetup.com/WordPress-Meetup-Montpellier/\";s:4:\"date\";s:19:\"2025-01-14 19:00:00\";s:8:\"end_date\";s:19:\"2025-01-14 22:00:00\";s:20:\"start_unix_timestamp\";i:1736877600;s:18:\"end_unix_timestamp\";i:1736888400;s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Montpellier , France\";s:7:\"country\";s:2:\"FR\";s:8:\"latitude\";d:43.60139;s:9:\"longitude\";d:3.876853;}}}}", "off");
INSERT INTO `wor6069_options` VALUES("15189", "_transient_timeout_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "1736455118", "off");
INSERT INTO `wor6069_options` VALUES("15190", "_transient_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:36:\"https://rss.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://rss.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2025-01-09T08:40:55+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://yesweblog.fr/taches-cron-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Découvrir les tâches du Cron WordPress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://yesweblog.fr/taches-cron-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-08T16:15:16.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-08T16:15:16.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:476:\"Nouvel Article\n\n	\n	\n	Le mot CRON peut faire un peu peur quand on ne connaît pas beaucoup l’univers WordPress. Ou le doux et petit monde des sites web. Pourtant, le Cron n’est pas une bête méchante. Il s’agit d’un élément technique qui permet au contraire à un site web de fonctionner de manière fluide et autonome. Le cron […]\n- Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:858:\"\n        <p>Nouvel Article</p>\n<div>\n	<a href=\"https://yesweblog.fr/taches-cron-wordpress/\"><img title=\"studio-yesweblog-griselidis-gaillet\" src=\"https://yesweblog.fr/wp-content/uploads/2024/08/studio-yesweblog-griselidis-gaillet-300x200.webp\" alt=\"Studio yesweblog griselidis gaillet\" width=\"300\" height=\"200\" //></a>\n	</div>\n<p>	Le mot CRON peut faire un peu peur quand on ne connaît pas beaucoup l&#8217;univers WordPress. Ou le doux et petit monde des sites web. Pourtant, le Cron n&#8217;est pas une bête méchante. Il s&#8217;agit d&#8217;un élément technique qui permet au contraire à un site web de fonctionner de manière fluide et autonome. Le cron [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Griselidis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://wpmarmite.com/header-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Dis, c’est quoi un bon header sur WordPress ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:39:\"https://wpmarmite.com/header-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-07T12:54:28.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-07T12:54:28.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"Après plusieurs déconvenues, vous attendez ce moment avec impatience. Tic, toc. Tic, toc. Les secondes s’égrènent. Et soudain, voilà votre rendez-vous du soir qui débarque au coin de la rue. Bim, bam, boum : dans votre poitrine, votre cœur s’emballe....\nDis, c’est quoi un bon header sur WordPress ? est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:722:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2020/10/cover-header-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Header WordPress cover\" //></p>\n<p>Après plusieurs déconvenues, vous attendez ce moment avec impatience. Tic, toc. Tic, toc. Les secondes s’égrènent. Et soudain, voilà votre rendez-vous du soir qui débarque au coin de la rue. Bim, bam, boum : dans votre poitrine, votre cœur s’emballe....</p>\n<p><a href=\"https://wpmarmite.com/header-wordpress/\">Dis, c&#8217;est quoi un bon header sur WordPress ?</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Thibaut &amp;#124; WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wpchannel.com/wordpress/plugins-wordpress/wplingua-extension-multilingue-traduction-automatique/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"wpLingua, une extension multilingue avec traduction automatique\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:104:\"https://wpchannel.com/wordpress/plugins-wordpress/wplingua-extension-multilingue-traduction-automatique/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-06T17:49:06.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-06T17:49:06.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Dans un monde de plus en plus globalisé, disposer d’un site Web accessible dans plusieurs langues est devenu essentiel. Que vous gériez un blog personnel ou une boutique en ligne, offrir une expérience utilisateur adaptée à un public international peut considérablement augmenter votre audience et vos revenus. C’est ici qu’entre en jeu wpLingua, une extension […]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:396:\"\n        Dans un monde de plus en plus globalisé, disposer d’un site Web accessible dans plusieurs langues est devenu essentiel. Que vous gériez un blog personnel ou une boutique en ligne, offrir une expérience utilisateur adaptée à un public international peut considérablement augmenter votre audience et vos revenus. C’est ici qu’entre en jeu wpLingua, une extension [&#8230;]\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpchannel.com/feed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://kinsta.com/fr/blog/paquet-donnees-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Comment utiliser le paquet de données WordPress pour gérer les états de l’application ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:52:\"https://kinsta.com/fr/blog/paquet-donnees-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-03T09:26:59.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-01-03T09:26:59.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:298:\"Gérer l’état d’une application WordPress – la façon dont elle traite et organise les données – peut s’avérer difficile. Au fur et à mesure que votre ...\nThe post Comment utiliser le paquet de données WordPress pour gérer les états de l’application ? appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:484:\"\n        <p>Gérer l&#8217;état d&#8217;une application WordPress &#8211; la façon dont elle traite et organise les données &#8211; peut s&#8217;avérer difficile. Au fur et à mesure que votre ...</p>\n<p>The post <a rel=\"nofollow\" href=\"https://kinsta.com/fr/blog/paquet-donnees-wordpress/\">Comment utiliser le paquet de données WordPress pour gérer les états de l&rsquo;application ?</a> appeared first on <a rel=\"nofollow\" href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Steve Bonisteel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://kinsta.com/fr/blog/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://www.gregoirenoyelle.com/ajouter-en-tete-dynamique-wordpress-dans-taxonomie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Ajouter un en-tête dynamique dans une taxonomie\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:83:\"https://www.gregoirenoyelle.com/ajouter-en-tete-dynamique-wordpress-dans-taxonomie/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-22T11:43:30.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-22T11:43:30.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:533:\"J’avais un challenge, Ajouter une image différente pour chaque terme de ma taxonomie sur mesure. J’ai tout de suite pensé à ACF. Nativement, il est possible d’ajouter des métadonnées à n’importe quel terme. Dans la base, c’est la table term_meta qui permet d’ajouter des réglages très variés. D’ailleurs, tous les outils de SEO l’utilisent à […]Cet article a été publié le 22 décembre 2024 par Grégoire Noyelle. Pour le lire en ligne, suivre le lien: Ajouter un en-tête dynamique dans une taxonomie.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:734:\"\n        J&#8217;avais un challenge, Ajouter une image différente pour chaque terme de ma taxonomie sur mesure. J&#8217;ai tout de suite pensé à ACF. Nativement, il est possible d&#8217;ajouter des métadonnées à n&#8217;importe quel terme. Dans la base, c&#8217;est la table term_meta qui permet d&#8217;ajouter des réglages très variés. D&#8217;ailleurs, tous les outils de SEO l&#8217;utilisent à [&#8230;]<p>Cet article a été publié le 22 décembre 2024 par <a href=\"https://www.gregoirenoyelle.com\">Grégoire Noyelle</a>. Pour le lire en ligne, suivre le lien: <a href=\"https://www.gregoirenoyelle.com/ajouter-en-tete-dynamique-wordpress-dans-taxonomie/\">Ajouter un en-tête dynamique dans une taxonomie</a>.</p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://www.gregoirenoyelle.com/category/tuto/wordpress-tutos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Grégoire Noyelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://promatec.digital/blog/2024/12/16/retour-acf-dans-le-depot-wordpress-org-un-tournant-decisif/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Retour d’ACF dans le Dépôt WordPress.org : Un Tournant Décisif\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:100:\"https://promatec.digital/blog/2024/12/16/retour-acf-dans-le-depot-wordpress-org-un-tournant-decisif/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-16T11:38:48.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-16T11:38:48.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:477:\"Le 14 décembre 2024, la communauté WordPress a assisté à un retournement majeur dans l’affaire qui a secoué le monde des plugins WordPress ces derniers mois : le retour de WP Engine et du plugin Advanced Custom Fields (ACF) dans le dépôt officiel de WordPress.org. Ce retour fait suite à une décision judiciaire contraignant Automattic, […]\nL’article Retour d’ACF dans le Dépôt WordPress.org : Un Tournant Décisif est apparu en premier sur Promatec Digital.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:664:\"\n        <p>Le 14 décembre 2024, la communauté WordPress a assisté à un retournement majeur dans l’affaire qui a secoué le monde des plugins WordPress ces derniers mois : le retour de WP Engine et du plugin Advanced Custom Fields (ACF) dans le dépôt officiel de WordPress.org. Ce retour fait suite à une décision judiciaire contraignant Automattic, [&#8230;]</p>\n<p>L’article <a href=\"https://promatec.digital/blog/2024/12/16/retour-acf-dans-le-depot-wordpress-org-un-tournant-decisif/\">Retour d’ACF dans le Dépôt WordPress.org : Un Tournant Décisif</a> est apparu en premier sur <a href=\"https://promatec.digital\">Promatec Digital</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Promatec Digital\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://promatec.digital/blog/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Promatec\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://www.seomix.fr/site-wordpress-lent/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Mon site WordPress est lent : que faire ? \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:42:\"https://www.seomix.fr/site-wordpress-lent/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-09T09:15:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-09T09:15:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:728:\"Le temps de chargement d’un site web est un facteur crucial, tant pour l’expérience utilisateur que pour le référencement naturel (SEO). Un site WordPress lent peut entraîner une baisse des conversions, ou un impact négatif sur votre positionnement dans les moteurs de recherche. Alors, que faire si votre site WordPress manque de réactivité ? Voici un guide détaillé pour identifier les causes de la lenteur et appliquer des solutions efficaces, étape par étape ! Pourquoi la vitesse d’un site est-elle si importante ? La vitesse d’un site web est essentielle pour plusieurs raisons, qui touchent à la fois l’expérience utilisateur, le […]Lire la suite : Mon site WordPress est lent : que faire ? \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:836:\"\n        Le temps de chargement d’un site web est un facteur crucial, tant pour l’expérience utilisateur que pour le référencement naturel (SEO). Un site WordPress lent peut entraîner une baisse des conversions, ou un impact négatif sur votre positionnement dans les moteurs de recherche. Alors, que faire si votre site WordPress manque de réactivité ? Voici un guide détaillé pour identifier les causes de la lenteur et appliquer des solutions efficaces, étape par étape&#160;! Pourquoi la vitesse d’un site est-elle si importante ? La vitesse d’un site web est essentielle pour plusieurs raisons, qui touchent à la fois l’expérience utilisateur, le [&#8230;]<br><strong>Lire la suite :</strong> <a href=\"https://www.seomix.fr/site-wordpress-lent/\">Mon site WordPress est lent&#160;: que faire&#160;? </a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Raphaël Maia Ferreira\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://www.seomix.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"SeoMix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://beapi.fr/blog/tout-savoir-sur-les-mises-a-jour-wordpress-enjeux-risques-et-solutions/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Tout savoir sur les mises à jour WordPress : enjeux, risques et solutions\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"https://beapi.fr/blog/tout-savoir-sur-les-mises-a-jour-wordpress-enjeux-risques-et-solutions/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-02T14:27:59.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-12-02T14:27:59.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:284:\"Dans cet article, on vous explique en quoi consistent ces mises à jour, pourquoi elles sont essentielles et comment on accompagne nos clients pour que tout se passe correctement. \nThe post Tout savoir sur les mises à jour WordPress : enjeux, risques et solutions appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:16854:\"\n        \n<p>La semaine dernière, WordPress a dévoilé sa version 6.7. Au menu : des améliorations de performance bienvenues, du peaufinage pour l’éditeur Gutenberg et un tout nouveau thème qui vient enrichir l’écosystème.&nbsp;</p>\n\n\n\n<p>L’occasion parfaite pour revenir sur l’importance des mises à jour chez WordPress. Ces évolutions régulières sont essentielles pour garantir la pérennité et l’efficacité des plateformes sur le CMS. Et pour les entreprises qui dépendent de WordPress – que ce soit pour des réseaux multisites complexes, des boutiques en ligne ou des entreprises issues de secteurs critiques comme la banque, la sécurité ou le service public – ces mises à jour demandent une gestion rigoureuse et stratégique.</p>\n\n\n\n<p>Chez Be API, la gestion des mises à jour est intégrée dans notre accompagnement RUN (maintenance WordPress). L’objectif ? S’adapter aux besoins spécifiques de chaque client, pour assurer une disponibilité maximale, renforcer la sécurité et, surtout, éviter toute interruption.</p>\n\n\n\n<p>Dans cet article, on vous explique en quoi consistent ces mises à jour, pourquoi elles sont essentielles et comment nous accompagnons nos clients pour que tout se passe correctement. Mais avant ça, on vous propose un petit rappel des bases.</p>\n\n\n\n<h2 class=\"wp-block-heading\">I. Comprendre les mises à jour WordPress</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Une mise à jour, c’est quoi ?</h3>\n\n\n\n<p>Les mises à jour WordPress servent à intégrer les derniers correctifs, nouvelles fonctionnalités et améliorations pour optimiser votre site. Elles concernent généralement trois éléments principaux :</p>\n\n\n\n<ul>\n<li><strong>Le cœur de WordPress</strong> : le moteur du site, son logiciel central.</li>\n\n\n\n<li><strong>Les extensions (plugins)</strong> : des outils qui ajoutent des fonctionnalités spécifiques.</li>\n\n\n\n<li><strong>Les thèmes </strong>qui définissent l’apparence visuelle du site.</li>\n</ul>\n\n\n\n<p>Ces mises à jour ne se contentent pas de rendre votre site compatible avec les dernières technologies : elles corrigent aussi des failles de sécurité et des bugs, renforçant la stabilité et la fiabilité de votre plateforme.</p>\n\n\n\n<p>Étant un CMS open source, WordPress évolue constamment pour suivre les besoins de ses utilisateurs et les standards du marché. Chaque mise à jour joue un rôle spécifique. Les mises à jour de sécurité corrigent les vulnérabilités identifiées, celles de maintenance résolvent des bugs techniques, et les mises à jour majeures introduisent de nouvelles fonctionnalités ou améliorations.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Les différents types de mises à jour</h3>\n\n\n\n<p>Il existe deux grandes catégories de mises à jour :</p>\n\n\n\n<ul>\n<li><strong>Les mises à jour majeures</strong> : elles apportent des fonctionnalités inédites ou des changements structurels significatifs. Par exemple, l’arrivée de l’éditeur Gutenberg en 2018.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>Les mises à jour mineures</strong> : elles se concentrent sur les correctifs techniques et les améliorations de sécurité.</li>\n</ul>\n\n\n\n<p>💡 Contrairement à bien d’autres projets open-source qui suivent la convention <a href=\"https://semver.org/lang/fr/\">SemVer</a>, la numérotation des versions chez WordPress suit une logique spécifique (ex. 6.7.1) : les deux premiers chiffres (6.7) indiquent une mise à jour majeure, tandis que le dernier chiffre (1) correspond à une mise à jour de maintenance ou de sécurité.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Automatiques ou manuelles ?</h3>\n\n\n\n<p>Certaines mises à jour, comme les correctifs de sécurité, sont conçues pour être réalisées automatiquement &#8211; sur le papier. Mais dans les faits, la situation est souvent plus complexe : une mise à jour WordPress peut englober des évolutions, des corrections de bugs, des patchs de sécurité, voire une nouvelle interface &#8211; si WordPress reste “safe”, les extensions et les thèmes eux, ne respectent pas toujours les règles.</p>\n\n\n\n<p>C’est pourquoi les mises à jour automatiques, bien que pratiques, restent imprévisibles. Pour les mises à jour majeures ou celles impactant des extensions et thèmes, une intervention manuelle est généralement recommandée pour limiter les risques d’incompatibilités ou les dysfonctionnements inattendus.</p>\n\n\n\n<h2 class=\"wp-block-heading\">II. Pourquoi les mises à jour sont-elles essentielles pour votre site ?</h2>\n\n\n\n<p>Les mises à jour WordPress sont indispensables pour assurer la sécurité, les performances et la pérennité de votre plateforme. Les ignorer, c’est risquer de mettre en péril votre activité en ligne. </p>\n\n\n\n<h3 class=\"wp-block-heading\">1. Sécurité : protéger votre site et vos données</h3>\n\n\n\n<p>Parfois, les&nbsp; mises à jours viennent combler des failles critiques, réduisant le risque d’attaques et de piratages. Elles permettent notamment de :</p>\n\n\n\n<ul>\n<li><strong>Protéger les données sensibles</strong> : Empêcher les accès non autorisés et minimiser les risques de fuite ou de vol d’informations.</li>\n\n\n\n<li><strong>Éviter les sanctions liées au RGPD</strong> : Une faille non corrigée peut entraîner une violation de données personnelles, avec des conséquences financières et d’image.</li>\n\n\n\n<li><strong>Maintenir la confiance de vos utilisateurs</strong> : Un site compromis peut nuire durablement à votre réputation</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">2. Compatibilité : rester à jour avec les innovations</h3>\n\n\n\n<p>Le web évolue rapidement, et votre site doit suivre le rythme pour offrir une expérience à la hauteur des attentes. Les mises à jour permettent de :</p>\n\n\n\n<ul>\n<li><strong>Éviter les bugs et incompatibilités</strong> : Extensions et thèmes obsolètes peuvent provoquer des dysfonctionnements avec WordPress, PHP ou les navigateurs récents.</li>\n\n\n\n<li><strong>Garantir une expérience utilisateur fluide</strong> : En limitant les erreurs, les lenteurs et les fonctionnalités dépassées, votre site reste au niveau des attentes de vos utilisateurs.</li>\n\n\n\n<li><strong>Proposer de nouvelles fonctionnalités</strong> : Les mises à jour majeures introduisent régulièrement des outils ou améliorations qui enrichissent l’expérience utilisateur et étendent les possibilités de la plateforme.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">3. Performances : améliorer la vitesse et l’expérience utilisateur</h3>\n\n\n\n<p>Les mises à jour WordPress intègrent souvent des optimisations qui boostent la rapidité et la stabilité de votre site.</p>\n\n\n\n<ul>\n<li><strong>Une vitesse optimisée améliore</strong> l’expérience utilisateur et favorise votre référencement (Google valorise les sites qui se chargent rapidement).</li>\n\n\n\n<li><strong>Correction des erreurs </strong> : Les mises à jour résolvent les problèmes techniques susceptibles de nuire au bon fonctionnement du site</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">4. Business et stratégie : un investissement rentable</h3>\n\n\n\n<p>Les mises à jour vont bien au-delà de la technique et impactent directement vos objectifs.</p>\n\n\n\n<ul>\n<li><strong>Anticiper les interruptions</strong> : Évitez les pannes imprévues, particulièrement critiques pour des périodes de forte activité ou les lancements de produits.</li>\n\n\n\n<li><strong>Maîtriser les coûts</strong> : La gestion proactive des mises à jour coûte moins cher que des corrections d’urgence ou une refonte complète.</li>\n\n\n\n<li><strong>Privilégier la durabilité </strong>: Mettre à jour régulièrement votre site, c’est prolonger sa durée de vie et éviter le recours à des refontes complètes souvent coûteuses en ressources. En adoptant des pratiques d’éco-conception et une approche durable, vous contribuez également à limiter l’impact environnemental lié aux refontes majeures ou aux hébergements énergivores.</li>\n\n\n\n<li><strong>Renforcer votre image professionnelle</strong> : Un site rapide et fiable inspire confiance, à l’inverse d’un site lent ou sujet à des erreurs.</li>\n</ul>\n\n\n\n<p>En somme, les mises à jour sont un levier important pour maintenir votre site performant, sécurisé, durable, qui propose une expérience moderne et fluide.</p>\n\n\n\n<h2 class=\"wp-block-heading\">III. Mises à jour automatiques ou gestion manuelle : quelle stratégie choisir pour vos mises à jour ?</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Automatiser : une solution pour les sites plus “simples”</h3>\n\n\n\n<p>Si vous gérez un blog ou un site avec des fonctionnalités basiques et peu de dépendances techniques, l’automatisation peut être une bonne option. WordPress permet de paramétrer les mises à jour automatiques, qu’il s’agisse des versions majeures ou mineures du core. Il est également possible de gérer les mises à jour automatiques des extensions au cas par cas, en les activant ou non selon les besoins.</p>\n\n\n\n<p><strong>Avantages</strong> :</p>\n\n\n\n<ul>\n<li><strong>Gain de temps</strong> : plus besoin d’intervenir manuellement pour chaque mise à jour.</li>\n\n\n\n<li><strong>Sécurité de base</strong> : les correctifs critiques sont appliqués rapidement.</li>\n\n\n\n<li><strong>Simplicité :</strong> adapté aux sites qui n’ont pas d’exigences techniques complexes.</li>\n</ul>\n\n\n\n<p>Cependant, l’automatisation atteint vite ses limites pour les sites plus complexes ou avec des dépendances spécifiques.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gestion manuelle&nbsp; : l’option pour les projets complexes</h3>\n\n\n\n<p>Pour les sites complexes – e-commerce, réseaux multisites, ou ceux intégrés à des outils tiers comme des ERP ou CRM – externaliser la gestion des mises à jour est souvent indispensable. Le prestataire pourra gérer les différents défis liés à ces mises à jour. </p>\n\n\n\n<ul>\n<li><strong>Les conflits techniques</strong> : Même une petite mise à jour peut créer des bugs imprévus, surtout si votre plateforme inclut des développements sur mesure.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>Les dépendances multiples</strong> : extensions, thèmes et intégrations tierces doivent rester compatibles entre eux. Une seule incompatibilité peut générer des régressions sur tout le système.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>Les plateformes multisites</strong> : Une mise à jour sur un réseau multisites peut impacter plusieurs sites, nécessitant une coordination rigoureuse pour éviter les interruptions.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>L’impact sur les performances</strong> : Certaines mises à jour peuvent dégrader les performances, notamment en ajoutant des fonctionnalités ou modifications non optimisées. Cela s’avérer critique pour les plateformes à fort trafic.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>Les bugs différés</strong> : Certains problèmes liés à des mises à jour peuvent apparaître bien après le déploiement, rendant leur résolution plus complexe et chronophage.</li>\n</ul>\n\n\n\n<p>Investir dans une gestion experte des mises à jour, c’est s’assurer une tranquillité d’esprit et une performance optimale, tout en protégeant votre plateforme.</p>\n\n\n\n<h2 class=\"wp-block-heading\">IV. Be API : une méthode adaptée aux grandes entreprises pour gérer les mises à jour WordPress</h2>\n\n\n\n<p>Chez Be API, nous avons développé une méthodologie structurée pour garantir la continuité de services, respecter des contraintes réglementaires et maintenir des performances optimales dans des environnements complexes. </p>\n\n\n\n<h3 class=\"wp-block-heading\">Une approche industrialisée et sur mesure</h3>\n\n\n\n<p>Notre processus a été conçu pour minimiser les risques et garantir des résultats fiables, même à grande échelle. </p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Audit complet annuel</strong></h4>\n\n\n\n<p>Nous réalisons une analyse approfondie de vos sites pour anticiper les impacts des mises à jour sur vos développements spécifiques, vos dépendances (extensions, thèmes) et vos intégrations tierces. Cet audit inclut également la mise à jour de toute la pile technologique : le CMS, les plugins, ainsi que les logiciels du serveur, notamment PHP.</p>\n\n\n\n<p>Cet audit inclut également des recommandations techniques, fonctionnelles et stratégiques sur des sujets connexes comme la conformité RGPD, la sécurité des données et l’optimisation SEO.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Tests dans des environnements de préproduction</strong></h4>\n\n\n\n<p>Pour éviter toute perturbation en production, nous nous appuyons sur les environnements de recette ou préproductions sécurisés qui reproduisent fidèlement vos sites.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Coordination avec vos équipes et prestataires<br></strong></h4>\n\n\n\n<p>Nous collaborons étroitement avec les équipes IT, les agences partenaires ou les hébergeurs pour assurer un déploiement harmonisé. Nous mettons l’accent sur : </p>\n\n\n\n<ul>\n<li>une intégration fluide dans vos processus existants&nbsp;</li>\n\n\n\n<li>une communication proactive pour minimiser les interruptions et répondre aux exigences internes.</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Tests et recettes rigoureux</strong></h4>\n\n\n\n<p>Chaque mise à jour est suivie d’une recette complète pour garantir le bon fonctionnement de vos fonctionnalités clés.</p>\n\n\n\n<ul>\n<li><strong>Tests manuels et automatisés</strong> : validation des développements spécifiques.</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Déploiement progressif et suivi actif</strong></h4>\n\n\n\n<p>Le déploiement est effectué par étapes, avec un monitoring actif pour :</p>\n\n\n\n<ul>\n<li>Identifier rapidement les anomalies.</li>\n\n\n\n<li>Intervenir immédiatement en cas de problème.</li>\n</ul>\n\n\n\n<p>Cette approche progressive limite les risques d’interruption et assure une transition maîtrisée.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Une maintenance continue pour anticiper les risques</h3>\n\n\n\n<p>Au-delà des audits annuels et des montées en version planifiées, nos équipes assurent une maintenance proactive tout au long de l’année. Les correctifs de sécurité et les mises à jour mineures sont appliqués en temps réel pour protéger votre site contre les menaces potentielles et garantir sa disponibilité.</p>\n\n\n\n<p>Une approche qui assure à vos équipes :&nbsp;</p>\n\n\n\n<ul>\n<li><strong>Tranquillité d’esprit</strong> : nos experts anticipent et gèrent les risques liés aux mises à jour</li>\n\n\n\n<li><strong>Gain de temps et de ressources</strong> : grâce à notre méthodologie éprouvée, les mises à jour sont planifiées, exécutées et monitorées avec efficacité, sans perturber vos opérations.</li>\n\n\n\n<li><strong>Conformité garantie</strong> : nous veillons à ce que vos sites respectent les réglementations en vigueur (RGPD, sécurité des données) et soient optimisés pour le SEO.</li>\n\n\n\n<li><strong>Adaptation à vos besoins spécifiques</strong> : Nous ajustons nos interventions à vos contraintes techniques, organisationnelles et stratégiques.</li>\n\n\n\n<li><strong>Relation de proximité</strong> : un accompagnement humain, une communication fluide et proactive pour assurer un partenariat aligné sur vos objectifs.</li>\n</ul>\n\n\n\n<p>En associant expertise technique et compréhension de vos enjeux, nous faisons bien plus que maintenir vos sites : nous contribuons à leur performance, leur sécurité et leur pérennité, tout en simplifiant vos opérations quotidiennes.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusion&nbsp;</h2>\n\n\n\n<p>Les mises à jour WordPress ne sont pas qu’une étape technique ; elles jouent un rôle clé dans la sécurité, les performances et la pérennité de vos sites.&nbsp;</p>\n\n\n\n<p>Une gestion rigoureuse et sécurisée des mises à jour est essentielle pour garantir la continuité de vos services, renforcer votre image et anticiper les risques.</p>\n\n\n\n<p>Chez Be API, notre méthodologie éprouvée combine expertise technique et adaptabilité : nous nous intégrons à chaque contexte d’entreprise, en évitant la standardisation, pour répondre précisément à vos besoins et contraintes.</p>\n\n\n\n<p><strong>Et pssst : Pas besoin d’un projet clé en main pour nous contacter !</strong></p>\n\n\n\n<p><strong>Que vous ayez une idée, une problématique ou simplement une question, nos experts WordPress sont disponibles pour échanger et vous accompagner. <a href=\"https://beapi.fr/contact/\">Prenez rendez-vous dès maintenant pour un appel gratuit</a>.</strong></p>\n<p>The post <a href=\"https://beapi.fr/blog/tout-savoir-sur-les-mises-a-jour-wordpress-enjeux-risques-et-solutions/\">Tout savoir sur les mises à jour WordPress : enjeux, risques et solutions</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://www.wppodcast.fr/podcast/feuille-de-route-pour-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"56. Feuille de route pour 2025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:60:\"https://www.wppodcast.fr/podcast/feuille-de-route-pour-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-26T01:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-26T01:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"Maintenant que WordPress 6.7 est disponible, la feuille de route pour toutes les versions de WordPress prévues en 2025 est en cours d’élaboration. N’oubliez pas que vous pouvez écouter les épisodes sur Pocket Casts, Spotify, et Apple Podcasts ou vous abonner directement au flux. Transcript de l’épisode Bonjour, je suis Patricia, et vous écoutez WPpodcast, […]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:401:\"\n        Maintenant que WordPress 6.7 est disponible, la feuille de route pour toutes les versions de WordPress prévues en 2025 est en cours d’élaboration. N&#8217;oubliez pas que vous pouvez écouter les épisodes sur Pocket Casts, Spotify, et Apple Podcasts ou vous abonner directement au flux. Transcript de l&#8217;épisode Bonjour, je suis Patricia, et vous écoutez WPpodcast, [&#8230;]\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Patricia BT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://www.wppodcast.fr/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wpfr.net/nouvelle-identite-de-lassociation-5-questions-a-antoine/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouvelle identité de l’association : 5 questions à Antoine\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:73:\"https://wpfr.net/nouvelle-identite-de-lassociation-5-questions-a-antoine/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-05T08:15:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-05T08:15:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"Après vous avoir révélé la nouvelle identité de l’association la semaine dernière, on ne pouvait pas décemment se dispenser d’une interview d’Antoine Paufichet, le directeur de création dont elle émane. C’est aussi ça, le rôle du blog de WPFR : donner la parole aux personnes qui animent et font vivre l’association.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:7751:\"\n        <p>Après vous avoir révélé <a href=\"https://wpfr.net/wpfr-revele-sa-nouvelle-identite-visuelle/\">la nouvelle identité de l’association</a> la semaine dernière, on ne pouvait pas décemment se dispenser d’une interview d’<strong>Antoine Paufichet</strong>, le directeur de création dont elle émane. C’est aussi ça, le rôle du blog de WPFR&nbsp;: donner la parole aux personnes qui animent et font vivre l’association.</p><p>Antoine s’est donc gentiment plié au jeu des 5 questions, <a href=\"https://wpfr.net/journee-de-contribution-7-questions-aux-organisateurs/\">comme l’avaient fait Valérie, Jenny et Éric</a> avant la dernière Journée de Contribution. Il vous raconte, mieux que personne, sa vision de l’association et les inspirations qui ont donné naissance à notre nouveau logo et son univers graphique.</p><p>Antoine, c’est à toi&nbsp;!</p><p><strong>WPFR : Salut Antoine, peux-tu te présenter en quelques lignes ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : Je suis designer de naissance ! J’ai commencé en tant que directeur artistique dans les agences de communication, puis indépendant pour accompagner les startups à trouver leur proposition de valeur et à la mettre en forme (du branding au sens large : logo, charte, app mobile, site web, communication, design de magasin, etc.). C’est ce qui m’a amené au design d’interface. Je suis d’ailleurs toujours coach dans le Startup LaunchPad d’HEC.<br>Depuis 7 ans maintenant, je suis le directeur de création de <a href=\"https://beapi.fr/\">l’agence Be API</a> et je m’occupe d’inspirer au mieux les DA/UI/UX designers de l’agence. J’ai découvert WordPress ici et j’ai très vite adhéré à cette idée d’open source et de redevabilité de <em>giving back</em>. C’est ce qu’on essaye de faire au sein de l’équipe design, même si nous ne sommes pas des techs purs et durs. Nous avons créé Johannes par exemple, premier UX kit open source (Figma) pour réaliser des wireframes Gutenberg friendly.<br>Il y a 1 an, avec Be API, nous avons monté <a href=\"https://be-beau.fr/\">le studio de design be-beau</a>, agence spécialisée dans le rebranding. Il faut croire que mes crayons de couleurs me manquaient <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p></blockquote><p><strong>WPFR : Tu as supervisé la refonte de l’identité graphique de l’association. Quand arrive un chantier de ce type, quelles sont tes premiers réflexes, les premières choses que tu fais pour démarrer ce projet ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : Toujours commencer par une bonne sieste ! Plus sérieusement, il n’y a pas vraiment de “chantier de ce type”. Dans n’importe quel projet de rebranding, on commence par apprendre. Nous ne sommes pas là pour démontrer notre talent artistique mais pour mettre en forme et en lumière une identité, un message.<br>Ainsi, un designer, quel qu’il soit, ne peut se satisfaire d’un brief comme : “<em>On veut être plus moderne et créer une rupture</em>.” (n’est-ce pas Jason? <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>) Une rupture, … OK mais pourquoi ? pour qui ? avec quelle histoire derrière ?<br>Apprendre, c’est comprendre. Comprendre le client, assimiler son projet. Et là, ceux qui ont travaillé sur cette nouvelle identité été beaucoup aidés car le nouveau projet de l’association porté par Jason et Amaury et clair, documenté, structuré.<br>Nous avons ensuite réalisé des workshops, ouverts aux volontaires, pour dégager une vraie proposition de valeur qui illustre ce projet. C’est de là qu’est né la nouvelle baseline: “<strong>Le point de rencontre de la communauté WordPress en France</strong>”</p>\n\n<p>Nous avions trouvé notre autoroute pour lancer le design.</p></blockquote><p><strong>WPFR : Quelles ont été les principales inspirations pour cette nouvelle identité ? Peux-tu nous expliquer le cheminement qui débouche sur cette identité ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : La principale source d’inspiration c’est la communauté elle-même. Un ensemble de professionnels hétérogène : des freelances, des agences de toutes tailles, des techs, des designers, des contributeurs, des chefs de projets, des commerciaux, des clients finaux, des experts du web, des professionnels du droit, etc. venant des quatre coins de la France… C’est ce qui m’a toujours frappé aux WordCamps ou journées de contribution. La disparité des profils, réunis autour d’un outil commun, avec passion.<br>Chacun d’eux, chacun de nous, est un pixel et ensemble, nous nous rassemblons et formons le nouveau logo et les éléments de la charte graphique. Le point de rencontre.<br>Et à l’instar de la communauté, nous avons voulu un logo modulaire qui s’adapte au format sur lequel il est posé. Le logo peut s’élargir, grandir, s’étirer comme pour symboliser que l’association est toujours en mouvement, en action et s’adapte aux besoins de la communauté WordPress.<br>La création de cette nouvelle identité a été collaborative, avec les membres du groupe de travail Design au CA de l’association.</p></blockquote><p><strong>WPFR : Cette nouvelle identité a été dévoilée à Rennes il y a un peu plus de deux semaines, lors du WordCamp Bretagne et de la Journée de Contribution qui l’a précédé. Quelles ont été les réactions sur place ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : Personne n’est venu me voir pour me dire qu’il détestait ! Par politesse et bienveillance sûrement … <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f602.png\" alt=\"😂\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //><br>Je crois que la nouvelle identité en a surpris plus d’un, tant mieux, et le parti pris a été plutôt bien accueilli. Ce qui m’a fait plaisir c’est quand un vieux de la vieille de la communauté (il se reconnaîtra !) m’a dit : “<em>Quand j’ai vu le logo tout seul j’ai pas trouvé ça top, mais en voyant la charte s’exprimer sur tous les supports (affiches, écrans, rollups, t-shirts, tote bags, etc.), ça a de la gueule et j’ai compris le sens.</em>”<br>C’est un excellent retour ! La preuve qu’un logo seul ne se suffit jamais. Une identité c’est un ensemble.</p></blockquote><p><strong>WPFR : Un dernier mot pour finir ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : J’ai hâte de voir la charte se déployer sur tous nos supports, comme le site web par exemple. Notre chantier pour 2025 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //> Vive le design <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4aa.png\" alt=\"💪\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p></blockquote><p>Un grand merci à Antoine donc de s&rsquo;être prêté au jeu de l&rsquo;interview. Et un dernier rappel, si vous voulez en savoir plus sur la nouvelle identité graphique de l&rsquo;association, <a href=\"https://wpfr.net/wpfr-revele-sa-nouvelle-identite-visuelle/\">tout est décrit dans cet article</a> !</p><p></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"François Houste\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpfr.net/actualites/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:12:\"nginx/1.27.0\";s:4:\"date\";s:29:\"Thu, 09 Jan 2025 08:40:55 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:12:\"x-powered-by\";s:10:\"PHP/8.0.30\";s:13:\"last-modified\";s:29:\"Fri, 01 Dec 2023 22:13:18 GMT\";s:4:\"etag\";s:34:\"\"c11b85e08f9a55c369b83cdc4e5e720f\"\";s:4:\"link\";s:57:\"<https://rss.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:25:\"strict-transport-security\";s:16:\"max-age=63072000\";}}s:5:\"build\";i:1735311133;s:21:\"cache_expiration_time\";i:1736455118;s:23:\"__cache_expiration_time\";i:1736455118;}", "off");
INSERT INTO `wor6069_options` VALUES("15191", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1736455119", "off");
INSERT INTO `wor6069_options` VALUES("15192", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><p><strong>Erreur RSS :</strong> A feed could not be found at `https://fr.wordpress.org/news/feed/`; the status code is `429` and content-type is `text/html`</p></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://yesweblog.fr/taches-cron-wordpress/\'>Découvrir les tâches du Cron WordPress</a></li><li><a class=\'rsswidget\' href=\'https://wpmarmite.com/header-wordpress/\'>Dis, c’est quoi un bon header sur WordPress ?</a></li><li><a class=\'rsswidget\' href=\'https://wpchannel.com/wordpress/plugins-wordpress/wplingua-extension-multilingue-traduction-automatique/\'>wpLingua, une extension multilingue avec traduction automatique</a></li></ul></div>", "off");
INSERT INTO `wor6069_options` VALUES("15312", "_transient_timeout_fusion_tos", "1737031842", "off");
INSERT INTO `wor6069_options` VALUES("15313", "_transient_fusion_tos", "a:32:{s:6:\"layout\";a:6:{s:5:\"label\";s:12:\"Mise en page\";s:2:\"id\";s:14:\"heading_layout\";s:8:\"priority\";i:1;s:4:\"icon\";s:15:\"el-icon-website\";s:8:\"alt_icon\";s:15:\"fusiona-browser\";s:6:\"fields\";a:15:{s:6:\"layout\";a:7:{s:5:\"label\";s:12:\"Mise en page\";s:11:\"description\";s:33:\"Contrôle la disposition du site.\";s:2:\"id\";s:6:\"layout\";s:7:\"default\";s:4:\"wide\";s:4:\"type\";s:15:\"radio-buttonset\";s:7:\"choices\";a:2:{s:5:\"boxed\";s:8:\"Encadré\";s:4:\"wide\";s:5:\"Large\";}s:6:\"output\";a:4:{i:0;a:6:{s:7:\"element\";s:4:\"html\";s:8:\"function\";s:4:\"attr\";s:4:\"attr\";s:5:\"class\";s:11:\"toLowerCase\";b:1;s:13:\"value_pattern\";s:19:\"avada-html-layout-$\";s:12:\"remove_attrs\";a:2:{i:0;s:23:\"avada-html-layout-boxed\";i:1;s:22:\"avada-html-layout-wide\";}}i:1;a:6:{s:7:\"element\";s:4:\"body\";s:8:\"function\";s:4:\"attr\";s:4:\"attr\";s:5:\"class\";s:11:\"toLowerCase\";b:1;s:13:\"value_pattern\";s:13:\"layout-$-mode\";s:12:\"remove_attrs\";a:2:{i:0;s:17:\"layout-boxed-mode\";i:1;s:16:\"layout-wide-mode\";}}i:2;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:13:\"avadaMenuVars\";s:2:\"id\";s:11:\"site_layout\";s:7:\"trigger\";a:1:{i:0;s:22:\"fusionPositionSubmenus\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:3;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:15:\"avadaHeaderVars\";s:2:\"id\";s:11:\"layout_mode\";s:7:\"trigger\";a:2:{i:0;s:21:\"fusionSliderReTrigger\";i:1;s:27:\"fusion-reinit-sticky-header\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:10:\"site_width\";a:10:{s:5:\"label\";s:15:\"Largeur du site\";s:11:\"description\";s:37:\"Contrôle la largeur globale du site.\";s:2:\"id\";s:10:\"site_width\";s:7:\"default\";s:6:\"1200px\";s:4:\"type\";s:9:\"dimension\";s:7:\"choices\";a:2:{i:0;s:2:\"px\";i:1;s:1:\"%\";}s:4:\"desc\";s:0:\"\";s:8:\"css_vars\";a:2:{i:0;a:1:{s:4:\"name\";s:12:\"--site_width\";}i:1;a:2:{s:4:\"name\";s:16:\"--site_width-int\";s:8:\"callback\";a:2:{i:0;s:23:\"convert_font_size_to_px\";i:1;s:0:\"\";}}}s:6:\"output\";a:4:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:1:\"%\";i:1;s:8:\"contains\";}s:7:\"element\";s:4:\"html\";s:9:\"className\";s:28:\"avada-has-site-width-percent\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:1;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:4:\"100%\";i:1;s:3:\"===\";}s:7:\"element\";s:4:\"html\";s:9:\"className\";s:32:\"avada-has-site-width-100-percent\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:2;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:20:\"fusionTypographyVars\";s:2:\"id\";s:10:\"site_width\";s:7:\"trigger\";a:1:{i:0;s:20:\"fusionInitTypography\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:3;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusion-reinit-sticky-header\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}s:15:\"partial_refresh\";a:3:{s:36:\"site_width_header_remove_before_hook\";a:3:{s:8:\"selector\";s:33:\".avada-hook-before-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:35:\"site_width_header_remove_after_hook\";a:3:{s:8:\"selector\";s:32:\".avada-hook-after-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:17:\"site_width_header\";a:4:{s:8:\"selector\";s:22:\".fusion-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";a:2:{i:0;s:31:\"Avada_Partial_Refresh_Callbacks\";i:1;s:6:\"header\";}s:21:\"success_trigger_event\";s:15:\"header-rendered\";}}}s:13:\"margin_offset\";a:9:{s:5:\"label\";s:38:\"Décalage haut et bas du mode encadré\";s:11:\"description\";s:65:\"Contrôle le décalage haut et bas de l’arrière-plan encadré.\";s:2:\"id\";s:13:\"margin_offset\";s:7:\"choices\";a:2:{s:3:\"top\";b:1;s:6:\"bottom\";b:1;}s:7:\"default\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:4:\"type\";s:7:\"spacing\";s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:6:\"layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"boxed\";}}s:8:\"css_vars\";a:4:{i:0;a:2:{s:4:\"name\";s:19:\"--margin_offset-top\";s:6:\"choice\";s:3:\"top\";}i:1;a:2:{s:4:\"name\";s:22:\"--margin_offset-bottom\";s:6:\"choice\";s:6:\"bottom\";}i:2;a:3:{s:4:\"name\";s:30:\"--margin_offset-top-no-percent\";s:6:\"choice\";s:3:\"top\";s:8:\"callback\";a:2:{i:0;s:14:\"string_replace\";i:1;a:2:{i:0;s:1:\"%\";i:1;s:2:\"vh\";}}}i:3;a:3:{s:4:\"name\";s:33:\"--margin_offset-bottom-no-percent\";s:6:\"choice\";s:6:\"bottom\";s:8:\"callback\";a:2:{i:0;s:14:\"string_replace\";i:1;a:2:{i:0;s:1:\"%\";i:1;s:2:\"vh\";}}}}s:6:\"output\";a:2:{i:0;a:5:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:6:\"choice\";s:3:\"top\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:0:\"\";i:1;s:16:\"is-zero-or-empty\";}s:7:\"element\";s:4:\"body\";s:9:\"className\";s:32:\"avada-has-zero-margin-offset-top\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:1;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusion-reinit-sticky-header\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:13:\"scroll_offset\";a:8:{s:5:\"label\";s:36:\"Mode de défilement du mode encadré\";s:11:\"description\";s:160:\"Définissez le type de défilement de la page. Le défilement par sauts ne produit aucun décalage, le défilement continu supprime le décalage au défilement.\";s:2:\"id\";s:13:\"scroll_offset\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:2:{s:6:\"framed\";s:21:\"Défilement par sauts\";s:4:\"full\";s:19:\"Défilement continu\";}s:7:\"default\";s:4:\"full\";s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:6:\"layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"boxed\";}}s:6:\"output\";a:3:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:3:\"===\";i:1;s:6:\"framed\";}s:7:\"element\";s:4:\"html\";s:9:\"className\";s:24:\"avada-html-layout-framed\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:1;a:6:{s:7:\"element\";s:4:\"body\";s:8:\"function\";s:4:\"attr\";s:4:\"attr\";s:5:\"class\";s:11:\"toLowerCase\";b:1;s:13:\"value_pattern\";s:22:\"layout-scroll-offset-$\";s:12:\"remove_attrs\";a:2:{i:0;s:27:\"layout-scroll-offset-framed\";i:1;s:25:\"layout-scroll-offset-full\";}}i:2;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:15:\"avadaHeaderVars\";s:2:\"id\";s:13:\"scroll_offset\";s:7:\"trigger\";a:1:{i:0;s:6:\"scroll\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:18:\"boxed_modal_shadow\";a:8:{s:5:\"label\";s:31:\"Type d’ombre du mode encadré\";s:11:\"description\";s:62:\"Contrôle le type d’ombre à afficher pour le mode encadré.\";s:2:\"id\";s:18:\"boxed_modal_shadow\";s:7:\"default\";s:4:\"none\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:4:{s:4:\"none\";s:13:\"Pas d’ombre\";s:5:\"light\";s:14:\"Ombre légère\";s:6:\"medium\";s:13:\"Ombre moyenne\";s:4:\"hard\";s:10:\"Ombre dure\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:6:\"layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"boxed\";}}s:6:\"output\";a:2:{i:0;a:5:{s:7:\"element\";s:4:\"body\";s:8:\"function\";s:4:\"attr\";s:4:\"attr\";s:5:\"class\";s:13:\"value_pattern\";s:30:\"avada-has-boxed-modal-shadow-$\";s:12:\"remove_attrs\";a:4:{i:0;s:33:\"avada-has-boxed-modal-shadow-none\";i:1;s:34:\"avada-has-boxed-modal-shadow-light\";i:2;s:35:\"avada-has-boxed-modal-shadow-medium\";i:3;s:33:\"avada-has-boxed-modal-shadow-hard\";}}i:1;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusion-reinit-sticky-header\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:12:\"main_padding\";a:7:{s:5:\"label\";s:33:\"Remplissage du contenu de la page\";s:11:\"description\";s:67:\"Contrôle la marge supérieure / inférieure du contenu de la page.\";s:2:\"id\";s:12:\"main_padding\";s:7:\"choices\";a:2:{s:3:\"top\";b:1;s:6:\"bottom\";b:1;}s:7:\"default\";a:2:{s:3:\"top\";s:4:\"60px\";s:6:\"bottom\";s:4:\"60px\";}s:4:\"type\";s:7:\"spacing\";s:8:\"css_vars\";a:3:{i:0;a:2:{s:4:\"name\";s:18:\"--main_padding-top\";s:6:\"choice\";s:3:\"top\";}i:1;a:3:{s:4:\"name\";s:26:\"--main_padding-top-or-55px\";s:6:\"choice\";s:3:\"top\";s:8:\"callback\";a:2:{i:0;s:26:\"fallback_to_value_if_empty\";i:1;s:4:\"55px\";}}i:2;a:2:{s:4:\"name\";s:21:\"--main_padding-bottom\";s:6:\"choice\";s:6:\"bottom\";}}}s:13:\"page_template\";a:7:{s:5:\"label\";s:21:\"Default Page Template\";s:11:\"description\";s:33:\"Choose the default page template.\";s:2:\"id\";s:13:\"page_template\";s:7:\"default\";s:9:\"100_width\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:2:{s:9:\"100_width\";s:12:\"100% Largeur\";s:10:\"site_width\";s:15:\"Largeur du site\";}s:9:\"transport\";s:11:\"postMessage\";}s:16:\"hundredp_padding\";a:7:{s:5:\"label\";s:30:\"Marges intérieures latérales\";s:11:\"description\";s:255:\"Contrôle le rembourrage gauche et droit pour le contenu de la page lorsque vous utilisez la largeur du site à 100 %, le modèle de page de largeur 100 % ou l’option de publication de 100 % de largeur. Cela n’affecte pas les conteneurs Avada Builder.\";s:2:\"id\";s:16:\"hundredp_padding\";s:7:\"default\";s:4:\"30px\";s:4:\"type\";s:9:\"dimension\";s:7:\"choices\";a:2:{i:0;s:2:\"px\";i:1;s:1:\"%\";}s:8:\"css_vars\";a:4:{i:0;a:1:{s:4:\"name\";s:18:\"--hundredp_padding\";}i:1;a:2:{s:4:\"name\";s:35:\"--hundredp_padding-fallback_to_zero\";s:8:\"callback\";s:16:\"fallback_to_zero\";}i:2;a:2:{s:4:\"name\";s:38:\"--hundredp_padding-fallback_to_zero_px\";s:8:\"callback\";a:2:{i:0;s:26:\"fallback_to_value_if_empty\";i:1;s:3:\"0px\";}}i:3;a:2:{s:4:\"name\";s:50:\"--hundredp_padding-hundred_percent_negative_margin\";s:8:\"callback\";a:2:{i:0;s:31:\"hundred_percent_negative_margin\";i:1;s:0:\"\";}}}}s:27:\"single_sidebar_layouts_info\";a:4:{s:5:\"label\";s:44:\"Mise en page de la barre latérale (Sidebar)\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:27:\"single_sidebar_layouts_info\";s:4:\"type\";s:4:\"info\";}s:13:\"sidebar_width\";a:7:{s:5:\"label\";s:36:\"Largeur de la barre latérale unique\";s:11:\"description\";s:95:\"Contrôle la largeur de la barre latérale lorsqu&#039;une seule barre latérale est présente.\";s:2:\"id\";s:13:\"sidebar_width\";s:7:\"default\";s:3:\"24%\";s:4:\"type\";s:9:\"dimension\";s:7:\"choices\";a:2:{i:0;s:2:\"px\";i:1;s:1:\"%\";}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:15:\"--sidebar_width\";}}}s:14:\"sidebar_gutter\";a:6:{s:5:\"label\";s:39:\"Gouttière de la barre latérale unique\";s:11:\"description\";s:80:\"Contrôle l&#039;espace entre le contenu principal et la barre latérale unique.\";s:2:\"id\";s:14:\"sidebar_gutter\";s:7:\"default\";s:2:\"6%\";s:4:\"type\";s:9:\"dimension\";s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:16:\"--sidebar_gutter\";}}}s:25:\"dual_sidebar_layouts_info\";a:4:{s:5:\"label\";s:56:\"Mise en page de la barre latérale double (Dual Sidebar)\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:25:\"dual_sidebar_layouts_info\";s:4:\"type\";s:4:\"info\";}s:17:\"sidebar_2_1_width\";a:7:{s:5:\"label\";s:38:\"Largeur de la barre latérale double 1\";s:11:\"description\";s:92:\"Contrôle la largeur de la barre latérale 1 lorsque deux barres latérales sont affichées.\";s:2:\"id\";s:17:\"sidebar_2_1_width\";s:7:\"default\";s:3:\"20%\";s:4:\"type\";s:9:\"dimension\";s:7:\"choices\";a:2:{i:0;s:2:\"px\";i:1;s:1:\"%\";}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:19:\"--sidebar_2_1_width\";}}}s:17:\"sidebar_2_2_width\";a:7:{s:5:\"label\";s:38:\"Largeur de la barre latérale double 2\";s:11:\"description\";s:92:\"Contrôle la largeur de la barre latérale 2 lorsque deux barres latérales sont affichées.\";s:2:\"id\";s:17:\"sidebar_2_2_width\";s:7:\"default\";s:3:\"20%\";s:4:\"type\";s:9:\"dimension\";s:7:\"choices\";a:2:{i:0;s:2:\"px\";i:1;s:1:\"%\";}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:19:\"--sidebar_2_2_width\";}}}s:19:\"dual_sidebar_gutter\";a:6:{s:5:\"label\";s:39:\"Gouttière de la double barre latérale\";s:11:\"description\";s:127:\"Contrôle l&#039;espace entre le contenu principal et la barre latérale lorsque des barres latérales doubles sont présentes.\";s:2:\"id\";s:19:\"dual_sidebar_gutter\";s:7:\"default\";s:2:\"4%\";s:4:\"type\";s:9:\"dimension\";s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:21:\"--dual_sidebar_gutter\";}}}}}s:6:\"mobile\";a:6:{s:5:\"label\";s:10:\"Responsive\";s:2:\"id\";s:6:\"mobile\";s:8:\"priority\";i:2;s:4:\"icon\";s:25:\"el-icon-resize-horizontal\";s:8:\"alt_icon\";s:14:\"fusiona-mobile\";s:6:\"fields\";a:13:{s:10:\"responsive\";a:6:{s:5:\"label\";s:17:\"Responsive design\";s:11:\"description\";s:107:\"Pour utiliser les fonctionnalités du responsive design. Si désactivé, la mise en page fixe est utilisé.\";s:2:\"id\";s:10:\"responsive\";s:7:\"default\";s:1:\"1\";s:4:\"type\";s:15:\"radio-buttonset\";s:7:\"choices\";a:2:{i:1;s:7:\"Activé\";i:0;s:11:\"Désactivé\";}}s:21:\"grid_main_break_point\";a:9:{s:5:\"label\";s:40:\"Point de bascule Responsive de la grille\";s:11:\"description\";s:194:\"Contrôle le point de bascule des dispositions en grille (blog et portfolio) à partir duquel la largeur des colonnes est réduite. Les points de bascule suivants sont calculés automatiquement.\";s:2:\"id\";s:21:\"grid_main_break_point\";s:7:\"default\";s:4:\"1000\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:4:{s:3:\"min\";s:3:\"360\";s:3:\"max\";s:4:\"2000\";s:4:\"step\";s:1:\"1\";s:4:\"edit\";s:3:\"yes\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:23:\"--grid_main_break_point\";}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusionRecalcAllMediaQueries\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:23:\"side_header_break_point\";a:9:{s:5:\"label\";s:49:\"Point d&#039;arrêt de l&#039;en-tête responsive\";s:11:\"description\";s:95:\"Contrôle lorsque l&#039;en-tête de bureau change pour l&#039;en-tête pour appareils mobiles.\";s:2:\"id\";s:23:\"side_header_break_point\";s:7:\"default\";s:3:\"800\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:4:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:4:\"2000\";s:4:\"step\";s:1:\"1\";s:4:\"edit\";s:3:\"yes\";}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:25:\"--side_header_break_point\";}}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusionRecalcAllMediaQueries\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:19:\"content_break_point\";a:9:{s:5:\"label\";s:40:\"Point de bascule Responsive des contenus\";s:11:\"description\";s:207:\"Contrôle le point de bascule à partir duquel les zones de contenus sont remplacées par les dispositions pour mobiles. Cela concerne tous les contenus affichés sous l’entête, y compris le pied de page.\";s:2:\"id\";s:19:\"content_break_point\";s:7:\"default\";s:3:\"800\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:4:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:4:\"2000\";s:4:\"step\";s:1:\"1\";s:4:\"edit\";s:3:\"yes\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:21:\"--content_break_point\";}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusionRecalcAllMediaQueries\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:19:\"sidebar_break_point\";a:8:{s:5:\"label\";s:52:\"Point d&#039;arrêt de la barre latérale responsive\";s:11:\"description\";s:92:\"Contrôle lorsque les barres latérales changent pour la disposition pour appareils mobiles.\";s:2:\"id\";s:19:\"sidebar_break_point\";s:7:\"default\";s:3:\"800\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:4:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:4:\"2000\";s:4:\"step\";s:1:\"1\";s:4:\"edit\";s:3:\"yes\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:27:\"fusionRecalcAllMediaQueries\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:11:\"mobile_zoom\";a:8:{s:5:\"label\";s:27:\"Zoom pour appareils mobiles\";s:11:\"description\";s:84:\"Activer cette option pour permettre de pincer pour zoomer sur les appareils mobiles.\";s:2:\"id\";s:11:\"mobile_zoom\";s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"switch\";s:7:\"choices\";a:2:{s:2:\"on\";s:7:\"Activé\";s:3:\"off\";s:11:\"Désactivé\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:9:\"transport\";s:11:\"postMessage\";}s:41:\"element_responsive_breakpoints_info_title\";a:5:{s:5:\"label\";s:42:\"Points d’arrêt réactifs aux éléments\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:41:\"element_responsive_breakpoints_info_title\";s:4:\"icon\";b:1;s:4:\"type\";s:4:\"info\";}s:16:\"visibility_small\";a:8:{s:5:\"label\";s:12:\"Small Screen\";s:11:\"description\";s:73:\"Controls when the small screen options and visibility should take effect.\";s:2:\"id\";s:16:\"visibility_small\";s:7:\"default\";s:3:\"640\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:3:{s:3:\"min\";s:1:\"0\";s:4:\"step\";s:1:\"1\";s:3:\"max\";s:4:\"2000\";}s:11:\"option_name\";s:14:\"fusion_options\";s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:34:\"fusionRecalcVisibilityMediaQueries\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:17:\"visibility_medium\";a:8:{s:5:\"label\";s:13:\"Medium Screen\";s:11:\"description\";s:74:\"Controls when the medium screen options and visibility should take effect.\";s:2:\"id\";s:17:\"visibility_medium\";s:7:\"default\";s:4:\"1024\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:3:{s:3:\"min\";s:1:\"0\";s:4:\"step\";s:1:\"1\";s:3:\"max\";s:4:\"2000\";}s:11:\"option_name\";s:14:\"fusion_options\";s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:34:\"fusionRecalcVisibilityMediaQueries\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:16:\"visibility_large\";a:7:{s:5:\"label\";s:12:\"Large Screen\";s:11:\"description\";s:100:\"Any screen larger than that which is defined as the medium screen will be counted as a large screen.\";s:2:\"id\";s:16:\"visibility_large\";s:10:\"full_width\";b:0;s:4:\"type\";s:3:\"raw\";s:7:\"content\";s:59:\"<div id=\"fusion-visibility-large\">> <span>1024</span></div>\";s:11:\"option_name\";s:14:\"fusion_options\";}s:32:\"responsive_typography_info_title\";a:5:{s:5:\"label\";s:22:\"Typographie responsive\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:32:\"responsive_typography_info_title\";s:4:\"icon\";b:1;s:4:\"type\";s:4:\"info\";}s:22:\"typography_sensitivity\";a:9:{s:5:\"label\";s:41:\"Sensibilité de la typographie Responsive\";s:11:\"description\";s:102:\"Définir à 0 pour désactiver la typographie réactive. Augmenter la valeur pour un plus grand effet.\";s:2:\"id\";s:22:\"typography_sensitivity\";s:7:\"default\";s:1:\"0\";s:4:\"type\";s:6:\"slider\";s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:7:\"choices\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:1:\"1\";s:4:\"step\";s:3:\".01\";}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:20:\"fusionTypographyVars\";s:2:\"id\";s:22:\"typography_sensitivity\";s:7:\"trigger\";a:1:{i:0;s:20:\"fusionInitTypography\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:24:\"--typography_sensitivity\";}}}s:17:\"typography_factor\";a:9:{s:5:\"label\";s:35:\"Facteur de taille de police minimum\";s:11:\"description\";s:135:\"La taille minimale des éléments affectés par la typographie réactive est la taille de police corporelle multipliée par ce facteur.\";s:2:\"id\";s:17:\"typography_factor\";s:7:\"default\";s:3:\"1.5\";s:4:\"type\";s:6:\"slider\";s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:10:\"responsive\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}s:7:\"choices\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:1:\"4\";s:4:\"step\";s:3:\".01\";}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:20:\"fusionTypographyVars\";s:2:\"id\";s:17:\"typography_factor\";s:7:\"trigger\";a:1:{i:0;s:20:\"fusionInitTypography\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:19:\"--typography_factor\";}}}}}s:6:\"colors\";a:6:{s:5:\"label\";s:8:\"Couleurs\";s:2:\"id\";s:6:\"colors\";s:8:\"priority\";i:3;s:4:\"icon\";s:13:\"el-icon-brush\";s:8:\"alt_icon\";s:21:\"fusiona-color-dropper\";s:6:\"fields\";a:2:{s:13:\"color_palette\";a:5:{s:5:\"label\";s:19:\"Palette de couleurs\";s:11:\"description\";s:537:\"Set your global color palette. The colors defined here can be used from other global options, from page options and element options. For best results, the 8 colors of the core palette should be set from lightest to darkest. <strong>IMPORTANT NOTE:</strong> If a global color that is used by other options gets deleted, these corresponding options will display a default color instead. Colors are internally stored with a fixed counter. Thus, adding a new color after deleting an old one, will set the same internal name to the new color.\";s:2:\"id\";s:13:\"color_palette\";s:7:\"default\";a:8:{s:6:\"color1\";a:2:{s:5:\"color\";s:19:\"rgba(255,255,255,1)\";s:5:\"label\";s:7:\"Color 1\";}s:6:\"color2\";a:2:{s:5:\"color\";s:19:\"rgba(249,249,251,1)\";s:5:\"label\";s:7:\"Color 2\";}s:6:\"color3\";a:2:{s:5:\"color\";s:19:\"rgba(242,243,245,1)\";s:5:\"label\";s:7:\"Color 3\";}s:6:\"color4\";a:2:{s:5:\"color\";s:19:\"rgba(101,189,125,1)\";s:5:\"label\";s:7:\"Color 4\";}s:6:\"color5\";a:2:{s:5:\"color\";s:18:\"rgba(25,143,217,1)\";s:5:\"label\";s:7:\"Color 5\";}s:6:\"color6\";a:2:{s:5:\"color\";s:16:\"rgba(67,69,73,1)\";s:5:\"label\";s:7:\"Color 6\";}s:6:\"color7\";a:2:{s:5:\"color\";s:16:\"rgba(33,35,38,1)\";s:5:\"label\";s:7:\"Color 7\";}s:6:\"color8\";a:2:{s:5:\"color\";s:16:\"rgba(20,22,23,1)\";s:5:\"label\";s:7:\"Color 8\";}}s:4:\"type\";s:13:\"color-palette\";}s:13:\"primary_color\";a:6:{s:5:\"label\";s:16:\"Couleur primaire\";s:11:\"description\";s:57:\"Controls the main highlight color throughout the website.\";s:2:\"id\";s:13:\"primary_color\";s:7:\"default\";s:17:\"var(--awb-color5)\";s:4:\"type\";s:11:\"color-alpha\";s:8:\"css_vars\";a:6:{i:0;a:2:{s:4:\"name\";s:15:\"--primary_color\";s:8:\"callback\";a:1:{i:0;s:14:\"sanitize_color\";}}i:1;a:2:{s:4:\"name\";s:19:\"--primary_color-85a\";s:8:\"callback\";a:2:{i:0;s:15:\"color_alpha_set\";i:1;s:4:\"0.85\";}}i:2;a:2:{s:4:\"name\";s:18:\"--primary_color-7a\";s:8:\"callback\";a:2:{i:0;s:15:\"color_alpha_set\";i:1;s:3:\"0.7\";}}i:3;a:2:{s:4:\"name\";s:18:\"--primary_color-5a\";s:8:\"callback\";a:2:{i:0;s:15:\"color_alpha_set\";i:1;s:3:\"0.5\";}}i:4;a:2:{s:4:\"name\";s:19:\"--primary_color-35a\";s:8:\"callback\";a:2:{i:0;s:15:\"color_alpha_set\";i:1;s:4:\"0.35\";}}i:5;a:2:{s:4:\"name\";s:18:\"--primary_color-2a\";s:8:\"callback\";a:2:{i:0;s:15:\"color_alpha_set\";i:1;s:3:\"0.2\";}}}}}}s:6:\"header\";a:7:{s:5:\"label\";s:8:\"En-tête\";s:2:\"id\";s:14:\"heading_header\";s:8:\"is_panel\";b:1;s:8:\"priority\";i:3;s:4:\"icon\";s:16:\"el-icon-arrow-up\";s:8:\"alt_icon\";s:14:\"fusiona-header\";s:6:\"fields\";a:6:{s:15:\"slider_position\";a:8:{s:5:\"label\";s:18:\"Position du slider\";s:11:\"description\";s:81:\"Choisir si le slider s&#039;affiche en dessous ou en dessus dans l&#039;en-tête.\";s:2:\"id\";s:15:\"slider_position\";s:7:\"default\";s:5:\"below\";s:4:\"type\";s:15:\"radio-buttonset\";s:7:\"choices\";a:2:{s:5:\"below\";s:10:\"En-dessous\";s:5:\"above\";s:9:\"Au-dessus\";}s:9:\"transport\";s:11:\"postMessage\";s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:22:\"change_slider_position\";i:1;a:1:{s:7:\"element\";s:18:\"#sliders-container\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:45:\"header_global_header_override_template_notice\";a:5:{s:2:\"id\";s:45:\"header_global_header_override_template_notice\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:504:\"<div class=\"fusion-redux-important-notice\"><strong>NOTE IMPORTANTE :</strong> Les options de cet onglet ne sont pas disponibles car une substitution globale de 0.000000e+0st actuellement utilisée. Pour modifier votre mise en page globale, veuillez visiter <a href=\"https://donnadieu.agencemiyou.com/wp-admin/admin.php?page=avada-layouts\" target=\"_blank\">cette page</a>ou <a href=\"https://donnadieu.agencemiyou.com/wp-admin/post.php?post=3468&action=edit\" target=\"_blank\">modifier l’en-tête</a>.</div>\";s:4:\"type\";s:6:\"custom\";s:13:\"edit_shortcut\";a:2:{s:8:\"selector\";a:1:{i:0;s:17:\".fusion-tb-header\";}s:9:\"shortcuts\";a:1:{i:0;a:4:{s:10:\"aria_label\";s:15:\"Editer En-tête\";s:4:\"icon\";s:14:\"fusiona-header\";s:11:\"open_parent\";b:1;s:35:\"link_to_template_if_override_active\";s:6:\"header\";}}}}s:13:\"header_info_1\";a:8:{s:5:\"label\";s:26:\"Contenu de l&#039;en-tête\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:13:\"header_info_1\";s:7:\"default\";s:0:\"\";s:4:\"icon\";b:1;s:4:\"type\";s:11:\"sub-section\";s:6:\"hidden\";b:1;s:6:\"fields\";a:11:{s:44:\"header_global_header_template_content_notice\";a:4:{s:2:\"id\";s:44:\"header_global_header_template_content_notice\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:331:\"<div class=\"fusion-redux-important-notice\"><strong>IMPORTANT NOTE:</strong> For more flexibility and a more modern, performant setup, we recommend using the Header Builder. To create a custom Header Layout, <a href=\"https://donnadieu.agencemiyou.com/wp-admin/admin.php?page=avada-layouts\" target=\"_blank\">visit this page</a>.</div>\";s:4:\"type\";s:6:\"custom\";}s:15:\"header_position\";a:8:{s:5:\"label\";s:30:\"Emplacement de l&#039;en-tête\";s:11:\"description\";s:248:\"Contrôle la position de l&#039;en-tête en haut, à gauche ou à droite du site. La hauteur du menu principal, les marges de l&#039;en-tête et du logo s&#039;ajusteront automatiquement en fonction de votre sélection pour une esthétique idéale.\";s:2:\"id\";s:15:\"header_position\";s:7:\"default\";s:3:\"top\";s:4:\"type\";s:15:\"radio-buttonset\";s:7:\"choices\";a:3:{s:3:\"top\";s:4:\"Haut\";s:4:\"left\";s:6:\"Gauche\";s:5:\"right\";s:6:\"Droite\";}s:15:\"partial_refresh\";a:2:{s:34:\"header_position_remove_before_hook\";a:3:{s:8:\"selector\";s:112:\".avada-hook-before-header-wrapper, .fusion-header-wrapper, #side-header-sticky, #side-header, #sliders-container\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:34:\"header_position_replace_after_hook\";a:4:{s:8:\"selector\";s:32:\".avada-hook-after-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";a:2:{i:0;s:31:\"Avada_Partial_Refresh_Callbacks\";i:1;s:15:\"header_position\";}s:21:\"success_trigger_event\";s:40:\"header-rendered fusion-partial-wooslider\";}}s:6:\"output\";a:3:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:2:{s:9:\"globalVar\";s:13:\"avadaMenuVars\";s:2:\"id\";s:15:\"header_position\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:1;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:2:{s:9:\"globalVar\";s:21:\"avadaFusionSliderVars\";s:2:\"id\";s:15:\"header_position\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}i:2;a:1:{s:11:\"js_callback\";a:1:{i:0;s:22:\"change_header_position\";}}}}s:13:\"header_layout\";a:10:{s:5:\"label\";s:46:\"Sélectionner une mise en page d&#039;en-tête\";s:11:\"description\";s:480:\"Contrôle la disposition générale de l&#039;en-tête. Les en-têtes 2-5 permettent des zones de contenu supplémentaires via les options de contenu d&#039;en-tête 1-3. L&#039;en-tête 6 n&#039;autorise que les éléments de menu de niveau parent, aucun niveau enfant ne s&#039;affiche. La hauteur du menu principal, le remplissage de l&#039;en-tête et les options de marge du logo s&#039;ajusteront automatiquement en fonction de votre sélection pour une esthétique idéale.\";s:2:\"id\";s:13:\"header_layout\";s:7:\"default\";s:2:\"v3\";s:4:\"type\";s:11:\"radio-image\";s:7:\"choices\";a:7:{s:2:\"v1\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header1.jpg\";s:2:\"v2\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header2.jpg\";s:2:\"v3\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header3.jpg\";s:2:\"v4\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header4.jpg\";s:2:\"v5\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header5.jpg\";s:2:\"v6\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header6.jpg\";s:2:\"v7\";s:92:\"https://donnadieu.agencemiyou.com/wp-content/themes/Avada/assets/images/patterns/header7.jpg\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:3:\"top\";}}s:15:\"partial_refresh\";a:3:{s:47:\"header_content_header_layout_remove_before_hook\";a:3:{s:8:\"selector\";s:33:\".avada-hook-before-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:46:\"header_content_header_layout_remove_after_hook\";a:3:{s:8:\"selector\";s:32:\".avada-hook-after-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:28:\"header_content_header_layout\";a:4:{s:8:\"selector\";s:22:\".fusion-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";a:2:{i:0;s:31:\"Avada_Partial_Refresh_Callbacks\";i:1;s:6:\"header\";}s:21:\"success_trigger_event\";s:15:\"header-rendered\";}}s:13:\"edit_shortcut\";a:2:{s:8:\"selector\";a:2:{i:0;s:14:\".fusion-header\";i:1;s:33:\"#side-header .side-header-wrapper\";}s:9:\"shortcuts\";a:3:{i:0;a:4:{s:10:\"aria_label\";s:39:\"Modifier la disposition d&#039;en-tête\";s:4:\"icon\";s:14:\"fusiona-header\";s:11:\"open_parent\";b:1;s:5:\"order\";i:1;}i:1;a:5:{s:10:\"aria_label\";s:17:\"Ajouter un Slider\";s:4:\"icon\";s:15:\"fusiona-uniF61C\";s:4:\"link\";s:1:\"#\";s:9:\"css_class\";s:10:\"add-slider\";s:5:\"order\";i:4;}i:2;a:5:{s:10:\"aria_label\";s:33:\"Ajouter la barre de titre de page\";s:4:\"icon\";s:18:\"fusiona-page_title\";s:4:\"link\";s:1:\"#\";s:9:\"css_class\";s:7:\"add-ptb\";s:5:\"order\";i:5;}}}s:6:\"output\";a:2:{i:0;a:5:{s:7:\"element\";s:4:\"body\";s:8:\"function\";s:4:\"attr\";s:4:\"attr\";s:5:\"class\";s:13:\"value_pattern\";s:22:\"fusion-header-layout-$\";s:12:\"remove_attrs\";a:7:{i:0;s:23:\"fusion-header-layout-v1\";i:1;s:23:\"fusion-header-layout-v2\";i:2;s:23:\"fusion-header-layout-v3\";i:3;s:23:\"fusion-header-layout-v4\";i:4;s:23:\"fusion-header-layout-v5\";i:5;s:23:\"fusion-header-layout-v6\";i:6;s:23:\"fusion-header-layout-v7\";}}i:1;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:4:{s:6:\"choice\";s:3:\"top\";s:9:\"globalVar\";s:17:\"avadaSidebarsVars\";s:2:\"id\";s:13:\"header_layout\";s:7:\"trigger\";a:1:{i:0;s:31:\"fusionReSettStickySidebarStatus\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:0:\"\";a:0:{}s:19:\"header_left_content\";a:9:{s:5:\"label\";s:28:\"Contenu de l&#039;en-tête 1\";s:11:\"description\";s:77:\"Contrôle le contenu qui s&#039;affiche en haut à gauche de l&#039;en-tête.\";s:2:\"id\";s:19:\"header_left_content\";s:7:\"default\";s:12:\"social_links\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:4:{s:12:\"contact_info\";s:23:\"Informations de contact\";s:12:\"social_links\";s:16:\"Réseaux sociaux\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"leave_empty\";s:12:\"Laisser vide\";}s:5:\"class\";s:16:\"fusion-or-gutter\";s:8:\"required\";a:5:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v2\";}i:2;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v3\";}i:3;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v4\";}i:4;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v5\";}}s:15:\"partial_refresh\";a:3:{s:53:\"header_content_header_left_content_remove_before_hook\";a:3:{s:8:\"selector\";s:33:\".avada-hook-before-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:52:\"header_content_header_left_content_remove_after_hook\";a:3:{s:8:\"selector\";s:32:\".avada-hook-after-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:34:\"header_content_header_left_content\";a:4:{s:8:\"selector\";s:57:\".fusion-header-wrapper, #side-header-sticky, #side-header\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";a:2:{i:0;s:31:\"Avada_Partial_Refresh_Callbacks\";i:1;s:6:\"header\";}s:21:\"success_trigger_event\";s:22:\"header-rendered resize\";}}}s:20:\"header_right_content\";a:9:{s:5:\"label\";s:28:\"Contenu de l&#039;en-tête 2\";s:11:\"description\";s:79:\"Contrôle le contenu qui s&#039;affiche en haut à droite dans l&#039;en-tête.\";s:2:\"id\";s:20:\"header_right_content\";s:7:\"default\";s:10:\"navigation\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:4:{s:12:\"contact_info\";s:23:\"Informations de contact\";s:12:\"social_links\";s:16:\"Réseaux sociaux\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"leave_empty\";s:12:\"Laisser vide\";}s:5:\"class\";s:16:\"fusion-or-gutter\";s:8:\"required\";a:5:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v2\";}i:2;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v3\";}i:3;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v4\";}i:4;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v5\";}}s:15:\"partial_refresh\";a:3:{s:54:\"header_content_header_right_content_remove_before_hook\";a:3:{s:8:\"selector\";s:33:\".avada-hook-before-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:53:\"header_content_header_right_content_remove_after_hook\";a:3:{s:8:\"selector\";s:32:\".avada-hook-after-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:35:\"header_content_header_right_content\";a:4:{s:8:\"selector\";s:57:\".fusion-header-wrapper, #side-header-sticky, #side-header\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";a:2:{i:0;s:31:\"Avada_Partial_Refresh_Callbacks\";i:1;s:6:\"header\";}s:21:\"success_trigger_event\";s:22:\"header-rendered resize\";}}}s:17:\"header_v4_content\";a:9:{s:5:\"label\";s:28:\"Contenu de l&#039;en-tête 3\";s:11:\"description\";s:71:\"Contrôle le contenu qui s&#039;affiche dans la partie droite centrale.\";s:2:\"id\";s:17:\"header_v4_content\";s:7:\"default\";s:18:\"tagline_and_search\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:5:{s:7:\"tagline\";s:6:\"Slogan\";s:6:\"search\";s:9:\"Recherche\";s:18:\"tagline_and_search\";s:19:\"Slogan et Recherche\";s:6:\"banner\";s:9:\"Bannière\";s:4:\"none\";s:12:\"Laisser vide\";}s:5:\"class\";s:16:\"fusion-or-gutter\";s:8:\"required\";a:2:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:2:\"v4\";}}s:15:\"partial_refresh\";a:3:{s:51:\"header_content_header_v4_content_remove_before_hook\";a:3:{s:8:\"selector\";s:33:\".avada-hook-before-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:50:\"header_content_header_v4_content_remove_after_hook\";a:3:{s:8:\"selector\";s:32:\".avada-hook-after-header-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:13:\"__return_null\";}s:32:\"header_content_header_v4_content\";a:4:{s:8:\"selector\";s:57:\".fusion-header-wrapper, #side-header-sticky, #side-header\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";a:2:{i:0;s:31:\"Avada_Partial_Refresh_Callbacks\";i:1;s:6:\"header\";}s:21:\"success_trigger_event\";s:22:\"header-rendered resize\";}}}s:13:\"header_number\";a:8:{s:5:\"label\";s:55:\"Numéro de téléphone pour les informations de contact\";s:11:\"description\";s:155:\"Ce contenu s&#039;affichera si vous avez &quot;Contact Info&quot; sélectionné pour l&#039;option &quot;Contenu de l&#039;en-tête 1&quot; ou 2 ci-dessus.\";s:2:\"id\";s:13:\"header_number\";s:7:\"default\";s:28:\"Call Us Today! 1.555.555.555\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:16:\"fusion-or-gutter\";s:8:\"required\";a:5:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v2\";}i:2;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v3\";}i:3;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v4\";}i:4;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v5\";}}s:6:\"output\";a:1:{i:0;a:2:{s:7:\"element\";s:33:\".fusion-contact-info-phone-number\";s:8:\"function\";s:4:\"html\";}}}s:12:\"header_email\";a:8:{s:5:\"label\";s:46:\"Adresse email pour les informations de contact\";s:11:\"description\";s:155:\"Ce contenu s&#039;affichera si vous avez &quot;Contact Info&quot; sélectionné pour l&#039;option &quot;Contenu de l&#039;en-tête 1&quot; ou 2 ci-dessus.\";s:2:\"id\";s:12:\"header_email\";s:7:\"default\";s:19:\"info@yourdomain.com\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:16:\"fusion-or-gutter\";s:8:\"required\";a:5:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v2\";}i:2;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v3\";}i:3;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v4\";}i:4;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v5\";}}s:6:\"output\";a:1:{i:0;a:3:{s:7:\"element\";s:34:\".fusion-contact-info-email-address\";s:8:\"function\";s:4:\"html\";s:13:\"value_pattern\";s:24:\"<a href=\"mailto:$\">$</a>\";}}}s:14:\"header_tagline\";a:8:{s:5:\"label\";s:24:\"Slogan pour le contenu 3\";s:11:\"description\";s:125:\"Ce contenu affichera si vous avez &quot;Slogan&quot; sélectionné pour l&#039;option de contenu d&#039;en-tête 3 ci-dessus.\";s:2:\"id\";s:14:\"header_tagline\";s:7:\"default\";s:19:\"Insert Tagline Here\";s:4:\"type\";s:8:\"textarea\";s:5:\"class\";s:24:\"fusion-gutter-and-or-and\";s:8:\"required\";a:4:{i:0;a:3:{s:7:\"setting\";s:17:\"header_v4_content\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:7:\"tagline\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v4\";}i:2;a:3:{s:7:\"setting\";s:17:\"header_v4_content\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:7:\"tagline\";}i:3;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}}s:6:\"output\";a:1:{i:0;a:2:{s:7:\"element\";s:22:\".fusion-header-tagline\";s:8:\"function\";s:4:\"html\";}}}s:18:\"header_banner_code\";a:9:{s:5:\"label\";s:38:\"Code de la bannière pour le contenu 3\";s:11:\"description\";s:311:\"Ce contenu s&#039;affichera si vous avez activé l&#039;option &quot;Bannière&quot; pour les contenus 1 ou 2 de l&#039;en-tête ci-dessus. Ajoutez le code HTML de la bannière à afficher dans le contenu 3 de l&#039;en-tête. Les éléments et boutons &quot;J&#039;aime&quot; peuvent aussi être utilisés ici.\";s:2:\"id\";s:18:\"header_banner_code\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:4:\"code\";s:7:\"choices\";a:2:{s:8:\"language\";s:4:\"html\";s:5:\"theme\";s:6:\"chrome\";}s:5:\"class\";s:24:\"fusion-gutter-and-or-and\";s:8:\"required\";a:4:{i:0;a:3:{s:7:\"setting\";s:17:\"header_v4_content\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:6:\"banner\";}i:1;a:3:{s:7:\"setting\";s:13:\"header_layout\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:2:\"v4\";}i:2;a:3:{s:7:\"setting\";s:17:\"header_v4_content\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:6:\"banner\";}i:3;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}}s:15:\"partial_refresh\";a:1:{s:26:\"header_content_banner_code\";a:4:{s:8:\"selector\";s:32:\".fusion-header-content-3-wrapper\";s:19:\"container_inclusive\";b:1;s:15:\"render_callback\";s:22:\"avada_header_content_3\";s:21:\"success_trigger_event\";s:15:\"header-rendered\";}}}}}s:13:\"header_info_2\";a:8:{s:5:\"label\";s:45:\"Image d&#039;arrière-plan de l&#039;en-tête\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:13:\"header_info_2\";s:7:\"default\";s:0:\"\";s:4:\"icon\";b:1;s:4:\"type\";s:11:\"sub-section\";s:6:\"hidden\";b:1;s:6:\"fields\";a:5:{s:39:\"header_global_header_template_bg_notice\";a:4:{s:2:\"id\";s:39:\"header_global_header_template_bg_notice\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:331:\"<div class=\"fusion-redux-important-notice\"><strong>IMPORTANT NOTE:</strong> For more flexibility and a more modern, performant setup, we recommend using the Header Builder. To create a custom Header Layout, <a href=\"https://donnadieu.agencemiyou.com/wp-admin/admin.php?page=avada-layouts\" target=\"_blank\">visit this page</a>.</div>\";s:4:\"type\";s:6:\"custom\";}s:15:\"header_bg_image\";a:8:{s:5:\"label\";s:58:\"Image d&#039;arrière-plan pour la zone de l&#039;en-tête\";s:11:\"description\";s:578:\"Sélectionnez une image pour l’arrière-plan de l’en-tête. Si elle est laissée vide, la couleur d’arrière-plan de l’en-tête sera utilisée. Pour les en-têtes supérieurs, l’image s’affiche en haut de la couleur d’arrière-plan de l’en-tête et ne s’affiche que si l’opacité de couleur d’arrière-plan de l’en-tête est définie sur 1. Pour les en-têtes latérales, l’image s’affiche derrière la couleur d’arrière-plan de l’en-tête, de sorte que l’opacité de l’arrière-tête doit être définie en dessous de 1 pour voir l’image.\";s:2:\"id\";s:15:\"header_bg_image\";s:7:\"default\";s:0:\"\";s:3:\"mod\";s:0:\"\";s:4:\"type\";s:5:\"media\";s:8:\"css_vars\";a:1:{i:0;a:3:{s:4:\"name\";s:17:\"--header_bg_image\";s:6:\"choice\";s:3:\"url\";s:8:\"callback\";a:2:{i:0;s:17:\"fallback_to_value\";i:1;a:2:{i:0;s:8:\"url(\"$\")\";i:1;s:0:\"\";}}}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:0:\"\";i:1;s:9:\"has-image\";}s:7:\"element\";s:4:\"body\";s:9:\"className\";s:25:\"avada-has-header-bg-image\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:14:\"header_bg_full\";a:7:{s:5:\"label\";s:31:\"Image d&#039;arrière-plan 100%\";s:11:\"description\";s:192:\"Activer cette option pour que l’image d’arrière-plan de l&#039;en-tête de page s’affiche à 100% en largeur et en hauteur, en s&#039;adaptant à la taille de la fenêtre du navigateur.\";s:2:\"id\";s:14:\"header_bg_full\";s:7:\"default\";s:1:\"0\";s:4:\"type\";s:6:\"switch\";s:8:\"required\";a:3:{i:0;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:0:\"\";}i:1;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:1:{s:3:\"url\";s:0:\"\";}}i:2;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:0:\"\";i:1;s:4:\"true\";}s:7:\"element\";s:4:\"body\";s:9:\"className\";s:24:\"avada-has-header-bg-full\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:18:\"header_bg_parallax\";a:7:{s:5:\"label\";s:36:\"Image d&#039;arrière-plan parallaxe\";s:11:\"description\";s:181:\"Activer cette option afin d&#039;utiliser un effet de défilement Parallax sur l&#039;image d&#039;arrière-plan. Fonctionne uniquement pour la position d&#039;en-tête supérieure.\";s:2:\"id\";s:18:\"header_bg_parallax\";s:7:\"default\";s:1:\"1\";s:4:\"type\";s:6:\"switch\";s:8:\"required\";a:4:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:3:\"top\";}i:1;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:0:\"\";}i:2;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:1:{s:3:\"url\";s:0:\"\";}}i:3;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:5:\"dummy\";s:8:\"callback\";a:2:{i:0;s:12:\"toggle_class\";i:1;a:3:{s:9:\"condition\";a:2:{i:0;s:0:\"\";i:1;s:4:\"true\";}s:7:\"element\";s:4:\"body\";s:9:\"className\";s:28:\"avada-has-header-bg-parallax\";}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:16:\"header_bg_repeat\";a:9:{s:5:\"label\";s:36:\"Répétition de l&#039;arrière-plan\";s:11:\"description\";s:71:\"Contrôle la façon dont l&#039;image d&#039;arrière-plan se répète.\";s:2:\"id\";s:16:\"header_bg_repeat\";s:7:\"default\";s:9:\"no-repeat\";s:4:\"type\";s:6:\"select\";s:7:\"choices\";a:4:{s:6:\"repeat\";s:14:\"Tout répéter\";s:8:\"repeat-x\";s:25:\"Répéter horizontalement\";s:8:\"repeat-y\";s:23:\"Répéter verticalement\";s:9:\"no-repeat\";s:16:\"Ne pas répéter\";}s:8:\"required\";a:3:{i:0;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:0:\"\";}i:1;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:1:{s:3:\"url\";s:0:\"\";}}i:2;a:3:{s:7:\"setting\";s:15:\"header_bg_image\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:8:\"css_vars\";a:1:{i:0;a:1:{s:4:\"name\";s:18:\"--header_bg_repeat\";}}s:6:\"output\";a:1:{i:0;a:5:{s:7:\"element\";s:4:\"body\";s:8:\"function\";s:4:\"attr\";s:4:\"attr\";s:5:\"class\";s:13:\"value_pattern\";s:17:\"avada-header-bg-$\";s:12:\"remove_attrs\";a:4:{i:0;s:22:\"avada-header-bg-repeat\";i:1;s:24:\"avada-header-bg-repeat-x\";i:2;s:24:\"avada-header-bg-repeat-y\";i:3;s:25:\"avada-header-bg-no-repeat\";}}}}}}s:14:\"header_styling\";a:8:{s:5:\"label\";s:24:\"Style de l&#039;en-tête\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:14:\"header_styling\";s:7:\"default\";s:0:\"\";s:4:\"icon\";b:1;s:4:\"type\";s:11:\"sub-section\";s:6:\"hidden\";b:1;s:6:\"fields\";a:11:{s:44:\"header_global_header_template_styling_notice\";a:4:{s:2:\"id\";s:44:\"header_global_header_template_styling_notice\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:331:\"<div class=\"fusion-redux-important-notice\"><strong>IMPORTANT NOTE:</strong> For more flexibility and a more modern, performant setup, we recommend using the Header Builder. To create a custom Header Layout, <a href=\"https://donnadieu.agencemiyou.com/wp-admin/admin.php?page=avada-layouts\" target=\"_blank\">visit this page</a>.</div>\";s:4:\"type\";s:6:\"custom\";}s:17:\"side_header_width\";a:9:{s:5:\"label\";s:64:\"Largeur de l&#039;en-tête pour l&#039;emplacement gauche-droite\";s:11:\"description\";s:65:\"Contrôle la largeur de l&#039;en-tête latéral gauche ou droit.\";s:2:\"id\";s:17:\"side_header_width\";s:7:\"default\";s:3:\"280\";s:4:\"type\";s:6:\"slider\";s:7:\"choices\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:3:\"800\";s:4:\"step\";s:1:\"1\";}s:8:\"required\";a:1:{i:0;a:3:{s:7:\"setting\";s:15:\"header_position\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:3:\"top\";}}s:8:\"css_vars\";a:2:{i:0;a:2:{s:4:\"name\";s:19:\"--side_header_width\";s:13:\"value_pattern\";s:3:\"$px\";}i:1;a:1:{s:4:\"name\";s:23:\"--side_header_width-int\";}}s:6:\"output\";a:1:{i:0;a:4:{s:7:\"element\";s:13:\"helperElement\";s:8:\"property\";s:6:\"bottom\";s:11:\"js_callback\";a:2:{i:0;s:21:\"fusionGlobalScriptSet\";i:1;a:3:{s:9:\"globalVar\";s:5:\"dummy\";s:2:\"id\";s:5:\"dummy\";s:7:\"trigger\";a:1:{i:0;s:6:\"resize\";}}}s:17:\"sanitize_callback\";s:21:\"__return_empty_string\";}}}s:14:\"header_padding\";a:8:{s:5:\"label\";s:28:\"Padding de l’en tête (px)\";s:11:\"description\";s:63:\"Contrôle les marges haut/droite/bas/gauche de l&#039;en-tête.\"